# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel


class AcceptInquiredSystemEventRequest(TeaModel):
    def __init__(self, choice=None, event_id=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.choice = choice  # type: str
        self.event_id = event_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(AcceptInquiredSystemEventRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.choice is not None:
            result['Choice'] = self.choice
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Choice') is not None:
            self.choice = m.get('Choice')
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class AcceptInquiredSystemEventResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AcceptInquiredSystemEventResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AcceptInquiredSystemEventResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AcceptInquiredSystemEventResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AcceptInquiredSystemEventResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AcceptInquiredSystemEventResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ActivateRouterInterfaceRequest(TeaModel):
    def __init__(self, owner_id=None, region_id=None, resource_owner_account=None, resource_owner_id=None,
                 router_interface_id=None):
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.router_interface_id = router_interface_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ActivateRouterInterfaceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.router_interface_id is not None:
            result['RouterInterfaceId'] = self.router_interface_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RouterInterfaceId') is not None:
            self.router_interface_id = m.get('RouterInterfaceId')
        return self


class ActivateRouterInterfaceResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ActivateRouterInterfaceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ActivateRouterInterfaceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ActivateRouterInterfaceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ActivateRouterInterfaceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ActivateRouterInterfaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddBandwidthPackageIpsRequest(TeaModel):
    def __init__(self, bandwidth_package_id=None, client_token=None, ip_count=None, owner_account=None,
                 owner_id=None, region_id=None, resource_owner_account=None, resource_owner_id=None):
        self.bandwidth_package_id = bandwidth_package_id  # type: str
        self.client_token = client_token  # type: str
        self.ip_count = ip_count  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddBandwidthPackageIpsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth_package_id is not None:
            result['BandwidthPackageId'] = self.bandwidth_package_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.ip_count is not None:
            result['IpCount'] = self.ip_count
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BandwidthPackageId') is not None:
            self.bandwidth_package_id = m.get('BandwidthPackageId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('IpCount') is not None:
            self.ip_count = m.get('IpCount')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class AddBandwidthPackageIpsResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddBandwidthPackageIpsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddBandwidthPackageIpsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddBandwidthPackageIpsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddBandwidthPackageIpsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddBandwidthPackageIpsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddTagsRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddTagsRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class AddTagsRequest(TeaModel):
    def __init__(self, owner_id=None, region_id=None, resource_id=None, resource_owner_account=None,
                 resource_owner_id=None, resource_type=None, tag=None):
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_id = resource_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.resource_type = resource_type  # type: str
        self.tag = tag  # type: list[AddTagsRequestTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AddTagsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = AddTagsRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class AddTagsResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddTagsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddTagsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddTagsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddTagsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AllocateDedicatedHostsRequestNetworkAttributes(TeaModel):
    def __init__(self, slb_udp_timeout=None, udp_timeout=None):
        self.slb_udp_timeout = slb_udp_timeout  # type: int
        self.udp_timeout = udp_timeout  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(AllocateDedicatedHostsRequestNetworkAttributes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.slb_udp_timeout is not None:
            result['SlbUdpTimeout'] = self.slb_udp_timeout
        if self.udp_timeout is not None:
            result['UdpTimeout'] = self.udp_timeout
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SlbUdpTimeout') is not None:
            self.slb_udp_timeout = m.get('SlbUdpTimeout')
        if m.get('UdpTimeout') is not None:
            self.udp_timeout = m.get('UdpTimeout')
        return self


class AllocateDedicatedHostsRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AllocateDedicatedHostsRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class AllocateDedicatedHostsRequest(TeaModel):
    def __init__(self, network_attributes=None, action_on_maintenance=None, auto_placement=None,
                 auto_release_time=None, auto_renew=None, auto_renew_period=None, charge_type=None, client_token=None,
                 cpu_over_commit_ratio=None, dedicated_host_cluster_id=None, dedicated_host_name=None, dedicated_host_type=None,
                 description=None, min_quantity=None, owner_account=None, owner_id=None, period=None, period_unit=None,
                 quantity=None, region_id=None, resource_group_id=None, resource_owner_account=None, resource_owner_id=None,
                 tag=None, zone_id=None):
        self.network_attributes = network_attributes  # type: AllocateDedicatedHostsRequestNetworkAttributes
        self.action_on_maintenance = action_on_maintenance  # type: str
        self.auto_placement = auto_placement  # type: str
        self.auto_release_time = auto_release_time  # type: str
        self.auto_renew = auto_renew  # type: bool
        self.auto_renew_period = auto_renew_period  # type: int
        self.charge_type = charge_type  # type: str
        self.client_token = client_token  # type: str
        self.cpu_over_commit_ratio = cpu_over_commit_ratio  # type: float
        self.dedicated_host_cluster_id = dedicated_host_cluster_id  # type: str
        self.dedicated_host_name = dedicated_host_name  # type: str
        self.dedicated_host_type = dedicated_host_type  # type: str
        self.description = description  # type: str
        self.min_quantity = min_quantity  # type: int
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.period = period  # type: int
        self.period_unit = period_unit  # type: str
        self.quantity = quantity  # type: int
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.tag = tag  # type: list[AllocateDedicatedHostsRequestTag]
        self.zone_id = zone_id  # type: str

    def validate(self):
        if self.network_attributes:
            self.network_attributes.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AllocateDedicatedHostsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.network_attributes is not None:
            result['NetworkAttributes'] = self.network_attributes.to_map()
        if self.action_on_maintenance is not None:
            result['ActionOnMaintenance'] = self.action_on_maintenance
        if self.auto_placement is not None:
            result['AutoPlacement'] = self.auto_placement
        if self.auto_release_time is not None:
            result['AutoReleaseTime'] = self.auto_release_time
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.auto_renew_period is not None:
            result['AutoRenewPeriod'] = self.auto_renew_period
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.cpu_over_commit_ratio is not None:
            result['CpuOverCommitRatio'] = self.cpu_over_commit_ratio
        if self.dedicated_host_cluster_id is not None:
            result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        if self.dedicated_host_name is not None:
            result['DedicatedHostName'] = self.dedicated_host_name
        if self.dedicated_host_type is not None:
            result['DedicatedHostType'] = self.dedicated_host_type
        if self.description is not None:
            result['Description'] = self.description
        if self.min_quantity is not None:
            result['MinQuantity'] = self.min_quantity
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.quantity is not None:
            result['Quantity'] = self.quantity
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NetworkAttributes') is not None:
            temp_model = AllocateDedicatedHostsRequestNetworkAttributes()
            self.network_attributes = temp_model.from_map(m['NetworkAttributes'])
        if m.get('ActionOnMaintenance') is not None:
            self.action_on_maintenance = m.get('ActionOnMaintenance')
        if m.get('AutoPlacement') is not None:
            self.auto_placement = m.get('AutoPlacement')
        if m.get('AutoReleaseTime') is not None:
            self.auto_release_time = m.get('AutoReleaseTime')
        if m.get('AutoRenew') is not None:
            self.auto_renew = m.get('AutoRenew')
        if m.get('AutoRenewPeriod') is not None:
            self.auto_renew_period = m.get('AutoRenewPeriod')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('CpuOverCommitRatio') is not None:
            self.cpu_over_commit_ratio = m.get('CpuOverCommitRatio')
        if m.get('DedicatedHostClusterId') is not None:
            self.dedicated_host_cluster_id = m.get('DedicatedHostClusterId')
        if m.get('DedicatedHostName') is not None:
            self.dedicated_host_name = m.get('DedicatedHostName')
        if m.get('DedicatedHostType') is not None:
            self.dedicated_host_type = m.get('DedicatedHostType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('MinQuantity') is not None:
            self.min_quantity = m.get('MinQuantity')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('Quantity') is not None:
            self.quantity = m.get('Quantity')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = AllocateDedicatedHostsRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class AllocateDedicatedHostsResponseBodyDedicatedHostIdSets(TeaModel):
    def __init__(self, dedicated_host_id=None):
        self.dedicated_host_id = dedicated_host_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(AllocateDedicatedHostsResponseBodyDedicatedHostIdSets, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DedicatedHostId') is not None:
            self.dedicated_host_id = m.get('DedicatedHostId')
        return self


class AllocateDedicatedHostsResponseBody(TeaModel):
    def __init__(self, dedicated_host_id_sets=None, request_id=None):
        self.dedicated_host_id_sets = dedicated_host_id_sets  # type: AllocateDedicatedHostsResponseBodyDedicatedHostIdSets
        self.request_id = request_id  # type: str

    def validate(self):
        if self.dedicated_host_id_sets:
            self.dedicated_host_id_sets.validate()

    def to_map(self):
        _map = super(AllocateDedicatedHostsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_host_id_sets is not None:
            result['DedicatedHostIdSets'] = self.dedicated_host_id_sets.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DedicatedHostIdSets') is not None:
            temp_model = AllocateDedicatedHostsResponseBodyDedicatedHostIdSets()
            self.dedicated_host_id_sets = temp_model.from_map(m['DedicatedHostIdSets'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AllocateDedicatedHostsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AllocateDedicatedHostsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AllocateDedicatedHostsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AllocateDedicatedHostsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AllocateEipAddressRequest(TeaModel):
    def __init__(self, activity_id=None, bandwidth=None, client_token=None, isp=None, internet_charge_type=None,
                 owner_account=None, owner_id=None, region_id=None, resource_owner_account=None, resource_owner_id=None):
        self.activity_id = activity_id  # type: long
        self.bandwidth = bandwidth  # type: str
        self.client_token = client_token  # type: str
        self.isp = isp  # type: str
        self.internet_charge_type = internet_charge_type  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(AllocateEipAddressRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.activity_id is not None:
            result['ActivityId'] = self.activity_id
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.isp is not None:
            result['ISP'] = self.isp
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActivityId') is not None:
            self.activity_id = m.get('ActivityId')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ISP') is not None:
            self.isp = m.get('ISP')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class AllocateEipAddressResponseBody(TeaModel):
    def __init__(self, allocation_id=None, eip_address=None, request_id=None):
        self.allocation_id = allocation_id  # type: str
        self.eip_address = eip_address  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AllocateEipAddressResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allocation_id is not None:
            result['AllocationId'] = self.allocation_id
        if self.eip_address is not None:
            result['EipAddress'] = self.eip_address
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AllocationId') is not None:
            self.allocation_id = m.get('AllocationId')
        if m.get('EipAddress') is not None:
            self.eip_address = m.get('EipAddress')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AllocateEipAddressResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AllocateEipAddressResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AllocateEipAddressResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AllocateEipAddressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AllocatePublicIpAddressRequest(TeaModel):
    def __init__(self, instance_id=None, ip_address=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, vlan_id=None):
        self.instance_id = instance_id  # type: str
        self.ip_address = ip_address  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.vlan_id = vlan_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AllocatePublicIpAddressRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.vlan_id is not None:
            result['VlanId'] = self.vlan_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('VlanId') is not None:
            self.vlan_id = m.get('VlanId')
        return self


class AllocatePublicIpAddressResponseBody(TeaModel):
    def __init__(self, ip_address=None, request_id=None):
        self.ip_address = ip_address  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AllocatePublicIpAddressResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AllocatePublicIpAddressResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AllocatePublicIpAddressResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AllocatePublicIpAddressResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AllocatePublicIpAddressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ApplyAutoSnapshotPolicyRequest(TeaModel):
    def __init__(self, owner_id=None, resource_owner_account=None, resource_owner_id=None,
                 auto_snapshot_policy_id=None, disk_ids=None, region_id=None):
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.auto_snapshot_policy_id = auto_snapshot_policy_id  # type: str
        self.disk_ids = disk_ids  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyAutoSnapshotPolicyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.auto_snapshot_policy_id is not None:
            result['autoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        if self.disk_ids is not None:
            result['diskIds'] = self.disk_ids
        if self.region_id is not None:
            result['regionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('autoSnapshotPolicyId') is not None:
            self.auto_snapshot_policy_id = m.get('autoSnapshotPolicyId')
        if m.get('diskIds') is not None:
            self.disk_ids = m.get('diskIds')
        if m.get('regionId') is not None:
            self.region_id = m.get('regionId')
        return self


class ApplyAutoSnapshotPolicyResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ApplyAutoSnapshotPolicyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ApplyAutoSnapshotPolicyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ApplyAutoSnapshotPolicyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ApplyAutoSnapshotPolicyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ApplyAutoSnapshotPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AssignIpv6AddressesRequest(TeaModel):
    def __init__(self, ipv_6address=None, ipv_6address_count=None, network_interface_id=None, owner_account=None,
                 owner_id=None, region_id=None, resource_owner_account=None, resource_owner_id=None):
        self.ipv_6address = ipv_6address  # type: list[str]
        self.ipv_6address_count = ipv_6address_count  # type: int
        self.network_interface_id = network_interface_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(AssignIpv6AddressesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ipv_6address is not None:
            result['Ipv6Address'] = self.ipv_6address
        if self.ipv_6address_count is not None:
            result['Ipv6AddressCount'] = self.ipv_6address_count
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Ipv6Address') is not None:
            self.ipv_6address = m.get('Ipv6Address')
        if m.get('Ipv6AddressCount') is not None:
            self.ipv_6address_count = m.get('Ipv6AddressCount')
        if m.get('NetworkInterfaceId') is not None:
            self.network_interface_id = m.get('NetworkInterfaceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class AssignIpv6AddressesResponseBodyIpv6Sets(TeaModel):
    def __init__(self, ipv_6address=None):
        self.ipv_6address = ipv_6address  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(AssignIpv6AddressesResponseBodyIpv6Sets, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ipv_6address is not None:
            result['Ipv6Address'] = self.ipv_6address
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Ipv6Address') is not None:
            self.ipv_6address = m.get('Ipv6Address')
        return self


class AssignIpv6AddressesResponseBody(TeaModel):
    def __init__(self, ipv_6sets=None, network_interface_id=None, request_id=None):
        self.ipv_6sets = ipv_6sets  # type: AssignIpv6AddressesResponseBodyIpv6Sets
        self.network_interface_id = network_interface_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.ipv_6sets:
            self.ipv_6sets.validate()

    def to_map(self):
        _map = super(AssignIpv6AddressesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ipv_6sets is not None:
            result['Ipv6Sets'] = self.ipv_6sets.to_map()
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Ipv6Sets') is not None:
            temp_model = AssignIpv6AddressesResponseBodyIpv6Sets()
            self.ipv_6sets = temp_model.from_map(m['Ipv6Sets'])
        if m.get('NetworkInterfaceId') is not None:
            self.network_interface_id = m.get('NetworkInterfaceId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AssignIpv6AddressesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AssignIpv6AddressesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AssignIpv6AddressesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AssignIpv6AddressesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AssignPrivateIpAddressesRequest(TeaModel):
    def __init__(self, client_token=None, network_interface_id=None, owner_account=None, owner_id=None,
                 private_ip_address=None, region_id=None, resource_owner_account=None, resource_owner_id=None,
                 secondary_private_ip_address_count=None):
        self.client_token = client_token  # type: str
        self.network_interface_id = network_interface_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.private_ip_address = private_ip_address  # type: list[str]
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.secondary_private_ip_address_count = secondary_private_ip_address_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(AssignPrivateIpAddressesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.secondary_private_ip_address_count is not None:
            result['SecondaryPrivateIpAddressCount'] = self.secondary_private_ip_address_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('NetworkInterfaceId') is not None:
            self.network_interface_id = m.get('NetworkInterfaceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PrivateIpAddress') is not None:
            self.private_ip_address = m.get('PrivateIpAddress')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SecondaryPrivateIpAddressCount') is not None:
            self.secondary_private_ip_address_count = m.get('SecondaryPrivateIpAddressCount')
        return self


class AssignPrivateIpAddressesResponseBodyAssignedPrivateIpAddressesSetPrivateIpSet(TeaModel):
    def __init__(self, private_ip_address=None):
        self.private_ip_address = private_ip_address  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(AssignPrivateIpAddressesResponseBodyAssignedPrivateIpAddressesSetPrivateIpSet, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PrivateIpAddress') is not None:
            self.private_ip_address = m.get('PrivateIpAddress')
        return self


class AssignPrivateIpAddressesResponseBodyAssignedPrivateIpAddressesSet(TeaModel):
    def __init__(self, network_interface_id=None, private_ip_set=None):
        self.network_interface_id = network_interface_id  # type: str
        self.private_ip_set = private_ip_set  # type: AssignPrivateIpAddressesResponseBodyAssignedPrivateIpAddressesSetPrivateIpSet

    def validate(self):
        if self.private_ip_set:
            self.private_ip_set.validate()

    def to_map(self):
        _map = super(AssignPrivateIpAddressesResponseBodyAssignedPrivateIpAddressesSet, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.private_ip_set is not None:
            result['PrivateIpSet'] = self.private_ip_set.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NetworkInterfaceId') is not None:
            self.network_interface_id = m.get('NetworkInterfaceId')
        if m.get('PrivateIpSet') is not None:
            temp_model = AssignPrivateIpAddressesResponseBodyAssignedPrivateIpAddressesSetPrivateIpSet()
            self.private_ip_set = temp_model.from_map(m['PrivateIpSet'])
        return self


class AssignPrivateIpAddressesResponseBody(TeaModel):
    def __init__(self, assigned_private_ip_addresses_set=None, request_id=None):
        self.assigned_private_ip_addresses_set = assigned_private_ip_addresses_set  # type: AssignPrivateIpAddressesResponseBodyAssignedPrivateIpAddressesSet
        self.request_id = request_id  # type: str

    def validate(self):
        if self.assigned_private_ip_addresses_set:
            self.assigned_private_ip_addresses_set.validate()

    def to_map(self):
        _map = super(AssignPrivateIpAddressesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.assigned_private_ip_addresses_set is not None:
            result['AssignedPrivateIpAddressesSet'] = self.assigned_private_ip_addresses_set.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AssignedPrivateIpAddressesSet') is not None:
            temp_model = AssignPrivateIpAddressesResponseBodyAssignedPrivateIpAddressesSet()
            self.assigned_private_ip_addresses_set = temp_model.from_map(m['AssignedPrivateIpAddressesSet'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AssignPrivateIpAddressesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AssignPrivateIpAddressesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AssignPrivateIpAddressesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AssignPrivateIpAddressesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AssociateEipAddressRequest(TeaModel):
    def __init__(self, allocation_id=None, instance_id=None, instance_type=None, owner_account=None, owner_id=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None):
        self.allocation_id = allocation_id  # type: str
        self.instance_id = instance_id  # type: str
        self.instance_type = instance_type  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(AssociateEipAddressRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allocation_id is not None:
            result['AllocationId'] = self.allocation_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AllocationId') is not None:
            self.allocation_id = m.get('AllocationId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class AssociateEipAddressResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AssociateEipAddressResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AssociateEipAddressResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AssociateEipAddressResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AssociateEipAddressResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AssociateEipAddressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AssociateHaVipRequest(TeaModel):
    def __init__(self, client_token=None, ha_vip_id=None, instance_id=None, owner_account=None, owner_id=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None):
        self.client_token = client_token  # type: str
        self.ha_vip_id = ha_vip_id  # type: str
        self.instance_id = instance_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(AssociateHaVipRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.ha_vip_id is not None:
            result['HaVipId'] = self.ha_vip_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('HaVipId') is not None:
            self.ha_vip_id = m.get('HaVipId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class AssociateHaVipResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AssociateHaVipResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AssociateHaVipResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AssociateHaVipResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AssociateHaVipResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AssociateHaVipResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AttachClassicLinkVpcRequest(TeaModel):
    def __init__(self, instance_id=None, owner_id=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None, vpc_id=None):
        self.instance_id = instance_id  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.vpc_id = vpc_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AttachClassicLinkVpcRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class AttachClassicLinkVpcResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AttachClassicLinkVpcResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AttachClassicLinkVpcResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AttachClassicLinkVpcResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AttachClassicLinkVpcResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AttachClassicLinkVpcResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AttachDiskRequest(TeaModel):
    def __init__(self, bootable=None, delete_with_instance=None, device=None, disk_id=None, instance_id=None,
                 key_pair_name=None, owner_account=None, owner_id=None, password=None, resource_owner_account=None,
                 resource_owner_id=None):
        self.bootable = bootable  # type: bool
        self.delete_with_instance = delete_with_instance  # type: bool
        self.device = device  # type: str
        self.disk_id = disk_id  # type: str
        self.instance_id = instance_id  # type: str
        self.key_pair_name = key_pair_name  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.password = password  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(AttachDiskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bootable is not None:
            result['Bootable'] = self.bootable
        if self.delete_with_instance is not None:
            result['DeleteWithInstance'] = self.delete_with_instance
        if self.device is not None:
            result['Device'] = self.device
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.password is not None:
            result['Password'] = self.password
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bootable') is not None:
            self.bootable = m.get('Bootable')
        if m.get('DeleteWithInstance') is not None:
            self.delete_with_instance = m.get('DeleteWithInstance')
        if m.get('Device') is not None:
            self.device = m.get('Device')
        if m.get('DiskId') is not None:
            self.disk_id = m.get('DiskId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class AttachDiskResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AttachDiskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AttachDiskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AttachDiskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AttachDiskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AttachDiskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AttachInstanceRamRoleRequest(TeaModel):
    def __init__(self, instance_ids=None, owner_id=None, policy=None, ram_role_name=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.instance_ids = instance_ids  # type: str
        self.owner_id = owner_id  # type: long
        self.policy = policy  # type: str
        self.ram_role_name = ram_role_name  # type: str
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(AttachInstanceRamRoleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.ram_role_name is not None:
            result['RamRoleName'] = self.ram_role_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('RamRoleName') is not None:
            self.ram_role_name = m.get('RamRoleName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class AttachInstanceRamRoleResponseBodyAttachInstanceRamRoleResultsAttachInstanceRamRoleResult(TeaModel):
    def __init__(self, code=None, instance_id=None, message=None, success=None):
        self.code = code  # type: str
        self.instance_id = instance_id  # type: str
        self.message = message  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(AttachInstanceRamRoleResponseBodyAttachInstanceRamRoleResultsAttachInstanceRamRoleResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.message is not None:
            result['Message'] = self.message
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AttachInstanceRamRoleResponseBodyAttachInstanceRamRoleResults(TeaModel):
    def __init__(self, attach_instance_ram_role_result=None):
        self.attach_instance_ram_role_result = attach_instance_ram_role_result  # type: list[AttachInstanceRamRoleResponseBodyAttachInstanceRamRoleResultsAttachInstanceRamRoleResult]

    def validate(self):
        if self.attach_instance_ram_role_result:
            for k in self.attach_instance_ram_role_result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AttachInstanceRamRoleResponseBodyAttachInstanceRamRoleResults, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AttachInstanceRamRoleResult'] = []
        if self.attach_instance_ram_role_result is not None:
            for k in self.attach_instance_ram_role_result:
                result['AttachInstanceRamRoleResult'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.attach_instance_ram_role_result = []
        if m.get('AttachInstanceRamRoleResult') is not None:
            for k in m.get('AttachInstanceRamRoleResult'):
                temp_model = AttachInstanceRamRoleResponseBodyAttachInstanceRamRoleResultsAttachInstanceRamRoleResult()
                self.attach_instance_ram_role_result.append(temp_model.from_map(k))
        return self


class AttachInstanceRamRoleResponseBody(TeaModel):
    def __init__(self, attach_instance_ram_role_results=None, fail_count=None, ram_role_name=None, request_id=None,
                 total_count=None):
        self.attach_instance_ram_role_results = attach_instance_ram_role_results  # type: AttachInstanceRamRoleResponseBodyAttachInstanceRamRoleResults
        self.fail_count = fail_count  # type: int
        self.ram_role_name = ram_role_name  # type: str
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.attach_instance_ram_role_results:
            self.attach_instance_ram_role_results.validate()

    def to_map(self):
        _map = super(AttachInstanceRamRoleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attach_instance_ram_role_results is not None:
            result['AttachInstanceRamRoleResults'] = self.attach_instance_ram_role_results.to_map()
        if self.fail_count is not None:
            result['FailCount'] = self.fail_count
        if self.ram_role_name is not None:
            result['RamRoleName'] = self.ram_role_name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AttachInstanceRamRoleResults') is not None:
            temp_model = AttachInstanceRamRoleResponseBodyAttachInstanceRamRoleResults()
            self.attach_instance_ram_role_results = temp_model.from_map(m['AttachInstanceRamRoleResults'])
        if m.get('FailCount') is not None:
            self.fail_count = m.get('FailCount')
        if m.get('RamRoleName') is not None:
            self.ram_role_name = m.get('RamRoleName')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class AttachInstanceRamRoleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AttachInstanceRamRoleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AttachInstanceRamRoleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AttachInstanceRamRoleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AttachKeyPairRequest(TeaModel):
    def __init__(self, instance_ids=None, key_pair_name=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.instance_ids = instance_ids  # type: str
        self.key_pair_name = key_pair_name  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(AttachKeyPairRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class AttachKeyPairResponseBodyResultsResult(TeaModel):
    def __init__(self, code=None, instance_id=None, message=None, success=None):
        self.code = code  # type: str
        self.instance_id = instance_id  # type: str
        self.message = message  # type: str
        self.success = success  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AttachKeyPairResponseBodyResultsResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.message is not None:
            result['Message'] = self.message
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AttachKeyPairResponseBodyResults(TeaModel):
    def __init__(self, result=None):
        self.result = result  # type: list[AttachKeyPairResponseBodyResultsResult]

    def validate(self):
        if self.result:
            for k in self.result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AttachKeyPairResponseBodyResults, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Result'] = []
        if self.result is not None:
            for k in self.result:
                result['Result'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.result = []
        if m.get('Result') is not None:
            for k in m.get('Result'):
                temp_model = AttachKeyPairResponseBodyResultsResult()
                self.result.append(temp_model.from_map(k))
        return self


class AttachKeyPairResponseBody(TeaModel):
    def __init__(self, fail_count=None, key_pair_name=None, request_id=None, results=None, total_count=None):
        self.fail_count = fail_count  # type: str
        self.key_pair_name = key_pair_name  # type: str
        self.request_id = request_id  # type: str
        self.results = results  # type: AttachKeyPairResponseBodyResults
        self.total_count = total_count  # type: str

    def validate(self):
        if self.results:
            self.results.validate()

    def to_map(self):
        _map = super(AttachKeyPairResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fail_count is not None:
            result['FailCount'] = self.fail_count
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.results is not None:
            result['Results'] = self.results.to_map()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FailCount') is not None:
            self.fail_count = m.get('FailCount')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Results') is not None:
            temp_model = AttachKeyPairResponseBodyResults()
            self.results = temp_model.from_map(m['Results'])
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class AttachKeyPairResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AttachKeyPairResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AttachKeyPairResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AttachKeyPairResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AttachNetworkInterfaceRequest(TeaModel):
    def __init__(self, instance_id=None, network_interface_id=None, owner_account=None, owner_id=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None, trunk_network_instance_id=None,
                 wait_for_network_configuration_ready=None):
        self.instance_id = instance_id  # type: str
        self.network_interface_id = network_interface_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.trunk_network_instance_id = trunk_network_instance_id  # type: str
        self.wait_for_network_configuration_ready = wait_for_network_configuration_ready  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(AttachNetworkInterfaceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.trunk_network_instance_id is not None:
            result['TrunkNetworkInstanceId'] = self.trunk_network_instance_id
        if self.wait_for_network_configuration_ready is not None:
            result['WaitForNetworkConfigurationReady'] = self.wait_for_network_configuration_ready
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NetworkInterfaceId') is not None:
            self.network_interface_id = m.get('NetworkInterfaceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TrunkNetworkInstanceId') is not None:
            self.trunk_network_instance_id = m.get('TrunkNetworkInstanceId')
        if m.get('WaitForNetworkConfigurationReady') is not None:
            self.wait_for_network_configuration_ready = m.get('WaitForNetworkConfigurationReady')
        return self


class AttachNetworkInterfaceResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AttachNetworkInterfaceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AttachNetworkInterfaceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AttachNetworkInterfaceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AttachNetworkInterfaceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AttachNetworkInterfaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AuthorizeSecurityGroupRequestPermissions(TeaModel):
    def __init__(self, description=None, dest_cidr_ip=None, ip_protocol=None, ipv_6dest_cidr_ip=None,
                 ipv_6source_cidr_ip=None, nic_type=None, policy=None, port_range=None, priority=None, source_cidr_ip=None,
                 source_group_id=None, source_group_owner_account=None, source_group_owner_id=None, source_port_range=None,
                 source_prefix_list_id=None):
        self.description = description  # type: str
        self.dest_cidr_ip = dest_cidr_ip  # type: str
        self.ip_protocol = ip_protocol  # type: str
        self.ipv_6dest_cidr_ip = ipv_6dest_cidr_ip  # type: str
        self.ipv_6source_cidr_ip = ipv_6source_cidr_ip  # type: str
        self.nic_type = nic_type  # type: str
        self.policy = policy  # type: str
        self.port_range = port_range  # type: str
        self.priority = priority  # type: str
        self.source_cidr_ip = source_cidr_ip  # type: str
        self.source_group_id = source_group_id  # type: str
        self.source_group_owner_account = source_group_owner_account  # type: str
        self.source_group_owner_id = source_group_owner_id  # type: long
        self.source_port_range = source_port_range  # type: str
        self.source_prefix_list_id = source_prefix_list_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AuthorizeSecurityGroupRequestPermissions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.dest_cidr_ip is not None:
            result['DestCidrIp'] = self.dest_cidr_ip
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.ipv_6dest_cidr_ip is not None:
            result['Ipv6DestCidrIp'] = self.ipv_6dest_cidr_ip
        if self.ipv_6source_cidr_ip is not None:
            result['Ipv6SourceCidrIp'] = self.ipv_6source_cidr_ip
        if self.nic_type is not None:
            result['NicType'] = self.nic_type
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.port_range is not None:
            result['PortRange'] = self.port_range
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.source_cidr_ip is not None:
            result['SourceCidrIp'] = self.source_cidr_ip
        if self.source_group_id is not None:
            result['SourceGroupId'] = self.source_group_id
        if self.source_group_owner_account is not None:
            result['SourceGroupOwnerAccount'] = self.source_group_owner_account
        if self.source_group_owner_id is not None:
            result['SourceGroupOwnerId'] = self.source_group_owner_id
        if self.source_port_range is not None:
            result['SourcePortRange'] = self.source_port_range
        if self.source_prefix_list_id is not None:
            result['SourcePrefixListId'] = self.source_prefix_list_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DestCidrIp') is not None:
            self.dest_cidr_ip = m.get('DestCidrIp')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('Ipv6DestCidrIp') is not None:
            self.ipv_6dest_cidr_ip = m.get('Ipv6DestCidrIp')
        if m.get('Ipv6SourceCidrIp') is not None:
            self.ipv_6source_cidr_ip = m.get('Ipv6SourceCidrIp')
        if m.get('NicType') is not None:
            self.nic_type = m.get('NicType')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('PortRange') is not None:
            self.port_range = m.get('PortRange')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('SourceCidrIp') is not None:
            self.source_cidr_ip = m.get('SourceCidrIp')
        if m.get('SourceGroupId') is not None:
            self.source_group_id = m.get('SourceGroupId')
        if m.get('SourceGroupOwnerAccount') is not None:
            self.source_group_owner_account = m.get('SourceGroupOwnerAccount')
        if m.get('SourceGroupOwnerId') is not None:
            self.source_group_owner_id = m.get('SourceGroupOwnerId')
        if m.get('SourcePortRange') is not None:
            self.source_port_range = m.get('SourcePortRange')
        if m.get('SourcePrefixListId') is not None:
            self.source_prefix_list_id = m.get('SourcePrefixListId')
        return self


class AuthorizeSecurityGroupRequest(TeaModel):
    def __init__(self, client_token=None, description=None, dest_cidr_ip=None, ip_protocol=None,
                 ipv_6dest_cidr_ip=None, ipv_6source_cidr_ip=None, nic_type=None, owner_account=None, owner_id=None, permissions=None,
                 policy=None, port_range=None, priority=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None, security_group_id=None, source_cidr_ip=None, source_group_id=None,
                 source_group_owner_account=None, source_group_owner_id=None, source_port_range=None, source_prefix_list_id=None):
        self.client_token = client_token  # type: str
        self.description = description  # type: str
        self.dest_cidr_ip = dest_cidr_ip  # type: str
        self.ip_protocol = ip_protocol  # type: str
        self.ipv_6dest_cidr_ip = ipv_6dest_cidr_ip  # type: str
        self.ipv_6source_cidr_ip = ipv_6source_cidr_ip  # type: str
        self.nic_type = nic_type  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.permissions = permissions  # type: list[AuthorizeSecurityGroupRequestPermissions]
        self.policy = policy  # type: str
        self.port_range = port_range  # type: str
        self.priority = priority  # type: str
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.security_group_id = security_group_id  # type: str
        self.source_cidr_ip = source_cidr_ip  # type: str
        self.source_group_id = source_group_id  # type: str
        self.source_group_owner_account = source_group_owner_account  # type: str
        self.source_group_owner_id = source_group_owner_id  # type: long
        self.source_port_range = source_port_range  # type: str
        self.source_prefix_list_id = source_prefix_list_id  # type: str

    def validate(self):
        if self.permissions:
            for k in self.permissions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AuthorizeSecurityGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.dest_cidr_ip is not None:
            result['DestCidrIp'] = self.dest_cidr_ip
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.ipv_6dest_cidr_ip is not None:
            result['Ipv6DestCidrIp'] = self.ipv_6dest_cidr_ip
        if self.ipv_6source_cidr_ip is not None:
            result['Ipv6SourceCidrIp'] = self.ipv_6source_cidr_ip
        if self.nic_type is not None:
            result['NicType'] = self.nic_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        result['Permissions'] = []
        if self.permissions is not None:
            for k in self.permissions:
                result['Permissions'].append(k.to_map() if k else None)
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.port_range is not None:
            result['PortRange'] = self.port_range
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.source_cidr_ip is not None:
            result['SourceCidrIp'] = self.source_cidr_ip
        if self.source_group_id is not None:
            result['SourceGroupId'] = self.source_group_id
        if self.source_group_owner_account is not None:
            result['SourceGroupOwnerAccount'] = self.source_group_owner_account
        if self.source_group_owner_id is not None:
            result['SourceGroupOwnerId'] = self.source_group_owner_id
        if self.source_port_range is not None:
            result['SourcePortRange'] = self.source_port_range
        if self.source_prefix_list_id is not None:
            result['SourcePrefixListId'] = self.source_prefix_list_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DestCidrIp') is not None:
            self.dest_cidr_ip = m.get('DestCidrIp')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('Ipv6DestCidrIp') is not None:
            self.ipv_6dest_cidr_ip = m.get('Ipv6DestCidrIp')
        if m.get('Ipv6SourceCidrIp') is not None:
            self.ipv_6source_cidr_ip = m.get('Ipv6SourceCidrIp')
        if m.get('NicType') is not None:
            self.nic_type = m.get('NicType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        self.permissions = []
        if m.get('Permissions') is not None:
            for k in m.get('Permissions'):
                temp_model = AuthorizeSecurityGroupRequestPermissions()
                self.permissions.append(temp_model.from_map(k))
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('PortRange') is not None:
            self.port_range = m.get('PortRange')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('SourceCidrIp') is not None:
            self.source_cidr_ip = m.get('SourceCidrIp')
        if m.get('SourceGroupId') is not None:
            self.source_group_id = m.get('SourceGroupId')
        if m.get('SourceGroupOwnerAccount') is not None:
            self.source_group_owner_account = m.get('SourceGroupOwnerAccount')
        if m.get('SourceGroupOwnerId') is not None:
            self.source_group_owner_id = m.get('SourceGroupOwnerId')
        if m.get('SourcePortRange') is not None:
            self.source_port_range = m.get('SourcePortRange')
        if m.get('SourcePrefixListId') is not None:
            self.source_prefix_list_id = m.get('SourcePrefixListId')
        return self


class AuthorizeSecurityGroupResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AuthorizeSecurityGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AuthorizeSecurityGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AuthorizeSecurityGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AuthorizeSecurityGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AuthorizeSecurityGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AuthorizeSecurityGroupEgressRequestPermissions(TeaModel):
    def __init__(self, description=None, dest_cidr_ip=None, dest_group_id=None, dest_group_owner_account=None,
                 dest_group_owner_id=None, dest_prefix_list_id=None, ip_protocol=None, ipv_6dest_cidr_ip=None,
                 ipv_6source_cidr_ip=None, nic_type=None, policy=None, port_range=None, priority=None, source_cidr_ip=None,
                 source_port_range=None):
        self.description = description  # type: str
        self.dest_cidr_ip = dest_cidr_ip  # type: str
        self.dest_group_id = dest_group_id  # type: str
        self.dest_group_owner_account = dest_group_owner_account  # type: str
        self.dest_group_owner_id = dest_group_owner_id  # type: long
        self.dest_prefix_list_id = dest_prefix_list_id  # type: str
        self.ip_protocol = ip_protocol  # type: str
        self.ipv_6dest_cidr_ip = ipv_6dest_cidr_ip  # type: str
        self.ipv_6source_cidr_ip = ipv_6source_cidr_ip  # type: str
        self.nic_type = nic_type  # type: str
        self.policy = policy  # type: str
        self.port_range = port_range  # type: str
        self.priority = priority  # type: str
        self.source_cidr_ip = source_cidr_ip  # type: str
        self.source_port_range = source_port_range  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AuthorizeSecurityGroupEgressRequestPermissions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.dest_cidr_ip is not None:
            result['DestCidrIp'] = self.dest_cidr_ip
        if self.dest_group_id is not None:
            result['DestGroupId'] = self.dest_group_id
        if self.dest_group_owner_account is not None:
            result['DestGroupOwnerAccount'] = self.dest_group_owner_account
        if self.dest_group_owner_id is not None:
            result['DestGroupOwnerId'] = self.dest_group_owner_id
        if self.dest_prefix_list_id is not None:
            result['DestPrefixListId'] = self.dest_prefix_list_id
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.ipv_6dest_cidr_ip is not None:
            result['Ipv6DestCidrIp'] = self.ipv_6dest_cidr_ip
        if self.ipv_6source_cidr_ip is not None:
            result['Ipv6SourceCidrIp'] = self.ipv_6source_cidr_ip
        if self.nic_type is not None:
            result['NicType'] = self.nic_type
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.port_range is not None:
            result['PortRange'] = self.port_range
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.source_cidr_ip is not None:
            result['SourceCidrIp'] = self.source_cidr_ip
        if self.source_port_range is not None:
            result['SourcePortRange'] = self.source_port_range
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DestCidrIp') is not None:
            self.dest_cidr_ip = m.get('DestCidrIp')
        if m.get('DestGroupId') is not None:
            self.dest_group_id = m.get('DestGroupId')
        if m.get('DestGroupOwnerAccount') is not None:
            self.dest_group_owner_account = m.get('DestGroupOwnerAccount')
        if m.get('DestGroupOwnerId') is not None:
            self.dest_group_owner_id = m.get('DestGroupOwnerId')
        if m.get('DestPrefixListId') is not None:
            self.dest_prefix_list_id = m.get('DestPrefixListId')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('Ipv6DestCidrIp') is not None:
            self.ipv_6dest_cidr_ip = m.get('Ipv6DestCidrIp')
        if m.get('Ipv6SourceCidrIp') is not None:
            self.ipv_6source_cidr_ip = m.get('Ipv6SourceCidrIp')
        if m.get('NicType') is not None:
            self.nic_type = m.get('NicType')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('PortRange') is not None:
            self.port_range = m.get('PortRange')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('SourceCidrIp') is not None:
            self.source_cidr_ip = m.get('SourceCidrIp')
        if m.get('SourcePortRange') is not None:
            self.source_port_range = m.get('SourcePortRange')
        return self


class AuthorizeSecurityGroupEgressRequest(TeaModel):
    def __init__(self, client_token=None, description=None, dest_cidr_ip=None, dest_group_id=None,
                 dest_group_owner_account=None, dest_group_owner_id=None, dest_prefix_list_id=None, ip_protocol=None,
                 ipv_6dest_cidr_ip=None, ipv_6source_cidr_ip=None, nic_type=None, owner_account=None, owner_id=None, permissions=None,
                 policy=None, port_range=None, priority=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None, security_group_id=None, source_cidr_ip=None, source_port_range=None):
        self.client_token = client_token  # type: str
        self.description = description  # type: str
        self.dest_cidr_ip = dest_cidr_ip  # type: str
        self.dest_group_id = dest_group_id  # type: str
        self.dest_group_owner_account = dest_group_owner_account  # type: str
        self.dest_group_owner_id = dest_group_owner_id  # type: long
        self.dest_prefix_list_id = dest_prefix_list_id  # type: str
        self.ip_protocol = ip_protocol  # type: str
        self.ipv_6dest_cidr_ip = ipv_6dest_cidr_ip  # type: str
        self.ipv_6source_cidr_ip = ipv_6source_cidr_ip  # type: str
        self.nic_type = nic_type  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.permissions = permissions  # type: list[AuthorizeSecurityGroupEgressRequestPermissions]
        self.policy = policy  # type: str
        self.port_range = port_range  # type: str
        self.priority = priority  # type: str
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.security_group_id = security_group_id  # type: str
        self.source_cidr_ip = source_cidr_ip  # type: str
        self.source_port_range = source_port_range  # type: str

    def validate(self):
        if self.permissions:
            for k in self.permissions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AuthorizeSecurityGroupEgressRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.dest_cidr_ip is not None:
            result['DestCidrIp'] = self.dest_cidr_ip
        if self.dest_group_id is not None:
            result['DestGroupId'] = self.dest_group_id
        if self.dest_group_owner_account is not None:
            result['DestGroupOwnerAccount'] = self.dest_group_owner_account
        if self.dest_group_owner_id is not None:
            result['DestGroupOwnerId'] = self.dest_group_owner_id
        if self.dest_prefix_list_id is not None:
            result['DestPrefixListId'] = self.dest_prefix_list_id
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.ipv_6dest_cidr_ip is not None:
            result['Ipv6DestCidrIp'] = self.ipv_6dest_cidr_ip
        if self.ipv_6source_cidr_ip is not None:
            result['Ipv6SourceCidrIp'] = self.ipv_6source_cidr_ip
        if self.nic_type is not None:
            result['NicType'] = self.nic_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        result['Permissions'] = []
        if self.permissions is not None:
            for k in self.permissions:
                result['Permissions'].append(k.to_map() if k else None)
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.port_range is not None:
            result['PortRange'] = self.port_range
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.source_cidr_ip is not None:
            result['SourceCidrIp'] = self.source_cidr_ip
        if self.source_port_range is not None:
            result['SourcePortRange'] = self.source_port_range
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DestCidrIp') is not None:
            self.dest_cidr_ip = m.get('DestCidrIp')
        if m.get('DestGroupId') is not None:
            self.dest_group_id = m.get('DestGroupId')
        if m.get('DestGroupOwnerAccount') is not None:
            self.dest_group_owner_account = m.get('DestGroupOwnerAccount')
        if m.get('DestGroupOwnerId') is not None:
            self.dest_group_owner_id = m.get('DestGroupOwnerId')
        if m.get('DestPrefixListId') is not None:
            self.dest_prefix_list_id = m.get('DestPrefixListId')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('Ipv6DestCidrIp') is not None:
            self.ipv_6dest_cidr_ip = m.get('Ipv6DestCidrIp')
        if m.get('Ipv6SourceCidrIp') is not None:
            self.ipv_6source_cidr_ip = m.get('Ipv6SourceCidrIp')
        if m.get('NicType') is not None:
            self.nic_type = m.get('NicType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        self.permissions = []
        if m.get('Permissions') is not None:
            for k in m.get('Permissions'):
                temp_model = AuthorizeSecurityGroupEgressRequestPermissions()
                self.permissions.append(temp_model.from_map(k))
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('PortRange') is not None:
            self.port_range = m.get('PortRange')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('SourceCidrIp') is not None:
            self.source_cidr_ip = m.get('SourceCidrIp')
        if m.get('SourcePortRange') is not None:
            self.source_port_range = m.get('SourcePortRange')
        return self


class AuthorizeSecurityGroupEgressResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AuthorizeSecurityGroupEgressResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AuthorizeSecurityGroupEgressResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AuthorizeSecurityGroupEgressResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AuthorizeSecurityGroupEgressResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AuthorizeSecurityGroupEgressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelAutoSnapshotPolicyRequest(TeaModel):
    def __init__(self, owner_id=None, resource_owner_account=None, resource_owner_id=None, disk_ids=None,
                 region_id=None):
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.disk_ids = disk_ids  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelAutoSnapshotPolicyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.disk_ids is not None:
            result['diskIds'] = self.disk_ids
        if self.region_id is not None:
            result['regionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('diskIds') is not None:
            self.disk_ids = m.get('diskIds')
        if m.get('regionId') is not None:
            self.region_id = m.get('regionId')
        return self


class CancelAutoSnapshotPolicyResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelAutoSnapshotPolicyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelAutoSnapshotPolicyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CancelAutoSnapshotPolicyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CancelAutoSnapshotPolicyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelAutoSnapshotPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelCopyImageRequest(TeaModel):
    def __init__(self, image_id=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.image_id = image_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelCopyImageRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CancelCopyImageResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelCopyImageResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelCopyImageResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CancelCopyImageResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CancelCopyImageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelCopyImageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelImagePipelineExecutionRequestTemplateTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelImagePipelineExecutionRequestTemplateTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CancelImagePipelineExecutionRequest(TeaModel):
    def __init__(self, execution_id=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None, template_tag=None):
        self.execution_id = execution_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.template_tag = template_tag  # type: list[CancelImagePipelineExecutionRequestTemplateTag]

    def validate(self):
        if self.template_tag:
            for k in self.template_tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CancelImagePipelineExecutionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.execution_id is not None:
            result['ExecutionId'] = self.execution_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        result['TemplateTag'] = []
        if self.template_tag is not None:
            for k in self.template_tag:
                result['TemplateTag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ExecutionId') is not None:
            self.execution_id = m.get('ExecutionId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        self.template_tag = []
        if m.get('TemplateTag') is not None:
            for k in m.get('TemplateTag'):
                temp_model = CancelImagePipelineExecutionRequestTemplateTag()
                self.template_tag.append(temp_model.from_map(k))
        return self


class CancelImagePipelineExecutionResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelImagePipelineExecutionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelImagePipelineExecutionResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CancelImagePipelineExecutionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CancelImagePipelineExecutionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelImagePipelineExecutionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelPhysicalConnectionRequest(TeaModel):
    def __init__(self, client_token=None, owner_account=None, owner_id=None, physical_connection_id=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None, user_cidr=None):
        self.client_token = client_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.physical_connection_id = physical_connection_id  # type: str
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.user_cidr = user_cidr  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelPhysicalConnectionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.physical_connection_id is not None:
            result['PhysicalConnectionId'] = self.physical_connection_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.user_cidr is not None:
            result['UserCidr'] = self.user_cidr
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PhysicalConnectionId') is not None:
            self.physical_connection_id = m.get('PhysicalConnectionId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('UserCidr') is not None:
            self.user_cidr = m.get('UserCidr')
        return self


class CancelPhysicalConnectionResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelPhysicalConnectionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelPhysicalConnectionResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CancelPhysicalConnectionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CancelPhysicalConnectionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelPhysicalConnectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelSimulatedSystemEventsRequest(TeaModel):
    def __init__(self, event_id=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.event_id = event_id  # type: list[str]
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelSimulatedSystemEventsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CancelSimulatedSystemEventsResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelSimulatedSystemEventsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelSimulatedSystemEventsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CancelSimulatedSystemEventsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CancelSimulatedSystemEventsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelSimulatedSystemEventsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelTaskRequest(TeaModel):
    def __init__(self, owner_id=None, region_id=None, resource_owner_account=None, resource_owner_id=None,
                 task_id=None):
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.task_id = task_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CancelTaskResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CancelTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CancelTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ConnectRouterInterfaceRequest(TeaModel):
    def __init__(self, owner_id=None, region_id=None, resource_owner_account=None, resource_owner_id=None,
                 router_interface_id=None):
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.router_interface_id = router_interface_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ConnectRouterInterfaceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.router_interface_id is not None:
            result['RouterInterfaceId'] = self.router_interface_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RouterInterfaceId') is not None:
            self.router_interface_id = m.get('RouterInterfaceId')
        return self


class ConnectRouterInterfaceResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ConnectRouterInterfaceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ConnectRouterInterfaceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ConnectRouterInterfaceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ConnectRouterInterfaceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ConnectRouterInterfaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ConvertNatPublicIpToEipRequest(TeaModel):
    def __init__(self, instance_id=None, owner_id=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        self.instance_id = instance_id  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ConvertNatPublicIpToEipRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class ConvertNatPublicIpToEipResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ConvertNatPublicIpToEipResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ConvertNatPublicIpToEipResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ConvertNatPublicIpToEipResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ConvertNatPublicIpToEipResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ConvertNatPublicIpToEipResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CopyImageRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CopyImageRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CopyImageRequest(TeaModel):
    def __init__(self, destination_description=None, destination_image_name=None, destination_region_id=None,
                 encrypt_algorithm=None, encrypted=None, image_id=None, kmskey_id=None, owner_account=None, owner_id=None,
                 region_id=None, resource_group_id=None, resource_owner_account=None, resource_owner_id=None, tag=None):
        self.destination_description = destination_description  # type: str
        self.destination_image_name = destination_image_name  # type: str
        self.destination_region_id = destination_region_id  # type: str
        self.encrypt_algorithm = encrypt_algorithm  # type: str
        self.encrypted = encrypted  # type: bool
        self.image_id = image_id  # type: str
        self.kmskey_id = kmskey_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.tag = tag  # type: list[CopyImageRequestTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CopyImageRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.destination_description is not None:
            result['DestinationDescription'] = self.destination_description
        if self.destination_image_name is not None:
            result['DestinationImageName'] = self.destination_image_name
        if self.destination_region_id is not None:
            result['DestinationRegionId'] = self.destination_region_id
        if self.encrypt_algorithm is not None:
            result['EncryptAlgorithm'] = self.encrypt_algorithm
        if self.encrypted is not None:
            result['Encrypted'] = self.encrypted
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.kmskey_id is not None:
            result['KMSKeyId'] = self.kmskey_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DestinationDescription') is not None:
            self.destination_description = m.get('DestinationDescription')
        if m.get('DestinationImageName') is not None:
            self.destination_image_name = m.get('DestinationImageName')
        if m.get('DestinationRegionId') is not None:
            self.destination_region_id = m.get('DestinationRegionId')
        if m.get('EncryptAlgorithm') is not None:
            self.encrypt_algorithm = m.get('EncryptAlgorithm')
        if m.get('Encrypted') is not None:
            self.encrypted = m.get('Encrypted')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('KMSKeyId') is not None:
            self.kmskey_id = m.get('KMSKeyId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CopyImageRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CopyImageResponseBody(TeaModel):
    def __init__(self, image_id=None, request_id=None):
        self.image_id = image_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CopyImageResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CopyImageResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CopyImageResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CopyImageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CopyImageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CopySnapshotRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CopySnapshotRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CopySnapshotRequest(TeaModel):
    def __init__(self, destination_region_id=None, destination_snapshot_description=None,
                 destination_snapshot_name=None, owner_id=None, region_id=None, resource_group_id=None, resource_owner_account=None,
                 resource_owner_id=None, retention_days=None, snapshot_id=None, tag=None):
        self.destination_region_id = destination_region_id  # type: str
        self.destination_snapshot_description = destination_snapshot_description  # type: str
        self.destination_snapshot_name = destination_snapshot_name  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.retention_days = retention_days  # type: int
        self.snapshot_id = snapshot_id  # type: str
        self.tag = tag  # type: list[CopySnapshotRequestTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CopySnapshotRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.destination_region_id is not None:
            result['DestinationRegionId'] = self.destination_region_id
        if self.destination_snapshot_description is not None:
            result['DestinationSnapshotDescription'] = self.destination_snapshot_description
        if self.destination_snapshot_name is not None:
            result['DestinationSnapshotName'] = self.destination_snapshot_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.retention_days is not None:
            result['RetentionDays'] = self.retention_days
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DestinationRegionId') is not None:
            self.destination_region_id = m.get('DestinationRegionId')
        if m.get('DestinationSnapshotDescription') is not None:
            self.destination_snapshot_description = m.get('DestinationSnapshotDescription')
        if m.get('DestinationSnapshotName') is not None:
            self.destination_snapshot_name = m.get('DestinationSnapshotName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RetentionDays') is not None:
            self.retention_days = m.get('RetentionDays')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CopySnapshotRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CopySnapshotResponseBody(TeaModel):
    def __init__(self, request_id=None, snapshot_id=None):
        self.request_id = request_id  # type: str
        self.snapshot_id = snapshot_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CopySnapshotResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        return self


class CopySnapshotResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CopySnapshotResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CopySnapshotResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CopySnapshotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateActivationRequest(TeaModel):
    def __init__(self, description=None, instance_count=None, instance_name=None, ip_address_range=None,
                 owner_account=None, owner_id=None, region_id=None, resource_owner_account=None, resource_owner_id=None,
                 time_to_live_in_hours=None):
        self.description = description  # type: str
        self.instance_count = instance_count  # type: int
        self.instance_name = instance_name  # type: str
        self.ip_address_range = ip_address_range  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.time_to_live_in_hours = time_to_live_in_hours  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateActivationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.ip_address_range is not None:
            result['IpAddressRange'] = self.ip_address_range
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.time_to_live_in_hours is not None:
            result['TimeToLiveInHours'] = self.time_to_live_in_hours
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('IpAddressRange') is not None:
            self.ip_address_range = m.get('IpAddressRange')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TimeToLiveInHours') is not None:
            self.time_to_live_in_hours = m.get('TimeToLiveInHours')
        return self


class CreateActivationResponseBody(TeaModel):
    def __init__(self, activation_code=None, activation_id=None, request_id=None):
        self.activation_code = activation_code  # type: str
        self.activation_id = activation_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateActivationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.activation_code is not None:
            result['ActivationCode'] = self.activation_code
        if self.activation_id is not None:
            result['ActivationId'] = self.activation_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActivationCode') is not None:
            self.activation_code = m.get('ActivationCode')
        if m.get('ActivationId') is not None:
            self.activation_id = m.get('ActivationId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateActivationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateActivationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateActivationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateActivationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAutoProvisioningGroupRequestLaunchConfigurationArn(TeaModel):
    def __init__(self, assume_role_for=None, role_type=None, rolearn=None):
        self.assume_role_for = assume_role_for  # type: long
        self.role_type = role_type  # type: str
        self.rolearn = rolearn  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAutoProvisioningGroupRequestLaunchConfigurationArn, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.assume_role_for is not None:
            result['AssumeRoleFor'] = self.assume_role_for
        if self.role_type is not None:
            result['RoleType'] = self.role_type
        if self.rolearn is not None:
            result['Rolearn'] = self.rolearn
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AssumeRoleFor') is not None:
            self.assume_role_for = m.get('AssumeRoleFor')
        if m.get('RoleType') is not None:
            self.role_type = m.get('RoleType')
        if m.get('Rolearn') is not None:
            self.rolearn = m.get('Rolearn')
        return self


class CreateAutoProvisioningGroupRequestLaunchConfigurationDataDisk(TeaModel):
    def __init__(self, category=None, delete_with_instance=None, description=None, device=None, disk_name=None,
                 encrypted=None, kms_key_id=None, performance_level=None, size=None, snapshot_id=None):
        self.category = category  # type: str
        self.delete_with_instance = delete_with_instance  # type: bool
        self.description = description  # type: str
        self.device = device  # type: str
        self.disk_name = disk_name  # type: str
        self.encrypted = encrypted  # type: bool
        self.kms_key_id = kms_key_id  # type: str
        self.performance_level = performance_level  # type: str
        self.size = size  # type: int
        self.snapshot_id = snapshot_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAutoProvisioningGroupRequestLaunchConfigurationDataDisk, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.delete_with_instance is not None:
            result['DeleteWithInstance'] = self.delete_with_instance
        if self.description is not None:
            result['Description'] = self.description
        if self.device is not None:
            result['Device'] = self.device
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.encrypted is not None:
            result['Encrypted'] = self.encrypted
        if self.kms_key_id is not None:
            result['KmsKeyId'] = self.kms_key_id
        if self.performance_level is not None:
            result['PerformanceLevel'] = self.performance_level
        if self.size is not None:
            result['Size'] = self.size
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('DeleteWithInstance') is not None:
            self.delete_with_instance = m.get('DeleteWithInstance')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Device') is not None:
            self.device = m.get('Device')
        if m.get('DiskName') is not None:
            self.disk_name = m.get('DiskName')
        if m.get('Encrypted') is not None:
            self.encrypted = m.get('Encrypted')
        if m.get('KmsKeyId') is not None:
            self.kms_key_id = m.get('KmsKeyId')
        if m.get('PerformanceLevel') is not None:
            self.performance_level = m.get('PerformanceLevel')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        return self


class CreateAutoProvisioningGroupRequestLaunchConfigurationSystemDisk(TeaModel):
    def __init__(self, encrypt_algorithm=None, encrypted=None, kmskey_id=None):
        self.encrypt_algorithm = encrypt_algorithm  # type: str
        self.encrypted = encrypted  # type: str
        self.kmskey_id = kmskey_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAutoProvisioningGroupRequestLaunchConfigurationSystemDisk, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.encrypt_algorithm is not None:
            result['EncryptAlgorithm'] = self.encrypt_algorithm
        if self.encrypted is not None:
            result['Encrypted'] = self.encrypted
        if self.kmskey_id is not None:
            result['KMSKeyId'] = self.kmskey_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EncryptAlgorithm') is not None:
            self.encrypt_algorithm = m.get('EncryptAlgorithm')
        if m.get('Encrypted') is not None:
            self.encrypted = m.get('Encrypted')
        if m.get('KMSKeyId') is not None:
            self.kmskey_id = m.get('KMSKeyId')
        return self


class CreateAutoProvisioningGroupRequestLaunchConfigurationTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAutoProvisioningGroupRequestLaunchConfigurationTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateAutoProvisioningGroupRequestLaunchConfiguration(TeaModel):
    def __init__(self, arn=None, credit_specification=None, data_disk=None, deployment_set_id=None, host_name=None,
                 host_names=None, image_id=None, instance_description=None, instance_name=None, internet_charge_type=None,
                 internet_max_bandwidth_in=None, internet_max_bandwidth_out=None, io_optimized=None, key_pair_name=None, password=None,
                 password_inherit=None, ram_role_name=None, resource_group_id=None, security_enhancement_strategy=None,
                 security_group_id=None, security_group_ids=None, system_disk=None, system_disk_category=None,
                 system_disk_description=None, system_disk_name=None, system_disk_performance_level=None, system_disk_size=None, tag=None,
                 user_data=None):
        self.arn = arn  # type: list[CreateAutoProvisioningGroupRequestLaunchConfigurationArn]
        self.credit_specification = credit_specification  # type: str
        self.data_disk = data_disk  # type: list[CreateAutoProvisioningGroupRequestLaunchConfigurationDataDisk]
        self.deployment_set_id = deployment_set_id  # type: str
        self.host_name = host_name  # type: str
        self.host_names = host_names  # type: list[str]
        self.image_id = image_id  # type: str
        self.instance_description = instance_description  # type: str
        self.instance_name = instance_name  # type: str
        self.internet_charge_type = internet_charge_type  # type: str
        self.internet_max_bandwidth_in = internet_max_bandwidth_in  # type: int
        self.internet_max_bandwidth_out = internet_max_bandwidth_out  # type: int
        self.io_optimized = io_optimized  # type: str
        self.key_pair_name = key_pair_name  # type: str
        self.password = password  # type: str
        self.password_inherit = password_inherit  # type: bool
        self.ram_role_name = ram_role_name  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.security_enhancement_strategy = security_enhancement_strategy  # type: str
        self.security_group_id = security_group_id  # type: str
        self.security_group_ids = security_group_ids  # type: list[str]
        self.system_disk = system_disk  # type: CreateAutoProvisioningGroupRequestLaunchConfigurationSystemDisk
        self.system_disk_category = system_disk_category  # type: str
        self.system_disk_description = system_disk_description  # type: str
        self.system_disk_name = system_disk_name  # type: str
        self.system_disk_performance_level = system_disk_performance_level  # type: str
        self.system_disk_size = system_disk_size  # type: int
        self.tag = tag  # type: list[CreateAutoProvisioningGroupRequestLaunchConfigurationTag]
        self.user_data = user_data  # type: str

    def validate(self):
        if self.arn:
            for k in self.arn:
                if k:
                    k.validate()
        if self.data_disk:
            for k in self.data_disk:
                if k:
                    k.validate()
        if self.system_disk:
            self.system_disk.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateAutoProvisioningGroupRequestLaunchConfiguration, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Arn'] = []
        if self.arn is not None:
            for k in self.arn:
                result['Arn'].append(k.to_map() if k else None)
        if self.credit_specification is not None:
            result['CreditSpecification'] = self.credit_specification
        result['DataDisk'] = []
        if self.data_disk is not None:
            for k in self.data_disk:
                result['DataDisk'].append(k.to_map() if k else None)
        if self.deployment_set_id is not None:
            result['DeploymentSetId'] = self.deployment_set_id
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.host_names is not None:
            result['HostNames'] = self.host_names
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.instance_description is not None:
            result['InstanceDescription'] = self.instance_description
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.internet_max_bandwidth_in is not None:
            result['InternetMaxBandwidthIn'] = self.internet_max_bandwidth_in
        if self.internet_max_bandwidth_out is not None:
            result['InternetMaxBandwidthOut'] = self.internet_max_bandwidth_out
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.password is not None:
            result['Password'] = self.password
        if self.password_inherit is not None:
            result['PasswordInherit'] = self.password_inherit
        if self.ram_role_name is not None:
            result['RamRoleName'] = self.ram_role_name
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.security_enhancement_strategy is not None:
            result['SecurityEnhancementStrategy'] = self.security_enhancement_strategy
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.security_group_ids is not None:
            result['SecurityGroupIds'] = self.security_group_ids
        if self.system_disk is not None:
            result['SystemDisk'] = self.system_disk.to_map()
        if self.system_disk_category is not None:
            result['SystemDiskCategory'] = self.system_disk_category
        if self.system_disk_description is not None:
            result['SystemDiskDescription'] = self.system_disk_description
        if self.system_disk_name is not None:
            result['SystemDiskName'] = self.system_disk_name
        if self.system_disk_performance_level is not None:
            result['SystemDiskPerformanceLevel'] = self.system_disk_performance_level
        if self.system_disk_size is not None:
            result['SystemDiskSize'] = self.system_disk_size
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.user_data is not None:
            result['UserData'] = self.user_data
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.arn = []
        if m.get('Arn') is not None:
            for k in m.get('Arn'):
                temp_model = CreateAutoProvisioningGroupRequestLaunchConfigurationArn()
                self.arn.append(temp_model.from_map(k))
        if m.get('CreditSpecification') is not None:
            self.credit_specification = m.get('CreditSpecification')
        self.data_disk = []
        if m.get('DataDisk') is not None:
            for k in m.get('DataDisk'):
                temp_model = CreateAutoProvisioningGroupRequestLaunchConfigurationDataDisk()
                self.data_disk.append(temp_model.from_map(k))
        if m.get('DeploymentSetId') is not None:
            self.deployment_set_id = m.get('DeploymentSetId')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('HostNames') is not None:
            self.host_names = m.get('HostNames')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('InstanceDescription') is not None:
            self.instance_description = m.get('InstanceDescription')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('InternetMaxBandwidthIn') is not None:
            self.internet_max_bandwidth_in = m.get('InternetMaxBandwidthIn')
        if m.get('InternetMaxBandwidthOut') is not None:
            self.internet_max_bandwidth_out = m.get('InternetMaxBandwidthOut')
        if m.get('IoOptimized') is not None:
            self.io_optimized = m.get('IoOptimized')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('PasswordInherit') is not None:
            self.password_inherit = m.get('PasswordInherit')
        if m.get('RamRoleName') is not None:
            self.ram_role_name = m.get('RamRoleName')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SecurityEnhancementStrategy') is not None:
            self.security_enhancement_strategy = m.get('SecurityEnhancementStrategy')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('SecurityGroupIds') is not None:
            self.security_group_ids = m.get('SecurityGroupIds')
        if m.get('SystemDisk') is not None:
            temp_model = CreateAutoProvisioningGroupRequestLaunchConfigurationSystemDisk()
            self.system_disk = temp_model.from_map(m['SystemDisk'])
        if m.get('SystemDiskCategory') is not None:
            self.system_disk_category = m.get('SystemDiskCategory')
        if m.get('SystemDiskDescription') is not None:
            self.system_disk_description = m.get('SystemDiskDescription')
        if m.get('SystemDiskName') is not None:
            self.system_disk_name = m.get('SystemDiskName')
        if m.get('SystemDiskPerformanceLevel') is not None:
            self.system_disk_performance_level = m.get('SystemDiskPerformanceLevel')
        if m.get('SystemDiskSize') is not None:
            self.system_disk_size = m.get('SystemDiskSize')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateAutoProvisioningGroupRequestLaunchConfigurationTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        return self


class CreateAutoProvisioningGroupRequestDataDiskConfig(TeaModel):
    def __init__(self, disk_category=None):
        self.disk_category = disk_category  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAutoProvisioningGroupRequestDataDiskConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disk_category is not None:
            result['DiskCategory'] = self.disk_category
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DiskCategory') is not None:
            self.disk_category = m.get('DiskCategory')
        return self


class CreateAutoProvisioningGroupRequestLaunchTemplateConfig(TeaModel):
    def __init__(self, instance_type=None, max_price=None, priority=None, v_switch_id=None, weighted_capacity=None):
        self.instance_type = instance_type  # type: str
        self.max_price = max_price  # type: float
        self.priority = priority  # type: int
        self.v_switch_id = v_switch_id  # type: str
        self.weighted_capacity = weighted_capacity  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAutoProvisioningGroupRequestLaunchTemplateConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.max_price is not None:
            result['MaxPrice'] = self.max_price
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.weighted_capacity is not None:
            result['WeightedCapacity'] = self.weighted_capacity
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('MaxPrice') is not None:
            self.max_price = m.get('MaxPrice')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('WeightedCapacity') is not None:
            self.weighted_capacity = m.get('WeightedCapacity')
        return self


class CreateAutoProvisioningGroupRequestSystemDiskConfig(TeaModel):
    def __init__(self, disk_category=None):
        self.disk_category = disk_category  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAutoProvisioningGroupRequestSystemDiskConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disk_category is not None:
            result['DiskCategory'] = self.disk_category
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DiskCategory') is not None:
            self.disk_category = m.get('DiskCategory')
        return self


class CreateAutoProvisioningGroupRequest(TeaModel):
    def __init__(self, launch_configuration=None, auto_provisioning_group_name=None,
                 auto_provisioning_group_type=None, client_token=None, data_disk_config=None, default_target_capacity_type=None,
                 description=None, excess_capacity_termination_policy=None, hibernation_options_configured=None,
                 launch_template_config=None, launch_template_id=None, launch_template_version=None, max_spot_price=None,
                 min_target_capacity=None, owner_account=None, owner_id=None, pay_as_you_go_allocation_strategy=None,
                 pay_as_you_go_target_capacity=None, region_id=None, resource_group_id=None, resource_owner_account=None, resource_owner_id=None,
                 spot_allocation_strategy=None, spot_instance_interruption_behavior=None, spot_instance_pools_to_use_count=None,
                 spot_target_capacity=None, system_disk_config=None, terminate_instances=None,
                 terminate_instances_with_expiration=None, total_target_capacity=None, valid_from=None, valid_until=None):
        self.launch_configuration = launch_configuration  # type: CreateAutoProvisioningGroupRequestLaunchConfiguration
        self.auto_provisioning_group_name = auto_provisioning_group_name  # type: str
        self.auto_provisioning_group_type = auto_provisioning_group_type  # type: str
        self.client_token = client_token  # type: str
        self.data_disk_config = data_disk_config  # type: list[CreateAutoProvisioningGroupRequestDataDiskConfig]
        self.default_target_capacity_type = default_target_capacity_type  # type: str
        self.description = description  # type: str
        self.excess_capacity_termination_policy = excess_capacity_termination_policy  # type: str
        self.hibernation_options_configured = hibernation_options_configured  # type: bool
        self.launch_template_config = launch_template_config  # type: list[CreateAutoProvisioningGroupRequestLaunchTemplateConfig]
        self.launch_template_id = launch_template_id  # type: str
        self.launch_template_version = launch_template_version  # type: str
        self.max_spot_price = max_spot_price  # type: float
        self.min_target_capacity = min_target_capacity  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.pay_as_you_go_allocation_strategy = pay_as_you_go_allocation_strategy  # type: str
        self.pay_as_you_go_target_capacity = pay_as_you_go_target_capacity  # type: str
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.spot_allocation_strategy = spot_allocation_strategy  # type: str
        self.spot_instance_interruption_behavior = spot_instance_interruption_behavior  # type: str
        self.spot_instance_pools_to_use_count = spot_instance_pools_to_use_count  # type: int
        self.spot_target_capacity = spot_target_capacity  # type: str
        self.system_disk_config = system_disk_config  # type: list[CreateAutoProvisioningGroupRequestSystemDiskConfig]
        self.terminate_instances = terminate_instances  # type: bool
        self.terminate_instances_with_expiration = terminate_instances_with_expiration  # type: bool
        self.total_target_capacity = total_target_capacity  # type: str
        self.valid_from = valid_from  # type: str
        self.valid_until = valid_until  # type: str

    def validate(self):
        if self.launch_configuration:
            self.launch_configuration.validate()
        if self.data_disk_config:
            for k in self.data_disk_config:
                if k:
                    k.validate()
        if self.launch_template_config:
            for k in self.launch_template_config:
                if k:
                    k.validate()
        if self.system_disk_config:
            for k in self.system_disk_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateAutoProvisioningGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.launch_configuration is not None:
            result['LaunchConfiguration'] = self.launch_configuration.to_map()
        if self.auto_provisioning_group_name is not None:
            result['AutoProvisioningGroupName'] = self.auto_provisioning_group_name
        if self.auto_provisioning_group_type is not None:
            result['AutoProvisioningGroupType'] = self.auto_provisioning_group_type
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        result['DataDiskConfig'] = []
        if self.data_disk_config is not None:
            for k in self.data_disk_config:
                result['DataDiskConfig'].append(k.to_map() if k else None)
        if self.default_target_capacity_type is not None:
            result['DefaultTargetCapacityType'] = self.default_target_capacity_type
        if self.description is not None:
            result['Description'] = self.description
        if self.excess_capacity_termination_policy is not None:
            result['ExcessCapacityTerminationPolicy'] = self.excess_capacity_termination_policy
        if self.hibernation_options_configured is not None:
            result['HibernationOptionsConfigured'] = self.hibernation_options_configured
        result['LaunchTemplateConfig'] = []
        if self.launch_template_config is not None:
            for k in self.launch_template_config:
                result['LaunchTemplateConfig'].append(k.to_map() if k else None)
        if self.launch_template_id is not None:
            result['LaunchTemplateId'] = self.launch_template_id
        if self.launch_template_version is not None:
            result['LaunchTemplateVersion'] = self.launch_template_version
        if self.max_spot_price is not None:
            result['MaxSpotPrice'] = self.max_spot_price
        if self.min_target_capacity is not None:
            result['MinTargetCapacity'] = self.min_target_capacity
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.pay_as_you_go_allocation_strategy is not None:
            result['PayAsYouGoAllocationStrategy'] = self.pay_as_you_go_allocation_strategy
        if self.pay_as_you_go_target_capacity is not None:
            result['PayAsYouGoTargetCapacity'] = self.pay_as_you_go_target_capacity
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.spot_allocation_strategy is not None:
            result['SpotAllocationStrategy'] = self.spot_allocation_strategy
        if self.spot_instance_interruption_behavior is not None:
            result['SpotInstanceInterruptionBehavior'] = self.spot_instance_interruption_behavior
        if self.spot_instance_pools_to_use_count is not None:
            result['SpotInstancePoolsToUseCount'] = self.spot_instance_pools_to_use_count
        if self.spot_target_capacity is not None:
            result['SpotTargetCapacity'] = self.spot_target_capacity
        result['SystemDiskConfig'] = []
        if self.system_disk_config is not None:
            for k in self.system_disk_config:
                result['SystemDiskConfig'].append(k.to_map() if k else None)
        if self.terminate_instances is not None:
            result['TerminateInstances'] = self.terminate_instances
        if self.terminate_instances_with_expiration is not None:
            result['TerminateInstancesWithExpiration'] = self.terminate_instances_with_expiration
        if self.total_target_capacity is not None:
            result['TotalTargetCapacity'] = self.total_target_capacity
        if self.valid_from is not None:
            result['ValidFrom'] = self.valid_from
        if self.valid_until is not None:
            result['ValidUntil'] = self.valid_until
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LaunchConfiguration') is not None:
            temp_model = CreateAutoProvisioningGroupRequestLaunchConfiguration()
            self.launch_configuration = temp_model.from_map(m['LaunchConfiguration'])
        if m.get('AutoProvisioningGroupName') is not None:
            self.auto_provisioning_group_name = m.get('AutoProvisioningGroupName')
        if m.get('AutoProvisioningGroupType') is not None:
            self.auto_provisioning_group_type = m.get('AutoProvisioningGroupType')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        self.data_disk_config = []
        if m.get('DataDiskConfig') is not None:
            for k in m.get('DataDiskConfig'):
                temp_model = CreateAutoProvisioningGroupRequestDataDiskConfig()
                self.data_disk_config.append(temp_model.from_map(k))
        if m.get('DefaultTargetCapacityType') is not None:
            self.default_target_capacity_type = m.get('DefaultTargetCapacityType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ExcessCapacityTerminationPolicy') is not None:
            self.excess_capacity_termination_policy = m.get('ExcessCapacityTerminationPolicy')
        if m.get('HibernationOptionsConfigured') is not None:
            self.hibernation_options_configured = m.get('HibernationOptionsConfigured')
        self.launch_template_config = []
        if m.get('LaunchTemplateConfig') is not None:
            for k in m.get('LaunchTemplateConfig'):
                temp_model = CreateAutoProvisioningGroupRequestLaunchTemplateConfig()
                self.launch_template_config.append(temp_model.from_map(k))
        if m.get('LaunchTemplateId') is not None:
            self.launch_template_id = m.get('LaunchTemplateId')
        if m.get('LaunchTemplateVersion') is not None:
            self.launch_template_version = m.get('LaunchTemplateVersion')
        if m.get('MaxSpotPrice') is not None:
            self.max_spot_price = m.get('MaxSpotPrice')
        if m.get('MinTargetCapacity') is not None:
            self.min_target_capacity = m.get('MinTargetCapacity')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PayAsYouGoAllocationStrategy') is not None:
            self.pay_as_you_go_allocation_strategy = m.get('PayAsYouGoAllocationStrategy')
        if m.get('PayAsYouGoTargetCapacity') is not None:
            self.pay_as_you_go_target_capacity = m.get('PayAsYouGoTargetCapacity')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SpotAllocationStrategy') is not None:
            self.spot_allocation_strategy = m.get('SpotAllocationStrategy')
        if m.get('SpotInstanceInterruptionBehavior') is not None:
            self.spot_instance_interruption_behavior = m.get('SpotInstanceInterruptionBehavior')
        if m.get('SpotInstancePoolsToUseCount') is not None:
            self.spot_instance_pools_to_use_count = m.get('SpotInstancePoolsToUseCount')
        if m.get('SpotTargetCapacity') is not None:
            self.spot_target_capacity = m.get('SpotTargetCapacity')
        self.system_disk_config = []
        if m.get('SystemDiskConfig') is not None:
            for k in m.get('SystemDiskConfig'):
                temp_model = CreateAutoProvisioningGroupRequestSystemDiskConfig()
                self.system_disk_config.append(temp_model.from_map(k))
        if m.get('TerminateInstances') is not None:
            self.terminate_instances = m.get('TerminateInstances')
        if m.get('TerminateInstancesWithExpiration') is not None:
            self.terminate_instances_with_expiration = m.get('TerminateInstancesWithExpiration')
        if m.get('TotalTargetCapacity') is not None:
            self.total_target_capacity = m.get('TotalTargetCapacity')
        if m.get('ValidFrom') is not None:
            self.valid_from = m.get('ValidFrom')
        if m.get('ValidUntil') is not None:
            self.valid_until = m.get('ValidUntil')
        return self


class CreateAutoProvisioningGroupResponseBodyLaunchResultsLaunchResultInstanceIds(TeaModel):
    def __init__(self, instance_id=None):
        self.instance_id = instance_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAutoProvisioningGroupResponseBodyLaunchResultsLaunchResultInstanceIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class CreateAutoProvisioningGroupResponseBodyLaunchResultsLaunchResult(TeaModel):
    def __init__(self, error_code=None, error_msg=None, instance_ids=None, instance_type=None, spot_strategy=None,
                 zone_id=None):
        self.error_code = error_code  # type: str
        self.error_msg = error_msg  # type: str
        self.instance_ids = instance_ids  # type: CreateAutoProvisioningGroupResponseBodyLaunchResultsLaunchResultInstanceIds
        self.instance_type = instance_type  # type: str
        self.spot_strategy = spot_strategy  # type: str
        self.zone_id = zone_id  # type: str

    def validate(self):
        if self.instance_ids:
            self.instance_ids.validate()

    def to_map(self):
        _map = super(CreateAutoProvisioningGroupResponseBodyLaunchResultsLaunchResult, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_msg is not None:
            result['ErrorMsg'] = self.error_msg
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids.to_map()
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.spot_strategy is not None:
            result['SpotStrategy'] = self.spot_strategy
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMsg') is not None:
            self.error_msg = m.get('ErrorMsg')
        if m.get('InstanceIds') is not None:
            temp_model = CreateAutoProvisioningGroupResponseBodyLaunchResultsLaunchResultInstanceIds()
            self.instance_ids = temp_model.from_map(m['InstanceIds'])
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('SpotStrategy') is not None:
            self.spot_strategy = m.get('SpotStrategy')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class CreateAutoProvisioningGroupResponseBodyLaunchResults(TeaModel):
    def __init__(self, launch_result=None):
        self.launch_result = launch_result  # type: list[CreateAutoProvisioningGroupResponseBodyLaunchResultsLaunchResult]

    def validate(self):
        if self.launch_result:
            for k in self.launch_result:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateAutoProvisioningGroupResponseBodyLaunchResults, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LaunchResult'] = []
        if self.launch_result is not None:
            for k in self.launch_result:
                result['LaunchResult'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.launch_result = []
        if m.get('LaunchResult') is not None:
            for k in m.get('LaunchResult'):
                temp_model = CreateAutoProvisioningGroupResponseBodyLaunchResultsLaunchResult()
                self.launch_result.append(temp_model.from_map(k))
        return self


class CreateAutoProvisioningGroupResponseBody(TeaModel):
    def __init__(self, auto_provisioning_group_id=None, launch_results=None, request_id=None):
        self.auto_provisioning_group_id = auto_provisioning_group_id  # type: str
        self.launch_results = launch_results  # type: CreateAutoProvisioningGroupResponseBodyLaunchResults
        self.request_id = request_id  # type: str

    def validate(self):
        if self.launch_results:
            self.launch_results.validate()

    def to_map(self):
        _map = super(CreateAutoProvisioningGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_provisioning_group_id is not None:
            result['AutoProvisioningGroupId'] = self.auto_provisioning_group_id
        if self.launch_results is not None:
            result['LaunchResults'] = self.launch_results.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoProvisioningGroupId') is not None:
            self.auto_provisioning_group_id = m.get('AutoProvisioningGroupId')
        if m.get('LaunchResults') is not None:
            temp_model = CreateAutoProvisioningGroupResponseBodyLaunchResults()
            self.launch_results = temp_model.from_map(m['LaunchResults'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAutoProvisioningGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateAutoProvisioningGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateAutoProvisioningGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAutoProvisioningGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAutoSnapshotPolicyRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAutoSnapshotPolicyRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateAutoSnapshotPolicyRequest(TeaModel):
    def __init__(self, copied_snapshots_retention_days=None, enable_cross_region_copy=None, owner_id=None,
                 resource_group_id=None, resource_owner_account=None, resource_owner_id=None, tag=None, target_copy_regions=None,
                 auto_snapshot_policy_name=None, region_id=None, repeat_weekdays=None, retention_days=None, time_points=None):
        self.copied_snapshots_retention_days = copied_snapshots_retention_days  # type: int
        self.enable_cross_region_copy = enable_cross_region_copy  # type: bool
        self.owner_id = owner_id  # type: long
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.tag = tag  # type: list[CreateAutoSnapshotPolicyRequestTag]
        self.target_copy_regions = target_copy_regions  # type: str
        self.auto_snapshot_policy_name = auto_snapshot_policy_name  # type: str
        self.region_id = region_id  # type: str
        self.repeat_weekdays = repeat_weekdays  # type: str
        self.retention_days = retention_days  # type: int
        self.time_points = time_points  # type: str

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateAutoSnapshotPolicyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.copied_snapshots_retention_days is not None:
            result['CopiedSnapshotsRetentionDays'] = self.copied_snapshots_retention_days
        if self.enable_cross_region_copy is not None:
            result['EnableCrossRegionCopy'] = self.enable_cross_region_copy
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.target_copy_regions is not None:
            result['TargetCopyRegions'] = self.target_copy_regions
        if self.auto_snapshot_policy_name is not None:
            result['autoSnapshotPolicyName'] = self.auto_snapshot_policy_name
        if self.region_id is not None:
            result['regionId'] = self.region_id
        if self.repeat_weekdays is not None:
            result['repeatWeekdays'] = self.repeat_weekdays
        if self.retention_days is not None:
            result['retentionDays'] = self.retention_days
        if self.time_points is not None:
            result['timePoints'] = self.time_points
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CopiedSnapshotsRetentionDays') is not None:
            self.copied_snapshots_retention_days = m.get('CopiedSnapshotsRetentionDays')
        if m.get('EnableCrossRegionCopy') is not None:
            self.enable_cross_region_copy = m.get('EnableCrossRegionCopy')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateAutoSnapshotPolicyRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('TargetCopyRegions') is not None:
            self.target_copy_regions = m.get('TargetCopyRegions')
        if m.get('autoSnapshotPolicyName') is not None:
            self.auto_snapshot_policy_name = m.get('autoSnapshotPolicyName')
        if m.get('regionId') is not None:
            self.region_id = m.get('regionId')
        if m.get('repeatWeekdays') is not None:
            self.repeat_weekdays = m.get('repeatWeekdays')
        if m.get('retentionDays') is not None:
            self.retention_days = m.get('retentionDays')
        if m.get('timePoints') is not None:
            self.time_points = m.get('timePoints')
        return self


class CreateAutoSnapshotPolicyResponseBody(TeaModel):
    def __init__(self, auto_snapshot_policy_id=None, request_id=None):
        self.auto_snapshot_policy_id = auto_snapshot_policy_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAutoSnapshotPolicyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_snapshot_policy_id is not None:
            result['AutoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoSnapshotPolicyId') is not None:
            self.auto_snapshot_policy_id = m.get('AutoSnapshotPolicyId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAutoSnapshotPolicyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateAutoSnapshotPolicyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateAutoSnapshotPolicyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAutoSnapshotPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCapacityReservationRequestPrivatePoolOptions(TeaModel):
    def __init__(self, match_criteria=None, name=None):
        self.match_criteria = match_criteria  # type: str
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCapacityReservationRequestPrivatePoolOptions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_criteria is not None:
            result['MatchCriteria'] = self.match_criteria
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MatchCriteria') is not None:
            self.match_criteria = m.get('MatchCriteria')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateCapacityReservationRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCapacityReservationRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateCapacityReservationRequest(TeaModel):
    def __init__(self, private_pool_options=None, client_token=None, description=None, end_time=None,
                 end_time_type=None, instance_amount=None, instance_type=None, owner_account=None, owner_id=None, platform=None,
                 region_id=None, resource_group_id=None, resource_owner_account=None, resource_owner_id=None,
                 start_time=None, tag=None, zone_id=None):
        self.private_pool_options = private_pool_options  # type: CreateCapacityReservationRequestPrivatePoolOptions
        self.client_token = client_token  # type: str
        self.description = description  # type: str
        self.end_time = end_time  # type: str
        self.end_time_type = end_time_type  # type: str
        self.instance_amount = instance_amount  # type: int
        self.instance_type = instance_type  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.platform = platform  # type: str
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.start_time = start_time  # type: str
        self.tag = tag  # type: list[CreateCapacityReservationRequestTag]
        self.zone_id = zone_id  # type: list[str]

    def validate(self):
        if self.private_pool_options:
            self.private_pool_options.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateCapacityReservationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.private_pool_options is not None:
            result['PrivatePoolOptions'] = self.private_pool_options.to_map()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.end_time_type is not None:
            result['EndTimeType'] = self.end_time_type
        if self.instance_amount is not None:
            result['InstanceAmount'] = self.instance_amount
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.platform is not None:
            result['Platform'] = self.platform
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PrivatePoolOptions') is not None:
            temp_model = CreateCapacityReservationRequestPrivatePoolOptions()
            self.private_pool_options = temp_model.from_map(m['PrivatePoolOptions'])
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EndTimeType') is not None:
            self.end_time_type = m.get('EndTimeType')
        if m.get('InstanceAmount') is not None:
            self.instance_amount = m.get('InstanceAmount')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Platform') is not None:
            self.platform = m.get('Platform')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateCapacityReservationRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class CreateCapacityReservationResponseBody(TeaModel):
    def __init__(self, private_pool_options_id=None, request_id=None):
        self.private_pool_options_id = private_pool_options_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCapacityReservationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.private_pool_options_id is not None:
            result['PrivatePoolOptionsId'] = self.private_pool_options_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PrivatePoolOptionsId') is not None:
            self.private_pool_options_id = m.get('PrivatePoolOptionsId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCapacityReservationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateCapacityReservationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateCapacityReservationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCapacityReservationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCommandRequest(TeaModel):
    def __init__(self, command_content=None, content_encoding=None, description=None, enable_parameter=None,
                 name=None, owner_account=None, owner_id=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None, timeout=None, type=None, working_dir=None):
        self.command_content = command_content  # type: str
        self.content_encoding = content_encoding  # type: str
        self.description = description  # type: str
        self.enable_parameter = enable_parameter  # type: bool
        self.name = name  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.timeout = timeout  # type: long
        self.type = type  # type: str
        self.working_dir = working_dir  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCommandRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.command_content is not None:
            result['CommandContent'] = self.command_content
        if self.content_encoding is not None:
            result['ContentEncoding'] = self.content_encoding
        if self.description is not None:
            result['Description'] = self.description
        if self.enable_parameter is not None:
            result['EnableParameter'] = self.enable_parameter
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        if self.type is not None:
            result['Type'] = self.type
        if self.working_dir is not None:
            result['WorkingDir'] = self.working_dir
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CommandContent') is not None:
            self.command_content = m.get('CommandContent')
        if m.get('ContentEncoding') is not None:
            self.content_encoding = m.get('ContentEncoding')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnableParameter') is not None:
            self.enable_parameter = m.get('EnableParameter')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('WorkingDir') is not None:
            self.working_dir = m.get('WorkingDir')
        return self


class CreateCommandResponseBody(TeaModel):
    def __init__(self, command_id=None, request_id=None):
        self.command_id = command_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCommandResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.command_id is not None:
            result['CommandId'] = self.command_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CommandId') is not None:
            self.command_id = m.get('CommandId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCommandResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateCommandResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateCommandResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCommandResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDedicatedBlockStorageClusterRequest(TeaModel):
    def __init__(self, capacity=None, category=None, client_token=None, dedicated_block_storage_cluster_name=None,
                 description=None, from_app=None, owner_account=None, owner_id=None, period=None, period_unit=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None, type=None, zone_id=None):
        self.capacity = capacity  # type: int
        self.category = category  # type: str
        self.client_token = client_token  # type: str
        self.dedicated_block_storage_cluster_name = dedicated_block_storage_cluster_name  # type: str
        self.description = description  # type: str
        self.from_app = from_app  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.period = period  # type: int
        self.period_unit = period_unit  # type: str
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.type = type  # type: str
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDedicatedBlockStorageClusterRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.capacity is not None:
            result['Capacity'] = self.capacity
        if self.category is not None:
            result['Category'] = self.category
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dedicated_block_storage_cluster_name is not None:
            result['DedicatedBlockStorageClusterName'] = self.dedicated_block_storage_cluster_name
        if self.description is not None:
            result['Description'] = self.description
        if self.from_app is not None:
            result['FromApp'] = self.from_app
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.type is not None:
            result['Type'] = self.type
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Capacity') is not None:
            self.capacity = m.get('Capacity')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DedicatedBlockStorageClusterName') is not None:
            self.dedicated_block_storage_cluster_name = m.get('DedicatedBlockStorageClusterName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('FromApp') is not None:
            self.from_app = m.get('FromApp')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class CreateDedicatedBlockStorageClusterResponseBody(TeaModel):
    def __init__(self, dedicated_block_storage_cluster_id=None, dedicated_block_storage_cluster_order_id=None,
                 request_id=None):
        self.dedicated_block_storage_cluster_id = dedicated_block_storage_cluster_id  # type: str
        self.dedicated_block_storage_cluster_order_id = dedicated_block_storage_cluster_order_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDedicatedBlockStorageClusterResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_block_storage_cluster_id is not None:
            result['DedicatedBlockStorageClusterId'] = self.dedicated_block_storage_cluster_id
        if self.dedicated_block_storage_cluster_order_id is not None:
            result['DedicatedBlockStorageClusterOrderId'] = self.dedicated_block_storage_cluster_order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DedicatedBlockStorageClusterId') is not None:
            self.dedicated_block_storage_cluster_id = m.get('DedicatedBlockStorageClusterId')
        if m.get('DedicatedBlockStorageClusterOrderId') is not None:
            self.dedicated_block_storage_cluster_order_id = m.get('DedicatedBlockStorageClusterOrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDedicatedBlockStorageClusterResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDedicatedBlockStorageClusterResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDedicatedBlockStorageClusterResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDedicatedBlockStorageClusterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDedicatedHostClusterRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDedicatedHostClusterRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateDedicatedHostClusterRequest(TeaModel):
    def __init__(self, dedicated_host_cluster_name=None, description=None, dry_run=None, owner_account=None,
                 owner_id=None, region_id=None, resource_group_id=None, resource_owner_account=None, resource_owner_id=None,
                 tag=None, zone_id=None):
        self.dedicated_host_cluster_name = dedicated_host_cluster_name  # type: str
        self.description = description  # type: str
        self.dry_run = dry_run  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.tag = tag  # type: list[CreateDedicatedHostClusterRequestTag]
        self.zone_id = zone_id  # type: str

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateDedicatedHostClusterRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_host_cluster_name is not None:
            result['DedicatedHostClusterName'] = self.dedicated_host_cluster_name
        if self.description is not None:
            result['Description'] = self.description
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DedicatedHostClusterName') is not None:
            self.dedicated_host_cluster_name = m.get('DedicatedHostClusterName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateDedicatedHostClusterRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class CreateDedicatedHostClusterResponseBody(TeaModel):
    def __init__(self, dedicated_host_cluster_id=None, request_id=None):
        self.dedicated_host_cluster_id = dedicated_host_cluster_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDedicatedHostClusterResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_host_cluster_id is not None:
            result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DedicatedHostClusterId') is not None:
            self.dedicated_host_cluster_id = m.get('DedicatedHostClusterId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDedicatedHostClusterResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDedicatedHostClusterResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDedicatedHostClusterResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDedicatedHostClusterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDemandRequest(TeaModel):
    def __init__(self, amount=None, client_token=None, demand_description=None, demand_name=None, end_time=None,
                 instance_charge_type=None, instance_type=None, owner_account=None, owner_id=None, period=None, period_unit=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None, start_time=None, zone_id=None):
        self.amount = amount  # type: int
        self.client_token = client_token  # type: str
        self.demand_description = demand_description  # type: str
        self.demand_name = demand_name  # type: str
        self.end_time = end_time  # type: str
        self.instance_charge_type = instance_charge_type  # type: str
        self.instance_type = instance_type  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.period = period  # type: int
        self.period_unit = period_unit  # type: str
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.start_time = start_time  # type: str
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDemandRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amount is not None:
            result['Amount'] = self.amount
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.demand_description is not None:
            result['DemandDescription'] = self.demand_description
        if self.demand_name is not None:
            result['DemandName'] = self.demand_name
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Amount') is not None:
            self.amount = m.get('Amount')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DemandDescription') is not None:
            self.demand_description = m.get('DemandDescription')
        if m.get('DemandName') is not None:
            self.demand_name = m.get('DemandName')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class CreateDemandResponseBody(TeaModel):
    def __init__(self, demand_id=None, request_id=None):
        self.demand_id = demand_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDemandResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.demand_id is not None:
            result['DemandId'] = self.demand_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DemandId') is not None:
            self.demand_id = m.get('DemandId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDemandResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDemandResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDemandResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDemandResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDeploymentSetRequest(TeaModel):
    def __init__(self, client_token=None, deployment_set_name=None, description=None, domain=None, granularity=None,
                 group_count=None, on_unable_to_redeploy_failed_instance=None, owner_account=None, owner_id=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None, strategy=None):
        self.client_token = client_token  # type: str
        self.deployment_set_name = deployment_set_name  # type: str
        self.description = description  # type: str
        self.domain = domain  # type: str
        self.granularity = granularity  # type: str
        self.group_count = group_count  # type: long
        self.on_unable_to_redeploy_failed_instance = on_unable_to_redeploy_failed_instance  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.strategy = strategy  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDeploymentSetRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.deployment_set_name is not None:
            result['DeploymentSetName'] = self.deployment_set_name
        if self.description is not None:
            result['Description'] = self.description
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.granularity is not None:
            result['Granularity'] = self.granularity
        if self.group_count is not None:
            result['GroupCount'] = self.group_count
        if self.on_unable_to_redeploy_failed_instance is not None:
            result['OnUnableToRedeployFailedInstance'] = self.on_unable_to_redeploy_failed_instance
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.strategy is not None:
            result['Strategy'] = self.strategy
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DeploymentSetName') is not None:
            self.deployment_set_name = m.get('DeploymentSetName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('Granularity') is not None:
            self.granularity = m.get('Granularity')
        if m.get('GroupCount') is not None:
            self.group_count = m.get('GroupCount')
        if m.get('OnUnableToRedeployFailedInstance') is not None:
            self.on_unable_to_redeploy_failed_instance = m.get('OnUnableToRedeployFailedInstance')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Strategy') is not None:
            self.strategy = m.get('Strategy')
        return self


class CreateDeploymentSetResponseBody(TeaModel):
    def __init__(self, deployment_set_id=None, request_id=None):
        self.deployment_set_id = deployment_set_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDeploymentSetResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deployment_set_id is not None:
            result['DeploymentSetId'] = self.deployment_set_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeploymentSetId') is not None:
            self.deployment_set_id = m.get('DeploymentSetId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDeploymentSetResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDeploymentSetResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDeploymentSetResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDeploymentSetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDiagnosticMetricSetRequest(TeaModel):
    def __init__(self, description=None, metric_ids=None, metric_set_name=None, region_id=None, resource_type=None):
        self.description = description  # type: str
        self.metric_ids = metric_ids  # type: list[str]
        self.metric_set_name = metric_set_name  # type: str
        self.region_id = region_id  # type: str
        self.resource_type = resource_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDiagnosticMetricSetRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.metric_ids is not None:
            result['MetricIds'] = self.metric_ids
        if self.metric_set_name is not None:
            result['MetricSetName'] = self.metric_set_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('MetricIds') is not None:
            self.metric_ids = m.get('MetricIds')
        if m.get('MetricSetName') is not None:
            self.metric_set_name = m.get('MetricSetName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        return self


class CreateDiagnosticMetricSetResponseBody(TeaModel):
    def __init__(self, metric_set_id=None, request_id=None):
        self.metric_set_id = metric_set_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDiagnosticMetricSetResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.metric_set_id is not None:
            result['MetricSetId'] = self.metric_set_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MetricSetId') is not None:
            self.metric_set_id = m.get('MetricSetId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDiagnosticMetricSetResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDiagnosticMetricSetResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDiagnosticMetricSetResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDiagnosticMetricSetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDiagnosticReportRequest(TeaModel):
    def __init__(self, end_time=None, metric_set_id=None, region_id=None, resource_id=None, start_time=None):
        self.end_time = end_time  # type: str
        self.metric_set_id = metric_set_id  # type: str
        self.region_id = region_id  # type: str
        self.resource_id = resource_id  # type: str
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDiagnosticReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.metric_set_id is not None:
            result['MetricSetId'] = self.metric_set_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('MetricSetId') is not None:
            self.metric_set_id = m.get('MetricSetId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class CreateDiagnosticReportResponseBody(TeaModel):
    def __init__(self, report_id=None, request_id=None):
        self.report_id = report_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDiagnosticReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.report_id is not None:
            result['ReportId'] = self.report_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ReportId') is not None:
            self.report_id = m.get('ReportId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDiagnosticReportResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDiagnosticReportResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDiagnosticReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDiagnosticReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDiskRequestArn(TeaModel):
    def __init__(self, assume_role_for=None, role_type=None, rolearn=None):
        self.assume_role_for = assume_role_for  # type: long
        self.role_type = role_type  # type: str
        self.rolearn = rolearn  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDiskRequestArn, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.assume_role_for is not None:
            result['AssumeRoleFor'] = self.assume_role_for
        if self.role_type is not None:
            result['RoleType'] = self.role_type
        if self.rolearn is not None:
            result['Rolearn'] = self.rolearn
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AssumeRoleFor') is not None:
            self.assume_role_for = m.get('AssumeRoleFor')
        if m.get('RoleType') is not None:
            self.role_type = m.get('RoleType')
        if m.get('Rolearn') is not None:
            self.rolearn = m.get('Rolearn')
        return self


class CreateDiskRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDiskRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateDiskRequest(TeaModel):
    def __init__(self, advanced_features=None, arn=None, bursting_enabled=None, client_token=None, description=None,
                 disk_category=None, disk_name=None, encrypt_algorithm=None, encrypted=None, instance_id=None, kmskey_id=None,
                 multi_attach=None, owner_account=None, owner_id=None, performance_level=None, provisioned_iops=None,
                 region_id=None, resource_group_id=None, resource_owner_account=None, resource_owner_id=None, size=None,
                 snapshot_id=None, storage_cluster_id=None, storage_set_id=None, storage_set_partition_number=None, tag=None,
                 zone_id=None):
        self.advanced_features = advanced_features  # type: str
        self.arn = arn  # type: list[CreateDiskRequestArn]
        self.bursting_enabled = bursting_enabled  # type: bool
        self.client_token = client_token  # type: str
        self.description = description  # type: str
        self.disk_category = disk_category  # type: str
        self.disk_name = disk_name  # type: str
        self.encrypt_algorithm = encrypt_algorithm  # type: str
        self.encrypted = encrypted  # type: bool
        self.instance_id = instance_id  # type: str
        self.kmskey_id = kmskey_id  # type: str
        self.multi_attach = multi_attach  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.performance_level = performance_level  # type: str
        self.provisioned_iops = provisioned_iops  # type: long
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.size = size  # type: int
        self.snapshot_id = snapshot_id  # type: str
        self.storage_cluster_id = storage_cluster_id  # type: str
        self.storage_set_id = storage_set_id  # type: str
        self.storage_set_partition_number = storage_set_partition_number  # type: int
        self.tag = tag  # type: list[CreateDiskRequestTag]
        self.zone_id = zone_id  # type: str

    def validate(self):
        if self.arn:
            for k in self.arn:
                if k:
                    k.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateDiskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.advanced_features is not None:
            result['AdvancedFeatures'] = self.advanced_features
        result['Arn'] = []
        if self.arn is not None:
            for k in self.arn:
                result['Arn'].append(k.to_map() if k else None)
        if self.bursting_enabled is not None:
            result['BurstingEnabled'] = self.bursting_enabled
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.disk_category is not None:
            result['DiskCategory'] = self.disk_category
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.encrypt_algorithm is not None:
            result['EncryptAlgorithm'] = self.encrypt_algorithm
        if self.encrypted is not None:
            result['Encrypted'] = self.encrypted
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.kmskey_id is not None:
            result['KMSKeyId'] = self.kmskey_id
        if self.multi_attach is not None:
            result['MultiAttach'] = self.multi_attach
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.performance_level is not None:
            result['PerformanceLevel'] = self.performance_level
        if self.provisioned_iops is not None:
            result['ProvisionedIops'] = self.provisioned_iops
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.size is not None:
            result['Size'] = self.size
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.storage_cluster_id is not None:
            result['StorageClusterId'] = self.storage_cluster_id
        if self.storage_set_id is not None:
            result['StorageSetId'] = self.storage_set_id
        if self.storage_set_partition_number is not None:
            result['StorageSetPartitionNumber'] = self.storage_set_partition_number
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AdvancedFeatures') is not None:
            self.advanced_features = m.get('AdvancedFeatures')
        self.arn = []
        if m.get('Arn') is not None:
            for k in m.get('Arn'):
                temp_model = CreateDiskRequestArn()
                self.arn.append(temp_model.from_map(k))
        if m.get('BurstingEnabled') is not None:
            self.bursting_enabled = m.get('BurstingEnabled')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DiskCategory') is not None:
            self.disk_category = m.get('DiskCategory')
        if m.get('DiskName') is not None:
            self.disk_name = m.get('DiskName')
        if m.get('EncryptAlgorithm') is not None:
            self.encrypt_algorithm = m.get('EncryptAlgorithm')
        if m.get('Encrypted') is not None:
            self.encrypted = m.get('Encrypted')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('KMSKeyId') is not None:
            self.kmskey_id = m.get('KMSKeyId')
        if m.get('MultiAttach') is not None:
            self.multi_attach = m.get('MultiAttach')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PerformanceLevel') is not None:
            self.performance_level = m.get('PerformanceLevel')
        if m.get('ProvisionedIops') is not None:
            self.provisioned_iops = m.get('ProvisionedIops')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('StorageClusterId') is not None:
            self.storage_cluster_id = m.get('StorageClusterId')
        if m.get('StorageSetId') is not None:
            self.storage_set_id = m.get('StorageSetId')
        if m.get('StorageSetPartitionNumber') is not None:
            self.storage_set_partition_number = m.get('StorageSetPartitionNumber')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateDiskRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class CreateDiskResponseBody(TeaModel):
    def __init__(self, disk_id=None, order_id=None, request_id=None):
        self.disk_id = disk_id  # type: str
        self.order_id = order_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDiskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DiskId') is not None:
            self.disk_id = m.get('DiskId')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateDiskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDiskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDiskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDiskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateElasticityAssuranceRequestPrivatePoolOptions(TeaModel):
    def __init__(self, match_criteria=None, name=None):
        self.match_criteria = match_criteria  # type: str
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateElasticityAssuranceRequestPrivatePoolOptions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_criteria is not None:
            result['MatchCriteria'] = self.match_criteria
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MatchCriteria') is not None:
            self.match_criteria = m.get('MatchCriteria')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateElasticityAssuranceRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateElasticityAssuranceRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateElasticityAssuranceRequest(TeaModel):
    def __init__(self, private_pool_options=None, assurance_times=None, client_token=None, description=None,
                 instance_amount=None, instance_cpu_core_count=None, instance_type=None, owner_account=None, owner_id=None,
                 period=None, period_unit=None, region_id=None, resource_group_id=None, resource_owner_account=None,
                 resource_owner_id=None, start_time=None, tag=None, zone_id=None):
        self.private_pool_options = private_pool_options  # type: CreateElasticityAssuranceRequestPrivatePoolOptions
        self.assurance_times = assurance_times  # type: str
        self.client_token = client_token  # type: str
        self.description = description  # type: str
        self.instance_amount = instance_amount  # type: int
        self.instance_cpu_core_count = instance_cpu_core_count  # type: int
        self.instance_type = instance_type  # type: list[str]
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.period = period  # type: int
        self.period_unit = period_unit  # type: str
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.start_time = start_time  # type: str
        self.tag = tag  # type: list[CreateElasticityAssuranceRequestTag]
        self.zone_id = zone_id  # type: list[str]

    def validate(self):
        if self.private_pool_options:
            self.private_pool_options.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateElasticityAssuranceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.private_pool_options is not None:
            result['PrivatePoolOptions'] = self.private_pool_options.to_map()
        if self.assurance_times is not None:
            result['AssuranceTimes'] = self.assurance_times
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.instance_amount is not None:
            result['InstanceAmount'] = self.instance_amount
        if self.instance_cpu_core_count is not None:
            result['InstanceCpuCoreCount'] = self.instance_cpu_core_count
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PrivatePoolOptions') is not None:
            temp_model = CreateElasticityAssuranceRequestPrivatePoolOptions()
            self.private_pool_options = temp_model.from_map(m['PrivatePoolOptions'])
        if m.get('AssuranceTimes') is not None:
            self.assurance_times = m.get('AssuranceTimes')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InstanceAmount') is not None:
            self.instance_amount = m.get('InstanceAmount')
        if m.get('InstanceCpuCoreCount') is not None:
            self.instance_cpu_core_count = m.get('InstanceCpuCoreCount')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateElasticityAssuranceRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class CreateElasticityAssuranceResponseBody(TeaModel):
    def __init__(self, order_id=None, private_pool_options_id=None, request_id=None):
        self.order_id = order_id  # type: str
        self.private_pool_options_id = private_pool_options_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateElasticityAssuranceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.private_pool_options_id is not None:
            result['PrivatePoolOptionsId'] = self.private_pool_options_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('PrivatePoolOptionsId') is not None:
            self.private_pool_options_id = m.get('PrivatePoolOptionsId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateElasticityAssuranceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateElasticityAssuranceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateElasticityAssuranceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateElasticityAssuranceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateForwardEntryRequest(TeaModel):
    def __init__(self, external_ip=None, external_port=None, forward_table_id=None, internal_ip=None,
                 internal_port=None, ip_protocol=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.external_ip = external_ip  # type: str
        self.external_port = external_port  # type: str
        self.forward_table_id = forward_table_id  # type: str
        self.internal_ip = internal_ip  # type: str
        self.internal_port = internal_port  # type: str
        self.ip_protocol = ip_protocol  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateForwardEntryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.external_ip is not None:
            result['ExternalIp'] = self.external_ip
        if self.external_port is not None:
            result['ExternalPort'] = self.external_port
        if self.forward_table_id is not None:
            result['ForwardTableId'] = self.forward_table_id
        if self.internal_ip is not None:
            result['InternalIp'] = self.internal_ip
        if self.internal_port is not None:
            result['InternalPort'] = self.internal_port
        if self.ip_protocol is not None:
            result['IpProtocol'] = self.ip_protocol
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ExternalIp') is not None:
            self.external_ip = m.get('ExternalIp')
        if m.get('ExternalPort') is not None:
            self.external_port = m.get('ExternalPort')
        if m.get('ForwardTableId') is not None:
            self.forward_table_id = m.get('ForwardTableId')
        if m.get('InternalIp') is not None:
            self.internal_ip = m.get('InternalIp')
        if m.get('InternalPort') is not None:
            self.internal_port = m.get('InternalPort')
        if m.get('IpProtocol') is not None:
            self.ip_protocol = m.get('IpProtocol')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CreateForwardEntryResponseBody(TeaModel):
    def __init__(self, forward_entry_id=None, request_id=None):
        self.forward_entry_id = forward_entry_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateForwardEntryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.forward_entry_id is not None:
            result['ForwardEntryId'] = self.forward_entry_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ForwardEntryId') is not None:
            self.forward_entry_id = m.get('ForwardEntryId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateForwardEntryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateForwardEntryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateForwardEntryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateForwardEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateHaVipRequest(TeaModel):
    def __init__(self, client_token=None, description=None, ip_address=None, owner_account=None, owner_id=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None, v_switch_id=None):
        self.client_token = client_token  # type: str
        self.description = description  # type: str
        self.ip_address = ip_address  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.v_switch_id = v_switch_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateHaVipRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class CreateHaVipResponseBody(TeaModel):
    def __init__(self, ha_vip_id=None, request_id=None):
        self.ha_vip_id = ha_vip_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateHaVipResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ha_vip_id is not None:
            result['HaVipId'] = self.ha_vip_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HaVipId') is not None:
            self.ha_vip_id = m.get('HaVipId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateHaVipResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateHaVipResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateHaVipResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateHaVipResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateHpcClusterRequest(TeaModel):
    def __init__(self, client_token=None, description=None, name=None, owner_account=None, owner_id=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None):
        self.client_token = client_token  # type: str
        self.description = description  # type: str
        self.name = name  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateHpcClusterRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CreateHpcClusterResponseBody(TeaModel):
    def __init__(self, hpc_cluster_id=None, request_id=None):
        self.hpc_cluster_id = hpc_cluster_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateHpcClusterResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hpc_cluster_id is not None:
            result['HpcClusterId'] = self.hpc_cluster_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HpcClusterId') is not None:
            self.hpc_cluster_id = m.get('HpcClusterId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateHpcClusterResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateHpcClusterResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateHpcClusterResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateHpcClusterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateImageRequestDiskDeviceMapping(TeaModel):
    def __init__(self, device=None, disk_type=None, size=None, snapshot_id=None):
        self.device = device  # type: str
        self.disk_type = disk_type  # type: str
        self.size = size  # type: int
        self.snapshot_id = snapshot_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateImageRequestDiskDeviceMapping, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device is not None:
            result['Device'] = self.device
        if self.disk_type is not None:
            result['DiskType'] = self.disk_type
        if self.size is not None:
            result['Size'] = self.size
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Device') is not None:
            self.device = m.get('Device')
        if m.get('DiskType') is not None:
            self.disk_type = m.get('DiskType')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        return self


class CreateImageRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateImageRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateImageRequest(TeaModel):
    def __init__(self, architecture=None, boot_mode=None, client_token=None, description=None,
                 disk_device_mapping=None, image_family=None, image_name=None, image_version=None, instance_id=None, owner_account=None,
                 owner_id=None, platform=None, region_id=None, resource_group_id=None, resource_owner_account=None,
                 resource_owner_id=None, snapshot_id=None, tag=None):
        self.architecture = architecture  # type: str
        self.boot_mode = boot_mode  # type: str
        self.client_token = client_token  # type: str
        self.description = description  # type: str
        self.disk_device_mapping = disk_device_mapping  # type: list[CreateImageRequestDiskDeviceMapping]
        self.image_family = image_family  # type: str
        self.image_name = image_name  # type: str
        self.image_version = image_version  # type: str
        self.instance_id = instance_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.platform = platform  # type: str
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.snapshot_id = snapshot_id  # type: str
        self.tag = tag  # type: list[CreateImageRequestTag]

    def validate(self):
        if self.disk_device_mapping:
            for k in self.disk_device_mapping:
                if k:
                    k.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateImageRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.architecture is not None:
            result['Architecture'] = self.architecture
        if self.boot_mode is not None:
            result['BootMode'] = self.boot_mode
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        result['DiskDeviceMapping'] = []
        if self.disk_device_mapping is not None:
            for k in self.disk_device_mapping:
                result['DiskDeviceMapping'].append(k.to_map() if k else None)
        if self.image_family is not None:
            result['ImageFamily'] = self.image_family
        if self.image_name is not None:
            result['ImageName'] = self.image_name
        if self.image_version is not None:
            result['ImageVersion'] = self.image_version
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.platform is not None:
            result['Platform'] = self.platform
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Architecture') is not None:
            self.architecture = m.get('Architecture')
        if m.get('BootMode') is not None:
            self.boot_mode = m.get('BootMode')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        self.disk_device_mapping = []
        if m.get('DiskDeviceMapping') is not None:
            for k in m.get('DiskDeviceMapping'):
                temp_model = CreateImageRequestDiskDeviceMapping()
                self.disk_device_mapping.append(temp_model.from_map(k))
        if m.get('ImageFamily') is not None:
            self.image_family = m.get('ImageFamily')
        if m.get('ImageName') is not None:
            self.image_name = m.get('ImageName')
        if m.get('ImageVersion') is not None:
            self.image_version = m.get('ImageVersion')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Platform') is not None:
            self.platform = m.get('Platform')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateImageRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CreateImageResponseBody(TeaModel):
    def __init__(self, image_id=None, request_id=None):
        self.image_id = image_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateImageResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateImageResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateImageResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateImageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateImageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateImageComponentRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateImageComponentRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateImageComponentRequest(TeaModel):
    def __init__(self, client_token=None, component_type=None, content=None, description=None, name=None,
                 owner_account=None, owner_id=None, region_id=None, resource_group_id=None, resource_owner_account=None,
                 resource_owner_id=None, system_type=None, tag=None):
        self.client_token = client_token  # type: str
        self.component_type = component_type  # type: str
        self.content = content  # type: str
        self.description = description  # type: str
        self.name = name  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.system_type = system_type  # type: str
        self.tag = tag  # type: list[CreateImageComponentRequestTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateImageComponentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.component_type is not None:
            result['ComponentType'] = self.component_type
        if self.content is not None:
            result['Content'] = self.content
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.system_type is not None:
            result['SystemType'] = self.system_type
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ComponentType') is not None:
            self.component_type = m.get('ComponentType')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SystemType') is not None:
            self.system_type = m.get('SystemType')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateImageComponentRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CreateImageComponentResponseBody(TeaModel):
    def __init__(self, image_component_id=None, request_id=None):
        self.image_component_id = image_component_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateImageComponentResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_component_id is not None:
            result['ImageComponentId'] = self.image_component_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ImageComponentId') is not None:
            self.image_component_id = m.get('ImageComponentId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateImageComponentResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateImageComponentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateImageComponentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateImageComponentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateImagePipelineRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateImagePipelineRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateImagePipelineRequest(TeaModel):
    def __init__(self, add_account=None, base_image=None, base_image_type=None, build_content=None,
                 client_token=None, delete_instance_on_failure=None, description=None, image_name=None, instance_type=None,
                 internet_max_bandwidth_out=None, name=None, owner_account=None, owner_id=None, region_id=None, resource_group_id=None,
                 resource_owner_account=None, resource_owner_id=None, system_disk_size=None, tag=None, to_region_id=None, v_switch_id=None):
        self.add_account = add_account  # type: list[long]
        self.base_image = base_image  # type: str
        self.base_image_type = base_image_type  # type: str
        self.build_content = build_content  # type: str
        self.client_token = client_token  # type: str
        self.delete_instance_on_failure = delete_instance_on_failure  # type: bool
        self.description = description  # type: str
        self.image_name = image_name  # type: str
        self.instance_type = instance_type  # type: str
        self.internet_max_bandwidth_out = internet_max_bandwidth_out  # type: int
        self.name = name  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.system_disk_size = system_disk_size  # type: int
        self.tag = tag  # type: list[CreateImagePipelineRequestTag]
        self.to_region_id = to_region_id  # type: list[str]
        self.v_switch_id = v_switch_id  # type: str

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateImagePipelineRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.add_account is not None:
            result['AddAccount'] = self.add_account
        if self.base_image is not None:
            result['BaseImage'] = self.base_image
        if self.base_image_type is not None:
            result['BaseImageType'] = self.base_image_type
        if self.build_content is not None:
            result['BuildContent'] = self.build_content
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.delete_instance_on_failure is not None:
            result['DeleteInstanceOnFailure'] = self.delete_instance_on_failure
        if self.description is not None:
            result['Description'] = self.description
        if self.image_name is not None:
            result['ImageName'] = self.image_name
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.internet_max_bandwidth_out is not None:
            result['InternetMaxBandwidthOut'] = self.internet_max_bandwidth_out
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.system_disk_size is not None:
            result['SystemDiskSize'] = self.system_disk_size
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.to_region_id is not None:
            result['ToRegionId'] = self.to_region_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AddAccount') is not None:
            self.add_account = m.get('AddAccount')
        if m.get('BaseImage') is not None:
            self.base_image = m.get('BaseImage')
        if m.get('BaseImageType') is not None:
            self.base_image_type = m.get('BaseImageType')
        if m.get('BuildContent') is not None:
            self.build_content = m.get('BuildContent')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DeleteInstanceOnFailure') is not None:
            self.delete_instance_on_failure = m.get('DeleteInstanceOnFailure')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ImageName') is not None:
            self.image_name = m.get('ImageName')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('InternetMaxBandwidthOut') is not None:
            self.internet_max_bandwidth_out = m.get('InternetMaxBandwidthOut')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SystemDiskSize') is not None:
            self.system_disk_size = m.get('SystemDiskSize')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateImagePipelineRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('ToRegionId') is not None:
            self.to_region_id = m.get('ToRegionId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class CreateImagePipelineResponseBody(TeaModel):
    def __init__(self, image_pipeline_id=None, request_id=None):
        self.image_pipeline_id = image_pipeline_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateImagePipelineResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_pipeline_id is not None:
            result['ImagePipelineId'] = self.image_pipeline_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ImagePipelineId') is not None:
            self.image_pipeline_id = m.get('ImagePipelineId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateImagePipelineResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateImagePipelineResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateImagePipelineResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateImagePipelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateInstanceRequestHibernationOptions(TeaModel):
    def __init__(self, configured=None):
        self.configured = configured  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateInstanceRequestHibernationOptions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.configured is not None:
            result['Configured'] = self.configured
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Configured') is not None:
            self.configured = m.get('Configured')
        return self


class CreateInstanceRequestPrivatePoolOptions(TeaModel):
    def __init__(self, id=None, match_criteria=None):
        self.id = id  # type: str
        self.match_criteria = match_criteria  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateInstanceRequestPrivatePoolOptions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.match_criteria is not None:
            result['MatchCriteria'] = self.match_criteria
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MatchCriteria') is not None:
            self.match_criteria = m.get('MatchCriteria')
        return self


class CreateInstanceRequestSystemDisk(TeaModel):
    def __init__(self, category=None, description=None, disk_name=None, performance_level=None, size=None,
                 storage_cluster_id=None):
        self.category = category  # type: str
        self.description = description  # type: str
        self.disk_name = disk_name  # type: str
        self.performance_level = performance_level  # type: str
        self.size = size  # type: int
        self.storage_cluster_id = storage_cluster_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateInstanceRequestSystemDisk, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.description is not None:
            result['Description'] = self.description
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.performance_level is not None:
            result['PerformanceLevel'] = self.performance_level
        if self.size is not None:
            result['Size'] = self.size
        if self.storage_cluster_id is not None:
            result['StorageClusterId'] = self.storage_cluster_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DiskName') is not None:
            self.disk_name = m.get('DiskName')
        if m.get('PerformanceLevel') is not None:
            self.performance_level = m.get('PerformanceLevel')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('StorageClusterId') is not None:
            self.storage_cluster_id = m.get('StorageClusterId')
        return self


class CreateInstanceRequestArn(TeaModel):
    def __init__(self, assume_role_for=None, role_type=None, rolearn=None):
        self.assume_role_for = assume_role_for  # type: long
        self.role_type = role_type  # type: str
        self.rolearn = rolearn  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateInstanceRequestArn, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.assume_role_for is not None:
            result['AssumeRoleFor'] = self.assume_role_for
        if self.role_type is not None:
            result['RoleType'] = self.role_type
        if self.rolearn is not None:
            result['Rolearn'] = self.rolearn
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AssumeRoleFor') is not None:
            self.assume_role_for = m.get('AssumeRoleFor')
        if m.get('RoleType') is not None:
            self.role_type = m.get('RoleType')
        if m.get('Rolearn') is not None:
            self.rolearn = m.get('Rolearn')
        return self


class CreateInstanceRequestDataDisk(TeaModel):
    def __init__(self, category=None, delete_with_instance=None, description=None, device=None, disk_name=None,
                 encrypt_algorithm=None, encrypted=None, kmskey_id=None, performance_level=None, size=None, snapshot_id=None,
                 storage_cluster_id=None):
        self.category = category  # type: str
        self.delete_with_instance = delete_with_instance  # type: bool
        self.description = description  # type: str
        self.device = device  # type: str
        self.disk_name = disk_name  # type: str
        self.encrypt_algorithm = encrypt_algorithm  # type: str
        self.encrypted = encrypted  # type: bool
        self.kmskey_id = kmskey_id  # type: str
        self.performance_level = performance_level  # type: str
        self.size = size  # type: int
        self.snapshot_id = snapshot_id  # type: str
        self.storage_cluster_id = storage_cluster_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateInstanceRequestDataDisk, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.delete_with_instance is not None:
            result['DeleteWithInstance'] = self.delete_with_instance
        if self.description is not None:
            result['Description'] = self.description
        if self.device is not None:
            result['Device'] = self.device
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.encrypt_algorithm is not None:
            result['EncryptAlgorithm'] = self.encrypt_algorithm
        if self.encrypted is not None:
            result['Encrypted'] = self.encrypted
        if self.kmskey_id is not None:
            result['KMSKeyId'] = self.kmskey_id
        if self.performance_level is not None:
            result['PerformanceLevel'] = self.performance_level
        if self.size is not None:
            result['Size'] = self.size
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.storage_cluster_id is not None:
            result['StorageClusterId'] = self.storage_cluster_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('DeleteWithInstance') is not None:
            self.delete_with_instance = m.get('DeleteWithInstance')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Device') is not None:
            self.device = m.get('Device')
        if m.get('DiskName') is not None:
            self.disk_name = m.get('DiskName')
        if m.get('EncryptAlgorithm') is not None:
            self.encrypt_algorithm = m.get('EncryptAlgorithm')
        if m.get('Encrypted') is not None:
            self.encrypted = m.get('Encrypted')
        if m.get('KMSKeyId') is not None:
            self.kmskey_id = m.get('KMSKeyId')
        if m.get('PerformanceLevel') is not None:
            self.performance_level = m.get('PerformanceLevel')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('StorageClusterId') is not None:
            self.storage_cluster_id = m.get('StorageClusterId')
        return self


class CreateInstanceRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateInstanceRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateInstanceRequest(TeaModel):
    def __init__(self, hibernation_options=None, private_pool_options=None, system_disk=None, affinity=None,
                 arn=None, auto_renew=None, auto_renew_period=None, client_token=None, cluster_id=None,
                 credit_specification=None, data_disk=None, dedicated_host_id=None, deletion_protection=None,
                 deployment_set_group_no=None, deployment_set_id=None, description=None, dry_run=None, host_name=None, hpc_cluster_id=None,
                 http_endpoint=None, http_put_response_hop_limit=None, http_tokens=None, image_family=None, image_id=None,
                 inner_ip_address=None, instance_charge_type=None, instance_name=None, instance_type=None,
                 internet_charge_type=None, internet_max_bandwidth_in=None, internet_max_bandwidth_out=None, io_optimized=None,
                 key_pair_name=None, node_controller_id=None, owner_account=None, owner_id=None, password=None,
                 password_inherit=None, period=None, period_unit=None, private_ip_address=None, ram_role_name=None, region_id=None,
                 resource_group_id=None, resource_owner_account=None, resource_owner_id=None, security_enhancement_strategy=None,
                 security_group_id=None, spot_duration=None, spot_interruption_behavior=None, spot_price_limit=None,
                 spot_strategy=None, storage_set_id=None, storage_set_partition_number=None, tag=None, tenancy=None,
                 use_additional_service=None, user_data=None, v_switch_id=None, vlan_id=None, zone_id=None):
        self.hibernation_options = hibernation_options  # type: CreateInstanceRequestHibernationOptions
        self.private_pool_options = private_pool_options  # type: CreateInstanceRequestPrivatePoolOptions
        self.system_disk = system_disk  # type: CreateInstanceRequestSystemDisk
        self.affinity = affinity  # type: str
        self.arn = arn  # type: list[CreateInstanceRequestArn]
        self.auto_renew = auto_renew  # type: bool
        self.auto_renew_period = auto_renew_period  # type: int
        self.client_token = client_token  # type: str
        self.cluster_id = cluster_id  # type: str
        self.credit_specification = credit_specification  # type: str
        self.data_disk = data_disk  # type: list[CreateInstanceRequestDataDisk]
        self.dedicated_host_id = dedicated_host_id  # type: str
        self.deletion_protection = deletion_protection  # type: bool
        self.deployment_set_group_no = deployment_set_group_no  # type: int
        self.deployment_set_id = deployment_set_id  # type: str
        self.description = description  # type: str
        self.dry_run = dry_run  # type: bool
        self.host_name = host_name  # type: str
        self.hpc_cluster_id = hpc_cluster_id  # type: str
        self.http_endpoint = http_endpoint  # type: str
        self.http_put_response_hop_limit = http_put_response_hop_limit  # type: int
        self.http_tokens = http_tokens  # type: str
        self.image_family = image_family  # type: str
        self.image_id = image_id  # type: str
        self.inner_ip_address = inner_ip_address  # type: str
        self.instance_charge_type = instance_charge_type  # type: str
        self.instance_name = instance_name  # type: str
        self.instance_type = instance_type  # type: str
        self.internet_charge_type = internet_charge_type  # type: str
        self.internet_max_bandwidth_in = internet_max_bandwidth_in  # type: int
        self.internet_max_bandwidth_out = internet_max_bandwidth_out  # type: int
        self.io_optimized = io_optimized  # type: str
        self.key_pair_name = key_pair_name  # type: str
        self.node_controller_id = node_controller_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.password = password  # type: str
        self.password_inherit = password_inherit  # type: bool
        self.period = period  # type: int
        self.period_unit = period_unit  # type: str
        self.private_ip_address = private_ip_address  # type: str
        self.ram_role_name = ram_role_name  # type: str
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.security_enhancement_strategy = security_enhancement_strategy  # type: str
        self.security_group_id = security_group_id  # type: str
        self.spot_duration = spot_duration  # type: int
        self.spot_interruption_behavior = spot_interruption_behavior  # type: str
        self.spot_price_limit = spot_price_limit  # type: float
        self.spot_strategy = spot_strategy  # type: str
        self.storage_set_id = storage_set_id  # type: str
        self.storage_set_partition_number = storage_set_partition_number  # type: int
        self.tag = tag  # type: list[CreateInstanceRequestTag]
        self.tenancy = tenancy  # type: str
        self.use_additional_service = use_additional_service  # type: bool
        self.user_data = user_data  # type: str
        self.v_switch_id = v_switch_id  # type: str
        self.vlan_id = vlan_id  # type: str
        self.zone_id = zone_id  # type: str

    def validate(self):
        if self.hibernation_options:
            self.hibernation_options.validate()
        if self.private_pool_options:
            self.private_pool_options.validate()
        if self.system_disk:
            self.system_disk.validate()
        if self.arn:
            for k in self.arn:
                if k:
                    k.validate()
        if self.data_disk:
            for k in self.data_disk:
                if k:
                    k.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hibernation_options is not None:
            result['HibernationOptions'] = self.hibernation_options.to_map()
        if self.private_pool_options is not None:
            result['PrivatePoolOptions'] = self.private_pool_options.to_map()
        if self.system_disk is not None:
            result['SystemDisk'] = self.system_disk.to_map()
        if self.affinity is not None:
            result['Affinity'] = self.affinity
        result['Arn'] = []
        if self.arn is not None:
            for k in self.arn:
                result['Arn'].append(k.to_map() if k else None)
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.auto_renew_period is not None:
            result['AutoRenewPeriod'] = self.auto_renew_period
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.credit_specification is not None:
            result['CreditSpecification'] = self.credit_specification
        result['DataDisk'] = []
        if self.data_disk is not None:
            for k in self.data_disk:
                result['DataDisk'].append(k.to_map() if k else None)
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        if self.deletion_protection is not None:
            result['DeletionProtection'] = self.deletion_protection
        if self.deployment_set_group_no is not None:
            result['DeploymentSetGroupNo'] = self.deployment_set_group_no
        if self.deployment_set_id is not None:
            result['DeploymentSetId'] = self.deployment_set_id
        if self.description is not None:
            result['Description'] = self.description
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.hpc_cluster_id is not None:
            result['HpcClusterId'] = self.hpc_cluster_id
        if self.http_endpoint is not None:
            result['HttpEndpoint'] = self.http_endpoint
        if self.http_put_response_hop_limit is not None:
            result['HttpPutResponseHopLimit'] = self.http_put_response_hop_limit
        if self.http_tokens is not None:
            result['HttpTokens'] = self.http_tokens
        if self.image_family is not None:
            result['ImageFamily'] = self.image_family
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.inner_ip_address is not None:
            result['InnerIpAddress'] = self.inner_ip_address
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.internet_max_bandwidth_in is not None:
            result['InternetMaxBandwidthIn'] = self.internet_max_bandwidth_in
        if self.internet_max_bandwidth_out is not None:
            result['InternetMaxBandwidthOut'] = self.internet_max_bandwidth_out
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.node_controller_id is not None:
            result['NodeControllerId'] = self.node_controller_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.password is not None:
            result['Password'] = self.password
        if self.password_inherit is not None:
            result['PasswordInherit'] = self.password_inherit
        if self.period is not None:
            result['Period'] = self.period
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.ram_role_name is not None:
            result['RamRoleName'] = self.ram_role_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.security_enhancement_strategy is not None:
            result['SecurityEnhancementStrategy'] = self.security_enhancement_strategy
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.spot_duration is not None:
            result['SpotDuration'] = self.spot_duration
        if self.spot_interruption_behavior is not None:
            result['SpotInterruptionBehavior'] = self.spot_interruption_behavior
        if self.spot_price_limit is not None:
            result['SpotPriceLimit'] = self.spot_price_limit
        if self.spot_strategy is not None:
            result['SpotStrategy'] = self.spot_strategy
        if self.storage_set_id is not None:
            result['StorageSetId'] = self.storage_set_id
        if self.storage_set_partition_number is not None:
            result['StorageSetPartitionNumber'] = self.storage_set_partition_number
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.tenancy is not None:
            result['Tenancy'] = self.tenancy
        if self.use_additional_service is not None:
            result['UseAdditionalService'] = self.use_additional_service
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.vlan_id is not None:
            result['VlanId'] = self.vlan_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HibernationOptions') is not None:
            temp_model = CreateInstanceRequestHibernationOptions()
            self.hibernation_options = temp_model.from_map(m['HibernationOptions'])
        if m.get('PrivatePoolOptions') is not None:
            temp_model = CreateInstanceRequestPrivatePoolOptions()
            self.private_pool_options = temp_model.from_map(m['PrivatePoolOptions'])
        if m.get('SystemDisk') is not None:
            temp_model = CreateInstanceRequestSystemDisk()
            self.system_disk = temp_model.from_map(m['SystemDisk'])
        if m.get('Affinity') is not None:
            self.affinity = m.get('Affinity')
        self.arn = []
        if m.get('Arn') is not None:
            for k in m.get('Arn'):
                temp_model = CreateInstanceRequestArn()
                self.arn.append(temp_model.from_map(k))
        if m.get('AutoRenew') is not None:
            self.auto_renew = m.get('AutoRenew')
        if m.get('AutoRenewPeriod') is not None:
            self.auto_renew_period = m.get('AutoRenewPeriod')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('CreditSpecification') is not None:
            self.credit_specification = m.get('CreditSpecification')
        self.data_disk = []
        if m.get('DataDisk') is not None:
            for k in m.get('DataDisk'):
                temp_model = CreateInstanceRequestDataDisk()
                self.data_disk.append(temp_model.from_map(k))
        if m.get('DedicatedHostId') is not None:
            self.dedicated_host_id = m.get('DedicatedHostId')
        if m.get('DeletionProtection') is not None:
            self.deletion_protection = m.get('DeletionProtection')
        if m.get('DeploymentSetGroupNo') is not None:
            self.deployment_set_group_no = m.get('DeploymentSetGroupNo')
        if m.get('DeploymentSetId') is not None:
            self.deployment_set_id = m.get('DeploymentSetId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('HpcClusterId') is not None:
            self.hpc_cluster_id = m.get('HpcClusterId')
        if m.get('HttpEndpoint') is not None:
            self.http_endpoint = m.get('HttpEndpoint')
        if m.get('HttpPutResponseHopLimit') is not None:
            self.http_put_response_hop_limit = m.get('HttpPutResponseHopLimit')
        if m.get('HttpTokens') is not None:
            self.http_tokens = m.get('HttpTokens')
        if m.get('ImageFamily') is not None:
            self.image_family = m.get('ImageFamily')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('InnerIpAddress') is not None:
            self.inner_ip_address = m.get('InnerIpAddress')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('InternetMaxBandwidthIn') is not None:
            self.internet_max_bandwidth_in = m.get('InternetMaxBandwidthIn')
        if m.get('InternetMaxBandwidthOut') is not None:
            self.internet_max_bandwidth_out = m.get('InternetMaxBandwidthOut')
        if m.get('IoOptimized') is not None:
            self.io_optimized = m.get('IoOptimized')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('NodeControllerId') is not None:
            self.node_controller_id = m.get('NodeControllerId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('PasswordInherit') is not None:
            self.password_inherit = m.get('PasswordInherit')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('PrivateIpAddress') is not None:
            self.private_ip_address = m.get('PrivateIpAddress')
        if m.get('RamRoleName') is not None:
            self.ram_role_name = m.get('RamRoleName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SecurityEnhancementStrategy') is not None:
            self.security_enhancement_strategy = m.get('SecurityEnhancementStrategy')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('SpotDuration') is not None:
            self.spot_duration = m.get('SpotDuration')
        if m.get('SpotInterruptionBehavior') is not None:
            self.spot_interruption_behavior = m.get('SpotInterruptionBehavior')
        if m.get('SpotPriceLimit') is not None:
            self.spot_price_limit = m.get('SpotPriceLimit')
        if m.get('SpotStrategy') is not None:
            self.spot_strategy = m.get('SpotStrategy')
        if m.get('StorageSetId') is not None:
            self.storage_set_id = m.get('StorageSetId')
        if m.get('StorageSetPartitionNumber') is not None:
            self.storage_set_partition_number = m.get('StorageSetPartitionNumber')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateInstanceRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('Tenancy') is not None:
            self.tenancy = m.get('Tenancy')
        if m.get('UseAdditionalService') is not None:
            self.use_additional_service = m.get('UseAdditionalService')
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VlanId') is not None:
            self.vlan_id = m.get('VlanId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class CreateInstanceResponseBody(TeaModel):
    def __init__(self, instance_id=None, order_id=None, request_id=None, trade_price=None):
        self.instance_id = instance_id  # type: str
        self.order_id = order_id  # type: str
        self.request_id = request_id  # type: str
        self.trade_price = trade_price  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.trade_price is not None:
            result['TradePrice'] = self.trade_price
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TradePrice') is not None:
            self.trade_price = m.get('TradePrice')
        return self


class CreateInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateKeyPairRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateKeyPairRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateKeyPairRequest(TeaModel):
    def __init__(self, key_pair_name=None, owner_id=None, region_id=None, resource_group_id=None,
                 resource_owner_account=None, resource_owner_id=None, tag=None):
        self.key_pair_name = key_pair_name  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.tag = tag  # type: list[CreateKeyPairRequestTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateKeyPairRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateKeyPairRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CreateKeyPairResponseBody(TeaModel):
    def __init__(self, key_pair_finger_print=None, key_pair_id=None, key_pair_name=None, private_key_body=None,
                 request_id=None):
        self.key_pair_finger_print = key_pair_finger_print  # type: str
        self.key_pair_id = key_pair_id  # type: str
        self.key_pair_name = key_pair_name  # type: str
        self.private_key_body = private_key_body  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateKeyPairResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key_pair_finger_print is not None:
            result['KeyPairFingerPrint'] = self.key_pair_finger_print
        if self.key_pair_id is not None:
            result['KeyPairId'] = self.key_pair_id
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.private_key_body is not None:
            result['PrivateKeyBody'] = self.private_key_body
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('KeyPairFingerPrint') is not None:
            self.key_pair_finger_print = m.get('KeyPairFingerPrint')
        if m.get('KeyPairId') is not None:
            self.key_pair_id = m.get('KeyPairId')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('PrivateKeyBody') is not None:
            self.private_key_body = m.get('PrivateKeyBody')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateKeyPairResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateKeyPairResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateKeyPairResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateKeyPairResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLaunchTemplateRequestSystemDisk(TeaModel):
    def __init__(self, auto_snapshot_policy_id=None, bursting_enabled=None, category=None,
                 delete_with_instance=None, description=None, disk_name=None, iops=None, performance_level=None, provisioned_iops=None,
                 size=None):
        self.auto_snapshot_policy_id = auto_snapshot_policy_id  # type: str
        self.bursting_enabled = bursting_enabled  # type: bool
        self.category = category  # type: str
        self.delete_with_instance = delete_with_instance  # type: bool
        self.description = description  # type: str
        self.disk_name = disk_name  # type: str
        self.iops = iops  # type: int
        self.performance_level = performance_level  # type: str
        self.provisioned_iops = provisioned_iops  # type: long
        self.size = size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateLaunchTemplateRequestSystemDisk, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_snapshot_policy_id is not None:
            result['AutoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        if self.bursting_enabled is not None:
            result['BurstingEnabled'] = self.bursting_enabled
        if self.category is not None:
            result['Category'] = self.category
        if self.delete_with_instance is not None:
            result['DeleteWithInstance'] = self.delete_with_instance
        if self.description is not None:
            result['Description'] = self.description
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.iops is not None:
            result['Iops'] = self.iops
        if self.performance_level is not None:
            result['PerformanceLevel'] = self.performance_level
        if self.provisioned_iops is not None:
            result['ProvisionedIops'] = self.provisioned_iops
        if self.size is not None:
            result['Size'] = self.size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoSnapshotPolicyId') is not None:
            self.auto_snapshot_policy_id = m.get('AutoSnapshotPolicyId')
        if m.get('BurstingEnabled') is not None:
            self.bursting_enabled = m.get('BurstingEnabled')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('DeleteWithInstance') is not None:
            self.delete_with_instance = m.get('DeleteWithInstance')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DiskName') is not None:
            self.disk_name = m.get('DiskName')
        if m.get('Iops') is not None:
            self.iops = m.get('Iops')
        if m.get('PerformanceLevel') is not None:
            self.performance_level = m.get('PerformanceLevel')
        if m.get('ProvisionedIops') is not None:
            self.provisioned_iops = m.get('ProvisionedIops')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        return self


class CreateLaunchTemplateRequestDataDisk(TeaModel):
    def __init__(self, auto_snapshot_policy_id=None, bursting_enabled=None, category=None,
                 delete_with_instance=None, description=None, device=None, disk_name=None, encrypted=None, performance_level=None,
                 provisioned_iops=None, size=None, snapshot_id=None):
        self.auto_snapshot_policy_id = auto_snapshot_policy_id  # type: str
        self.bursting_enabled = bursting_enabled  # type: bool
        self.category = category  # type: str
        self.delete_with_instance = delete_with_instance  # type: bool
        self.description = description  # type: str
        self.device = device  # type: str
        self.disk_name = disk_name  # type: str
        self.encrypted = encrypted  # type: str
        self.performance_level = performance_level  # type: str
        self.provisioned_iops = provisioned_iops  # type: long
        self.size = size  # type: int
        self.snapshot_id = snapshot_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateLaunchTemplateRequestDataDisk, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_snapshot_policy_id is not None:
            result['AutoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        if self.bursting_enabled is not None:
            result['BurstingEnabled'] = self.bursting_enabled
        if self.category is not None:
            result['Category'] = self.category
        if self.delete_with_instance is not None:
            result['DeleteWithInstance'] = self.delete_with_instance
        if self.description is not None:
            result['Description'] = self.description
        if self.device is not None:
            result['Device'] = self.device
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.encrypted is not None:
            result['Encrypted'] = self.encrypted
        if self.performance_level is not None:
            result['PerformanceLevel'] = self.performance_level
        if self.provisioned_iops is not None:
            result['ProvisionedIops'] = self.provisioned_iops
        if self.size is not None:
            result['Size'] = self.size
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoSnapshotPolicyId') is not None:
            self.auto_snapshot_policy_id = m.get('AutoSnapshotPolicyId')
        if m.get('BurstingEnabled') is not None:
            self.bursting_enabled = m.get('BurstingEnabled')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('DeleteWithInstance') is not None:
            self.delete_with_instance = m.get('DeleteWithInstance')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Device') is not None:
            self.device = m.get('Device')
        if m.get('DiskName') is not None:
            self.disk_name = m.get('DiskName')
        if m.get('Encrypted') is not None:
            self.encrypted = m.get('Encrypted')
        if m.get('PerformanceLevel') is not None:
            self.performance_level = m.get('PerformanceLevel')
        if m.get('ProvisionedIops') is not None:
            self.provisioned_iops = m.get('ProvisionedIops')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        return self


class CreateLaunchTemplateRequestNetworkInterface(TeaModel):
    def __init__(self, description=None, instance_type=None, network_interface_name=None,
                 network_interface_traffic_mode=None, primary_ip_address=None, security_group_id=None, security_group_ids=None, v_switch_id=None):
        self.description = description  # type: str
        self.instance_type = instance_type  # type: str
        self.network_interface_name = network_interface_name  # type: str
        self.network_interface_traffic_mode = network_interface_traffic_mode  # type: str
        self.primary_ip_address = primary_ip_address  # type: str
        self.security_group_id = security_group_id  # type: str
        self.security_group_ids = security_group_ids  # type: list[str]
        self.v_switch_id = v_switch_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateLaunchTemplateRequestNetworkInterface, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.network_interface_name is not None:
            result['NetworkInterfaceName'] = self.network_interface_name
        if self.network_interface_traffic_mode is not None:
            result['NetworkInterfaceTrafficMode'] = self.network_interface_traffic_mode
        if self.primary_ip_address is not None:
            result['PrimaryIpAddress'] = self.primary_ip_address
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.security_group_ids is not None:
            result['SecurityGroupIds'] = self.security_group_ids
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('NetworkInterfaceName') is not None:
            self.network_interface_name = m.get('NetworkInterfaceName')
        if m.get('NetworkInterfaceTrafficMode') is not None:
            self.network_interface_traffic_mode = m.get('NetworkInterfaceTrafficMode')
        if m.get('PrimaryIpAddress') is not None:
            self.primary_ip_address = m.get('PrimaryIpAddress')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('SecurityGroupIds') is not None:
            self.security_group_ids = m.get('SecurityGroupIds')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class CreateLaunchTemplateRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateLaunchTemplateRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateLaunchTemplateRequestTemplateTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateLaunchTemplateRequestTemplateTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateLaunchTemplateRequest(TeaModel):
    def __init__(self, system_disk=None, auto_release_time=None, data_disk=None, deployment_set_id=None,
                 description=None, enable_vm_os_config=None, host_name=None, image_id=None, image_owner_alias=None,
                 instance_charge_type=None, instance_name=None, instance_type=None, internet_charge_type=None,
                 internet_max_bandwidth_in=None, internet_max_bandwidth_out=None, io_optimized=None, ipv_6address_count=None,
                 key_pair_name=None, launch_template_name=None, network_interface=None, network_type=None, owner_account=None,
                 owner_id=None, password_inherit=None, period=None, private_ip_address=None, ram_role_name=None,
                 region_id=None, resource_group_id=None, resource_owner_account=None, resource_owner_id=None,
                 security_enhancement_strategy=None, security_group_id=None, security_group_ids=None, spot_duration=None, spot_price_limit=None,
                 spot_strategy=None, tag=None, template_resource_group_id=None, template_tag=None, user_data=None,
                 v_switch_id=None, version_description=None, vpc_id=None, zone_id=None):
        self.system_disk = system_disk  # type: CreateLaunchTemplateRequestSystemDisk
        self.auto_release_time = auto_release_time  # type: str
        self.data_disk = data_disk  # type: list[CreateLaunchTemplateRequestDataDisk]
        self.deployment_set_id = deployment_set_id  # type: str
        self.description = description  # type: str
        self.enable_vm_os_config = enable_vm_os_config  # type: bool
        self.host_name = host_name  # type: str
        self.image_id = image_id  # type: str
        self.image_owner_alias = image_owner_alias  # type: str
        self.instance_charge_type = instance_charge_type  # type: str
        self.instance_name = instance_name  # type: str
        self.instance_type = instance_type  # type: str
        self.internet_charge_type = internet_charge_type  # type: str
        self.internet_max_bandwidth_in = internet_max_bandwidth_in  # type: int
        self.internet_max_bandwidth_out = internet_max_bandwidth_out  # type: int
        self.io_optimized = io_optimized  # type: str
        self.ipv_6address_count = ipv_6address_count  # type: int
        self.key_pair_name = key_pair_name  # type: str
        self.launch_template_name = launch_template_name  # type: str
        self.network_interface = network_interface  # type: list[CreateLaunchTemplateRequestNetworkInterface]
        self.network_type = network_type  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.password_inherit = password_inherit  # type: bool
        self.period = period  # type: int
        self.private_ip_address = private_ip_address  # type: str
        self.ram_role_name = ram_role_name  # type: str
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.security_enhancement_strategy = security_enhancement_strategy  # type: str
        self.security_group_id = security_group_id  # type: str
        self.security_group_ids = security_group_ids  # type: list[str]
        self.spot_duration = spot_duration  # type: int
        self.spot_price_limit = spot_price_limit  # type: float
        self.spot_strategy = spot_strategy  # type: str
        self.tag = tag  # type: list[CreateLaunchTemplateRequestTag]
        self.template_resource_group_id = template_resource_group_id  # type: str
        self.template_tag = template_tag  # type: list[CreateLaunchTemplateRequestTemplateTag]
        self.user_data = user_data  # type: str
        self.v_switch_id = v_switch_id  # type: str
        self.version_description = version_description  # type: str
        self.vpc_id = vpc_id  # type: str
        self.zone_id = zone_id  # type: str

    def validate(self):
        if self.system_disk:
            self.system_disk.validate()
        if self.data_disk:
            for k in self.data_disk:
                if k:
                    k.validate()
        if self.network_interface:
            for k in self.network_interface:
                if k:
                    k.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()
        if self.template_tag:
            for k in self.template_tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateLaunchTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.system_disk is not None:
            result['SystemDisk'] = self.system_disk.to_map()
        if self.auto_release_time is not None:
            result['AutoReleaseTime'] = self.auto_release_time
        result['DataDisk'] = []
        if self.data_disk is not None:
            for k in self.data_disk:
                result['DataDisk'].append(k.to_map() if k else None)
        if self.deployment_set_id is not None:
            result['DeploymentSetId'] = self.deployment_set_id
        if self.description is not None:
            result['Description'] = self.description
        if self.enable_vm_os_config is not None:
            result['EnableVmOsConfig'] = self.enable_vm_os_config
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_owner_alias is not None:
            result['ImageOwnerAlias'] = self.image_owner_alias
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.internet_max_bandwidth_in is not None:
            result['InternetMaxBandwidthIn'] = self.internet_max_bandwidth_in
        if self.internet_max_bandwidth_out is not None:
            result['InternetMaxBandwidthOut'] = self.internet_max_bandwidth_out
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.ipv_6address_count is not None:
            result['Ipv6AddressCount'] = self.ipv_6address_count
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.launch_template_name is not None:
            result['LaunchTemplateName'] = self.launch_template_name
        result['NetworkInterface'] = []
        if self.network_interface is not None:
            for k in self.network_interface:
                result['NetworkInterface'].append(k.to_map() if k else None)
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.password_inherit is not None:
            result['PasswordInherit'] = self.password_inherit
        if self.period is not None:
            result['Period'] = self.period
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.ram_role_name is not None:
            result['RamRoleName'] = self.ram_role_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.security_enhancement_strategy is not None:
            result['SecurityEnhancementStrategy'] = self.security_enhancement_strategy
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.security_group_ids is not None:
            result['SecurityGroupIds'] = self.security_group_ids
        if self.spot_duration is not None:
            result['SpotDuration'] = self.spot_duration
        if self.spot_price_limit is not None:
            result['SpotPriceLimit'] = self.spot_price_limit
        if self.spot_strategy is not None:
            result['SpotStrategy'] = self.spot_strategy
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.template_resource_group_id is not None:
            result['TemplateResourceGroupId'] = self.template_resource_group_id
        result['TemplateTag'] = []
        if self.template_tag is not None:
            for k in self.template_tag:
                result['TemplateTag'].append(k.to_map() if k else None)
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.version_description is not None:
            result['VersionDescription'] = self.version_description
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SystemDisk') is not None:
            temp_model = CreateLaunchTemplateRequestSystemDisk()
            self.system_disk = temp_model.from_map(m['SystemDisk'])
        if m.get('AutoReleaseTime') is not None:
            self.auto_release_time = m.get('AutoReleaseTime')
        self.data_disk = []
        if m.get('DataDisk') is not None:
            for k in m.get('DataDisk'):
                temp_model = CreateLaunchTemplateRequestDataDisk()
                self.data_disk.append(temp_model.from_map(k))
        if m.get('DeploymentSetId') is not None:
            self.deployment_set_id = m.get('DeploymentSetId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnableVmOsConfig') is not None:
            self.enable_vm_os_config = m.get('EnableVmOsConfig')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageOwnerAlias') is not None:
            self.image_owner_alias = m.get('ImageOwnerAlias')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('InternetMaxBandwidthIn') is not None:
            self.internet_max_bandwidth_in = m.get('InternetMaxBandwidthIn')
        if m.get('InternetMaxBandwidthOut') is not None:
            self.internet_max_bandwidth_out = m.get('InternetMaxBandwidthOut')
        if m.get('IoOptimized') is not None:
            self.io_optimized = m.get('IoOptimized')
        if m.get('Ipv6AddressCount') is not None:
            self.ipv_6address_count = m.get('Ipv6AddressCount')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('LaunchTemplateName') is not None:
            self.launch_template_name = m.get('LaunchTemplateName')
        self.network_interface = []
        if m.get('NetworkInterface') is not None:
            for k in m.get('NetworkInterface'):
                temp_model = CreateLaunchTemplateRequestNetworkInterface()
                self.network_interface.append(temp_model.from_map(k))
        if m.get('NetworkType') is not None:
            self.network_type = m.get('NetworkType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PasswordInherit') is not None:
            self.password_inherit = m.get('PasswordInherit')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PrivateIpAddress') is not None:
            self.private_ip_address = m.get('PrivateIpAddress')
        if m.get('RamRoleName') is not None:
            self.ram_role_name = m.get('RamRoleName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SecurityEnhancementStrategy') is not None:
            self.security_enhancement_strategy = m.get('SecurityEnhancementStrategy')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('SecurityGroupIds') is not None:
            self.security_group_ids = m.get('SecurityGroupIds')
        if m.get('SpotDuration') is not None:
            self.spot_duration = m.get('SpotDuration')
        if m.get('SpotPriceLimit') is not None:
            self.spot_price_limit = m.get('SpotPriceLimit')
        if m.get('SpotStrategy') is not None:
            self.spot_strategy = m.get('SpotStrategy')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateLaunchTemplateRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('TemplateResourceGroupId') is not None:
            self.template_resource_group_id = m.get('TemplateResourceGroupId')
        self.template_tag = []
        if m.get('TemplateTag') is not None:
            for k in m.get('TemplateTag'):
                temp_model = CreateLaunchTemplateRequestTemplateTag()
                self.template_tag.append(temp_model.from_map(k))
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VersionDescription') is not None:
            self.version_description = m.get('VersionDescription')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class CreateLaunchTemplateResponseBody(TeaModel):
    def __init__(self, launch_template_id=None, request_id=None):
        self.launch_template_id = launch_template_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateLaunchTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.launch_template_id is not None:
            result['LaunchTemplateId'] = self.launch_template_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LaunchTemplateId') is not None:
            self.launch_template_id = m.get('LaunchTemplateId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateLaunchTemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateLaunchTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateLaunchTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateLaunchTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateLaunchTemplateVersionRequestSystemDisk(TeaModel):
    def __init__(self, auto_snapshot_policy_id=None, bursting_enabled=None, category=None,
                 delete_with_instance=None, description=None, disk_name=None, iops=None, performance_level=None, provisioned_iops=None,
                 size=None):
        self.auto_snapshot_policy_id = auto_snapshot_policy_id  # type: str
        self.bursting_enabled = bursting_enabled  # type: bool
        self.category = category  # type: str
        self.delete_with_instance = delete_with_instance  # type: bool
        self.description = description  # type: str
        self.disk_name = disk_name  # type: str
        self.iops = iops  # type: int
        self.performance_level = performance_level  # type: str
        self.provisioned_iops = provisioned_iops  # type: long
        self.size = size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateLaunchTemplateVersionRequestSystemDisk, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_snapshot_policy_id is not None:
            result['AutoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        if self.bursting_enabled is not None:
            result['BurstingEnabled'] = self.bursting_enabled
        if self.category is not None:
            result['Category'] = self.category
        if self.delete_with_instance is not None:
            result['DeleteWithInstance'] = self.delete_with_instance
        if self.description is not None:
            result['Description'] = self.description
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.iops is not None:
            result['Iops'] = self.iops
        if self.performance_level is not None:
            result['PerformanceLevel'] = self.performance_level
        if self.provisioned_iops is not None:
            result['ProvisionedIops'] = self.provisioned_iops
        if self.size is not None:
            result['Size'] = self.size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoSnapshotPolicyId') is not None:
            self.auto_snapshot_policy_id = m.get('AutoSnapshotPolicyId')
        if m.get('BurstingEnabled') is not None:
            self.bursting_enabled = m.get('BurstingEnabled')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('DeleteWithInstance') is not None:
            self.delete_with_instance = m.get('DeleteWithInstance')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DiskName') is not None:
            self.disk_name = m.get('DiskName')
        if m.get('Iops') is not None:
            self.iops = m.get('Iops')
        if m.get('PerformanceLevel') is not None:
            self.performance_level = m.get('PerformanceLevel')
        if m.get('ProvisionedIops') is not None:
            self.provisioned_iops = m.get('ProvisionedIops')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        return self


class CreateLaunchTemplateVersionRequestDataDisk(TeaModel):
    def __init__(self, auto_snapshot_policy_id=None, bursting_enabled=None, category=None,
                 delete_with_instance=None, description=None, device=None, disk_name=None, encrypted=None, performance_level=None,
                 provisioned_iops=None, size=None, snapshot_id=None):
        self.auto_snapshot_policy_id = auto_snapshot_policy_id  # type: str
        self.bursting_enabled = bursting_enabled  # type: bool
        self.category = category  # type: str
        self.delete_with_instance = delete_with_instance  # type: bool
        self.description = description  # type: str
        self.device = device  # type: str
        self.disk_name = disk_name  # type: str
        self.encrypted = encrypted  # type: str
        self.performance_level = performance_level  # type: str
        self.provisioned_iops = provisioned_iops  # type: long
        self.size = size  # type: int
        self.snapshot_id = snapshot_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateLaunchTemplateVersionRequestDataDisk, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_snapshot_policy_id is not None:
            result['AutoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        if self.bursting_enabled is not None:
            result['BurstingEnabled'] = self.bursting_enabled
        if self.category is not None:
            result['Category'] = self.category
        if self.delete_with_instance is not None:
            result['DeleteWithInstance'] = self.delete_with_instance
        if self.description is not None:
            result['Description'] = self.description
        if self.device is not None:
            result['Device'] = self.device
        if self.disk_name is not None:
            result['DiskName'] = self.disk_name
        if self.encrypted is not None:
            result['Encrypted'] = self.encrypted
        if self.performance_level is not None:
            result['PerformanceLevel'] = self.performance_level
        if self.provisioned_iops is not None:
            result['ProvisionedIops'] = self.provisioned_iops
        if self.size is not None:
            result['Size'] = self.size
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoSnapshotPolicyId') is not None:
            self.auto_snapshot_policy_id = m.get('AutoSnapshotPolicyId')
        if m.get('BurstingEnabled') is not None:
            self.bursting_enabled = m.get('BurstingEnabled')
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('DeleteWithInstance') is not None:
            self.delete_with_instance = m.get('DeleteWithInstance')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Device') is not None:
            self.device = m.get('Device')
        if m.get('DiskName') is not None:
            self.disk_name = m.get('DiskName')
        if m.get('Encrypted') is not None:
            self.encrypted = m.get('Encrypted')
        if m.get('PerformanceLevel') is not None:
            self.performance_level = m.get('PerformanceLevel')
        if m.get('ProvisionedIops') is not None:
            self.provisioned_iops = m.get('ProvisionedIops')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        return self


class CreateLaunchTemplateVersionRequestNetworkInterface(TeaModel):
    def __init__(self, description=None, instance_type=None, network_interface_name=None,
                 network_interface_traffic_mode=None, primary_ip_address=None, security_group_id=None, security_group_ids=None, v_switch_id=None):
        self.description = description  # type: str
        self.instance_type = instance_type  # type: str
        self.network_interface_name = network_interface_name  # type: str
        self.network_interface_traffic_mode = network_interface_traffic_mode  # type: str
        self.primary_ip_address = primary_ip_address  # type: str
        self.security_group_id = security_group_id  # type: str
        self.security_group_ids = security_group_ids  # type: list[str]
        self.v_switch_id = v_switch_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateLaunchTemplateVersionRequestNetworkInterface, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.network_interface_name is not None:
            result['NetworkInterfaceName'] = self.network_interface_name
        if self.network_interface_traffic_mode is not None:
            result['NetworkInterfaceTrafficMode'] = self.network_interface_traffic_mode
        if self.primary_ip_address is not None:
            result['PrimaryIpAddress'] = self.primary_ip_address
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.security_group_ids is not None:
            result['SecurityGroupIds'] = self.security_group_ids
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('NetworkInterfaceName') is not None:
            self.network_interface_name = m.get('NetworkInterfaceName')
        if m.get('NetworkInterfaceTrafficMode') is not None:
            self.network_interface_traffic_mode = m.get('NetworkInterfaceTrafficMode')
        if m.get('PrimaryIpAddress') is not None:
            self.primary_ip_address = m.get('PrimaryIpAddress')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('SecurityGroupIds') is not None:
            self.security_group_ids = m.get('SecurityGroupIds')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class CreateLaunchTemplateVersionRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateLaunchTemplateVersionRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateLaunchTemplateVersionRequest(TeaModel):
    def __init__(self, system_disk=None, auto_release_time=None, data_disk=None, deployment_set_id=None,
                 description=None, enable_vm_os_config=None, host_name=None, image_id=None, image_owner_alias=None,
                 instance_charge_type=None, instance_name=None, instance_type=None, internet_charge_type=None,
                 internet_max_bandwidth_in=None, internet_max_bandwidth_out=None, io_optimized=None, ipv_6address_count=None,
                 key_pair_name=None, launch_template_id=None, launch_template_name=None, network_interface=None,
                 network_type=None, owner_account=None, owner_id=None, password_inherit=None, period=None,
                 private_ip_address=None, ram_role_name=None, region_id=None, resource_group_id=None, resource_owner_account=None,
                 resource_owner_id=None, security_enhancement_strategy=None, security_group_id=None, security_group_ids=None,
                 spot_duration=None, spot_price_limit=None, spot_strategy=None, tag=None, user_data=None, v_switch_id=None,
                 version_description=None, vpc_id=None, zone_id=None):
        self.system_disk = system_disk  # type: CreateLaunchTemplateVersionRequestSystemDisk
        self.auto_release_time = auto_release_time  # type: str
        self.data_disk = data_disk  # type: list[CreateLaunchTemplateVersionRequestDataDisk]
        self.deployment_set_id = deployment_set_id  # type: str
        self.description = description  # type: str
        self.enable_vm_os_config = enable_vm_os_config  # type: bool
        self.host_name = host_name  # type: str
        self.image_id = image_id  # type: str
        self.image_owner_alias = image_owner_alias  # type: str
        self.instance_charge_type = instance_charge_type  # type: str
        self.instance_name = instance_name  # type: str
        self.instance_type = instance_type  # type: str
        self.internet_charge_type = internet_charge_type  # type: str
        self.internet_max_bandwidth_in = internet_max_bandwidth_in  # type: int
        self.internet_max_bandwidth_out = internet_max_bandwidth_out  # type: int
        self.io_optimized = io_optimized  # type: str
        self.ipv_6address_count = ipv_6address_count  # type: int
        self.key_pair_name = key_pair_name  # type: str
        self.launch_template_id = launch_template_id  # type: str
        self.launch_template_name = launch_template_name  # type: str
        self.network_interface = network_interface  # type: list[CreateLaunchTemplateVersionRequestNetworkInterface]
        self.network_type = network_type  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.password_inherit = password_inherit  # type: bool
        self.period = period  # type: int
        self.private_ip_address = private_ip_address  # type: str
        self.ram_role_name = ram_role_name  # type: str
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.security_enhancement_strategy = security_enhancement_strategy  # type: str
        self.security_group_id = security_group_id  # type: str
        self.security_group_ids = security_group_ids  # type: list[str]
        self.spot_duration = spot_duration  # type: int
        self.spot_price_limit = spot_price_limit  # type: float
        self.spot_strategy = spot_strategy  # type: str
        self.tag = tag  # type: list[CreateLaunchTemplateVersionRequestTag]
        self.user_data = user_data  # type: str
        self.v_switch_id = v_switch_id  # type: str
        self.version_description = version_description  # type: str
        self.vpc_id = vpc_id  # type: str
        self.zone_id = zone_id  # type: str

    def validate(self):
        if self.system_disk:
            self.system_disk.validate()
        if self.data_disk:
            for k in self.data_disk:
                if k:
                    k.validate()
        if self.network_interface:
            for k in self.network_interface:
                if k:
                    k.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateLaunchTemplateVersionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.system_disk is not None:
            result['SystemDisk'] = self.system_disk.to_map()
        if self.auto_release_time is not None:
            result['AutoReleaseTime'] = self.auto_release_time
        result['DataDisk'] = []
        if self.data_disk is not None:
            for k in self.data_disk:
                result['DataDisk'].append(k.to_map() if k else None)
        if self.deployment_set_id is not None:
            result['DeploymentSetId'] = self.deployment_set_id
        if self.description is not None:
            result['Description'] = self.description
        if self.enable_vm_os_config is not None:
            result['EnableVmOsConfig'] = self.enable_vm_os_config
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_owner_alias is not None:
            result['ImageOwnerAlias'] = self.image_owner_alias
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.internet_max_bandwidth_in is not None:
            result['InternetMaxBandwidthIn'] = self.internet_max_bandwidth_in
        if self.internet_max_bandwidth_out is not None:
            result['InternetMaxBandwidthOut'] = self.internet_max_bandwidth_out
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.ipv_6address_count is not None:
            result['Ipv6AddressCount'] = self.ipv_6address_count
        if self.key_pair_name is not None:
            result['KeyPairName'] = self.key_pair_name
        if self.launch_template_id is not None:
            result['LaunchTemplateId'] = self.launch_template_id
        if self.launch_template_name is not None:
            result['LaunchTemplateName'] = self.launch_template_name
        result['NetworkInterface'] = []
        if self.network_interface is not None:
            for k in self.network_interface:
                result['NetworkInterface'].append(k.to_map() if k else None)
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.password_inherit is not None:
            result['PasswordInherit'] = self.password_inherit
        if self.period is not None:
            result['Period'] = self.period
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.ram_role_name is not None:
            result['RamRoleName'] = self.ram_role_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.security_enhancement_strategy is not None:
            result['SecurityEnhancementStrategy'] = self.security_enhancement_strategy
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.security_group_ids is not None:
            result['SecurityGroupIds'] = self.security_group_ids
        if self.spot_duration is not None:
            result['SpotDuration'] = self.spot_duration
        if self.spot_price_limit is not None:
            result['SpotPriceLimit'] = self.spot_price_limit
        if self.spot_strategy is not None:
            result['SpotStrategy'] = self.spot_strategy
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.user_data is not None:
            result['UserData'] = self.user_data
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.version_description is not None:
            result['VersionDescription'] = self.version_description
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SystemDisk') is not None:
            temp_model = CreateLaunchTemplateVersionRequestSystemDisk()
            self.system_disk = temp_model.from_map(m['SystemDisk'])
        if m.get('AutoReleaseTime') is not None:
            self.auto_release_time = m.get('AutoReleaseTime')
        self.data_disk = []
        if m.get('DataDisk') is not None:
            for k in m.get('DataDisk'):
                temp_model = CreateLaunchTemplateVersionRequestDataDisk()
                self.data_disk.append(temp_model.from_map(k))
        if m.get('DeploymentSetId') is not None:
            self.deployment_set_id = m.get('DeploymentSetId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnableVmOsConfig') is not None:
            self.enable_vm_os_config = m.get('EnableVmOsConfig')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageOwnerAlias') is not None:
            self.image_owner_alias = m.get('ImageOwnerAlias')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('InternetMaxBandwidthIn') is not None:
            self.internet_max_bandwidth_in = m.get('InternetMaxBandwidthIn')
        if m.get('InternetMaxBandwidthOut') is not None:
            self.internet_max_bandwidth_out = m.get('InternetMaxBandwidthOut')
        if m.get('IoOptimized') is not None:
            self.io_optimized = m.get('IoOptimized')
        if m.get('Ipv6AddressCount') is not None:
            self.ipv_6address_count = m.get('Ipv6AddressCount')
        if m.get('KeyPairName') is not None:
            self.key_pair_name = m.get('KeyPairName')
        if m.get('LaunchTemplateId') is not None:
            self.launch_template_id = m.get('LaunchTemplateId')
        if m.get('LaunchTemplateName') is not None:
            self.launch_template_name = m.get('LaunchTemplateName')
        self.network_interface = []
        if m.get('NetworkInterface') is not None:
            for k in m.get('NetworkInterface'):
                temp_model = CreateLaunchTemplateVersionRequestNetworkInterface()
                self.network_interface.append(temp_model.from_map(k))
        if m.get('NetworkType') is not None:
            self.network_type = m.get('NetworkType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PasswordInherit') is not None:
            self.password_inherit = m.get('PasswordInherit')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PrivateIpAddress') is not None:
            self.private_ip_address = m.get('PrivateIpAddress')
        if m.get('RamRoleName') is not None:
            self.ram_role_name = m.get('RamRoleName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SecurityEnhancementStrategy') is not None:
            self.security_enhancement_strategy = m.get('SecurityEnhancementStrategy')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('SecurityGroupIds') is not None:
            self.security_group_ids = m.get('SecurityGroupIds')
        if m.get('SpotDuration') is not None:
            self.spot_duration = m.get('SpotDuration')
        if m.get('SpotPriceLimit') is not None:
            self.spot_price_limit = m.get('SpotPriceLimit')
        if m.get('SpotStrategy') is not None:
            self.spot_strategy = m.get('SpotStrategy')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateLaunchTemplateVersionRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('UserData') is not None:
            self.user_data = m.get('UserData')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VersionDescription') is not None:
            self.version_description = m.get('VersionDescription')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class CreateLaunchTemplateVersionResponseBody(TeaModel):
    def __init__(self, launch_template_version_number=None, request_id=None):
        self.launch_template_version_number = launch_template_version_number  # type: long
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateLaunchTemplateVersionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.launch_template_version_number is not None:
            result['LaunchTemplateVersionNumber'] = self.launch_template_version_number
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LaunchTemplateVersionNumber') is not None:
            self.launch_template_version_number = m.get('LaunchTemplateVersionNumber')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateLaunchTemplateVersionResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateLaunchTemplateVersionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateLaunchTemplateVersionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateLaunchTemplateVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateNatGatewayRequestBandwidthPackage(TeaModel):
    def __init__(self, bandwidth=None, ip_count=None, zone=None):
        self.bandwidth = bandwidth  # type: int
        self.ip_count = ip_count  # type: int
        self.zone = zone  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateNatGatewayRequestBandwidthPackage, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.ip_count is not None:
            result['IpCount'] = self.ip_count
        if self.zone is not None:
            result['Zone'] = self.zone
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('IpCount') is not None:
            self.ip_count = m.get('IpCount')
        if m.get('Zone') is not None:
            self.zone = m.get('Zone')
        return self


class CreateNatGatewayRequest(TeaModel):
    def __init__(self, bandwidth_package=None, client_token=None, description=None, name=None, owner_account=None,
                 owner_id=None, region_id=None, resource_owner_account=None, resource_owner_id=None, vpc_id=None):
        self.bandwidth_package = bandwidth_package  # type: list[CreateNatGatewayRequestBandwidthPackage]
        self.client_token = client_token  # type: str
        self.description = description  # type: str
        self.name = name  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.vpc_id = vpc_id  # type: str

    def validate(self):
        if self.bandwidth_package:
            for k in self.bandwidth_package:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateNatGatewayRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BandwidthPackage'] = []
        if self.bandwidth_package is not None:
            for k in self.bandwidth_package:
                result['BandwidthPackage'].append(k.to_map() if k else None)
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.bandwidth_package = []
        if m.get('BandwidthPackage') is not None:
            for k in m.get('BandwidthPackage'):
                temp_model = CreateNatGatewayRequestBandwidthPackage()
                self.bandwidth_package.append(temp_model.from_map(k))
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class CreateNatGatewayResponseBodyBandwidthPackageIds(TeaModel):
    def __init__(self, bandwidth_package_id=None):
        self.bandwidth_package_id = bandwidth_package_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateNatGatewayResponseBodyBandwidthPackageIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth_package_id is not None:
            result['BandwidthPackageId'] = self.bandwidth_package_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BandwidthPackageId') is not None:
            self.bandwidth_package_id = m.get('BandwidthPackageId')
        return self


class CreateNatGatewayResponseBodyForwardTableIds(TeaModel):
    def __init__(self, forward_table_id=None):
        self.forward_table_id = forward_table_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateNatGatewayResponseBodyForwardTableIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.forward_table_id is not None:
            result['ForwardTableId'] = self.forward_table_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ForwardTableId') is not None:
            self.forward_table_id = m.get('ForwardTableId')
        return self


class CreateNatGatewayResponseBody(TeaModel):
    def __init__(self, bandwidth_package_ids=None, forward_table_ids=None, nat_gateway_id=None, request_id=None):
        self.bandwidth_package_ids = bandwidth_package_ids  # type: CreateNatGatewayResponseBodyBandwidthPackageIds
        self.forward_table_ids = forward_table_ids  # type: CreateNatGatewayResponseBodyForwardTableIds
        self.nat_gateway_id = nat_gateway_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.bandwidth_package_ids:
            self.bandwidth_package_ids.validate()
        if self.forward_table_ids:
            self.forward_table_ids.validate()

    def to_map(self):
        _map = super(CreateNatGatewayResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth_package_ids is not None:
            result['BandwidthPackageIds'] = self.bandwidth_package_ids.to_map()
        if self.forward_table_ids is not None:
            result['ForwardTableIds'] = self.forward_table_ids.to_map()
        if self.nat_gateway_id is not None:
            result['NatGatewayId'] = self.nat_gateway_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BandwidthPackageIds') is not None:
            temp_model = CreateNatGatewayResponseBodyBandwidthPackageIds()
            self.bandwidth_package_ids = temp_model.from_map(m['BandwidthPackageIds'])
        if m.get('ForwardTableIds') is not None:
            temp_model = CreateNatGatewayResponseBodyForwardTableIds()
            self.forward_table_ids = temp_model.from_map(m['ForwardTableIds'])
        if m.get('NatGatewayId') is not None:
            self.nat_gateway_id = m.get('NatGatewayId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateNatGatewayResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateNatGatewayResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateNatGatewayResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateNatGatewayResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateNetworkInterfaceRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateNetworkInterfaceRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateNetworkInterfaceRequest(TeaModel):
    def __init__(self, business_type=None, client_token=None, description=None, instance_type=None,
                 ipv_6address=None, ipv_6address_count=None, network_interface_name=None, network_interface_traffic_mode=None,
                 owner_account=None, owner_id=None, primary_ip_address=None, private_ip_address=None, queue_number=None,
                 queue_pair_number=None, region_id=None, resource_group_id=None, resource_owner_account=None, resource_owner_id=None,
                 secondary_private_ip_address_count=None, security_group_id=None, security_group_ids=None, tag=None, v_switch_id=None, visible=None):
        self.business_type = business_type  # type: str
        self.client_token = client_token  # type: str
        self.description = description  # type: str
        self.instance_type = instance_type  # type: str
        self.ipv_6address = ipv_6address  # type: list[str]
        self.ipv_6address_count = ipv_6address_count  # type: int
        self.network_interface_name = network_interface_name  # type: str
        self.network_interface_traffic_mode = network_interface_traffic_mode  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.primary_ip_address = primary_ip_address  # type: str
        self.private_ip_address = private_ip_address  # type: list[str]
        self.queue_number = queue_number  # type: int
        self.queue_pair_number = queue_pair_number  # type: int
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.secondary_private_ip_address_count = secondary_private_ip_address_count  # type: int
        self.security_group_id = security_group_id  # type: str
        self.security_group_ids = security_group_ids  # type: list[str]
        self.tag = tag  # type: list[CreateNetworkInterfaceRequestTag]
        self.v_switch_id = v_switch_id  # type: str
        self.visible = visible  # type: bool

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateNetworkInterfaceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.business_type is not None:
            result['BusinessType'] = self.business_type
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.ipv_6address is not None:
            result['Ipv6Address'] = self.ipv_6address
        if self.ipv_6address_count is not None:
            result['Ipv6AddressCount'] = self.ipv_6address_count
        if self.network_interface_name is not None:
            result['NetworkInterfaceName'] = self.network_interface_name
        if self.network_interface_traffic_mode is not None:
            result['NetworkInterfaceTrafficMode'] = self.network_interface_traffic_mode
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.primary_ip_address is not None:
            result['PrimaryIpAddress'] = self.primary_ip_address
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.queue_number is not None:
            result['QueueNumber'] = self.queue_number
        if self.queue_pair_number is not None:
            result['QueuePairNumber'] = self.queue_pair_number
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.secondary_private_ip_address_count is not None:
            result['SecondaryPrivateIpAddressCount'] = self.secondary_private_ip_address_count
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.security_group_ids is not None:
            result['SecurityGroupIds'] = self.security_group_ids
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.visible is not None:
            result['Visible'] = self.visible
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BusinessType') is not None:
            self.business_type = m.get('BusinessType')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('Ipv6Address') is not None:
            self.ipv_6address = m.get('Ipv6Address')
        if m.get('Ipv6AddressCount') is not None:
            self.ipv_6address_count = m.get('Ipv6AddressCount')
        if m.get('NetworkInterfaceName') is not None:
            self.network_interface_name = m.get('NetworkInterfaceName')
        if m.get('NetworkInterfaceTrafficMode') is not None:
            self.network_interface_traffic_mode = m.get('NetworkInterfaceTrafficMode')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PrimaryIpAddress') is not None:
            self.primary_ip_address = m.get('PrimaryIpAddress')
        if m.get('PrivateIpAddress') is not None:
            self.private_ip_address = m.get('PrivateIpAddress')
        if m.get('QueueNumber') is not None:
            self.queue_number = m.get('QueueNumber')
        if m.get('QueuePairNumber') is not None:
            self.queue_pair_number = m.get('QueuePairNumber')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SecondaryPrivateIpAddressCount') is not None:
            self.secondary_private_ip_address_count = m.get('SecondaryPrivateIpAddressCount')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('SecurityGroupIds') is not None:
            self.security_group_ids = m.get('SecurityGroupIds')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateNetworkInterfaceRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('Visible') is not None:
            self.visible = m.get('Visible')
        return self


class CreateNetworkInterfaceResponseBodyIpv6SetsIpv6Set(TeaModel):
    def __init__(self, ipv_6address=None):
        self.ipv_6address = ipv_6address  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateNetworkInterfaceResponseBodyIpv6SetsIpv6Set, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ipv_6address is not None:
            result['Ipv6Address'] = self.ipv_6address
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Ipv6Address') is not None:
            self.ipv_6address = m.get('Ipv6Address')
        return self


class CreateNetworkInterfaceResponseBodyIpv6Sets(TeaModel):
    def __init__(self, ipv_6set=None):
        self.ipv_6set = ipv_6set  # type: list[CreateNetworkInterfaceResponseBodyIpv6SetsIpv6Set]

    def validate(self):
        if self.ipv_6set:
            for k in self.ipv_6set:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateNetworkInterfaceResponseBodyIpv6Sets, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Ipv6Set'] = []
        if self.ipv_6set is not None:
            for k in self.ipv_6set:
                result['Ipv6Set'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.ipv_6set = []
        if m.get('Ipv6Set') is not None:
            for k in m.get('Ipv6Set'):
                temp_model = CreateNetworkInterfaceResponseBodyIpv6SetsIpv6Set()
                self.ipv_6set.append(temp_model.from_map(k))
        return self


class CreateNetworkInterfaceResponseBodyPrivateIpSetsPrivateIpSet(TeaModel):
    def __init__(self, primary=None, private_ip_address=None):
        self.primary = primary  # type: bool
        self.private_ip_address = private_ip_address  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateNetworkInterfaceResponseBodyPrivateIpSetsPrivateIpSet, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.primary is not None:
            result['Primary'] = self.primary
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Primary') is not None:
            self.primary = m.get('Primary')
        if m.get('PrivateIpAddress') is not None:
            self.private_ip_address = m.get('PrivateIpAddress')
        return self


class CreateNetworkInterfaceResponseBodyPrivateIpSets(TeaModel):
    def __init__(self, private_ip_set=None):
        self.private_ip_set = private_ip_set  # type: list[CreateNetworkInterfaceResponseBodyPrivateIpSetsPrivateIpSet]

    def validate(self):
        if self.private_ip_set:
            for k in self.private_ip_set:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateNetworkInterfaceResponseBodyPrivateIpSets, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PrivateIpSet'] = []
        if self.private_ip_set is not None:
            for k in self.private_ip_set:
                result['PrivateIpSet'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.private_ip_set = []
        if m.get('PrivateIpSet') is not None:
            for k in m.get('PrivateIpSet'):
                temp_model = CreateNetworkInterfaceResponseBodyPrivateIpSetsPrivateIpSet()
                self.private_ip_set.append(temp_model.from_map(k))
        return self


class CreateNetworkInterfaceResponseBodySecurityGroupIds(TeaModel):
    def __init__(self, security_group_id=None):
        self.security_group_id = security_group_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateNetworkInterfaceResponseBodySecurityGroupIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        return self


class CreateNetworkInterfaceResponseBodyTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key  # type: str
        self.tag_value = tag_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateNetworkInterfaceResponseBodyTagsTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class CreateNetworkInterfaceResponseBodyTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag  # type: list[CreateNetworkInterfaceResponseBodyTagsTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateNetworkInterfaceResponseBodyTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateNetworkInterfaceResponseBodyTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CreateNetworkInterfaceResponseBody(TeaModel):
    def __init__(self, description=None, ipv_6sets=None, mac_address=None, network_interface_id=None,
                 network_interface_name=None, owner_id=None, private_ip_address=None, private_ip_sets=None, request_id=None,
                 resource_group_id=None, security_group_ids=None, service_id=None, service_managed=None, status=None, tags=None,
                 type=None, v_switch_id=None, vpc_id=None, zone_id=None):
        self.description = description  # type: str
        self.ipv_6sets = ipv_6sets  # type: CreateNetworkInterfaceResponseBodyIpv6Sets
        self.mac_address = mac_address  # type: str
        self.network_interface_id = network_interface_id  # type: str
        self.network_interface_name = network_interface_name  # type: str
        self.owner_id = owner_id  # type: str
        self.private_ip_address = private_ip_address  # type: str
        self.private_ip_sets = private_ip_sets  # type: CreateNetworkInterfaceResponseBodyPrivateIpSets
        self.request_id = request_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.security_group_ids = security_group_ids  # type: CreateNetworkInterfaceResponseBodySecurityGroupIds
        self.service_id = service_id  # type: long
        self.service_managed = service_managed  # type: bool
        self.status = status  # type: str
        self.tags = tags  # type: CreateNetworkInterfaceResponseBodyTags
        self.type = type  # type: str
        self.v_switch_id = v_switch_id  # type: str
        self.vpc_id = vpc_id  # type: str
        self.zone_id = zone_id  # type: str

    def validate(self):
        if self.ipv_6sets:
            self.ipv_6sets.validate()
        if self.private_ip_sets:
            self.private_ip_sets.validate()
        if self.security_group_ids:
            self.security_group_ids.validate()
        if self.tags:
            self.tags.validate()

    def to_map(self):
        _map = super(CreateNetworkInterfaceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.ipv_6sets is not None:
            result['Ipv6Sets'] = self.ipv_6sets.to_map()
        if self.mac_address is not None:
            result['MacAddress'] = self.mac_address
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.network_interface_name is not None:
            result['NetworkInterfaceName'] = self.network_interface_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.private_ip_address is not None:
            result['PrivateIpAddress'] = self.private_ip_address
        if self.private_ip_sets is not None:
            result['PrivateIpSets'] = self.private_ip_sets.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.security_group_ids is not None:
            result['SecurityGroupIds'] = self.security_group_ids.to_map()
        if self.service_id is not None:
            result['ServiceID'] = self.service_id
        if self.service_managed is not None:
            result['ServiceManaged'] = self.service_managed
        if self.status is not None:
            result['Status'] = self.status
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.type is not None:
            result['Type'] = self.type
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Ipv6Sets') is not None:
            temp_model = CreateNetworkInterfaceResponseBodyIpv6Sets()
            self.ipv_6sets = temp_model.from_map(m['Ipv6Sets'])
        if m.get('MacAddress') is not None:
            self.mac_address = m.get('MacAddress')
        if m.get('NetworkInterfaceId') is not None:
            self.network_interface_id = m.get('NetworkInterfaceId')
        if m.get('NetworkInterfaceName') is not None:
            self.network_interface_name = m.get('NetworkInterfaceName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PrivateIpAddress') is not None:
            self.private_ip_address = m.get('PrivateIpAddress')
        if m.get('PrivateIpSets') is not None:
            temp_model = CreateNetworkInterfaceResponseBodyPrivateIpSets()
            self.private_ip_sets = temp_model.from_map(m['PrivateIpSets'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SecurityGroupIds') is not None:
            temp_model = CreateNetworkInterfaceResponseBodySecurityGroupIds()
            self.security_group_ids = temp_model.from_map(m['SecurityGroupIds'])
        if m.get('ServiceID') is not None:
            self.service_id = m.get('ServiceID')
        if m.get('ServiceManaged') is not None:
            self.service_managed = m.get('ServiceManaged')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tags') is not None:
            temp_model = CreateNetworkInterfaceResponseBodyTags()
            self.tags = temp_model.from_map(m['Tags'])
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class CreateNetworkInterfaceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateNetworkInterfaceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateNetworkInterfaceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateNetworkInterfaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateNetworkInterfacePermissionRequest(TeaModel):
    def __init__(self, account_id=None, network_interface_id=None, owner_account=None, owner_id=None,
                 permission=None, region_id=None, resource_owner_account=None, resource_owner_id=None):
        self.account_id = account_id  # type: long
        self.network_interface_id = network_interface_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.permission = permission  # type: str
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateNetworkInterfacePermissionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.permission is not None:
            result['Permission'] = self.permission
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('NetworkInterfaceId') is not None:
            self.network_interface_id = m.get('NetworkInterfaceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Permission') is not None:
            self.permission = m.get('Permission')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CreateNetworkInterfacePermissionResponseBodyNetworkInterfacePermission(TeaModel):
    def __init__(self, account_id=None, network_interface_id=None, network_interface_permission_id=None,
                 permission=None, permission_state=None, service_name=None):
        self.account_id = account_id  # type: long
        self.network_interface_id = network_interface_id  # type: str
        self.network_interface_permission_id = network_interface_permission_id  # type: str
        self.permission = permission  # type: str
        self.permission_state = permission_state  # type: str
        self.service_name = service_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateNetworkInterfacePermissionResponseBodyNetworkInterfacePermission, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.network_interface_permission_id is not None:
            result['NetworkInterfacePermissionId'] = self.network_interface_permission_id
        if self.permission is not None:
            result['Permission'] = self.permission
        if self.permission_state is not None:
            result['PermissionState'] = self.permission_state
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('NetworkInterfaceId') is not None:
            self.network_interface_id = m.get('NetworkInterfaceId')
        if m.get('NetworkInterfacePermissionId') is not None:
            self.network_interface_permission_id = m.get('NetworkInterfacePermissionId')
        if m.get('Permission') is not None:
            self.permission = m.get('Permission')
        if m.get('PermissionState') is not None:
            self.permission_state = m.get('PermissionState')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        return self


class CreateNetworkInterfacePermissionResponseBody(TeaModel):
    def __init__(self, network_interface_permission=None, request_id=None):
        self.network_interface_permission = network_interface_permission  # type: CreateNetworkInterfacePermissionResponseBodyNetworkInterfacePermission
        self.request_id = request_id  # type: str

    def validate(self):
        if self.network_interface_permission:
            self.network_interface_permission.validate()

    def to_map(self):
        _map = super(CreateNetworkInterfacePermissionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.network_interface_permission is not None:
            result['NetworkInterfacePermission'] = self.network_interface_permission.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NetworkInterfacePermission') is not None:
            temp_model = CreateNetworkInterfacePermissionResponseBodyNetworkInterfacePermission()
            self.network_interface_permission = temp_model.from_map(m['NetworkInterfacePermission'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateNetworkInterfacePermissionResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateNetworkInterfacePermissionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateNetworkInterfacePermissionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateNetworkInterfacePermissionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreatePhysicalConnectionRequest(TeaModel):
    def __init__(self, access_point_id=None, circuit_code=None, client_token=None, description=None,
                 line_operator=None, name=None, owner_account=None, owner_id=None, peer_location=None, port_type=None,
                 redundant_physical_connection_id=None, region_id=None, resource_owner_account=None, resource_owner_id=None, type=None,
                 user_cidr=None, bandwidth=None):
        self.access_point_id = access_point_id  # type: str
        self.circuit_code = circuit_code  # type: str
        self.client_token = client_token  # type: str
        self.description = description  # type: str
        self.line_operator = line_operator  # type: str
        self.name = name  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.peer_location = peer_location  # type: str
        self.port_type = port_type  # type: str
        self.redundant_physical_connection_id = redundant_physical_connection_id  # type: str
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.type = type  # type: str
        self.user_cidr = user_cidr  # type: str
        self.bandwidth = bandwidth  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreatePhysicalConnectionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_point_id is not None:
            result['AccessPointId'] = self.access_point_id
        if self.circuit_code is not None:
            result['CircuitCode'] = self.circuit_code
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.line_operator is not None:
            result['LineOperator'] = self.line_operator
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.peer_location is not None:
            result['PeerLocation'] = self.peer_location
        if self.port_type is not None:
            result['PortType'] = self.port_type
        if self.redundant_physical_connection_id is not None:
            result['RedundantPhysicalConnectionId'] = self.redundant_physical_connection_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.type is not None:
            result['Type'] = self.type
        if self.user_cidr is not None:
            result['UserCidr'] = self.user_cidr
        if self.bandwidth is not None:
            result['bandwidth'] = self.bandwidth
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccessPointId') is not None:
            self.access_point_id = m.get('AccessPointId')
        if m.get('CircuitCode') is not None:
            self.circuit_code = m.get('CircuitCode')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('LineOperator') is not None:
            self.line_operator = m.get('LineOperator')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PeerLocation') is not None:
            self.peer_location = m.get('PeerLocation')
        if m.get('PortType') is not None:
            self.port_type = m.get('PortType')
        if m.get('RedundantPhysicalConnectionId') is not None:
            self.redundant_physical_connection_id = m.get('RedundantPhysicalConnectionId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UserCidr') is not None:
            self.user_cidr = m.get('UserCidr')
        if m.get('bandwidth') is not None:
            self.bandwidth = m.get('bandwidth')
        return self


class CreatePhysicalConnectionResponseBody(TeaModel):
    def __init__(self, physical_connection_id=None, request_id=None):
        self.physical_connection_id = physical_connection_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreatePhysicalConnectionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.physical_connection_id is not None:
            result['PhysicalConnectionId'] = self.physical_connection_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PhysicalConnectionId') is not None:
            self.physical_connection_id = m.get('PhysicalConnectionId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreatePhysicalConnectionResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreatePhysicalConnectionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreatePhysicalConnectionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreatePhysicalConnectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreatePrefixListRequestEntry(TeaModel):
    def __init__(self, cidr=None, description=None):
        self.cidr = cidr  # type: str
        self.description = description  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreatePrefixListRequestEntry, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cidr is not None:
            result['Cidr'] = self.cidr
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Cidr') is not None:
            self.cidr = m.get('Cidr')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class CreatePrefixListRequest(TeaModel):
    def __init__(self, address_family=None, client_token=None, description=None, entry=None, max_entries=None,
                 owner_account=None, owner_id=None, prefix_list_name=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        self.address_family = address_family  # type: str
        self.client_token = client_token  # type: str
        self.description = description  # type: str
        self.entry = entry  # type: list[CreatePrefixListRequestEntry]
        self.max_entries = max_entries  # type: int
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.prefix_list_name = prefix_list_name  # type: str
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        if self.entry:
            for k in self.entry:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreatePrefixListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address_family is not None:
            result['AddressFamily'] = self.address_family
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        result['Entry'] = []
        if self.entry is not None:
            for k in self.entry:
                result['Entry'].append(k.to_map() if k else None)
        if self.max_entries is not None:
            result['MaxEntries'] = self.max_entries
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.prefix_list_name is not None:
            result['PrefixListName'] = self.prefix_list_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AddressFamily') is not None:
            self.address_family = m.get('AddressFamily')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        self.entry = []
        if m.get('Entry') is not None:
            for k in m.get('Entry'):
                temp_model = CreatePrefixListRequestEntry()
                self.entry.append(temp_model.from_map(k))
        if m.get('MaxEntries') is not None:
            self.max_entries = m.get('MaxEntries')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PrefixListName') is not None:
            self.prefix_list_name = m.get('PrefixListName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CreatePrefixListResponseBody(TeaModel):
    def __init__(self, prefix_list_id=None, request_id=None):
        self.prefix_list_id = prefix_list_id  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreatePrefixListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.prefix_list_id is not None:
            result['PrefixListId'] = self.prefix_list_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PrefixListId') is not None:
            self.prefix_list_id = m.get('PrefixListId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreatePrefixListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreatePrefixListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreatePrefixListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreatePrefixListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRouteEntryRequestNextHopList(TeaModel):
    def __init__(self, next_hop_id=None, next_hop_type=None):
        self.next_hop_id = next_hop_id  # type: str
        self.next_hop_type = next_hop_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateRouteEntryRequestNextHopList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_hop_id is not None:
            result['NextHopId'] = self.next_hop_id
        if self.next_hop_type is not None:
            result['NextHopType'] = self.next_hop_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NextHopId') is not None:
            self.next_hop_id = m.get('NextHopId')
        if m.get('NextHopType') is not None:
            self.next_hop_type = m.get('NextHopType')
        return self


class CreateRouteEntryRequest(TeaModel):
    def __init__(self, client_token=None, destination_cidr_block=None, next_hop_id=None, next_hop_list=None,
                 next_hop_type=None, owner_account=None, owner_id=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None, route_table_id=None):
        self.client_token = client_token  # type: str
        self.destination_cidr_block = destination_cidr_block  # type: str
        self.next_hop_id = next_hop_id  # type: str
        self.next_hop_list = next_hop_list  # type: list[CreateRouteEntryRequestNextHopList]
        self.next_hop_type = next_hop_type  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.route_table_id = route_table_id  # type: str

    def validate(self):
        if self.next_hop_list:
            for k in self.next_hop_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateRouteEntryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.destination_cidr_block is not None:
            result['DestinationCidrBlock'] = self.destination_cidr_block
        if self.next_hop_id is not None:
            result['NextHopId'] = self.next_hop_id
        result['NextHopList'] = []
        if self.next_hop_list is not None:
            for k in self.next_hop_list:
                result['NextHopList'].append(k.to_map() if k else None)
        if self.next_hop_type is not None:
            result['NextHopType'] = self.next_hop_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.route_table_id is not None:
            result['RouteTableId'] = self.route_table_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DestinationCidrBlock') is not None:
            self.destination_cidr_block = m.get('DestinationCidrBlock')
        if m.get('NextHopId') is not None:
            self.next_hop_id = m.get('NextHopId')
        self.next_hop_list = []
        if m.get('NextHopList') is not None:
            for k in m.get('NextHopList'):
                temp_model = CreateRouteEntryRequestNextHopList()
                self.next_hop_list.append(temp_model.from_map(k))
        if m.get('NextHopType') is not None:
            self.next_hop_type = m.get('NextHopType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RouteTableId') is not None:
            self.route_table_id = m.get('RouteTableId')
        return self


class CreateRouteEntryResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateRouteEntryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateRouteEntryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateRouteEntryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateRouteEntryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateRouteEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRouterInterfaceRequest(TeaModel):
    def __init__(self, access_point_id=None, auto_pay=None, client_token=None, description=None,
                 health_check_source_ip=None, health_check_target_ip=None, instance_charge_type=None, name=None,
                 opposite_access_point_id=None, opposite_interface_id=None, opposite_interface_owner_id=None, opposite_region_id=None,
                 opposite_router_id=None, opposite_router_type=None, owner_account=None, owner_id=None, period=None,
                 pricing_cycle=None, region_id=None, resource_owner_account=None, resource_owner_id=None, role=None,
                 router_id=None, router_type=None, spec=None, user_cidr=None):
        self.access_point_id = access_point_id  # type: str
        self.auto_pay = auto_pay  # type: bool
        self.client_token = client_token  # type: str
        self.description = description  # type: str
        self.health_check_source_ip = health_check_source_ip  # type: str
        self.health_check_target_ip = health_check_target_ip  # type: str
        self.instance_charge_type = instance_charge_type  # type: str
        self.name = name  # type: str
        self.opposite_access_point_id = opposite_access_point_id  # type: str
        self.opposite_interface_id = opposite_interface_id  # type: str
        self.opposite_interface_owner_id = opposite_interface_owner_id  # type: str
        self.opposite_region_id = opposite_region_id  # type: str
        self.opposite_router_id = opposite_router_id  # type: str
        self.opposite_router_type = opposite_router_type  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.period = period  # type: int
        self.pricing_cycle = pricing_cycle  # type: str
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.role = role  # type: str
        self.router_id = router_id  # type: str
        self.router_type = router_type  # type: str
        self.spec = spec  # type: str
        self.user_cidr = user_cidr  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateRouterInterfaceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_point_id is not None:
            result['AccessPointId'] = self.access_point_id
        if self.auto_pay is not None:
            result['AutoPay'] = self.auto_pay
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.health_check_source_ip is not None:
            result['HealthCheckSourceIp'] = self.health_check_source_ip
        if self.health_check_target_ip is not None:
            result['HealthCheckTargetIp'] = self.health_check_target_ip
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.name is not None:
            result['Name'] = self.name
        if self.opposite_access_point_id is not None:
            result['OppositeAccessPointId'] = self.opposite_access_point_id
        if self.opposite_interface_id is not None:
            result['OppositeInterfaceId'] = self.opposite_interface_id
        if self.opposite_interface_owner_id is not None:
            result['OppositeInterfaceOwnerId'] = self.opposite_interface_owner_id
        if self.opposite_region_id is not None:
            result['OppositeRegionId'] = self.opposite_region_id
        if self.opposite_router_id is not None:
            result['OppositeRouterId'] = self.opposite_router_id
        if self.opposite_router_type is not None:
            result['OppositeRouterType'] = self.opposite_router_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.period is not None:
            result['Period'] = self.period
        if self.pricing_cycle is not None:
            result['PricingCycle'] = self.pricing_cycle
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.role is not None:
            result['Role'] = self.role
        if self.router_id is not None:
            result['RouterId'] = self.router_id
        if self.router_type is not None:
            result['RouterType'] = self.router_type
        if self.spec is not None:
            result['Spec'] = self.spec
        if self.user_cidr is not None:
            result['UserCidr'] = self.user_cidr
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccessPointId') is not None:
            self.access_point_id = m.get('AccessPointId')
        if m.get('AutoPay') is not None:
            self.auto_pay = m.get('AutoPay')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('HealthCheckSourceIp') is not None:
            self.health_check_source_ip = m.get('HealthCheckSourceIp')
        if m.get('HealthCheckTargetIp') is not None:
            self.health_check_target_ip = m.get('HealthCheckTargetIp')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OppositeAccessPointId') is not None:
            self.opposite_access_point_id = m.get('OppositeAccessPointId')
        if m.get('OppositeInterfaceId') is not None:
            self.opposite_interface_id = m.get('OppositeInterfaceId')
        if m.get('OppositeInterfaceOwnerId') is not None:
            self.opposite_interface_owner_id = m.get('OppositeInterfaceOwnerId')
        if m.get('OppositeRegionId') is not None:
            self.opposite_region_id = m.get('OppositeRegionId')
        if m.get('OppositeRouterId') is not None:
            self.opposite_router_id = m.get('OppositeRouterId')
        if m.get('OppositeRouterType') is not None:
            self.opposite_router_type = m.get('OppositeRouterType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PricingCycle') is not None:
            self.pricing_cycle = m.get('PricingCycle')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('RouterId') is not None:
            self.router_id = m.get('RouterId')
        if m.get('RouterType') is not None:
            self.router_type = m.get('RouterType')
        if m.get('Spec') is not None:
            self.spec = m.get('Spec')
        if m.get('UserCidr') is not None:
            self.user_cidr = m.get('UserCidr')
        return self


class CreateRouterInterfaceResponseBody(TeaModel):
    def __init__(self, order_id=None, request_id=None, router_interface_id=None):
        self.order_id = order_id  # type: long
        self.request_id = request_id  # type: str
        self.router_interface_id = router_interface_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateRouterInterfaceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order_id is not None:
            result['OrderId'] = self.order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.router_interface_id is not None:
            result['RouterInterfaceId'] = self.router_interface_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OrderId') is not None:
            self.order_id = m.get('OrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RouterInterfaceId') is not None:
            self.router_interface_id = m.get('RouterInterfaceId')
        return self


class CreateRouterInterfaceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateRouterInterfaceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateRouterInterfaceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateRouterInterfaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSecurityGroupRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSecurityGroupRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateSecurityGroupRequest(TeaModel):
    def __init__(self, client_token=None, description=None, owner_account=None, owner_id=None, region_id=None,
                 resource_group_id=None, resource_owner_account=None, resource_owner_id=None, security_group_name=None,
                 security_group_type=None, service_managed=None, tag=None, vpc_id=None):
        self.client_token = client_token  # type: str
        self.description = description  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.security_group_name = security_group_name  # type: str
        self.security_group_type = security_group_type  # type: str
        self.service_managed = service_managed  # type: bool
        self.tag = tag  # type: list[CreateSecurityGroupRequestTag]
        self.vpc_id = vpc_id  # type: str

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateSecurityGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.security_group_name is not None:
            result['SecurityGroupName'] = self.security_group_name
        if self.security_group_type is not None:
            result['SecurityGroupType'] = self.security_group_type
        if self.service_managed is not None:
            result['ServiceManaged'] = self.service_managed
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SecurityGroupName') is not None:
            self.security_group_name = m.get('SecurityGroupName')
        if m.get('SecurityGroupType') is not None:
            self.security_group_type = m.get('SecurityGroupType')
        if m.get('ServiceManaged') is not None:
            self.service_managed = m.get('ServiceManaged')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateSecurityGroupRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class CreateSecurityGroupResponseBody(TeaModel):
    def __init__(self, request_id=None, security_group_id=None):
        self.request_id = request_id  # type: str
        self.security_group_id = security_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSecurityGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        return self


class CreateSecurityGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateSecurityGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateSecurityGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSecurityGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSimulatedSystemEventsRequest(TeaModel):
    def __init__(self, event_type=None, instance_id=None, not_before=None, owner_account=None, owner_id=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None):
        self.event_type = event_type  # type: str
        self.instance_id = instance_id  # type: list[str]
        self.not_before = not_before  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSimulatedSystemEventsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.not_before is not None:
            result['NotBefore'] = self.not_before
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('NotBefore') is not None:
            self.not_before = m.get('NotBefore')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CreateSimulatedSystemEventsResponseBodyEventIdSet(TeaModel):
    def __init__(self, event_id=None):
        self.event_id = event_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSimulatedSystemEventsResponseBodyEventIdSet, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_id is not None:
            result['EventId'] = self.event_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        return self


class CreateSimulatedSystemEventsResponseBody(TeaModel):
    def __init__(self, event_id_set=None, request_id=None):
        self.event_id_set = event_id_set  # type: CreateSimulatedSystemEventsResponseBodyEventIdSet
        self.request_id = request_id  # type: str

    def validate(self):
        if self.event_id_set:
            self.event_id_set.validate()

    def to_map(self):
        _map = super(CreateSimulatedSystemEventsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_id_set is not None:
            result['EventIdSet'] = self.event_id_set.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EventIdSet') is not None:
            temp_model = CreateSimulatedSystemEventsResponseBodyEventIdSet()
            self.event_id_set = temp_model.from_map(m['EventIdSet'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateSimulatedSystemEventsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateSimulatedSystemEventsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateSimulatedSystemEventsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSimulatedSystemEventsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSnapshotRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSnapshotRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateSnapshotRequest(TeaModel):
    def __init__(self, category=None, client_token=None, description=None, disk_id=None, instant_access=None,
                 instant_access_retention_days=None, owner_account=None, owner_id=None, resource_group_id=None, resource_owner_account=None,
                 resource_owner_id=None, retention_days=None, snapshot_name=None, tag=None):
        self.category = category  # type: str
        self.client_token = client_token  # type: str
        self.description = description  # type: str
        self.disk_id = disk_id  # type: str
        self.instant_access = instant_access  # type: bool
        self.instant_access_retention_days = instant_access_retention_days  # type: int
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.retention_days = retention_days  # type: int
        self.snapshot_name = snapshot_name  # type: str
        self.tag = tag  # type: list[CreateSnapshotRequestTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateSnapshotRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id
        if self.instant_access is not None:
            result['InstantAccess'] = self.instant_access
        if self.instant_access_retention_days is not None:
            result['InstantAccessRetentionDays'] = self.instant_access_retention_days
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.retention_days is not None:
            result['RetentionDays'] = self.retention_days
        if self.snapshot_name is not None:
            result['SnapshotName'] = self.snapshot_name
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DiskId') is not None:
            self.disk_id = m.get('DiskId')
        if m.get('InstantAccess') is not None:
            self.instant_access = m.get('InstantAccess')
        if m.get('InstantAccessRetentionDays') is not None:
            self.instant_access_retention_days = m.get('InstantAccessRetentionDays')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RetentionDays') is not None:
            self.retention_days = m.get('RetentionDays')
        if m.get('SnapshotName') is not None:
            self.snapshot_name = m.get('SnapshotName')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateSnapshotRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CreateSnapshotResponseBody(TeaModel):
    def __init__(self, request_id=None, snapshot_id=None):
        self.request_id = request_id  # type: str
        self.snapshot_id = snapshot_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSnapshotResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        return self


class CreateSnapshotResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateSnapshotResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateSnapshotResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSnapshotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSnapshotGroupRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSnapshotGroupRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateSnapshotGroupRequest(TeaModel):
    def __init__(self, description=None, disk_id=None, exclude_disk_id=None, instance_id=None, instant_access=None,
                 instant_access_retention_days=None, name=None, owner_account=None, owner_id=None, region_id=None, resource_group_id=None,
                 resource_owner_account=None, resource_owner_id=None, tag=None):
        self.description = description  # type: str
        self.disk_id = disk_id  # type: list[str]
        self.exclude_disk_id = exclude_disk_id  # type: list[str]
        self.instance_id = instance_id  # type: str
        self.instant_access = instant_access  # type: bool
        self.instant_access_retention_days = instant_access_retention_days  # type: int
        self.name = name  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.tag = tag  # type: list[CreateSnapshotGroupRequestTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateSnapshotGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id
        if self.exclude_disk_id is not None:
            result['ExcludeDiskId'] = self.exclude_disk_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instant_access is not None:
            result['InstantAccess'] = self.instant_access
        if self.instant_access_retention_days is not None:
            result['InstantAccessRetentionDays'] = self.instant_access_retention_days
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DiskId') is not None:
            self.disk_id = m.get('DiskId')
        if m.get('ExcludeDiskId') is not None:
            self.exclude_disk_id = m.get('ExcludeDiskId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstantAccess') is not None:
            self.instant_access = m.get('InstantAccess')
        if m.get('InstantAccessRetentionDays') is not None:
            self.instant_access_retention_days = m.get('InstantAccessRetentionDays')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateSnapshotGroupRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CreateSnapshotGroupResponseBody(TeaModel):
    def __init__(self, request_id=None, snapshot_group_id=None):
        self.request_id = request_id  # type: str
        self.snapshot_group_id = snapshot_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSnapshotGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.snapshot_group_id is not None:
            result['SnapshotGroupId'] = self.snapshot_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SnapshotGroupId') is not None:
            self.snapshot_group_id = m.get('SnapshotGroupId')
        return self


class CreateSnapshotGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateSnapshotGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateSnapshotGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSnapshotGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateStorageSetRequest(TeaModel):
    def __init__(self, client_token=None, description=None, max_partition_number=None, owner_account=None,
                 owner_id=None, region_id=None, resource_owner_account=None, resource_owner_id=None, storage_set_name=None,
                 zone_id=None):
        self.client_token = client_token  # type: str
        self.description = description  # type: str
        self.max_partition_number = max_partition_number  # type: int
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.storage_set_name = storage_set_name  # type: str
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateStorageSetRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.max_partition_number is not None:
            result['MaxPartitionNumber'] = self.max_partition_number
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.storage_set_name is not None:
            result['StorageSetName'] = self.storage_set_name
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('MaxPartitionNumber') is not None:
            self.max_partition_number = m.get('MaxPartitionNumber')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('StorageSetName') is not None:
            self.storage_set_name = m.get('StorageSetName')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class CreateStorageSetResponseBody(TeaModel):
    def __init__(self, request_id=None, storage_set_id=None):
        self.request_id = request_id  # type: str
        self.storage_set_id = storage_set_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateStorageSetResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.storage_set_id is not None:
            result['StorageSetId'] = self.storage_set_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StorageSetId') is not None:
            self.storage_set_id = m.get('StorageSetId')
        return self


class CreateStorageSetResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateStorageSetResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateStorageSetResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateStorageSetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateVSwitchRequest(TeaModel):
    def __init__(self, cidr_block=None, client_token=None, description=None, owner_account=None, owner_id=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None, v_switch_name=None, vpc_id=None,
                 zone_id=None):
        self.cidr_block = cidr_block  # type: str
        self.client_token = client_token  # type: str
        self.description = description  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.v_switch_name = v_switch_name  # type: str
        self.vpc_id = vpc_id  # type: str
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateVSwitchRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.v_switch_name is not None:
            result['VSwitchName'] = self.v_switch_name
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('VSwitchName') is not None:
            self.v_switch_name = m.get('VSwitchName')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class CreateVSwitchResponseBody(TeaModel):
    def __init__(self, request_id=None, v_switch_id=None):
        self.request_id = request_id  # type: str
        self.v_switch_id = v_switch_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateVSwitchResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class CreateVSwitchResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateVSwitchResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateVSwitchResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateVSwitchResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateVirtualBorderRouterRequest(TeaModel):
    def __init__(self, circuit_code=None, client_token=None, description=None, local_gateway_ip=None, name=None,
                 owner_account=None, owner_id=None, peer_gateway_ip=None, peering_subnet_mask=None, physical_connection_id=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None, user_cidr=None, vbr_owner_id=None,
                 vlan_id=None):
        self.circuit_code = circuit_code  # type: str
        self.client_token = client_token  # type: str
        self.description = description  # type: str
        self.local_gateway_ip = local_gateway_ip  # type: str
        self.name = name  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.peer_gateway_ip = peer_gateway_ip  # type: str
        self.peering_subnet_mask = peering_subnet_mask  # type: str
        self.physical_connection_id = physical_connection_id  # type: str
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.user_cidr = user_cidr  # type: str
        self.vbr_owner_id = vbr_owner_id  # type: long
        self.vlan_id = vlan_id  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateVirtualBorderRouterRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.circuit_code is not None:
            result['CircuitCode'] = self.circuit_code
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.local_gateway_ip is not None:
            result['LocalGatewayIp'] = self.local_gateway_ip
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.peer_gateway_ip is not None:
            result['PeerGatewayIp'] = self.peer_gateway_ip
        if self.peering_subnet_mask is not None:
            result['PeeringSubnetMask'] = self.peering_subnet_mask
        if self.physical_connection_id is not None:
            result['PhysicalConnectionId'] = self.physical_connection_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.user_cidr is not None:
            result['UserCidr'] = self.user_cidr
        if self.vbr_owner_id is not None:
            result['VbrOwnerId'] = self.vbr_owner_id
        if self.vlan_id is not None:
            result['VlanId'] = self.vlan_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CircuitCode') is not None:
            self.circuit_code = m.get('CircuitCode')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('LocalGatewayIp') is not None:
            self.local_gateway_ip = m.get('LocalGatewayIp')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PeerGatewayIp') is not None:
            self.peer_gateway_ip = m.get('PeerGatewayIp')
        if m.get('PeeringSubnetMask') is not None:
            self.peering_subnet_mask = m.get('PeeringSubnetMask')
        if m.get('PhysicalConnectionId') is not None:
            self.physical_connection_id = m.get('PhysicalConnectionId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('UserCidr') is not None:
            self.user_cidr = m.get('UserCidr')
        if m.get('VbrOwnerId') is not None:
            self.vbr_owner_id = m.get('VbrOwnerId')
        if m.get('VlanId') is not None:
            self.vlan_id = m.get('VlanId')
        return self


class CreateVirtualBorderRouterResponseBody(TeaModel):
    def __init__(self, request_id=None, vbr_id=None):
        self.request_id = request_id  # type: str
        self.vbr_id = vbr_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateVirtualBorderRouterResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.vbr_id is not None:
            result['VbrId'] = self.vbr_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('VbrId') is not None:
            self.vbr_id = m.get('VbrId')
        return self


class CreateVirtualBorderRouterResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateVirtualBorderRouterResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateVirtualBorderRouterResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateVirtualBorderRouterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateVpcRequest(TeaModel):
    def __init__(self, cidr_block=None, client_token=None, description=None, owner_account=None, owner_id=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None, user_cidr=None, vpc_name=None):
        self.cidr_block = cidr_block  # type: str
        self.client_token = client_token  # type: str
        self.description = description  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.user_cidr = user_cidr  # type: str
        self.vpc_name = vpc_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateVpcRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.user_cidr is not None:
            result['UserCidr'] = self.user_cidr
        if self.vpc_name is not None:
            result['VpcName'] = self.vpc_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('UserCidr') is not None:
            self.user_cidr = m.get('UserCidr')
        if m.get('VpcName') is not None:
            self.vpc_name = m.get('VpcName')
        return self


class CreateVpcResponseBody(TeaModel):
    def __init__(self, request_id=None, route_table_id=None, vrouter_id=None, vpc_id=None):
        self.request_id = request_id  # type: str
        self.route_table_id = route_table_id  # type: str
        self.vrouter_id = vrouter_id  # type: str
        self.vpc_id = vpc_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateVpcResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.route_table_id is not None:
            result['RouteTableId'] = self.route_table_id
        if self.vrouter_id is not None:
            result['VRouterId'] = self.vrouter_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RouteTableId') is not None:
            self.route_table_id = m.get('RouteTableId')
        if m.get('VRouterId') is not None:
            self.vrouter_id = m.get('VRouterId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class CreateVpcResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateVpcResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateVpcResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateVpcResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeactivateRouterInterfaceRequest(TeaModel):
    def __init__(self, owner_id=None, region_id=None, resource_owner_account=None, resource_owner_id=None,
                 router_interface_id=None):
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.router_interface_id = router_interface_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeactivateRouterInterfaceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.router_interface_id is not None:
            result['RouterInterfaceId'] = self.router_interface_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RouterInterfaceId') is not None:
            self.router_interface_id = m.get('RouterInterfaceId')
        return self


class DeactivateRouterInterfaceResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeactivateRouterInterfaceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeactivateRouterInterfaceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeactivateRouterInterfaceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeactivateRouterInterfaceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeactivateRouterInterfaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteActivationRequest(TeaModel):
    def __init__(self, activation_id=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.activation_id = activation_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteActivationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.activation_id is not None:
            result['ActivationId'] = self.activation_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActivationId') is not None:
            self.activation_id = m.get('ActivationId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteActivationResponseBodyActivation(TeaModel):
    def __init__(self, activation_id=None, creation_time=None, deregistered_count=None, description=None,
                 instance_count=None, instance_name=None, ip_address_range=None, registered_count=None,
                 time_to_live_in_hours=None):
        self.activation_id = activation_id  # type: str
        self.creation_time = creation_time  # type: str
        self.deregistered_count = deregistered_count  # type: int
        self.description = description  # type: str
        self.instance_count = instance_count  # type: int
        self.instance_name = instance_name  # type: str
        self.ip_address_range = ip_address_range  # type: str
        self.registered_count = registered_count  # type: int
        self.time_to_live_in_hours = time_to_live_in_hours  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteActivationResponseBodyActivation, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.activation_id is not None:
            result['ActivationId'] = self.activation_id
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.deregistered_count is not None:
            result['DeregisteredCount'] = self.deregistered_count
        if self.description is not None:
            result['Description'] = self.description
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.ip_address_range is not None:
            result['IpAddressRange'] = self.ip_address_range
        if self.registered_count is not None:
            result['RegisteredCount'] = self.registered_count
        if self.time_to_live_in_hours is not None:
            result['TimeToLiveInHours'] = self.time_to_live_in_hours
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActivationId') is not None:
            self.activation_id = m.get('ActivationId')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('DeregisteredCount') is not None:
            self.deregistered_count = m.get('DeregisteredCount')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('IpAddressRange') is not None:
            self.ip_address_range = m.get('IpAddressRange')
        if m.get('RegisteredCount') is not None:
            self.registered_count = m.get('RegisteredCount')
        if m.get('TimeToLiveInHours') is not None:
            self.time_to_live_in_hours = m.get('TimeToLiveInHours')
        return self


class DeleteActivationResponseBody(TeaModel):
    def __init__(self, activation=None, request_id=None):
        self.activation = activation  # type: DeleteActivationResponseBodyActivation
        self.request_id = request_id  # type: str

    def validate(self):
        if self.activation:
            self.activation.validate()

    def to_map(self):
        _map = super(DeleteActivationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.activation is not None:
            result['Activation'] = self.activation.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Activation') is not None:
            temp_model = DeleteActivationResponseBodyActivation()
            self.activation = temp_model.from_map(m['Activation'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteActivationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteActivationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteActivationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteActivationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAutoProvisioningGroupRequest(TeaModel):
    def __init__(self, auto_provisioning_group_id=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None, terminate_instances=None):
        self.auto_provisioning_group_id = auto_provisioning_group_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.terminate_instances = terminate_instances  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAutoProvisioningGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_provisioning_group_id is not None:
            result['AutoProvisioningGroupId'] = self.auto_provisioning_group_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.terminate_instances is not None:
            result['TerminateInstances'] = self.terminate_instances
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoProvisioningGroupId') is not None:
            self.auto_provisioning_group_id = m.get('AutoProvisioningGroupId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TerminateInstances') is not None:
            self.terminate_instances = m.get('TerminateInstances')
        return self


class DeleteAutoProvisioningGroupResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAutoProvisioningGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAutoProvisioningGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteAutoProvisioningGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteAutoProvisioningGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAutoProvisioningGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAutoSnapshotPolicyRequest(TeaModel):
    def __init__(self, owner_id=None, resource_owner_account=None, resource_owner_id=None,
                 auto_snapshot_policy_id=None, region_id=None):
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.auto_snapshot_policy_id = auto_snapshot_policy_id  # type: str
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAutoSnapshotPolicyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.auto_snapshot_policy_id is not None:
            result['autoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        if self.region_id is not None:
            result['regionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('autoSnapshotPolicyId') is not None:
            self.auto_snapshot_policy_id = m.get('autoSnapshotPolicyId')
        if m.get('regionId') is not None:
            self.region_id = m.get('regionId')
        return self


class DeleteAutoSnapshotPolicyResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAutoSnapshotPolicyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAutoSnapshotPolicyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteAutoSnapshotPolicyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteAutoSnapshotPolicyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAutoSnapshotPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteBandwidthPackageRequest(TeaModel):
    def __init__(self, bandwidth_package_id=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.bandwidth_package_id = bandwidth_package_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteBandwidthPackageRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth_package_id is not None:
            result['BandwidthPackageId'] = self.bandwidth_package_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BandwidthPackageId') is not None:
            self.bandwidth_package_id = m.get('BandwidthPackageId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteBandwidthPackageResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteBandwidthPackageResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteBandwidthPackageResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteBandwidthPackageResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteBandwidthPackageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteBandwidthPackageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCommandRequest(TeaModel):
    def __init__(self, command_id=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.command_id = command_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCommandRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.command_id is not None:
            result['CommandId'] = self.command_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CommandId') is not None:
            self.command_id = m.get('CommandId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteCommandResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCommandResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCommandResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteCommandResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteCommandResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCommandResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDedicatedHostClusterRequest(TeaModel):
    def __init__(self, dedicated_host_cluster_id=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.dedicated_host_cluster_id = dedicated_host_cluster_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDedicatedHostClusterRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_host_cluster_id is not None:
            result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DedicatedHostClusterId') is not None:
            self.dedicated_host_cluster_id = m.get('DedicatedHostClusterId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteDedicatedHostClusterResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDedicatedHostClusterResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDedicatedHostClusterResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDedicatedHostClusterResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDedicatedHostClusterResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDedicatedHostClusterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDemandRequest(TeaModel):
    def __init__(self, client_token=None, demand_id=None, owner_account=None, owner_id=None, reason=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None):
        self.client_token = client_token  # type: str
        self.demand_id = demand_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.reason = reason  # type: str
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDemandRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.demand_id is not None:
            result['DemandId'] = self.demand_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DemandId') is not None:
            self.demand_id = m.get('DemandId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteDemandResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDemandResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDemandResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDemandResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDemandResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDemandResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDeploymentSetRequest(TeaModel):
    def __init__(self, deployment_set_id=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.deployment_set_id = deployment_set_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDeploymentSetRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deployment_set_id is not None:
            result['DeploymentSetId'] = self.deployment_set_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeploymentSetId') is not None:
            self.deployment_set_id = m.get('DeploymentSetId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteDeploymentSetResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDeploymentSetResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDeploymentSetResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDeploymentSetResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDeploymentSetResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDeploymentSetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDiagnosticMetricSetsRequest(TeaModel):
    def __init__(self, metric_set_ids=None, region_id=None):
        self.metric_set_ids = metric_set_ids  # type: list[str]
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDiagnosticMetricSetsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.metric_set_ids is not None:
            result['MetricSetIds'] = self.metric_set_ids
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MetricSetIds') is not None:
            self.metric_set_ids = m.get('MetricSetIds')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DeleteDiagnosticMetricSetsResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDiagnosticMetricSetsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDiagnosticMetricSetsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDiagnosticMetricSetsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDiagnosticMetricSetsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDiagnosticMetricSetsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDiagnosticReportsRequest(TeaModel):
    def __init__(self, region_id=None, report_ids=None):
        self.region_id = region_id  # type: str
        self.report_ids = report_ids  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDiagnosticReportsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.report_ids is not None:
            result['ReportIds'] = self.report_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ReportIds') is not None:
            self.report_ids = m.get('ReportIds')
        return self


class DeleteDiagnosticReportsResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDiagnosticReportsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDiagnosticReportsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDiagnosticReportsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDiagnosticReportsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDiagnosticReportsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDiskRequest(TeaModel):
    def __init__(self, disk_id=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        self.disk_id = disk_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDiskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disk_id is not None:
            result['DiskId'] = self.disk_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DiskId') is not None:
            self.disk_id = m.get('DiskId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteDiskResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDiskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDiskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDiskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDiskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDiskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteForwardEntryRequest(TeaModel):
    def __init__(self, forward_entry_id=None, forward_table_id=None, owner_account=None, owner_id=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None):
        self.forward_entry_id = forward_entry_id  # type: str
        self.forward_table_id = forward_table_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteForwardEntryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.forward_entry_id is not None:
            result['ForwardEntryId'] = self.forward_entry_id
        if self.forward_table_id is not None:
            result['ForwardTableId'] = self.forward_table_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ForwardEntryId') is not None:
            self.forward_entry_id = m.get('ForwardEntryId')
        if m.get('ForwardTableId') is not None:
            self.forward_table_id = m.get('ForwardTableId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteForwardEntryResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteForwardEntryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteForwardEntryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteForwardEntryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteForwardEntryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteForwardEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHaVipRequest(TeaModel):
    def __init__(self, client_token=None, ha_vip_id=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.client_token = client_token  # type: str
        self.ha_vip_id = ha_vip_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteHaVipRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.ha_vip_id is not None:
            result['HaVipId'] = self.ha_vip_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('HaVipId') is not None:
            self.ha_vip_id = m.get('HaVipId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteHaVipResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteHaVipResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteHaVipResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteHaVipResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteHaVipResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteHaVipResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHpcClusterRequest(TeaModel):
    def __init__(self, client_token=None, hpc_cluster_id=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.client_token = client_token  # type: str
        self.hpc_cluster_id = hpc_cluster_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteHpcClusterRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.hpc_cluster_id is not None:
            result['HpcClusterId'] = self.hpc_cluster_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('HpcClusterId') is not None:
            self.hpc_cluster_id = m.get('HpcClusterId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteHpcClusterResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteHpcClusterResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteHpcClusterResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteHpcClusterResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteHpcClusterResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteHpcClusterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteImageRequest(TeaModel):
    def __init__(self, force=None, image_id=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.force = force  # type: bool
        self.image_id = image_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteImageRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.force is not None:
            result['Force'] = self.force
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Force') is not None:
            self.force = m.get('Force')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteImageResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteImageResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteImageResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteImageResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteImageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteImageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteImageComponentRequest(TeaModel):
    def __init__(self, image_component_id=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.image_component_id = image_component_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteImageComponentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_component_id is not None:
            result['ImageComponentId'] = self.image_component_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ImageComponentId') is not None:
            self.image_component_id = m.get('ImageComponentId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteImageComponentResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteImageComponentResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteImageComponentResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteImageComponentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteImageComponentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteImageComponentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteImagePipelineRequest(TeaModel):
    def __init__(self, image_pipeline_id=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.image_pipeline_id = image_pipeline_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteImagePipelineRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_pipeline_id is not None:
            result['ImagePipelineId'] = self.image_pipeline_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ImagePipelineId') is not None:
            self.image_pipeline_id = m.get('ImagePipelineId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteImagePipelineResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteImagePipelineResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteImagePipelineResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteImagePipelineResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteImagePipelineResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteImagePipelineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteInstanceRequest(TeaModel):
    def __init__(self, force=None, instance_id=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None, terminate_subscription=None):
        self.force = force  # type: bool
        self.instance_id = instance_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.terminate_subscription = terminate_subscription  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.force is not None:
            result['Force'] = self.force
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.terminate_subscription is not None:
            result['TerminateSubscription'] = self.terminate_subscription
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Force') is not None:
            self.force = m.get('Force')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TerminateSubscription') is not None:
            self.terminate_subscription = m.get('TerminateSubscription')
        return self


class DeleteInstanceResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteInstancesRequest(TeaModel):
    def __init__(self, client_token=None, dry_run=None, force=None, instance_id=None, owner_account=None,
                 owner_id=None, region_id=None, resource_owner_account=None, resource_owner_id=None,
                 terminate_subscription=None):
        self.client_token = client_token  # type: str
        self.dry_run = dry_run  # type: bool
        self.force = force  # type: bool
        self.instance_id = instance_id  # type: list[str]
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.terminate_subscription = terminate_subscription  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteInstancesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.force is not None:
            result['Force'] = self.force
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.terminate_subscription is not None:
            result['TerminateSubscription'] = self.terminate_subscription
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('Force') is not None:
            self.force = m.get('Force')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TerminateSubscription') is not None:
            self.terminate_subscription = m.get('TerminateSubscription')
        return self


class DeleteInstancesResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteInstancesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteInstancesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteInstancesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteInstancesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteKeyPairsRequest(TeaModel):
    def __init__(self, key_pair_names=None, owner_id=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        self.key_pair_names = key_pair_names  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteKeyPairsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key_pair_names is not None:
            result['KeyPairNames'] = self.key_pair_names
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('KeyPairNames') is not None:
            self.key_pair_names = m.get('KeyPairNames')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteKeyPairsResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteKeyPairsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteKeyPairsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteKeyPairsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteKeyPairsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteKeyPairsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLaunchTemplateRequest(TeaModel):
    def __init__(self, launch_template_id=None, launch_template_name=None, owner_account=None, owner_id=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None):
        self.launch_template_id = launch_template_id  # type: str
        self.launch_template_name = launch_template_name  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLaunchTemplateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.launch_template_id is not None:
            result['LaunchTemplateId'] = self.launch_template_id
        if self.launch_template_name is not None:
            result['LaunchTemplateName'] = self.launch_template_name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LaunchTemplateId') is not None:
            self.launch_template_id = m.get('LaunchTemplateId')
        if m.get('LaunchTemplateName') is not None:
            self.launch_template_name = m.get('LaunchTemplateName')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteLaunchTemplateResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLaunchTemplateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLaunchTemplateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteLaunchTemplateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteLaunchTemplateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLaunchTemplateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLaunchTemplateVersionRequest(TeaModel):
    def __init__(self, delete_version=None, launch_template_id=None, launch_template_name=None, owner_account=None,
                 owner_id=None, region_id=None, resource_owner_account=None, resource_owner_id=None):
        self.delete_version = delete_version  # type: list[long]
        self.launch_template_id = launch_template_id  # type: str
        self.launch_template_name = launch_template_name  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLaunchTemplateVersionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.delete_version is not None:
            result['DeleteVersion'] = self.delete_version
        if self.launch_template_id is not None:
            result['LaunchTemplateId'] = self.launch_template_id
        if self.launch_template_name is not None:
            result['LaunchTemplateName'] = self.launch_template_name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DeleteVersion') is not None:
            self.delete_version = m.get('DeleteVersion')
        if m.get('LaunchTemplateId') is not None:
            self.launch_template_id = m.get('LaunchTemplateId')
        if m.get('LaunchTemplateName') is not None:
            self.launch_template_name = m.get('LaunchTemplateName')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteLaunchTemplateVersionResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteLaunchTemplateVersionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLaunchTemplateVersionResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteLaunchTemplateVersionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteLaunchTemplateVersionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLaunchTemplateVersionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteNatGatewayRequest(TeaModel):
    def __init__(self, nat_gateway_id=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.nat_gateway_id = nat_gateway_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteNatGatewayRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.nat_gateway_id is not None:
            result['NatGatewayId'] = self.nat_gateway_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NatGatewayId') is not None:
            self.nat_gateway_id = m.get('NatGatewayId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteNatGatewayResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteNatGatewayResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteNatGatewayResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteNatGatewayResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteNatGatewayResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteNatGatewayResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteNetworkInterfaceRequest(TeaModel):
    def __init__(self, network_interface_id=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.network_interface_id = network_interface_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteNetworkInterfaceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NetworkInterfaceId') is not None:
            self.network_interface_id = m.get('NetworkInterfaceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteNetworkInterfaceResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteNetworkInterfaceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteNetworkInterfaceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteNetworkInterfaceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteNetworkInterfaceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteNetworkInterfaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteNetworkInterfacePermissionRequest(TeaModel):
    def __init__(self, force=None, network_interface_permission_id=None, owner_account=None, owner_id=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None):
        self.force = force  # type: bool
        self.network_interface_permission_id = network_interface_permission_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteNetworkInterfacePermissionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.force is not None:
            result['Force'] = self.force
        if self.network_interface_permission_id is not None:
            result['NetworkInterfacePermissionId'] = self.network_interface_permission_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Force') is not None:
            self.force = m.get('Force')
        if m.get('NetworkInterfacePermissionId') is not None:
            self.network_interface_permission_id = m.get('NetworkInterfacePermissionId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteNetworkInterfacePermissionResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteNetworkInterfacePermissionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteNetworkInterfacePermissionResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteNetworkInterfacePermissionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteNetworkInterfacePermissionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteNetworkInterfacePermissionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePhysicalConnectionRequest(TeaModel):
    def __init__(self, client_token=None, owner_account=None, owner_id=None, physical_connection_id=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None):
        self.client_token = client_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.physical_connection_id = physical_connection_id  # type: str
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeletePhysicalConnectionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.physical_connection_id is not None:
            result['PhysicalConnectionId'] = self.physical_connection_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PhysicalConnectionId') is not None:
            self.physical_connection_id = m.get('PhysicalConnectionId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeletePhysicalConnectionResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeletePhysicalConnectionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeletePhysicalConnectionResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeletePhysicalConnectionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeletePhysicalConnectionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeletePhysicalConnectionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeletePrefixListRequest(TeaModel):
    def __init__(self, owner_account=None, owner_id=None, prefix_list_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.prefix_list_id = prefix_list_id  # type: str
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeletePrefixListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.prefix_list_id is not None:
            result['PrefixListId'] = self.prefix_list_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PrefixListId') is not None:
            self.prefix_list_id = m.get('PrefixListId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeletePrefixListResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeletePrefixListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeletePrefixListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeletePrefixListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeletePrefixListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeletePrefixListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRouteEntryRequestNextHopList(TeaModel):
    def __init__(self, next_hop_id=None, next_hop_type=None):
        self.next_hop_id = next_hop_id  # type: str
        self.next_hop_type = next_hop_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteRouteEntryRequestNextHopList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_hop_id is not None:
            result['NextHopId'] = self.next_hop_id
        if self.next_hop_type is not None:
            result['NextHopType'] = self.next_hop_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NextHopId') is not None:
            self.next_hop_id = m.get('NextHopId')
        if m.get('NextHopType') is not None:
            self.next_hop_type = m.get('NextHopType')
        return self


class DeleteRouteEntryRequest(TeaModel):
    def __init__(self, destination_cidr_block=None, next_hop_id=None, next_hop_list=None, owner_account=None,
                 owner_id=None, region_id=None, resource_owner_account=None, resource_owner_id=None, route_table_id=None):
        self.destination_cidr_block = destination_cidr_block  # type: str
        self.next_hop_id = next_hop_id  # type: str
        self.next_hop_list = next_hop_list  # type: list[DeleteRouteEntryRequestNextHopList]
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.route_table_id = route_table_id  # type: str

    def validate(self):
        if self.next_hop_list:
            for k in self.next_hop_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DeleteRouteEntryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.destination_cidr_block is not None:
            result['DestinationCidrBlock'] = self.destination_cidr_block
        if self.next_hop_id is not None:
            result['NextHopId'] = self.next_hop_id
        result['NextHopList'] = []
        if self.next_hop_list is not None:
            for k in self.next_hop_list:
                result['NextHopList'].append(k.to_map() if k else None)
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.route_table_id is not None:
            result['RouteTableId'] = self.route_table_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DestinationCidrBlock') is not None:
            self.destination_cidr_block = m.get('DestinationCidrBlock')
        if m.get('NextHopId') is not None:
            self.next_hop_id = m.get('NextHopId')
        self.next_hop_list = []
        if m.get('NextHopList') is not None:
            for k in m.get('NextHopList'):
                temp_model = DeleteRouteEntryRequestNextHopList()
                self.next_hop_list.append(temp_model.from_map(k))
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RouteTableId') is not None:
            self.route_table_id = m.get('RouteTableId')
        return self


class DeleteRouteEntryResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteRouteEntryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteRouteEntryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteRouteEntryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteRouteEntryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteRouteEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRouterInterfaceRequest(TeaModel):
    def __init__(self, client_token=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None, router_interface_id=None, user_cidr=None):
        self.client_token = client_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.router_interface_id = router_interface_id  # type: str
        self.user_cidr = user_cidr  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteRouterInterfaceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.router_interface_id is not None:
            result['RouterInterfaceId'] = self.router_interface_id
        if self.user_cidr is not None:
            result['UserCidr'] = self.user_cidr
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RouterInterfaceId') is not None:
            self.router_interface_id = m.get('RouterInterfaceId')
        if m.get('UserCidr') is not None:
            self.user_cidr = m.get('UserCidr')
        return self


class DeleteRouterInterfaceResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteRouterInterfaceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteRouterInterfaceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteRouterInterfaceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteRouterInterfaceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteRouterInterfaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSecurityGroupRequest(TeaModel):
    def __init__(self, owner_account=None, owner_id=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None, security_group_id=None):
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.security_group_id = security_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSecurityGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        return self


class DeleteSecurityGroupResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSecurityGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSecurityGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteSecurityGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteSecurityGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSecurityGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSnapshotRequest(TeaModel):
    def __init__(self, force=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None, snapshot_id=None):
        self.force = force  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.snapshot_id = snapshot_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSnapshotRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.force is not None:
            result['Force'] = self.force
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Force') is not None:
            self.force = m.get('Force')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        return self


class DeleteSnapshotResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSnapshotResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSnapshotResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteSnapshotResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteSnapshotResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSnapshotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSnapshotGroupRequest(TeaModel):
    def __init__(self, owner_account=None, owner_id=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None, snapshot_group_id=None):
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.snapshot_group_id = snapshot_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSnapshotGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.snapshot_group_id is not None:
            result['SnapshotGroupId'] = self.snapshot_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SnapshotGroupId') is not None:
            self.snapshot_group_id = m.get('SnapshotGroupId')
        return self


class DeleteSnapshotGroupResponseBodyOperationProgressSetOperationProgressRelatedItemSetRelatedItem(TeaModel):
    def __init__(self, name=None, value=None):
        self.name = name  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSnapshotGroupResponseBodyOperationProgressSetOperationProgressRelatedItemSetRelatedItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DeleteSnapshotGroupResponseBodyOperationProgressSetOperationProgressRelatedItemSet(TeaModel):
    def __init__(self, related_item=None):
        self.related_item = related_item  # type: list[DeleteSnapshotGroupResponseBodyOperationProgressSetOperationProgressRelatedItemSetRelatedItem]

    def validate(self):
        if self.related_item:
            for k in self.related_item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DeleteSnapshotGroupResponseBodyOperationProgressSetOperationProgressRelatedItemSet, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RelatedItem'] = []
        if self.related_item is not None:
            for k in self.related_item:
                result['RelatedItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.related_item = []
        if m.get('RelatedItem') is not None:
            for k in m.get('RelatedItem'):
                temp_model = DeleteSnapshotGroupResponseBodyOperationProgressSetOperationProgressRelatedItemSetRelatedItem()
                self.related_item.append(temp_model.from_map(k))
        return self


class DeleteSnapshotGroupResponseBodyOperationProgressSetOperationProgress(TeaModel):
    def __init__(self, error_code=None, error_msg=None, operation_status=None, related_item_set=None):
        self.error_code = error_code  # type: str
        self.error_msg = error_msg  # type: str
        self.operation_status = operation_status  # type: str
        self.related_item_set = related_item_set  # type: DeleteSnapshotGroupResponseBodyOperationProgressSetOperationProgressRelatedItemSet

    def validate(self):
        if self.related_item_set:
            self.related_item_set.validate()

    def to_map(self):
        _map = super(DeleteSnapshotGroupResponseBodyOperationProgressSetOperationProgress, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_msg is not None:
            result['ErrorMsg'] = self.error_msg
        if self.operation_status is not None:
            result['OperationStatus'] = self.operation_status
        if self.related_item_set is not None:
            result['RelatedItemSet'] = self.related_item_set.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorMsg') is not None:
            self.error_msg = m.get('ErrorMsg')
        if m.get('OperationStatus') is not None:
            self.operation_status = m.get('OperationStatus')
        if m.get('RelatedItemSet') is not None:
            temp_model = DeleteSnapshotGroupResponseBodyOperationProgressSetOperationProgressRelatedItemSet()
            self.related_item_set = temp_model.from_map(m['RelatedItemSet'])
        return self


class DeleteSnapshotGroupResponseBodyOperationProgressSet(TeaModel):
    def __init__(self, operation_progress=None):
        self.operation_progress = operation_progress  # type: list[DeleteSnapshotGroupResponseBodyOperationProgressSetOperationProgress]

    def validate(self):
        if self.operation_progress:
            for k in self.operation_progress:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DeleteSnapshotGroupResponseBodyOperationProgressSet, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OperationProgress'] = []
        if self.operation_progress is not None:
            for k in self.operation_progress:
                result['OperationProgress'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.operation_progress = []
        if m.get('OperationProgress') is not None:
            for k in m.get('OperationProgress'):
                temp_model = DeleteSnapshotGroupResponseBodyOperationProgressSetOperationProgress()
                self.operation_progress.append(temp_model.from_map(k))
        return self


class DeleteSnapshotGroupResponseBody(TeaModel):
    def __init__(self, operation_progress_set=None, request_id=None):
        self.operation_progress_set = operation_progress_set  # type: DeleteSnapshotGroupResponseBodyOperationProgressSet
        self.request_id = request_id  # type: str

    def validate(self):
        if self.operation_progress_set:
            self.operation_progress_set.validate()

    def to_map(self):
        _map = super(DeleteSnapshotGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operation_progress_set is not None:
            result['OperationProgressSet'] = self.operation_progress_set.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OperationProgressSet') is not None:
            temp_model = DeleteSnapshotGroupResponseBodyOperationProgressSet()
            self.operation_progress_set = temp_model.from_map(m['OperationProgressSet'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSnapshotGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteSnapshotGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteSnapshotGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSnapshotGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteStorageSetRequest(TeaModel):
    def __init__(self, client_token=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None, storage_set_id=None):
        self.client_token = client_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.storage_set_id = storage_set_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteStorageSetRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.storage_set_id is not None:
            result['StorageSetId'] = self.storage_set_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('StorageSetId') is not None:
            self.storage_set_id = m.get('StorageSetId')
        return self


class DeleteStorageSetResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteStorageSetResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteStorageSetResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteStorageSetResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteStorageSetResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteStorageSetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVSwitchRequest(TeaModel):
    def __init__(self, owner_account=None, owner_id=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None, v_switch_id=None):
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.v_switch_id = v_switch_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteVSwitchRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class DeleteVSwitchResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteVSwitchResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteVSwitchResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteVSwitchResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteVSwitchResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteVSwitchResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVirtualBorderRouterRequest(TeaModel):
    def __init__(self, client_token=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None, user_cidr=None, vbr_id=None):
        self.client_token = client_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.user_cidr = user_cidr  # type: str
        self.vbr_id = vbr_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteVirtualBorderRouterRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.user_cidr is not None:
            result['UserCidr'] = self.user_cidr
        if self.vbr_id is not None:
            result['VbrId'] = self.vbr_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('UserCidr') is not None:
            self.user_cidr = m.get('UserCidr')
        if m.get('VbrId') is not None:
            self.vbr_id = m.get('VbrId')
        return self


class DeleteVirtualBorderRouterResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteVirtualBorderRouterResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteVirtualBorderRouterResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteVirtualBorderRouterResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteVirtualBorderRouterResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteVirtualBorderRouterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVpcRequest(TeaModel):
    def __init__(self, owner_account=None, owner_id=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None, vpc_id=None):
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.vpc_id = vpc_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteVpcRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class DeleteVpcResponseBody(TeaModel):
    def __init__(self, request_id=None):
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteVpcResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteVpcResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteVpcResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteVpcResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteVpcResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeregisterManagedInstanceRequest(TeaModel):
    def __init__(self, instance_id=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.instance_id = instance_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeregisterManagedInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeregisterManagedInstanceResponseBodyInstance(TeaModel):
    def __init__(self, activation_id=None, agent_version=None, hostname=None, instance_id=None, instance_name=None,
                 internet_ip=None, intranet_ip=None, invocation_count=None, last_invoked_time=None, machine_id=None,
                 os_type=None, os_version=None, registration_time=None):
        self.activation_id = activation_id  # type: str
        self.agent_version = agent_version  # type: str
        self.hostname = hostname  # type: str
        self.instance_id = instance_id  # type: str
        self.instance_name = instance_name  # type: str
        self.internet_ip = internet_ip  # type: str
        self.intranet_ip = intranet_ip  # type: str
        self.invocation_count = invocation_count  # type: long
        self.last_invoked_time = last_invoked_time  # type: str
        self.machine_id = machine_id  # type: str
        self.os_type = os_type  # type: str
        self.os_version = os_version  # type: str
        self.registration_time = registration_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeregisterManagedInstanceResponseBodyInstance, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.activation_id is not None:
            result['ActivationId'] = self.activation_id
        if self.agent_version is not None:
            result['AgentVersion'] = self.agent_version
        if self.hostname is not None:
            result['Hostname'] = self.hostname
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.invocation_count is not None:
            result['InvocationCount'] = self.invocation_count
        if self.last_invoked_time is not None:
            result['LastInvokedTime'] = self.last_invoked_time
        if self.machine_id is not None:
            result['MachineId'] = self.machine_id
        if self.os_type is not None:
            result['OsType'] = self.os_type
        if self.os_version is not None:
            result['OsVersion'] = self.os_version
        if self.registration_time is not None:
            result['RegistrationTime'] = self.registration_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActivationId') is not None:
            self.activation_id = m.get('ActivationId')
        if m.get('AgentVersion') is not None:
            self.agent_version = m.get('AgentVersion')
        if m.get('Hostname') is not None:
            self.hostname = m.get('Hostname')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('InvocationCount') is not None:
            self.invocation_count = m.get('InvocationCount')
        if m.get('LastInvokedTime') is not None:
            self.last_invoked_time = m.get('LastInvokedTime')
        if m.get('MachineId') is not None:
            self.machine_id = m.get('MachineId')
        if m.get('OsType') is not None:
            self.os_type = m.get('OsType')
        if m.get('OsVersion') is not None:
            self.os_version = m.get('OsVersion')
        if m.get('RegistrationTime') is not None:
            self.registration_time = m.get('RegistrationTime')
        return self


class DeregisterManagedInstanceResponseBody(TeaModel):
    def __init__(self, instance=None, request_id=None):
        self.instance = instance  # type: DeregisterManagedInstanceResponseBodyInstance
        self.request_id = request_id  # type: str

    def validate(self):
        if self.instance:
            self.instance.validate()

    def to_map(self):
        _map = super(DeregisterManagedInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance is not None:
            result['Instance'] = self.instance.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Instance') is not None:
            temp_model = DeregisterManagedInstanceResponseBodyInstance()
            self.instance = temp_model.from_map(m['Instance'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeregisterManagedInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeregisterManagedInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeregisterManagedInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeregisterManagedInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAccessPointsRequestFilter(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAccessPointsRequestFilter, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeAccessPointsRequest(TeaModel):
    def __init__(self, filter=None, owner_id=None, page_number=None, page_size=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None, type=None):
        self.filter = filter  # type: list[DescribeAccessPointsRequestFilter]
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.type = type  # type: str

    def validate(self):
        if self.filter:
            for k in self.filter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAccessPointsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Filter'] = []
        if self.filter is not None:
            for k in self.filter:
                result['Filter'].append(k.to_map() if k else None)
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.filter = []
        if m.get('Filter') is not None:
            for k in m.get('Filter'):
                temp_model = DescribeAccessPointsRequestFilter()
                self.filter.append(temp_model.from_map(k))
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeAccessPointsResponseBodyAccessPointSetAccessPointType(TeaModel):
    def __init__(self, access_point_id=None, attached_region_no=None, description=None, host_operator=None,
                 location=None, name=None, status=None, type=None):
        self.access_point_id = access_point_id  # type: str
        self.attached_region_no = attached_region_no  # type: str
        self.description = description  # type: str
        self.host_operator = host_operator  # type: str
        self.location = location  # type: str
        self.name = name  # type: str
        self.status = status  # type: str
        self.type = type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAccessPointsResponseBodyAccessPointSetAccessPointType, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_point_id is not None:
            result['AccessPointId'] = self.access_point_id
        if self.attached_region_no is not None:
            result['AttachedRegionNo'] = self.attached_region_no
        if self.description is not None:
            result['Description'] = self.description
        if self.host_operator is not None:
            result['HostOperator'] = self.host_operator
        if self.location is not None:
            result['Location'] = self.location
        if self.name is not None:
            result['Name'] = self.name
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccessPointId') is not None:
            self.access_point_id = m.get('AccessPointId')
        if m.get('AttachedRegionNo') is not None:
            self.attached_region_no = m.get('AttachedRegionNo')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('HostOperator') is not None:
            self.host_operator = m.get('HostOperator')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeAccessPointsResponseBodyAccessPointSet(TeaModel):
    def __init__(self, access_point_type=None):
        self.access_point_type = access_point_type  # type: list[DescribeAccessPointsResponseBodyAccessPointSetAccessPointType]

    def validate(self):
        if self.access_point_type:
            for k in self.access_point_type:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAccessPointsResponseBodyAccessPointSet, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AccessPointType'] = []
        if self.access_point_type is not None:
            for k in self.access_point_type:
                result['AccessPointType'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.access_point_type = []
        if m.get('AccessPointType') is not None:
            for k in m.get('AccessPointType'):
                temp_model = DescribeAccessPointsResponseBodyAccessPointSetAccessPointType()
                self.access_point_type.append(temp_model.from_map(k))
        return self


class DescribeAccessPointsResponseBody(TeaModel):
    def __init__(self, access_point_set=None, page_number=None, page_size=None, request_id=None, total_count=None):
        self.access_point_set = access_point_set  # type: DescribeAccessPointsResponseBodyAccessPointSet
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.access_point_set:
            self.access_point_set.validate()

    def to_map(self):
        _map = super(DescribeAccessPointsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_point_set is not None:
            result['AccessPointSet'] = self.access_point_set.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccessPointSet') is not None:
            temp_model = DescribeAccessPointsResponseBodyAccessPointSet()
            self.access_point_set = temp_model.from_map(m['AccessPointSet'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAccessPointsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAccessPointsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAccessPointsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAccessPointsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAccountAttributesRequest(TeaModel):
    def __init__(self, attribute_name=None, owner_id=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None, zone_id=None):
        self.attribute_name = attribute_name  # type: list[str]
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAccountAttributesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attribute_name is not None:
            result['AttributeName'] = self.attribute_name
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AttributeName') is not None:
            self.attribute_name = m.get('AttributeName')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeAccountAttributesResponseBodyAccountAttributeItemsAccountAttributeItemAttributeValuesValueItem(TeaModel):
    def __init__(self, count=None, disk_category=None, expired_time=None, instance_charge_type=None,
                 instance_type=None, value=None, zone_id=None):
        self.count = count  # type: int
        self.disk_category = disk_category  # type: str
        self.expired_time = expired_time  # type: str
        self.instance_charge_type = instance_charge_type  # type: str
        self.instance_type = instance_type  # type: str
        self.value = value  # type: str
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAccountAttributesResponseBodyAccountAttributeItemsAccountAttributeItemAttributeValuesValueItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.disk_category is not None:
            result['DiskCategory'] = self.disk_category
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.value is not None:
            result['Value'] = self.value
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('DiskCategory') is not None:
            self.disk_category = m.get('DiskCategory')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeAccountAttributesResponseBodyAccountAttributeItemsAccountAttributeItemAttributeValues(TeaModel):
    def __init__(self, value_item=None):
        self.value_item = value_item  # type: list[DescribeAccountAttributesResponseBodyAccountAttributeItemsAccountAttributeItemAttributeValuesValueItem]

    def validate(self):
        if self.value_item:
            for k in self.value_item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAccountAttributesResponseBodyAccountAttributeItemsAccountAttributeItemAttributeValues, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ValueItem'] = []
        if self.value_item is not None:
            for k in self.value_item:
                result['ValueItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.value_item = []
        if m.get('ValueItem') is not None:
            for k in m.get('ValueItem'):
                temp_model = DescribeAccountAttributesResponseBodyAccountAttributeItemsAccountAttributeItemAttributeValuesValueItem()
                self.value_item.append(temp_model.from_map(k))
        return self


class DescribeAccountAttributesResponseBodyAccountAttributeItemsAccountAttributeItem(TeaModel):
    def __init__(self, attribute_name=None, attribute_values=None):
        self.attribute_name = attribute_name  # type: str
        self.attribute_values = attribute_values  # type: DescribeAccountAttributesResponseBodyAccountAttributeItemsAccountAttributeItemAttributeValues

    def validate(self):
        if self.attribute_values:
            self.attribute_values.validate()

    def to_map(self):
        _map = super(DescribeAccountAttributesResponseBodyAccountAttributeItemsAccountAttributeItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attribute_name is not None:
            result['AttributeName'] = self.attribute_name
        if self.attribute_values is not None:
            result['AttributeValues'] = self.attribute_values.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AttributeName') is not None:
            self.attribute_name = m.get('AttributeName')
        if m.get('AttributeValues') is not None:
            temp_model = DescribeAccountAttributesResponseBodyAccountAttributeItemsAccountAttributeItemAttributeValues()
            self.attribute_values = temp_model.from_map(m['AttributeValues'])
        return self


class DescribeAccountAttributesResponseBodyAccountAttributeItems(TeaModel):
    def __init__(self, account_attribute_item=None):
        self.account_attribute_item = account_attribute_item  # type: list[DescribeAccountAttributesResponseBodyAccountAttributeItemsAccountAttributeItem]

    def validate(self):
        if self.account_attribute_item:
            for k in self.account_attribute_item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAccountAttributesResponseBodyAccountAttributeItems, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AccountAttributeItem'] = []
        if self.account_attribute_item is not None:
            for k in self.account_attribute_item:
                result['AccountAttributeItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.account_attribute_item = []
        if m.get('AccountAttributeItem') is not None:
            for k in m.get('AccountAttributeItem'):
                temp_model = DescribeAccountAttributesResponseBodyAccountAttributeItemsAccountAttributeItem()
                self.account_attribute_item.append(temp_model.from_map(k))
        return self


class DescribeAccountAttributesResponseBody(TeaModel):
    def __init__(self, account_attribute_items=None, request_id=None):
        self.account_attribute_items = account_attribute_items  # type: DescribeAccountAttributesResponseBodyAccountAttributeItems
        self.request_id = request_id  # type: str

    def validate(self):
        if self.account_attribute_items:
            self.account_attribute_items.validate()

    def to_map(self):
        _map = super(DescribeAccountAttributesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_attribute_items is not None:
            result['AccountAttributeItems'] = self.account_attribute_items.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountAttributeItems') is not None:
            temp_model = DescribeAccountAttributesResponseBodyAccountAttributeItems()
            self.account_attribute_items = temp_model.from_map(m['AccountAttributeItems'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAccountAttributesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAccountAttributesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAccountAttributesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAccountAttributesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeActivationsRequest(TeaModel):
    def __init__(self, activation_id=None, instance_name=None, owner_account=None, owner_id=None, page_number=None,
                 page_size=None, region_id=None, resource_owner_account=None, resource_owner_id=None):
        self.activation_id = activation_id  # type: str
        self.instance_name = instance_name  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeActivationsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.activation_id is not None:
            result['ActivationId'] = self.activation_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActivationId') is not None:
            self.activation_id = m.get('ActivationId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeActivationsResponseBodyActivationList(TeaModel):
    def __init__(self, activation_id=None, creation_time=None, deregistered_count=None, description=None,
                 disabled=None, instance_count=None, instance_name=None, ip_address_range=None, registered_count=None,
                 time_to_live_in_hours=None):
        self.activation_id = activation_id  # type: str
        self.creation_time = creation_time  # type: str
        self.deregistered_count = deregistered_count  # type: int
        self.description = description  # type: str
        self.disabled = disabled  # type: bool
        self.instance_count = instance_count  # type: int
        self.instance_name = instance_name  # type: str
        self.ip_address_range = ip_address_range  # type: str
        self.registered_count = registered_count  # type: int
        self.time_to_live_in_hours = time_to_live_in_hours  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeActivationsResponseBodyActivationList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.activation_id is not None:
            result['ActivationId'] = self.activation_id
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.deregistered_count is not None:
            result['DeregisteredCount'] = self.deregistered_count
        if self.description is not None:
            result['Description'] = self.description
        if self.disabled is not None:
            result['Disabled'] = self.disabled
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.ip_address_range is not None:
            result['IpAddressRange'] = self.ip_address_range
        if self.registered_count is not None:
            result['RegisteredCount'] = self.registered_count
        if self.time_to_live_in_hours is not None:
            result['TimeToLiveInHours'] = self.time_to_live_in_hours
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActivationId') is not None:
            self.activation_id = m.get('ActivationId')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('DeregisteredCount') is not None:
            self.deregistered_count = m.get('DeregisteredCount')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Disabled') is not None:
            self.disabled = m.get('Disabled')
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('IpAddressRange') is not None:
            self.ip_address_range = m.get('IpAddressRange')
        if m.get('RegisteredCount') is not None:
            self.registered_count = m.get('RegisteredCount')
        if m.get('TimeToLiveInHours') is not None:
            self.time_to_live_in_hours = m.get('TimeToLiveInHours')
        return self


class DescribeActivationsResponseBody(TeaModel):
    def __init__(self, activation_list=None, page_number=None, page_size=None, request_id=None, total_count=None):
        self.activation_list = activation_list  # type: list[DescribeActivationsResponseBodyActivationList]
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: long

    def validate(self):
        if self.activation_list:
            for k in self.activation_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeActivationsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ActivationList'] = []
        if self.activation_list is not None:
            for k in self.activation_list:
                result['ActivationList'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.activation_list = []
        if m.get('ActivationList') is not None:
            for k in m.get('ActivationList'):
                temp_model = DescribeActivationsResponseBodyActivationList()
                self.activation_list.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeActivationsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeActivationsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeActivationsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeActivationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAutoProvisioningGroupHistoryRequest(TeaModel):
    def __init__(self, auto_provisioning_group_id=None, end_time=None, owner_account=None, owner_id=None,
                 page_number=None, page_size=None, region_id=None, resource_owner_account=None, resource_owner_id=None,
                 start_time=None):
        self.auto_provisioning_group_id = auto_provisioning_group_id  # type: str
        self.end_time = end_time  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.start_time = start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAutoProvisioningGroupHistoryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_provisioning_group_id is not None:
            result['AutoProvisioningGroupId'] = self.auto_provisioning_group_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoProvisioningGroupId') is not None:
            self.auto_provisioning_group_id = m.get('AutoProvisioningGroupId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeAutoProvisioningGroupHistoryResponseBodyAutoProvisioningGroupHistoriesAutoProvisioningGroupHistoryActivityDetailsActivityDetail(TeaModel):
    def __init__(self, detail=None, status=None):
        self.detail = detail  # type: str
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAutoProvisioningGroupHistoryResponseBodyAutoProvisioningGroupHistoriesAutoProvisioningGroupHistoryActivityDetailsActivityDetail, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.detail is not None:
            result['Detail'] = self.detail
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Detail') is not None:
            self.detail = m.get('Detail')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeAutoProvisioningGroupHistoryResponseBodyAutoProvisioningGroupHistoriesAutoProvisioningGroupHistoryActivityDetails(TeaModel):
    def __init__(self, activity_detail=None):
        self.activity_detail = activity_detail  # type: list[DescribeAutoProvisioningGroupHistoryResponseBodyAutoProvisioningGroupHistoriesAutoProvisioningGroupHistoryActivityDetailsActivityDetail]

    def validate(self):
        if self.activity_detail:
            for k in self.activity_detail:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAutoProvisioningGroupHistoryResponseBodyAutoProvisioningGroupHistoriesAutoProvisioningGroupHistoryActivityDetails, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ActivityDetail'] = []
        if self.activity_detail is not None:
            for k in self.activity_detail:
                result['ActivityDetail'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.activity_detail = []
        if m.get('ActivityDetail') is not None:
            for k in m.get('ActivityDetail'):
                temp_model = DescribeAutoProvisioningGroupHistoryResponseBodyAutoProvisioningGroupHistoriesAutoProvisioningGroupHistoryActivityDetailsActivityDetail()
                self.activity_detail.append(temp_model.from_map(k))
        return self


class DescribeAutoProvisioningGroupHistoryResponseBodyAutoProvisioningGroupHistoriesAutoProvisioningGroupHistory(TeaModel):
    def __init__(self, activity_details=None, last_event_time=None, start_time=None, status=None, task_id=None):
        self.activity_details = activity_details  # type: DescribeAutoProvisioningGroupHistoryResponseBodyAutoProvisioningGroupHistoriesAutoProvisioningGroupHistoryActivityDetails
        self.last_event_time = last_event_time  # type: str
        self.start_time = start_time  # type: str
        self.status = status  # type: str
        self.task_id = task_id  # type: str

    def validate(self):
        if self.activity_details:
            self.activity_details.validate()

    def to_map(self):
        _map = super(DescribeAutoProvisioningGroupHistoryResponseBodyAutoProvisioningGroupHistoriesAutoProvisioningGroupHistory, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.activity_details is not None:
            result['ActivityDetails'] = self.activity_details.to_map()
        if self.last_event_time is not None:
            result['LastEventTime'] = self.last_event_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActivityDetails') is not None:
            temp_model = DescribeAutoProvisioningGroupHistoryResponseBodyAutoProvisioningGroupHistoriesAutoProvisioningGroupHistoryActivityDetails()
            self.activity_details = temp_model.from_map(m['ActivityDetails'])
        if m.get('LastEventTime') is not None:
            self.last_event_time = m.get('LastEventTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DescribeAutoProvisioningGroupHistoryResponseBodyAutoProvisioningGroupHistories(TeaModel):
    def __init__(self, auto_provisioning_group_history=None):
        self.auto_provisioning_group_history = auto_provisioning_group_history  # type: list[DescribeAutoProvisioningGroupHistoryResponseBodyAutoProvisioningGroupHistoriesAutoProvisioningGroupHistory]

    def validate(self):
        if self.auto_provisioning_group_history:
            for k in self.auto_provisioning_group_history:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAutoProvisioningGroupHistoryResponseBodyAutoProvisioningGroupHistories, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AutoProvisioningGroupHistory'] = []
        if self.auto_provisioning_group_history is not None:
            for k in self.auto_provisioning_group_history:
                result['AutoProvisioningGroupHistory'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.auto_provisioning_group_history = []
        if m.get('AutoProvisioningGroupHistory') is not None:
            for k in m.get('AutoProvisioningGroupHistory'):
                temp_model = DescribeAutoProvisioningGroupHistoryResponseBodyAutoProvisioningGroupHistoriesAutoProvisioningGroupHistory()
                self.auto_provisioning_group_history.append(temp_model.from_map(k))
        return self


class DescribeAutoProvisioningGroupHistoryResponseBody(TeaModel):
    def __init__(self, auto_provisioning_group_histories=None, page_number=None, page_size=None, request_id=None,
                 total_count=None):
        self.auto_provisioning_group_histories = auto_provisioning_group_histories  # type: DescribeAutoProvisioningGroupHistoryResponseBodyAutoProvisioningGroupHistories
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.auto_provisioning_group_histories:
            self.auto_provisioning_group_histories.validate()

    def to_map(self):
        _map = super(DescribeAutoProvisioningGroupHistoryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_provisioning_group_histories is not None:
            result['AutoProvisioningGroupHistories'] = self.auto_provisioning_group_histories.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoProvisioningGroupHistories') is not None:
            temp_model = DescribeAutoProvisioningGroupHistoryResponseBodyAutoProvisioningGroupHistories()
            self.auto_provisioning_group_histories = temp_model.from_map(m['AutoProvisioningGroupHistories'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAutoProvisioningGroupHistoryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAutoProvisioningGroupHistoryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAutoProvisioningGroupHistoryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAutoProvisioningGroupHistoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAutoProvisioningGroupInstancesRequest(TeaModel):
    def __init__(self, auto_provisioning_group_id=None, owner_account=None, owner_id=None, page_number=None,
                 page_size=None, region_id=None, resource_owner_account=None, resource_owner_id=None):
        self.auto_provisioning_group_id = auto_provisioning_group_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAutoProvisioningGroupInstancesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_provisioning_group_id is not None:
            result['AutoProvisioningGroupId'] = self.auto_provisioning_group_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoProvisioningGroupId') is not None:
            self.auto_provisioning_group_id = m.get('AutoProvisioningGroupId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeAutoProvisioningGroupInstancesResponseBodyInstancesInstance(TeaModel):
    def __init__(self, cpu=None, creation_time=None, instance_id=None, instance_type=None, io_optimized=None,
                 is_spot=None, memory=None, network_type=None, os_type=None, region_id=None, status=None, zone_id=None):
        self.cpu = cpu  # type: int
        self.creation_time = creation_time  # type: str
        self.instance_id = instance_id  # type: str
        self.instance_type = instance_type  # type: str
        self.io_optimized = io_optimized  # type: bool
        self.is_spot = is_spot  # type: bool
        self.memory = memory  # type: int
        self.network_type = network_type  # type: str
        self.os_type = os_type  # type: str
        self.region_id = region_id  # type: str
        self.status = status  # type: str
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAutoProvisioningGroupInstancesResponseBodyInstancesInstance, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cpu is not None:
            result['CPU'] = self.cpu
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.is_spot is not None:
            result['IsSpot'] = self.is_spot
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.network_type is not None:
            result['NetworkType'] = self.network_type
        if self.os_type is not None:
            result['OsType'] = self.os_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.status is not None:
            result['Status'] = self.status
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CPU') is not None:
            self.cpu = m.get('CPU')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('IoOptimized') is not None:
            self.io_optimized = m.get('IoOptimized')
        if m.get('IsSpot') is not None:
            self.is_spot = m.get('IsSpot')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('NetworkType') is not None:
            self.network_type = m.get('NetworkType')
        if m.get('OsType') is not None:
            self.os_type = m.get('OsType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeAutoProvisioningGroupInstancesResponseBodyInstances(TeaModel):
    def __init__(self, instance=None):
        self.instance = instance  # type: list[DescribeAutoProvisioningGroupInstancesResponseBodyInstancesInstance]

    def validate(self):
        if self.instance:
            for k in self.instance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAutoProvisioningGroupInstancesResponseBodyInstances, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Instance'] = []
        if self.instance is not None:
            for k in self.instance:
                result['Instance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.instance = []
        if m.get('Instance') is not None:
            for k in m.get('Instance'):
                temp_model = DescribeAutoProvisioningGroupInstancesResponseBodyInstancesInstance()
                self.instance.append(temp_model.from_map(k))
        return self


class DescribeAutoProvisioningGroupInstancesResponseBody(TeaModel):
    def __init__(self, instances=None, page_number=None, page_size=None, request_id=None, total_count=None):
        self.instances = instances  # type: DescribeAutoProvisioningGroupInstancesResponseBodyInstances
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.instances:
            self.instances.validate()

    def to_map(self):
        _map = super(DescribeAutoProvisioningGroupInstancesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instances is not None:
            result['Instances'] = self.instances.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Instances') is not None:
            temp_model = DescribeAutoProvisioningGroupInstancesResponseBodyInstances()
            self.instances = temp_model.from_map(m['Instances'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAutoProvisioningGroupInstancesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAutoProvisioningGroupInstancesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAutoProvisioningGroupInstancesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAutoProvisioningGroupInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAutoProvisioningGroupsRequest(TeaModel):
    def __init__(self, auto_provisioning_group_id=None, auto_provisioning_group_name=None,
                 auto_provisioning_group_status=None, owner_account=None, owner_id=None, page_number=None, page_size=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.auto_provisioning_group_id = auto_provisioning_group_id  # type: list[str]
        self.auto_provisioning_group_name = auto_provisioning_group_name  # type: str
        self.auto_provisioning_group_status = auto_provisioning_group_status  # type: list[str]
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAutoProvisioningGroupsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_provisioning_group_id is not None:
            result['AutoProvisioningGroupId'] = self.auto_provisioning_group_id
        if self.auto_provisioning_group_name is not None:
            result['AutoProvisioningGroupName'] = self.auto_provisioning_group_name
        if self.auto_provisioning_group_status is not None:
            result['AutoProvisioningGroupStatus'] = self.auto_provisioning_group_status
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoProvisioningGroupId') is not None:
            self.auto_provisioning_group_id = m.get('AutoProvisioningGroupId')
        if m.get('AutoProvisioningGroupName') is not None:
            self.auto_provisioning_group_name = m.get('AutoProvisioningGroupName')
        if m.get('AutoProvisioningGroupStatus') is not None:
            self.auto_provisioning_group_status = m.get('AutoProvisioningGroupStatus')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroupLaunchTemplateConfigsLaunchTemplateConfig(TeaModel):
    def __init__(self, instance_type=None, max_price=None, priority=None, v_switch_id=None, weighted_capacity=None):
        self.instance_type = instance_type  # type: str
        self.max_price = max_price  # type: float
        self.priority = priority  # type: float
        self.v_switch_id = v_switch_id  # type: str
        self.weighted_capacity = weighted_capacity  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroupLaunchTemplateConfigsLaunchTemplateConfig, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.max_price is not None:
            result['MaxPrice'] = self.max_price
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.weighted_capacity is not None:
            result['WeightedCapacity'] = self.weighted_capacity
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('MaxPrice') is not None:
            self.max_price = m.get('MaxPrice')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('WeightedCapacity') is not None:
            self.weighted_capacity = m.get('WeightedCapacity')
        return self


class DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroupLaunchTemplateConfigs(TeaModel):
    def __init__(self, launch_template_config=None):
        self.launch_template_config = launch_template_config  # type: list[DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroupLaunchTemplateConfigsLaunchTemplateConfig]

    def validate(self):
        if self.launch_template_config:
            for k in self.launch_template_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroupLaunchTemplateConfigs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LaunchTemplateConfig'] = []
        if self.launch_template_config is not None:
            for k in self.launch_template_config:
                result['LaunchTemplateConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.launch_template_config = []
        if m.get('LaunchTemplateConfig') is not None:
            for k in m.get('LaunchTemplateConfig'):
                temp_model = DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroupLaunchTemplateConfigsLaunchTemplateConfig()
                self.launch_template_config.append(temp_model.from_map(k))
        return self


class DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroupPayAsYouGoOptions(TeaModel):
    def __init__(self, allocation_strategy=None):
        self.allocation_strategy = allocation_strategy  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroupPayAsYouGoOptions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allocation_strategy is not None:
            result['AllocationStrategy'] = self.allocation_strategy
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AllocationStrategy') is not None:
            self.allocation_strategy = m.get('AllocationStrategy')
        return self


class DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroupSpotOptions(TeaModel):
    def __init__(self, allocation_strategy=None, instance_interruption_behavior=None,
                 instance_pools_to_use_count=None):
        self.allocation_strategy = allocation_strategy  # type: str
        self.instance_interruption_behavior = instance_interruption_behavior  # type: str
        self.instance_pools_to_use_count = instance_pools_to_use_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroupSpotOptions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allocation_strategy is not None:
            result['AllocationStrategy'] = self.allocation_strategy
        if self.instance_interruption_behavior is not None:
            result['InstanceInterruptionBehavior'] = self.instance_interruption_behavior
        if self.instance_pools_to_use_count is not None:
            result['InstancePoolsToUseCount'] = self.instance_pools_to_use_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AllocationStrategy') is not None:
            self.allocation_strategy = m.get('AllocationStrategy')
        if m.get('InstanceInterruptionBehavior') is not None:
            self.instance_interruption_behavior = m.get('InstanceInterruptionBehavior')
        if m.get('InstancePoolsToUseCount') is not None:
            self.instance_pools_to_use_count = m.get('InstancePoolsToUseCount')
        return self


class DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroupTargetCapacitySpecification(TeaModel):
    def __init__(self, default_target_capacity_type=None, pay_as_you_go_target_capacity=None,
                 spot_target_capacity=None, total_target_capacity=None):
        self.default_target_capacity_type = default_target_capacity_type  # type: str
        self.pay_as_you_go_target_capacity = pay_as_you_go_target_capacity  # type: float
        self.spot_target_capacity = spot_target_capacity  # type: float
        self.total_target_capacity = total_target_capacity  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroupTargetCapacitySpecification, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_target_capacity_type is not None:
            result['DefaultTargetCapacityType'] = self.default_target_capacity_type
        if self.pay_as_you_go_target_capacity is not None:
            result['PayAsYouGoTargetCapacity'] = self.pay_as_you_go_target_capacity
        if self.spot_target_capacity is not None:
            result['SpotTargetCapacity'] = self.spot_target_capacity
        if self.total_target_capacity is not None:
            result['TotalTargetCapacity'] = self.total_target_capacity
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DefaultTargetCapacityType') is not None:
            self.default_target_capacity_type = m.get('DefaultTargetCapacityType')
        if m.get('PayAsYouGoTargetCapacity') is not None:
            self.pay_as_you_go_target_capacity = m.get('PayAsYouGoTargetCapacity')
        if m.get('SpotTargetCapacity') is not None:
            self.spot_target_capacity = m.get('SpotTargetCapacity')
        if m.get('TotalTargetCapacity') is not None:
            self.total_target_capacity = m.get('TotalTargetCapacity')
        return self


class DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroup(TeaModel):
    def __init__(self, auto_provisioning_group_id=None, auto_provisioning_group_name=None,
                 auto_provisioning_group_type=None, creation_time=None, excess_capacity_termination_policy=None, launch_template_configs=None,
                 launch_template_id=None, launch_template_version=None, max_spot_price=None, pay_as_you_go_options=None,
                 region_id=None, spot_options=None, state=None, status=None, target_capacity_specification=None,
                 terminate_instances=None, terminate_instances_with_expiration=None, valid_from=None, valid_until=None):
        self.auto_provisioning_group_id = auto_provisioning_group_id  # type: str
        self.auto_provisioning_group_name = auto_provisioning_group_name  # type: str
        self.auto_provisioning_group_type = auto_provisioning_group_type  # type: str
        self.creation_time = creation_time  # type: str
        self.excess_capacity_termination_policy = excess_capacity_termination_policy  # type: str
        self.launch_template_configs = launch_template_configs  # type: DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroupLaunchTemplateConfigs
        self.launch_template_id = launch_template_id  # type: str
        self.launch_template_version = launch_template_version  # type: str
        self.max_spot_price = max_spot_price  # type: float
        self.pay_as_you_go_options = pay_as_you_go_options  # type: DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroupPayAsYouGoOptions
        self.region_id = region_id  # type: str
        self.spot_options = spot_options  # type: DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroupSpotOptions
        self.state = state  # type: str
        self.status = status  # type: str
        self.target_capacity_specification = target_capacity_specification  # type: DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroupTargetCapacitySpecification
        self.terminate_instances = terminate_instances  # type: bool
        self.terminate_instances_with_expiration = terminate_instances_with_expiration  # type: bool
        self.valid_from = valid_from  # type: str
        self.valid_until = valid_until  # type: str

    def validate(self):
        if self.launch_template_configs:
            self.launch_template_configs.validate()
        if self.pay_as_you_go_options:
            self.pay_as_you_go_options.validate()
        if self.spot_options:
            self.spot_options.validate()
        if self.target_capacity_specification:
            self.target_capacity_specification.validate()

    def to_map(self):
        _map = super(DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroup, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_provisioning_group_id is not None:
            result['AutoProvisioningGroupId'] = self.auto_provisioning_group_id
        if self.auto_provisioning_group_name is not None:
            result['AutoProvisioningGroupName'] = self.auto_provisioning_group_name
        if self.auto_provisioning_group_type is not None:
            result['AutoProvisioningGroupType'] = self.auto_provisioning_group_type
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.excess_capacity_termination_policy is not None:
            result['ExcessCapacityTerminationPolicy'] = self.excess_capacity_termination_policy
        if self.launch_template_configs is not None:
            result['LaunchTemplateConfigs'] = self.launch_template_configs.to_map()
        if self.launch_template_id is not None:
            result['LaunchTemplateId'] = self.launch_template_id
        if self.launch_template_version is not None:
            result['LaunchTemplateVersion'] = self.launch_template_version
        if self.max_spot_price is not None:
            result['MaxSpotPrice'] = self.max_spot_price
        if self.pay_as_you_go_options is not None:
            result['PayAsYouGoOptions'] = self.pay_as_you_go_options.to_map()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.spot_options is not None:
            result['SpotOptions'] = self.spot_options.to_map()
        if self.state is not None:
            result['State'] = self.state
        if self.status is not None:
            result['Status'] = self.status
        if self.target_capacity_specification is not None:
            result['TargetCapacitySpecification'] = self.target_capacity_specification.to_map()
        if self.terminate_instances is not None:
            result['TerminateInstances'] = self.terminate_instances
        if self.terminate_instances_with_expiration is not None:
            result['TerminateInstancesWithExpiration'] = self.terminate_instances_with_expiration
        if self.valid_from is not None:
            result['ValidFrom'] = self.valid_from
        if self.valid_until is not None:
            result['ValidUntil'] = self.valid_until
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoProvisioningGroupId') is not None:
            self.auto_provisioning_group_id = m.get('AutoProvisioningGroupId')
        if m.get('AutoProvisioningGroupName') is not None:
            self.auto_provisioning_group_name = m.get('AutoProvisioningGroupName')
        if m.get('AutoProvisioningGroupType') is not None:
            self.auto_provisioning_group_type = m.get('AutoProvisioningGroupType')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('ExcessCapacityTerminationPolicy') is not None:
            self.excess_capacity_termination_policy = m.get('ExcessCapacityTerminationPolicy')
        if m.get('LaunchTemplateConfigs') is not None:
            temp_model = DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroupLaunchTemplateConfigs()
            self.launch_template_configs = temp_model.from_map(m['LaunchTemplateConfigs'])
        if m.get('LaunchTemplateId') is not None:
            self.launch_template_id = m.get('LaunchTemplateId')
        if m.get('LaunchTemplateVersion') is not None:
            self.launch_template_version = m.get('LaunchTemplateVersion')
        if m.get('MaxSpotPrice') is not None:
            self.max_spot_price = m.get('MaxSpotPrice')
        if m.get('PayAsYouGoOptions') is not None:
            temp_model = DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroupPayAsYouGoOptions()
            self.pay_as_you_go_options = temp_model.from_map(m['PayAsYouGoOptions'])
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SpotOptions') is not None:
            temp_model = DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroupSpotOptions()
            self.spot_options = temp_model.from_map(m['SpotOptions'])
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TargetCapacitySpecification') is not None:
            temp_model = DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroupTargetCapacitySpecification()
            self.target_capacity_specification = temp_model.from_map(m['TargetCapacitySpecification'])
        if m.get('TerminateInstances') is not None:
            self.terminate_instances = m.get('TerminateInstances')
        if m.get('TerminateInstancesWithExpiration') is not None:
            self.terminate_instances_with_expiration = m.get('TerminateInstancesWithExpiration')
        if m.get('ValidFrom') is not None:
            self.valid_from = m.get('ValidFrom')
        if m.get('ValidUntil') is not None:
            self.valid_until = m.get('ValidUntil')
        return self


class DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroups(TeaModel):
    def __init__(self, auto_provisioning_group=None):
        self.auto_provisioning_group = auto_provisioning_group  # type: list[DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroup]

    def validate(self):
        if self.auto_provisioning_group:
            for k in self.auto_provisioning_group:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroups, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AutoProvisioningGroup'] = []
        if self.auto_provisioning_group is not None:
            for k in self.auto_provisioning_group:
                result['AutoProvisioningGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.auto_provisioning_group = []
        if m.get('AutoProvisioningGroup') is not None:
            for k in m.get('AutoProvisioningGroup'):
                temp_model = DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroupsAutoProvisioningGroup()
                self.auto_provisioning_group.append(temp_model.from_map(k))
        return self


class DescribeAutoProvisioningGroupsResponseBody(TeaModel):
    def __init__(self, auto_provisioning_groups=None, page_number=None, page_size=None, request_id=None,
                 total_count=None):
        self.auto_provisioning_groups = auto_provisioning_groups  # type: DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroups
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.auto_provisioning_groups:
            self.auto_provisioning_groups.validate()

    def to_map(self):
        _map = super(DescribeAutoProvisioningGroupsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_provisioning_groups is not None:
            result['AutoProvisioningGroups'] = self.auto_provisioning_groups.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoProvisioningGroups') is not None:
            temp_model = DescribeAutoProvisioningGroupsResponseBodyAutoProvisioningGroups()
            self.auto_provisioning_groups = temp_model.from_map(m['AutoProvisioningGroups'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAutoProvisioningGroupsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAutoProvisioningGroupsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAutoProvisioningGroupsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAutoProvisioningGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAutoSnapshotPolicyExRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAutoSnapshotPolicyExRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeAutoSnapshotPolicyExRequest(TeaModel):
    def __init__(self, auto_snapshot_policy_id=None, auto_snapshot_policy_name=None, owner_account=None,
                 owner_id=None, page_number=None, page_size=None, region_id=None, resource_group_id=None,
                 resource_owner_account=None, resource_owner_id=None, tag=None):
        self.auto_snapshot_policy_id = auto_snapshot_policy_id  # type: str
        self.auto_snapshot_policy_name = auto_snapshot_policy_name  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.tag = tag  # type: list[DescribeAutoSnapshotPolicyExRequestTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAutoSnapshotPolicyExRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_snapshot_policy_id is not None:
            result['AutoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        if self.auto_snapshot_policy_name is not None:
            result['AutoSnapshotPolicyName'] = self.auto_snapshot_policy_name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoSnapshotPolicyId') is not None:
            self.auto_snapshot_policy_id = m.get('AutoSnapshotPolicyId')
        if m.get('AutoSnapshotPolicyName') is not None:
            self.auto_snapshot_policy_name = m.get('AutoSnapshotPolicyName')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeAutoSnapshotPolicyExRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeAutoSnapshotPolicyExResponseBodyAutoSnapshotPoliciesAutoSnapshotPolicyTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key  # type: str
        self.tag_value = tag_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAutoSnapshotPolicyExResponseBodyAutoSnapshotPoliciesAutoSnapshotPolicyTagsTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class DescribeAutoSnapshotPolicyExResponseBodyAutoSnapshotPoliciesAutoSnapshotPolicyTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag  # type: list[DescribeAutoSnapshotPolicyExResponseBodyAutoSnapshotPoliciesAutoSnapshotPolicyTagsTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAutoSnapshotPolicyExResponseBodyAutoSnapshotPoliciesAutoSnapshotPolicyTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeAutoSnapshotPolicyExResponseBodyAutoSnapshotPoliciesAutoSnapshotPolicyTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeAutoSnapshotPolicyExResponseBodyAutoSnapshotPoliciesAutoSnapshotPolicy(TeaModel):
    def __init__(self, auto_snapshot_policy_id=None, auto_snapshot_policy_name=None,
                 copied_snapshots_retention_days=None, creation_time=None, disk_nums=None, enable_cross_region_copy=None, region_id=None,
                 repeat_weekdays=None, resource_group_id=None, retention_days=None, status=None, tags=None,
                 target_copy_regions=None, time_points=None, volume_nums=None):
        self.auto_snapshot_policy_id = auto_snapshot_policy_id  # type: str
        self.auto_snapshot_policy_name = auto_snapshot_policy_name  # type: str
        self.copied_snapshots_retention_days = copied_snapshots_retention_days  # type: int
        self.creation_time = creation_time  # type: str
        self.disk_nums = disk_nums  # type: int
        self.enable_cross_region_copy = enable_cross_region_copy  # type: bool
        self.region_id = region_id  # type: str
        self.repeat_weekdays = repeat_weekdays  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.retention_days = retention_days  # type: int
        self.status = status  # type: str
        self.tags = tags  # type: DescribeAutoSnapshotPolicyExResponseBodyAutoSnapshotPoliciesAutoSnapshotPolicyTags
        self.target_copy_regions = target_copy_regions  # type: str
        self.time_points = time_points  # type: str
        self.volume_nums = volume_nums  # type: int

    def validate(self):
        if self.tags:
            self.tags.validate()

    def to_map(self):
        _map = super(DescribeAutoSnapshotPolicyExResponseBodyAutoSnapshotPoliciesAutoSnapshotPolicy, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_snapshot_policy_id is not None:
            result['AutoSnapshotPolicyId'] = self.auto_snapshot_policy_id
        if self.auto_snapshot_policy_name is not None:
            result['AutoSnapshotPolicyName'] = self.auto_snapshot_policy_name
        if self.copied_snapshots_retention_days is not None:
            result['CopiedSnapshotsRetentionDays'] = self.copied_snapshots_retention_days
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.disk_nums is not None:
            result['DiskNums'] = self.disk_nums
        if self.enable_cross_region_copy is not None:
            result['EnableCrossRegionCopy'] = self.enable_cross_region_copy
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.repeat_weekdays is not None:
            result['RepeatWeekdays'] = self.repeat_weekdays
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.retention_days is not None:
            result['RetentionDays'] = self.retention_days
        if self.status is not None:
            result['Status'] = self.status
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.target_copy_regions is not None:
            result['TargetCopyRegions'] = self.target_copy_regions
        if self.time_points is not None:
            result['TimePoints'] = self.time_points
        if self.volume_nums is not None:
            result['VolumeNums'] = self.volume_nums
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoSnapshotPolicyId') is not None:
            self.auto_snapshot_policy_id = m.get('AutoSnapshotPolicyId')
        if m.get('AutoSnapshotPolicyName') is not None:
            self.auto_snapshot_policy_name = m.get('AutoSnapshotPolicyName')
        if m.get('CopiedSnapshotsRetentionDays') is not None:
            self.copied_snapshots_retention_days = m.get('CopiedSnapshotsRetentionDays')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('DiskNums') is not None:
            self.disk_nums = m.get('DiskNums')
        if m.get('EnableCrossRegionCopy') is not None:
            self.enable_cross_region_copy = m.get('EnableCrossRegionCopy')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RepeatWeekdays') is not None:
            self.repeat_weekdays = m.get('RepeatWeekdays')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('RetentionDays') is not None:
            self.retention_days = m.get('RetentionDays')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tags') is not None:
            temp_model = DescribeAutoSnapshotPolicyExResponseBodyAutoSnapshotPoliciesAutoSnapshotPolicyTags()
            self.tags = temp_model.from_map(m['Tags'])
        if m.get('TargetCopyRegions') is not None:
            self.target_copy_regions = m.get('TargetCopyRegions')
        if m.get('TimePoints') is not None:
            self.time_points = m.get('TimePoints')
        if m.get('VolumeNums') is not None:
            self.volume_nums = m.get('VolumeNums')
        return self


class DescribeAutoSnapshotPolicyExResponseBodyAutoSnapshotPolicies(TeaModel):
    def __init__(self, auto_snapshot_policy=None):
        self.auto_snapshot_policy = auto_snapshot_policy  # type: list[DescribeAutoSnapshotPolicyExResponseBodyAutoSnapshotPoliciesAutoSnapshotPolicy]

    def validate(self):
        if self.auto_snapshot_policy:
            for k in self.auto_snapshot_policy:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAutoSnapshotPolicyExResponseBodyAutoSnapshotPolicies, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AutoSnapshotPolicy'] = []
        if self.auto_snapshot_policy is not None:
            for k in self.auto_snapshot_policy:
                result['AutoSnapshotPolicy'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.auto_snapshot_policy = []
        if m.get('AutoSnapshotPolicy') is not None:
            for k in m.get('AutoSnapshotPolicy'):
                temp_model = DescribeAutoSnapshotPolicyExResponseBodyAutoSnapshotPoliciesAutoSnapshotPolicy()
                self.auto_snapshot_policy.append(temp_model.from_map(k))
        return self


class DescribeAutoSnapshotPolicyExResponseBody(TeaModel):
    def __init__(self, auto_snapshot_policies=None, page_number=None, page_size=None, request_id=None,
                 total_count=None):
        self.auto_snapshot_policies = auto_snapshot_policies  # type: DescribeAutoSnapshotPolicyExResponseBodyAutoSnapshotPolicies
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.auto_snapshot_policies:
            self.auto_snapshot_policies.validate()

    def to_map(self):
        _map = super(DescribeAutoSnapshotPolicyExResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_snapshot_policies is not None:
            result['AutoSnapshotPolicies'] = self.auto_snapshot_policies.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoSnapshotPolicies') is not None:
            temp_model = DescribeAutoSnapshotPolicyExResponseBodyAutoSnapshotPolicies()
            self.auto_snapshot_policies = temp_model.from_map(m['AutoSnapshotPolicies'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAutoSnapshotPolicyExResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAutoSnapshotPolicyExResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAutoSnapshotPolicyExResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAutoSnapshotPolicyExResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAvailableResourceRequest(TeaModel):
    def __init__(self, cores=None, data_disk_category=None, dedicated_host_id=None, destination_resource=None,
                 instance_charge_type=None, instance_type=None, io_optimized=None, memory=None, network_category=None,
                 owner_account=None, owner_id=None, region_id=None, resource_owner_account=None, resource_owner_id=None,
                 resource_type=None, scope=None, spot_duration=None, spot_strategy=None, system_disk_category=None, zone_id=None):
        self.cores = cores  # type: int
        self.data_disk_category = data_disk_category  # type: str
        self.dedicated_host_id = dedicated_host_id  # type: str
        self.destination_resource = destination_resource  # type: str
        self.instance_charge_type = instance_charge_type  # type: str
        self.instance_type = instance_type  # type: str
        self.io_optimized = io_optimized  # type: str
        self.memory = memory  # type: float
        self.network_category = network_category  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.resource_type = resource_type  # type: str
        self.scope = scope  # type: str
        self.spot_duration = spot_duration  # type: int
        self.spot_strategy = spot_strategy  # type: str
        self.system_disk_category = system_disk_category  # type: str
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAvailableResourceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cores is not None:
            result['Cores'] = self.cores
        if self.data_disk_category is not None:
            result['DataDiskCategory'] = self.data_disk_category
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        if self.destination_resource is not None:
            result['DestinationResource'] = self.destination_resource
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.io_optimized is not None:
            result['IoOptimized'] = self.io_optimized
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.network_category is not None:
            result['NetworkCategory'] = self.network_category
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.scope is not None:
            result['Scope'] = self.scope
        if self.spot_duration is not None:
            result['SpotDuration'] = self.spot_duration
        if self.spot_strategy is not None:
            result['SpotStrategy'] = self.spot_strategy
        if self.system_disk_category is not None:
            result['SystemDiskCategory'] = self.system_disk_category
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Cores') is not None:
            self.cores = m.get('Cores')
        if m.get('DataDiskCategory') is not None:
            self.data_disk_category = m.get('DataDiskCategory')
        if m.get('DedicatedHostId') is not None:
            self.dedicated_host_id = m.get('DedicatedHostId')
        if m.get('DestinationResource') is not None:
            self.destination_resource = m.get('DestinationResource')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('IoOptimized') is not None:
            self.io_optimized = m.get('IoOptimized')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('NetworkCategory') is not None:
            self.network_category = m.get('NetworkCategory')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('Scope') is not None:
            self.scope = m.get('Scope')
        if m.get('SpotDuration') is not None:
            self.spot_duration = m.get('SpotDuration')
        if m.get('SpotStrategy') is not None:
            self.spot_strategy = m.get('SpotStrategy')
        if m.get('SystemDiskCategory') is not None:
            self.system_disk_category = m.get('SystemDiskCategory')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeAvailableResourceResponseBodyAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResourcesSupportedResource(TeaModel):
    def __init__(self, max=None, min=None, status=None, status_category=None, unit=None, value=None):
        self.max = max  # type: int
        self.min = min  # type: int
        self.status = status  # type: str
        self.status_category = status_category  # type: str
        self.unit = unit  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeAvailableResourceResponseBodyAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResourcesSupportedResource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max is not None:
            result['Max'] = self.max
        if self.min is not None:
            result['Min'] = self.min
        if self.status is not None:
            result['Status'] = self.status
        if self.status_category is not None:
            result['StatusCategory'] = self.status_category
        if self.unit is not None:
            result['Unit'] = self.unit
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Max') is not None:
            self.max = m.get('Max')
        if m.get('Min') is not None:
            self.min = m.get('Min')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StatusCategory') is not None:
            self.status_category = m.get('StatusCategory')
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeAvailableResourceResponseBodyAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResources(TeaModel):
    def __init__(self, supported_resource=None):
        self.supported_resource = supported_resource  # type: list[DescribeAvailableResourceResponseBodyAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResourcesSupportedResource]

    def validate(self):
        if self.supported_resource:
            for k in self.supported_resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAvailableResourceResponseBodyAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResources, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SupportedResource'] = []
        if self.supported_resource is not None:
            for k in self.supported_resource:
                result['SupportedResource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.supported_resource = []
        if m.get('SupportedResource') is not None:
            for k in m.get('SupportedResource'):
                temp_model = DescribeAvailableResourceResponseBodyAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResourcesSupportedResource()
                self.supported_resource.append(temp_model.from_map(k))
        return self


class DescribeAvailableResourceResponseBodyAvailableZonesAvailableZoneAvailableResourcesAvailableResource(TeaModel):
    def __init__(self, supported_resources=None, type=None):
        self.supported_resources = supported_resources  # type: DescribeAvailableResourceResponseBodyAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResources
        self.type = type  # type: str

    def validate(self):
        if self.supported_resources:
            self.supported_resources.validate()

    def to_map(self):
        _map = super(DescribeAvailableResourceResponseBodyAvailableZonesAvailableZoneAvailableResourcesAvailableResource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.supported_resources is not None:
            result['SupportedResources'] = self.supported_resources.to_map()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SupportedResources') is not None:
            temp_model = DescribeAvailableResourceResponseBodyAvailableZonesAvailableZoneAvailableResourcesAvailableResourceSupportedResources()
            self.supported_resources = temp_model.from_map(m['SupportedResources'])
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeAvailableResourceResponseBodyAvailableZonesAvailableZoneAvailableResources(TeaModel):
    def __init__(self, available_resource=None):
        self.available_resource = available_resource  # type: list[DescribeAvailableResourceResponseBodyAvailableZonesAvailableZoneAvailableResourcesAvailableResource]

    def validate(self):
        if self.available_resource:
            for k in self.available_resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAvailableResourceResponseBodyAvailableZonesAvailableZoneAvailableResources, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AvailableResource'] = []
        if self.available_resource is not None:
            for k in self.available_resource:
                result['AvailableResource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.available_resource = []
        if m.get('AvailableResource') is not None:
            for k in m.get('AvailableResource'):
                temp_model = DescribeAvailableResourceResponseBodyAvailableZonesAvailableZoneAvailableResourcesAvailableResource()
                self.available_resource.append(temp_model.from_map(k))
        return self


class DescribeAvailableResourceResponseBodyAvailableZonesAvailableZone(TeaModel):
    def __init__(self, available_resources=None, region_id=None, status=None, status_category=None, zone_id=None):
        self.available_resources = available_resources  # type: DescribeAvailableResourceResponseBodyAvailableZonesAvailableZoneAvailableResources
        self.region_id = region_id  # type: str
        self.status = status  # type: str
        self.status_category = status_category  # type: str
        self.zone_id = zone_id  # type: str

    def validate(self):
        if self.available_resources:
            self.available_resources.validate()

    def to_map(self):
        _map = super(DescribeAvailableResourceResponseBodyAvailableZonesAvailableZone, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.available_resources is not None:
            result['AvailableResources'] = self.available_resources.to_map()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.status is not None:
            result['Status'] = self.status
        if self.status_category is not None:
            result['StatusCategory'] = self.status_category
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvailableResources') is not None:
            temp_model = DescribeAvailableResourceResponseBodyAvailableZonesAvailableZoneAvailableResources()
            self.available_resources = temp_model.from_map(m['AvailableResources'])
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StatusCategory') is not None:
            self.status_category = m.get('StatusCategory')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeAvailableResourceResponseBodyAvailableZones(TeaModel):
    def __init__(self, available_zone=None):
        self.available_zone = available_zone  # type: list[DescribeAvailableResourceResponseBodyAvailableZonesAvailableZone]

    def validate(self):
        if self.available_zone:
            for k in self.available_zone:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeAvailableResourceResponseBodyAvailableZones, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AvailableZone'] = []
        if self.available_zone is not None:
            for k in self.available_zone:
                result['AvailableZone'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.available_zone = []
        if m.get('AvailableZone') is not None:
            for k in m.get('AvailableZone'):
                temp_model = DescribeAvailableResourceResponseBodyAvailableZonesAvailableZone()
                self.available_zone.append(temp_model.from_map(k))
        return self


class DescribeAvailableResourceResponseBody(TeaModel):
    def __init__(self, available_zones=None, request_id=None):
        self.available_zones = available_zones  # type: DescribeAvailableResourceResponseBodyAvailableZones
        self.request_id = request_id  # type: str

    def validate(self):
        if self.available_zones:
            self.available_zones.validate()

    def to_map(self):
        _map = super(DescribeAvailableResourceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.available_zones is not None:
            result['AvailableZones'] = self.available_zones.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvailableZones') is not None:
            temp_model = DescribeAvailableResourceResponseBodyAvailableZones()
            self.available_zones = temp_model.from_map(m['AvailableZones'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAvailableResourceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeAvailableResourceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeAvailableResourceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAvailableResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBandwidthLimitationRequest(TeaModel):
    def __init__(self, instance_charge_type=None, instance_type=None, operation_type=None, owner_account=None,
                 owner_id=None, region_id=None, resource_id=None, resource_owner_account=None, resource_owner_id=None,
                 spot_strategy=None):
        self.instance_charge_type = instance_charge_type  # type: str
        self.instance_type = instance_type  # type: str
        self.operation_type = operation_type  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_id = resource_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.spot_strategy = spot_strategy  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBandwidthLimitationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.operation_type is not None:
            result['OperationType'] = self.operation_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.spot_strategy is not None:
            result['SpotStrategy'] = self.spot_strategy
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('OperationType') is not None:
            self.operation_type = m.get('OperationType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SpotStrategy') is not None:
            self.spot_strategy = m.get('SpotStrategy')
        return self


class DescribeBandwidthLimitationResponseBodyBandwidthsBandwidth(TeaModel):
    def __init__(self, internet_charge_type=None, max=None, min=None, unit=None):
        self.internet_charge_type = internet_charge_type  # type: str
        self.max = max  # type: int
        self.min = min  # type: int
        self.unit = unit  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBandwidthLimitationResponseBodyBandwidthsBandwidth, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.max is not None:
            result['Max'] = self.max
        if self.min is not None:
            result['Min'] = self.min
        if self.unit is not None:
            result['Unit'] = self.unit
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('Max') is not None:
            self.max = m.get('Max')
        if m.get('Min') is not None:
            self.min = m.get('Min')
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        return self


class DescribeBandwidthLimitationResponseBodyBandwidths(TeaModel):
    def __init__(self, bandwidth=None):
        self.bandwidth = bandwidth  # type: list[DescribeBandwidthLimitationResponseBodyBandwidthsBandwidth]

    def validate(self):
        if self.bandwidth:
            for k in self.bandwidth:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeBandwidthLimitationResponseBodyBandwidths, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Bandwidth'] = []
        if self.bandwidth is not None:
            for k in self.bandwidth:
                result['Bandwidth'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.bandwidth = []
        if m.get('Bandwidth') is not None:
            for k in m.get('Bandwidth'):
                temp_model = DescribeBandwidthLimitationResponseBodyBandwidthsBandwidth()
                self.bandwidth.append(temp_model.from_map(k))
        return self


class DescribeBandwidthLimitationResponseBody(TeaModel):
    def __init__(self, bandwidths=None, request_id=None):
        self.bandwidths = bandwidths  # type: DescribeBandwidthLimitationResponseBodyBandwidths
        self.request_id = request_id  # type: str

    def validate(self):
        if self.bandwidths:
            self.bandwidths.validate()

    def to_map(self):
        _map = super(DescribeBandwidthLimitationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidths is not None:
            result['Bandwidths'] = self.bandwidths.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bandwidths') is not None:
            temp_model = DescribeBandwidthLimitationResponseBodyBandwidths()
            self.bandwidths = temp_model.from_map(m['Bandwidths'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBandwidthLimitationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeBandwidthLimitationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeBandwidthLimitationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBandwidthLimitationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBandwidthPackagesRequest(TeaModel):
    def __init__(self, bandwidth_package_id=None, nat_gateway_id=None, owner_account=None, owner_id=None,
                 page_number=None, page_size=None, region_id=None, resource_owner_account=None, resource_owner_id=None):
        self.bandwidth_package_id = bandwidth_package_id  # type: str
        self.nat_gateway_id = nat_gateway_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBandwidthPackagesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth_package_id is not None:
            result['BandwidthPackageId'] = self.bandwidth_package_id
        if self.nat_gateway_id is not None:
            result['NatGatewayId'] = self.nat_gateway_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BandwidthPackageId') is not None:
            self.bandwidth_package_id = m.get('BandwidthPackageId')
        if m.get('NatGatewayId') is not None:
            self.nat_gateway_id = m.get('NatGatewayId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeBandwidthPackagesResponseBodyBandwidthPackagesBandwidthPackagePublicIpAddressesPublicIpAddresse(TeaModel):
    def __init__(self, allocation_id=None, ip_address=None):
        self.allocation_id = allocation_id  # type: str
        self.ip_address = ip_address  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeBandwidthPackagesResponseBodyBandwidthPackagesBandwidthPackagePublicIpAddressesPublicIpAddresse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allocation_id is not None:
            result['AllocationId'] = self.allocation_id
        if self.ip_address is not None:
            result['IpAddress'] = self.ip_address
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AllocationId') is not None:
            self.allocation_id = m.get('AllocationId')
        if m.get('IpAddress') is not None:
            self.ip_address = m.get('IpAddress')
        return self


class DescribeBandwidthPackagesResponseBodyBandwidthPackagesBandwidthPackagePublicIpAddresses(TeaModel):
    def __init__(self, public_ip_addresse=None):
        self.public_ip_addresse = public_ip_addresse  # type: list[DescribeBandwidthPackagesResponseBodyBandwidthPackagesBandwidthPackagePublicIpAddressesPublicIpAddresse]

    def validate(self):
        if self.public_ip_addresse:
            for k in self.public_ip_addresse:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeBandwidthPackagesResponseBodyBandwidthPackagesBandwidthPackagePublicIpAddresses, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PublicIpAddresse'] = []
        if self.public_ip_addresse is not None:
            for k in self.public_ip_addresse:
                result['PublicIpAddresse'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.public_ip_addresse = []
        if m.get('PublicIpAddresse') is not None:
            for k in m.get('PublicIpAddresse'):
                temp_model = DescribeBandwidthPackagesResponseBodyBandwidthPackagesBandwidthPackagePublicIpAddressesPublicIpAddresse()
                self.public_ip_addresse.append(temp_model.from_map(k))
        return self


class DescribeBandwidthPackagesResponseBodyBandwidthPackagesBandwidthPackage(TeaModel):
    def __init__(self, bandwidth=None, bandwidth_package_id=None, business_status=None, creation_time=None,
                 description=None, isp=None, instance_charge_type=None, internet_charge_type=None, ip_count=None, name=None,
                 nat_gateway_id=None, public_ip_addresses=None, region_id=None, status=None, zone_id=None):
        self.bandwidth = bandwidth  # type: str
        self.bandwidth_package_id = bandwidth_package_id  # type: str
        self.business_status = business_status  # type: str
        self.creation_time = creation_time  # type: str
        self.description = description  # type: str
        self.isp = isp  # type: str
        self.instance_charge_type = instance_charge_type  # type: str
        self.internet_charge_type = internet_charge_type  # type: str
        self.ip_count = ip_count  # type: str
        self.name = name  # type: str
        self.nat_gateway_id = nat_gateway_id  # type: str
        self.public_ip_addresses = public_ip_addresses  # type: DescribeBandwidthPackagesResponseBodyBandwidthPackagesBandwidthPackagePublicIpAddresses
        self.region_id = region_id  # type: str
        self.status = status  # type: str
        self.zone_id = zone_id  # type: str

    def validate(self):
        if self.public_ip_addresses:
            self.public_ip_addresses.validate()

    def to_map(self):
        _map = super(DescribeBandwidthPackagesResponseBodyBandwidthPackagesBandwidthPackage, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.bandwidth_package_id is not None:
            result['BandwidthPackageId'] = self.bandwidth_package_id
        if self.business_status is not None:
            result['BusinessStatus'] = self.business_status
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.isp is not None:
            result['ISP'] = self.isp
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.internet_charge_type is not None:
            result['InternetChargeType'] = self.internet_charge_type
        if self.ip_count is not None:
            result['IpCount'] = self.ip_count
        if self.name is not None:
            result['Name'] = self.name
        if self.nat_gateway_id is not None:
            result['NatGatewayId'] = self.nat_gateway_id
        if self.public_ip_addresses is not None:
            result['PublicIpAddresses'] = self.public_ip_addresses.to_map()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.status is not None:
            result['Status'] = self.status
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('BandwidthPackageId') is not None:
            self.bandwidth_package_id = m.get('BandwidthPackageId')
        if m.get('BusinessStatus') is not None:
            self.business_status = m.get('BusinessStatus')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ISP') is not None:
            self.isp = m.get('ISP')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('InternetChargeType') is not None:
            self.internet_charge_type = m.get('InternetChargeType')
        if m.get('IpCount') is not None:
            self.ip_count = m.get('IpCount')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NatGatewayId') is not None:
            self.nat_gateway_id = m.get('NatGatewayId')
        if m.get('PublicIpAddresses') is not None:
            temp_model = DescribeBandwidthPackagesResponseBodyBandwidthPackagesBandwidthPackagePublicIpAddresses()
            self.public_ip_addresses = temp_model.from_map(m['PublicIpAddresses'])
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeBandwidthPackagesResponseBodyBandwidthPackages(TeaModel):
    def __init__(self, bandwidth_package=None):
        self.bandwidth_package = bandwidth_package  # type: list[DescribeBandwidthPackagesResponseBodyBandwidthPackagesBandwidthPackage]

    def validate(self):
        if self.bandwidth_package:
            for k in self.bandwidth_package:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeBandwidthPackagesResponseBodyBandwidthPackages, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BandwidthPackage'] = []
        if self.bandwidth_package is not None:
            for k in self.bandwidth_package:
                result['BandwidthPackage'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.bandwidth_package = []
        if m.get('BandwidthPackage') is not None:
            for k in m.get('BandwidthPackage'):
                temp_model = DescribeBandwidthPackagesResponseBodyBandwidthPackagesBandwidthPackage()
                self.bandwidth_package.append(temp_model.from_map(k))
        return self


class DescribeBandwidthPackagesResponseBody(TeaModel):
    def __init__(self, bandwidth_packages=None, page_number=None, page_size=None, request_id=None, total_count=None):
        self.bandwidth_packages = bandwidth_packages  # type: DescribeBandwidthPackagesResponseBodyBandwidthPackages
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.bandwidth_packages:
            self.bandwidth_packages.validate()

    def to_map(self):
        _map = super(DescribeBandwidthPackagesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth_packages is not None:
            result['BandwidthPackages'] = self.bandwidth_packages.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BandwidthPackages') is not None:
            temp_model = DescribeBandwidthPackagesResponseBodyBandwidthPackages()
            self.bandwidth_packages = temp_model.from_map(m['BandwidthPackages'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeBandwidthPackagesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeBandwidthPackagesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeBandwidthPackagesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBandwidthPackagesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCapacityReservationInstancesRequestPrivatePoolOptions(TeaModel):
    def __init__(self, id=None):
        self.id = id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCapacityReservationInstancesRequestPrivatePoolOptions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DescribeCapacityReservationInstancesRequest(TeaModel):
    def __init__(self, private_pool_options=None, max_results=None, next_token=None, owner_account=None,
                 owner_id=None, region_id=None, resource_owner_account=None, resource_owner_id=None):
        self.private_pool_options = private_pool_options  # type: DescribeCapacityReservationInstancesRequestPrivatePoolOptions
        self.max_results = max_results  # type: int
        self.next_token = next_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        if self.private_pool_options:
            self.private_pool_options.validate()

    def to_map(self):
        _map = super(DescribeCapacityReservationInstancesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.private_pool_options is not None:
            result['PrivatePoolOptions'] = self.private_pool_options.to_map()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PrivatePoolOptions') is not None:
            temp_model = DescribeCapacityReservationInstancesRequestPrivatePoolOptions()
            self.private_pool_options = temp_model.from_map(m['PrivatePoolOptions'])
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeCapacityReservationInstancesResponseBodyCapacityReservationItemInstanceIdSet(TeaModel):
    def __init__(self, instance_id=None):
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCapacityReservationInstancesResponseBodyCapacityReservationItemInstanceIdSet, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DescribeCapacityReservationInstancesResponseBodyCapacityReservationItem(TeaModel):
    def __init__(self, instance_id_set=None):
        self.instance_id_set = instance_id_set  # type: list[DescribeCapacityReservationInstancesResponseBodyCapacityReservationItemInstanceIdSet]

    def validate(self):
        if self.instance_id_set:
            for k in self.instance_id_set:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCapacityReservationInstancesResponseBodyCapacityReservationItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['InstanceIdSet'] = []
        if self.instance_id_set is not None:
            for k in self.instance_id_set:
                result['InstanceIdSet'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.instance_id_set = []
        if m.get('InstanceIdSet') is not None:
            for k in m.get('InstanceIdSet'):
                temp_model = DescribeCapacityReservationInstancesResponseBodyCapacityReservationItemInstanceIdSet()
                self.instance_id_set.append(temp_model.from_map(k))
        return self


class DescribeCapacityReservationInstancesResponseBody(TeaModel):
    def __init__(self, capacity_reservation_item=None, max_results=None, next_token=None, request_id=None,
                 total_count=None):
        self.capacity_reservation_item = capacity_reservation_item  # type: DescribeCapacityReservationInstancesResponseBodyCapacityReservationItem
        self.max_results = max_results  # type: int
        self.next_token = next_token  # type: str
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.capacity_reservation_item:
            self.capacity_reservation_item.validate()

    def to_map(self):
        _map = super(DescribeCapacityReservationInstancesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.capacity_reservation_item is not None:
            result['CapacityReservationItem'] = self.capacity_reservation_item.to_map()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CapacityReservationItem') is not None:
            temp_model = DescribeCapacityReservationInstancesResponseBodyCapacityReservationItem()
            self.capacity_reservation_item = temp_model.from_map(m['CapacityReservationItem'])
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeCapacityReservationInstancesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCapacityReservationInstancesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCapacityReservationInstancesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCapacityReservationInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCapacityReservationsRequestPrivatePoolOptions(TeaModel):
    def __init__(self, ids=None):
        self.ids = ids  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCapacityReservationsRequestPrivatePoolOptions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ids is not None:
            result['Ids'] = self.ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Ids') is not None:
            self.ids = m.get('Ids')
        return self


class DescribeCapacityReservationsRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCapacityReservationsRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeCapacityReservationsRequest(TeaModel):
    def __init__(self, private_pool_options=None, instance_charge_type=None, instance_type=None, max_results=None,
                 next_token=None, owner_account=None, owner_id=None, platform=None, region_id=None, resource_group_id=None,
                 resource_owner_account=None, resource_owner_id=None, status=None, tag=None, zone_id=None):
        self.private_pool_options = private_pool_options  # type: DescribeCapacityReservationsRequestPrivatePoolOptions
        self.instance_charge_type = instance_charge_type  # type: str
        self.instance_type = instance_type  # type: str
        self.max_results = max_results  # type: int
        self.next_token = next_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.platform = platform  # type: str
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.status = status  # type: str
        self.tag = tag  # type: list[DescribeCapacityReservationsRequestTag]
        self.zone_id = zone_id  # type: str

    def validate(self):
        if self.private_pool_options:
            self.private_pool_options.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCapacityReservationsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.private_pool_options is not None:
            result['PrivatePoolOptions'] = self.private_pool_options.to_map()
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.platform is not None:
            result['Platform'] = self.platform
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.status is not None:
            result['Status'] = self.status
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PrivatePoolOptions') is not None:
            temp_model = DescribeCapacityReservationsRequestPrivatePoolOptions()
            self.private_pool_options = temp_model.from_map(m['PrivatePoolOptions'])
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Platform') is not None:
            self.platform = m.get('Platform')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeCapacityReservationsRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeCapacityReservationsResponseBodyCapacityReservationSetCapacityReservationItemAllocatedResourcesAllocatedResource(TeaModel):
    def __init__(self, instance_type=None, total_amount=None, used_amount=None, zone_id=None):
        self.instance_type = instance_type  # type: str
        self.total_amount = total_amount  # type: int
        self.used_amount = used_amount  # type: int
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCapacityReservationsResponseBodyCapacityReservationSetCapacityReservationItemAllocatedResourcesAllocatedResource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.total_amount is not None:
            result['TotalAmount'] = self.total_amount
        if self.used_amount is not None:
            result['UsedAmount'] = self.used_amount
        if self.zone_id is not None:
            result['zoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('TotalAmount') is not None:
            self.total_amount = m.get('TotalAmount')
        if m.get('UsedAmount') is not None:
            self.used_amount = m.get('UsedAmount')
        if m.get('zoneId') is not None:
            self.zone_id = m.get('zoneId')
        return self


class DescribeCapacityReservationsResponseBodyCapacityReservationSetCapacityReservationItemAllocatedResources(TeaModel):
    def __init__(self, allocated_resource=None):
        self.allocated_resource = allocated_resource  # type: list[DescribeCapacityReservationsResponseBodyCapacityReservationSetCapacityReservationItemAllocatedResourcesAllocatedResource]

    def validate(self):
        if self.allocated_resource:
            for k in self.allocated_resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCapacityReservationsResponseBodyCapacityReservationSetCapacityReservationItemAllocatedResources, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AllocatedResource'] = []
        if self.allocated_resource is not None:
            for k in self.allocated_resource:
                result['AllocatedResource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.allocated_resource = []
        if m.get('AllocatedResource') is not None:
            for k in m.get('AllocatedResource'):
                temp_model = DescribeCapacityReservationsResponseBodyCapacityReservationSetCapacityReservationItemAllocatedResourcesAllocatedResource()
                self.allocated_resource.append(temp_model.from_map(k))
        return self


class DescribeCapacityReservationsResponseBodyCapacityReservationSetCapacityReservationItemTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key  # type: str
        self.tag_value = tag_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCapacityReservationsResponseBodyCapacityReservationSetCapacityReservationItemTagsTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class DescribeCapacityReservationsResponseBodyCapacityReservationSetCapacityReservationItemTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag  # type: list[DescribeCapacityReservationsResponseBodyCapacityReservationSetCapacityReservationItemTagsTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCapacityReservationsResponseBodyCapacityReservationSetCapacityReservationItemTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeCapacityReservationsResponseBodyCapacityReservationSetCapacityReservationItemTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeCapacityReservationsResponseBodyCapacityReservationSetCapacityReservationItem(TeaModel):
    def __init__(self, allocated_resources=None, description=None, end_time=None, end_time_type=None,
                 instance_charge_type=None, platform=None, private_pool_options_id=None, private_pool_options_match_criteria=None,
                 private_pool_options_name=None, region_id=None, reserved_instance_id=None, resource_group_id=None, saving_plan_id=None,
                 start_time=None, start_time_type=None, status=None, tags=None, time_slot=None):
        self.allocated_resources = allocated_resources  # type: DescribeCapacityReservationsResponseBodyCapacityReservationSetCapacityReservationItemAllocatedResources
        self.description = description  # type: str
        self.end_time = end_time  # type: str
        self.end_time_type = end_time_type  # type: str
        self.instance_charge_type = instance_charge_type  # type: str
        self.platform = platform  # type: str
        self.private_pool_options_id = private_pool_options_id  # type: str
        self.private_pool_options_match_criteria = private_pool_options_match_criteria  # type: str
        self.private_pool_options_name = private_pool_options_name  # type: str
        self.region_id = region_id  # type: str
        self.reserved_instance_id = reserved_instance_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.saving_plan_id = saving_plan_id  # type: str
        self.start_time = start_time  # type: str
        self.start_time_type = start_time_type  # type: str
        self.status = status  # type: str
        self.tags = tags  # type: DescribeCapacityReservationsResponseBodyCapacityReservationSetCapacityReservationItemTags
        self.time_slot = time_slot  # type: str

    def validate(self):
        if self.allocated_resources:
            self.allocated_resources.validate()
        if self.tags:
            self.tags.validate()

    def to_map(self):
        _map = super(DescribeCapacityReservationsResponseBodyCapacityReservationSetCapacityReservationItem, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allocated_resources is not None:
            result['AllocatedResources'] = self.allocated_resources.to_map()
        if self.description is not None:
            result['Description'] = self.description
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.end_time_type is not None:
            result['EndTimeType'] = self.end_time_type
        if self.instance_charge_type is not None:
            result['InstanceChargeType'] = self.instance_charge_type
        if self.platform is not None:
            result['Platform'] = self.platform
        if self.private_pool_options_id is not None:
            result['PrivatePoolOptionsId'] = self.private_pool_options_id
        if self.private_pool_options_match_criteria is not None:
            result['PrivatePoolOptionsMatchCriteria'] = self.private_pool_options_match_criteria
        if self.private_pool_options_name is not None:
            result['PrivatePoolOptionsName'] = self.private_pool_options_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.reserved_instance_id is not None:
            result['ReservedInstanceId'] = self.reserved_instance_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.saving_plan_id is not None:
            result['SavingPlanId'] = self.saving_plan_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.start_time_type is not None:
            result['StartTimeType'] = self.start_time_type
        if self.status is not None:
            result['Status'] = self.status
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.time_slot is not None:
            result['TimeSlot'] = self.time_slot
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AllocatedResources') is not None:
            temp_model = DescribeCapacityReservationsResponseBodyCapacityReservationSetCapacityReservationItemAllocatedResources()
            self.allocated_resources = temp_model.from_map(m['AllocatedResources'])
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EndTimeType') is not None:
            self.end_time_type = m.get('EndTimeType')
        if m.get('InstanceChargeType') is not None:
            self.instance_charge_type = m.get('InstanceChargeType')
        if m.get('Platform') is not None:
            self.platform = m.get('Platform')
        if m.get('PrivatePoolOptionsId') is not None:
            self.private_pool_options_id = m.get('PrivatePoolOptionsId')
        if m.get('PrivatePoolOptionsMatchCriteria') is not None:
            self.private_pool_options_match_criteria = m.get('PrivatePoolOptionsMatchCriteria')
        if m.get('PrivatePoolOptionsName') is not None:
            self.private_pool_options_name = m.get('PrivatePoolOptionsName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ReservedInstanceId') is not None:
            self.reserved_instance_id = m.get('ReservedInstanceId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SavingPlanId') is not None:
            self.saving_plan_id = m.get('SavingPlanId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StartTimeType') is not None:
            self.start_time_type = m.get('StartTimeType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tags') is not None:
            temp_model = DescribeCapacityReservationsResponseBodyCapacityReservationSetCapacityReservationItemTags()
            self.tags = temp_model.from_map(m['Tags'])
        if m.get('TimeSlot') is not None:
            self.time_slot = m.get('TimeSlot')
        return self


class DescribeCapacityReservationsResponseBodyCapacityReservationSet(TeaModel):
    def __init__(self, capacity_reservation_item=None):
        self.capacity_reservation_item = capacity_reservation_item  # type: list[DescribeCapacityReservationsResponseBodyCapacityReservationSetCapacityReservationItem]

    def validate(self):
        if self.capacity_reservation_item:
            for k in self.capacity_reservation_item:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCapacityReservationsResponseBodyCapacityReservationSet, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CapacityReservationItem'] = []
        if self.capacity_reservation_item is not None:
            for k in self.capacity_reservation_item:
                result['CapacityReservationItem'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.capacity_reservation_item = []
        if m.get('CapacityReservationItem') is not None:
            for k in m.get('CapacityReservationItem'):
                temp_model = DescribeCapacityReservationsResponseBodyCapacityReservationSetCapacityReservationItem()
                self.capacity_reservation_item.append(temp_model.from_map(k))
        return self


class DescribeCapacityReservationsResponseBody(TeaModel):
    def __init__(self, capacity_reservation_set=None, max_results=None, next_token=None, request_id=None,
                 total_count=None):
        self.capacity_reservation_set = capacity_reservation_set  # type: DescribeCapacityReservationsResponseBodyCapacityReservationSet
        self.max_results = max_results  # type: int
        self.next_token = next_token  # type: str
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.capacity_reservation_set:
            self.capacity_reservation_set.validate()

    def to_map(self):
        _map = super(DescribeCapacityReservationsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.capacity_reservation_set is not None:
            result['CapacityReservationSet'] = self.capacity_reservation_set.to_map()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CapacityReservationSet') is not None:
            temp_model = DescribeCapacityReservationsResponseBodyCapacityReservationSet()
            self.capacity_reservation_set = temp_model.from_map(m['CapacityReservationSet'])
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeCapacityReservationsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCapacityReservationsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCapacityReservationsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCapacityReservationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClassicLinkInstancesRequest(TeaModel):
    def __init__(self, instance_id=None, owner_id=None, page_number=None, page_size=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None, vpc_id=None):
        self.instance_id = instance_id  # type: str
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: str
        self.page_size = page_size  # type: str
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.vpc_id = vpc_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClassicLinkInstancesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class DescribeClassicLinkInstancesResponseBodyLinksLink(TeaModel):
    def __init__(self, instance_id=None, vpc_id=None):
        self.instance_id = instance_id  # type: str
        self.vpc_id = vpc_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClassicLinkInstancesResponseBodyLinksLink, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class DescribeClassicLinkInstancesResponseBodyLinks(TeaModel):
    def __init__(self, link=None):
        self.link = link  # type: list[DescribeClassicLinkInstancesResponseBodyLinksLink]

    def validate(self):
        if self.link:
            for k in self.link:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeClassicLinkInstancesResponseBodyLinks, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Link'] = []
        if self.link is not None:
            for k in self.link:
                result['Link'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.link = []
        if m.get('Link') is not None:
            for k in m.get('Link'):
                temp_model = DescribeClassicLinkInstancesResponseBodyLinksLink()
                self.link.append(temp_model.from_map(k))
        return self


class DescribeClassicLinkInstancesResponseBody(TeaModel):
    def __init__(self, links=None, page_number=None, page_size=None, request_id=None, total_count=None):
        self.links = links  # type: DescribeClassicLinkInstancesResponseBodyLinks
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        if self.links:
            self.links.validate()

    def to_map(self):
        _map = super(DescribeClassicLinkInstancesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.links is not None:
            result['Links'] = self.links.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Links') is not None:
            temp_model = DescribeClassicLinkInstancesResponseBodyLinks()
            self.links = temp_model.from_map(m['Links'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeClassicLinkInstancesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeClassicLinkInstancesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeClassicLinkInstancesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeClassicLinkInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCloudAssistantStatusRequest(TeaModel):
    def __init__(self, instance_id=None, ostype=None, owner_account=None, owner_id=None, page_number=None,
                 page_size=None, region_id=None, resource_owner_account=None, resource_owner_id=None):
        self.instance_id = instance_id  # type: list[str]
        self.ostype = ostype  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCloudAssistantStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.ostype is not None:
            result['OSType'] = self.ostype
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OSType') is not None:
            self.ostype = m.get('OSType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeCloudAssistantStatusResponseBodyInstanceCloudAssistantStatusSetInstanceCloudAssistantStatus(TeaModel):
    def __init__(self, active_task_count=None, cloud_assistant_status=None, cloud_assistant_version=None,
                 instance_id=None, invocation_count=None, last_heartbeat_time=None, last_invoked_time=None, ostype=None,
                 support_session_manager=None):
        self.active_task_count = active_task_count  # type: long
        self.cloud_assistant_status = cloud_assistant_status  # type: str
        self.cloud_assistant_version = cloud_assistant_version  # type: str
        self.instance_id = instance_id  # type: str
        self.invocation_count = invocation_count  # type: long
        self.last_heartbeat_time = last_heartbeat_time  # type: str
        self.last_invoked_time = last_invoked_time  # type: str
        self.ostype = ostype  # type: str
        self.support_session_manager = support_session_manager  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCloudAssistantStatusResponseBodyInstanceCloudAssistantStatusSetInstanceCloudAssistantStatus, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active_task_count is not None:
            result['ActiveTaskCount'] = self.active_task_count
        if self.cloud_assistant_status is not None:
            result['CloudAssistantStatus'] = self.cloud_assistant_status
        if self.cloud_assistant_version is not None:
            result['CloudAssistantVersion'] = self.cloud_assistant_version
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.invocation_count is not None:
            result['InvocationCount'] = self.invocation_count
        if self.last_heartbeat_time is not None:
            result['LastHeartbeatTime'] = self.last_heartbeat_time
        if self.last_invoked_time is not None:
            result['LastInvokedTime'] = self.last_invoked_time
        if self.ostype is not None:
            result['OSType'] = self.ostype
        if self.support_session_manager is not None:
            result['SupportSessionManager'] = self.support_session_manager
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActiveTaskCount') is not None:
            self.active_task_count = m.get('ActiveTaskCount')
        if m.get('CloudAssistantStatus') is not None:
            self.cloud_assistant_status = m.get('CloudAssistantStatus')
        if m.get('CloudAssistantVersion') is not None:
            self.cloud_assistant_version = m.get('CloudAssistantVersion')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InvocationCount') is not None:
            self.invocation_count = m.get('InvocationCount')
        if m.get('LastHeartbeatTime') is not None:
            self.last_heartbeat_time = m.get('LastHeartbeatTime')
        if m.get('LastInvokedTime') is not None:
            self.last_invoked_time = m.get('LastInvokedTime')
        if m.get('OSType') is not None:
            self.ostype = m.get('OSType')
        if m.get('SupportSessionManager') is not None:
            self.support_session_manager = m.get('SupportSessionManager')
        return self


class DescribeCloudAssistantStatusResponseBodyInstanceCloudAssistantStatusSet(TeaModel):
    def __init__(self, instance_cloud_assistant_status=None):
        self.instance_cloud_assistant_status = instance_cloud_assistant_status  # type: list[DescribeCloudAssistantStatusResponseBodyInstanceCloudAssistantStatusSetInstanceCloudAssistantStatus]

    def validate(self):
        if self.instance_cloud_assistant_status:
            for k in self.instance_cloud_assistant_status:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCloudAssistantStatusResponseBodyInstanceCloudAssistantStatusSet, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['InstanceCloudAssistantStatus'] = []
        if self.instance_cloud_assistant_status is not None:
            for k in self.instance_cloud_assistant_status:
                result['InstanceCloudAssistantStatus'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.instance_cloud_assistant_status = []
        if m.get('InstanceCloudAssistantStatus') is not None:
            for k in m.get('InstanceCloudAssistantStatus'):
                temp_model = DescribeCloudAssistantStatusResponseBodyInstanceCloudAssistantStatusSetInstanceCloudAssistantStatus()
                self.instance_cloud_assistant_status.append(temp_model.from_map(k))
        return self


class DescribeCloudAssistantStatusResponseBody(TeaModel):
    def __init__(self, instance_cloud_assistant_status_set=None, page_number=None, page_size=None, request_id=None,
                 total_count=None):
        self.instance_cloud_assistant_status_set = instance_cloud_assistant_status_set  # type: DescribeCloudAssistantStatusResponseBodyInstanceCloudAssistantStatusSet
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: long

    def validate(self):
        if self.instance_cloud_assistant_status_set:
            self.instance_cloud_assistant_status_set.validate()

    def to_map(self):
        _map = super(DescribeCloudAssistantStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_cloud_assistant_status_set is not None:
            result['InstanceCloudAssistantStatusSet'] = self.instance_cloud_assistant_status_set.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceCloudAssistantStatusSet') is not None:
            temp_model = DescribeCloudAssistantStatusResponseBodyInstanceCloudAssistantStatusSet()
            self.instance_cloud_assistant_status_set = temp_model.from_map(m['InstanceCloudAssistantStatusSet'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeCloudAssistantStatusResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCloudAssistantStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCloudAssistantStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCloudAssistantStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClustersRequest(TeaModel):
    def __init__(self, owner_account=None, owner_id=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClustersRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeClustersResponseBodyClustersCluster(TeaModel):
    def __init__(self, cluster_id=None):
        self.cluster_id = cluster_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeClustersResponseBodyClustersCluster, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class DescribeClustersResponseBodyClusters(TeaModel):
    def __init__(self, cluster=None):
        self.cluster = cluster  # type: list[DescribeClustersResponseBodyClustersCluster]

    def validate(self):
        if self.cluster:
            for k in self.cluster:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeClustersResponseBodyClusters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Cluster'] = []
        if self.cluster is not None:
            for k in self.cluster:
                result['Cluster'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.cluster = []
        if m.get('Cluster') is not None:
            for k in m.get('Cluster'):
                temp_model = DescribeClustersResponseBodyClustersCluster()
                self.cluster.append(temp_model.from_map(k))
        return self


class DescribeClustersResponseBody(TeaModel):
    def __init__(self, clusters=None, request_id=None):
        self.clusters = clusters  # type: DescribeClustersResponseBodyClusters
        self.request_id = request_id  # type: str

    def validate(self):
        if self.clusters:
            self.clusters.validate()

    def to_map(self):
        _map = super(DescribeClustersResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.clusters is not None:
            result['Clusters'] = self.clusters.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Clusters') is not None:
            temp_model = DescribeClustersResponseBodyClusters()
            self.clusters = temp_model.from_map(m['Clusters'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeClustersResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeClustersResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeClustersResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeClustersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCommandsRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCommandsRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeCommandsRequest(TeaModel):
    def __init__(self, command_id=None, content_encoding=None, description=None, latest=None, name=None,
                 owner_account=None, owner_id=None, page_number=None, page_size=None, provider=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None, tag=None, type=None):
        self.command_id = command_id  # type: str
        self.content_encoding = content_encoding  # type: str
        self.description = description  # type: str
        self.latest = latest  # type: bool
        self.name = name  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.provider = provider  # type: str
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.tag = tag  # type: list[DescribeCommandsRequestTag]
        self.type = type  # type: str

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCommandsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.command_id is not None:
            result['CommandId'] = self.command_id
        if self.content_encoding is not None:
            result['ContentEncoding'] = self.content_encoding
        if self.description is not None:
            result['Description'] = self.description
        if self.latest is not None:
            result['Latest'] = self.latest
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.provider is not None:
            result['Provider'] = self.provider
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CommandId') is not None:
            self.command_id = m.get('CommandId')
        if m.get('ContentEncoding') is not None:
            self.content_encoding = m.get('ContentEncoding')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Latest') is not None:
            self.latest = m.get('Latest')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Provider') is not None:
            self.provider = m.get('Provider')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeCommandsRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeCommandsResponseBodyCommandsCommandParameterDefinitionsParameterDefinitionPossibleValues(TeaModel):
    def __init__(self, possible_value=None):
        self.possible_value = possible_value  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCommandsResponseBodyCommandsCommandParameterDefinitionsParameterDefinitionPossibleValues, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.possible_value is not None:
            result['PossibleValue'] = self.possible_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PossibleValue') is not None:
            self.possible_value = m.get('PossibleValue')
        return self


class DescribeCommandsResponseBodyCommandsCommandParameterDefinitionsParameterDefinition(TeaModel):
    def __init__(self, default_value=None, description=None, parameter_name=None, possible_values=None,
                 required=None):
        self.default_value = default_value  # type: str
        self.description = description  # type: str
        self.parameter_name = parameter_name  # type: str
        self.possible_values = possible_values  # type: DescribeCommandsResponseBodyCommandsCommandParameterDefinitionsParameterDefinitionPossibleValues
        self.required = required  # type: bool

    def validate(self):
        if self.possible_values:
            self.possible_values.validate()

    def to_map(self):
        _map = super(DescribeCommandsResponseBodyCommandsCommandParameterDefinitionsParameterDefinition, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.description is not None:
            result['Description'] = self.description
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        if self.possible_values is not None:
            result['PossibleValues'] = self.possible_values.to_map()
        if self.required is not None:
            result['Required'] = self.required
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        if m.get('PossibleValues') is not None:
            temp_model = DescribeCommandsResponseBodyCommandsCommandParameterDefinitionsParameterDefinitionPossibleValues()
            self.possible_values = temp_model.from_map(m['PossibleValues'])
        if m.get('Required') is not None:
            self.required = m.get('Required')
        return self


class DescribeCommandsResponseBodyCommandsCommandParameterDefinitions(TeaModel):
    def __init__(self, parameter_definition=None):
        self.parameter_definition = parameter_definition  # type: list[DescribeCommandsResponseBodyCommandsCommandParameterDefinitionsParameterDefinition]

    def validate(self):
        if self.parameter_definition:
            for k in self.parameter_definition:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCommandsResponseBodyCommandsCommandParameterDefinitions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ParameterDefinition'] = []
        if self.parameter_definition is not None:
            for k in self.parameter_definition:
                result['ParameterDefinition'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.parameter_definition = []
        if m.get('ParameterDefinition') is not None:
            for k in m.get('ParameterDefinition'):
                temp_model = DescribeCommandsResponseBodyCommandsCommandParameterDefinitionsParameterDefinition()
                self.parameter_definition.append(temp_model.from_map(k))
        return self


class DescribeCommandsResponseBodyCommandsCommandParameterNames(TeaModel):
    def __init__(self, parameter_name=None):
        self.parameter_name = parameter_name  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCommandsResponseBodyCommandsCommandParameterNames, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.parameter_name is not None:
            result['ParameterName'] = self.parameter_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ParameterName') is not None:
            self.parameter_name = m.get('ParameterName')
        return self


class DescribeCommandsResponseBodyCommandsCommandTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key  # type: str
        self.tag_value = tag_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCommandsResponseBodyCommandsCommandTagsTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class DescribeCommandsResponseBodyCommandsCommandTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag  # type: list[DescribeCommandsResponseBodyCommandsCommandTagsTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCommandsResponseBodyCommandsCommandTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeCommandsResponseBodyCommandsCommandTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeCommandsResponseBodyCommandsCommand(TeaModel):
    def __init__(self, category=None, command_content=None, command_id=None, creation_time=None, description=None,
                 enable_parameter=None, invoke_times=None, latest=None, name=None, parameter_definitions=None, parameter_names=None,
                 provider=None, tags=None, timeout=None, type=None, version=None, working_dir=None):
        self.category = category  # type: str
        self.command_content = command_content  # type: str
        self.command_id = command_id  # type: str
        self.creation_time = creation_time  # type: str
        self.description = description  # type: str
        self.enable_parameter = enable_parameter  # type: bool
        self.invoke_times = invoke_times  # type: int
        self.latest = latest  # type: bool
        self.name = name  # type: str
        self.parameter_definitions = parameter_definitions  # type: DescribeCommandsResponseBodyCommandsCommandParameterDefinitions
        self.parameter_names = parameter_names  # type: DescribeCommandsResponseBodyCommandsCommandParameterNames
        self.provider = provider  # type: str
        self.tags = tags  # type: DescribeCommandsResponseBodyCommandsCommandTags
        self.timeout = timeout  # type: long
        self.type = type  # type: str
        self.version = version  # type: int
        self.working_dir = working_dir  # type: str

    def validate(self):
        if self.parameter_definitions:
            self.parameter_definitions.validate()
        if self.parameter_names:
            self.parameter_names.validate()
        if self.tags:
            self.tags.validate()

    def to_map(self):
        _map = super(DescribeCommandsResponseBodyCommandsCommand, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.command_content is not None:
            result['CommandContent'] = self.command_content
        if self.command_id is not None:
            result['CommandId'] = self.command_id
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.enable_parameter is not None:
            result['EnableParameter'] = self.enable_parameter
        if self.invoke_times is not None:
            result['InvokeTimes'] = self.invoke_times
        if self.latest is not None:
            result['Latest'] = self.latest
        if self.name is not None:
            result['Name'] = self.name
        if self.parameter_definitions is not None:
            result['ParameterDefinitions'] = self.parameter_definitions.to_map()
        if self.parameter_names is not None:
            result['ParameterNames'] = self.parameter_names.to_map()
        if self.provider is not None:
            result['Provider'] = self.provider
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        if self.type is not None:
            result['Type'] = self.type
        if self.version is not None:
            result['Version'] = self.version
        if self.working_dir is not None:
            result['WorkingDir'] = self.working_dir
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('CommandContent') is not None:
            self.command_content = m.get('CommandContent')
        if m.get('CommandId') is not None:
            self.command_id = m.get('CommandId')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnableParameter') is not None:
            self.enable_parameter = m.get('EnableParameter')
        if m.get('InvokeTimes') is not None:
            self.invoke_times = m.get('InvokeTimes')
        if m.get('Latest') is not None:
            self.latest = m.get('Latest')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ParameterDefinitions') is not None:
            temp_model = DescribeCommandsResponseBodyCommandsCommandParameterDefinitions()
            self.parameter_definitions = temp_model.from_map(m['ParameterDefinitions'])
        if m.get('ParameterNames') is not None:
            temp_model = DescribeCommandsResponseBodyCommandsCommandParameterNames()
            self.parameter_names = temp_model.from_map(m['ParameterNames'])
        if m.get('Provider') is not None:
            self.provider = m.get('Provider')
        if m.get('Tags') is not None:
            temp_model = DescribeCommandsResponseBodyCommandsCommandTags()
            self.tags = temp_model.from_map(m['Tags'])
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        if m.get('WorkingDir') is not None:
            self.working_dir = m.get('WorkingDir')
        return self


class DescribeCommandsResponseBodyCommands(TeaModel):
    def __init__(self, command=None):
        self.command = command  # type: list[DescribeCommandsResponseBodyCommandsCommand]

    def validate(self):
        if self.command:
            for k in self.command:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCommandsResponseBodyCommands, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Command'] = []
        if self.command is not None:
            for k in self.command:
                result['Command'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.command = []
        if m.get('Command') is not None:
            for k in m.get('Command'):
                temp_model = DescribeCommandsResponseBodyCommandsCommand()
                self.command.append(temp_model.from_map(k))
        return self


class DescribeCommandsResponseBody(TeaModel):
    def __init__(self, commands=None, page_number=None, page_size=None, request_id=None, total_count=None):
        self.commands = commands  # type: DescribeCommandsResponseBodyCommands
        self.page_number = page_number  # type: long
        self.page_size = page_size  # type: long
        self.request_id = request_id  # type: str
        self.total_count = total_count  # type: long

    def validate(self):
        if self.commands:
            self.commands.validate()

    def to_map(self):
        _map = super(DescribeCommandsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.commands is not None:
            result['Commands'] = self.commands.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Commands') is not None:
            temp_model = DescribeCommandsResponseBodyCommands()
            self.commands = temp_model.from_map(m['Commands'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeCommandsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCommandsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCommandsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCommandsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDedicatedBlockStorageClustersRequest(TeaModel):
    def __init__(self, category=None, dedicated_block_storage_cluster_id=None, max_results=None, next_token=None,
                 owner_account=None, owner_id=None, region_id=None, resource_owner_account=None, resource_owner_id=None,
                 status=None, zone_id=None):
        self.category = category  # type: str
        self.dedicated_block_storage_cluster_id = dedicated_block_storage_cluster_id  # type: list[str]
        self.max_results = max_results  # type: int
        self.next_token = next_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.status = status  # type: list[str]
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDedicatedBlockStorageClustersRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.dedicated_block_storage_cluster_id is not None:
            result['DedicatedBlockStorageClusterId'] = self.dedicated_block_storage_cluster_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.status is not None:
            result['Status'] = self.status
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('DedicatedBlockStorageClusterId') is not None:
            self.dedicated_block_storage_cluster_id = m.get('DedicatedBlockStorageClusterId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeDedicatedBlockStorageClustersResponseBodyDedicatedBlockStorageClustersDedicatedBlockStorageClusterDedicatedBlockStorageClusterCapacity(TeaModel):
    def __init__(self, available_capacity=None, total_capacity=None):
        self.available_capacity = available_capacity  # type: long
        self.total_capacity = total_capacity  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDedicatedBlockStorageClustersResponseBodyDedicatedBlockStorageClustersDedicatedBlockStorageClusterDedicatedBlockStorageClusterCapacity, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.available_capacity is not None:
            result['AvailableCapacity'] = self.available_capacity
        if self.total_capacity is not None:
            result['TotalCapacity'] = self.total_capacity
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvailableCapacity') is not None:
            self.available_capacity = m.get('AvailableCapacity')
        if m.get('TotalCapacity') is not None:
            self.total_capacity = m.get('TotalCapacity')
        return self


class DescribeDedicatedBlockStorageClustersResponseBodyDedicatedBlockStorageClustersDedicatedBlockStorageCluster(TeaModel):
    def __init__(self, category=None, create_time=None, dedicated_block_storage_cluster_capacity=None,
                 dedicated_block_storage_cluster_id=None, dedicated_block_storage_cluster_name=None, description=None, expired_time=None, status=None,
                 type=None, zone_id=None):
        self.category = category  # type: str
        self.create_time = create_time  # type: str
        self.dedicated_block_storage_cluster_capacity = dedicated_block_storage_cluster_capacity  # type: DescribeDedicatedBlockStorageClustersResponseBodyDedicatedBlockStorageClustersDedicatedBlockStorageClusterDedicatedBlockStorageClusterCapacity
        self.dedicated_block_storage_cluster_id = dedicated_block_storage_cluster_id  # type: str
        self.dedicated_block_storage_cluster_name = dedicated_block_storage_cluster_name  # type: str
        self.description = description  # type: str
        self.expired_time = expired_time  # type: str
        self.status = status  # type: str
        self.type = type  # type: str
        self.zone_id = zone_id  # type: str

    def validate(self):
        if self.dedicated_block_storage_cluster_capacity:
            self.dedicated_block_storage_cluster_capacity.validate()

    def to_map(self):
        _map = super(DescribeDedicatedBlockStorageClustersResponseBodyDedicatedBlockStorageClustersDedicatedBlockStorageCluster, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category is not None:
            result['Category'] = self.category
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.dedicated_block_storage_cluster_capacity is not None:
            result['DedicatedBlockStorageClusterCapacity'] = self.dedicated_block_storage_cluster_capacity.to_map()
        if self.dedicated_block_storage_cluster_id is not None:
            result['DedicatedBlockStorageClusterId'] = self.dedicated_block_storage_cluster_id
        if self.dedicated_block_storage_cluster_name is not None:
            result['DedicatedBlockStorageClusterName'] = self.dedicated_block_storage_cluster_name
        if self.description is not None:
            result['Description'] = self.description
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Category') is not None:
            self.category = m.get('Category')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DedicatedBlockStorageClusterCapacity') is not None:
            temp_model = DescribeDedicatedBlockStorageClustersResponseBodyDedicatedBlockStorageClustersDedicatedBlockStorageClusterDedicatedBlockStorageClusterCapacity()
            self.dedicated_block_storage_cluster_capacity = temp_model.from_map(m['DedicatedBlockStorageClusterCapacity'])
        if m.get('DedicatedBlockStorageClusterId') is not None:
            self.dedicated_block_storage_cluster_id = m.get('DedicatedBlockStorageClusterId')
        if m.get('DedicatedBlockStorageClusterName') is not None:
            self.dedicated_block_storage_cluster_name = m.get('DedicatedBlockStorageClusterName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeDedicatedBlockStorageClustersResponseBodyDedicatedBlockStorageClusters(TeaModel):
    def __init__(self, dedicated_block_storage_cluster=None):
        self.dedicated_block_storage_cluster = dedicated_block_storage_cluster  # type: list[DescribeDedicatedBlockStorageClustersResponseBodyDedicatedBlockStorageClustersDedicatedBlockStorageCluster]

    def validate(self):
        if self.dedicated_block_storage_cluster:
            for k in self.dedicated_block_storage_cluster:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDedicatedBlockStorageClustersResponseBodyDedicatedBlockStorageClusters, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DedicatedBlockStorageCluster'] = []
        if self.dedicated_block_storage_cluster is not None:
            for k in self.dedicated_block_storage_cluster:
                result['DedicatedBlockStorageCluster'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.dedicated_block_storage_cluster = []
        if m.get('DedicatedBlockStorageCluster') is not None:
            for k in m.get('DedicatedBlockStorageCluster'):
                temp_model = DescribeDedicatedBlockStorageClustersResponseBodyDedicatedBlockStorageClustersDedicatedBlockStorageCluster()
                self.dedicated_block_storage_cluster.append(temp_model.from_map(k))
        return self


class DescribeDedicatedBlockStorageClustersResponseBody(TeaModel):
    def __init__(self, dedicated_block_storage_clusters=None, next_token=None, request_id=None):
        self.dedicated_block_storage_clusters = dedicated_block_storage_clusters  # type: DescribeDedicatedBlockStorageClustersResponseBodyDedicatedBlockStorageClusters
        self.next_token = next_token  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        if self.dedicated_block_storage_clusters:
            self.dedicated_block_storage_clusters.validate()

    def to_map(self):
        _map = super(DescribeDedicatedBlockStorageClustersResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_block_storage_clusters is not None:
            result['DedicatedBlockStorageClusters'] = self.dedicated_block_storage_clusters.to_map()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DedicatedBlockStorageClusters') is not None:
            temp_model = DescribeDedicatedBlockStorageClustersResponseBodyDedicatedBlockStorageClusters()
            self.dedicated_block_storage_clusters = temp_model.from_map(m['DedicatedBlockStorageClusters'])
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDedicatedBlockStorageClustersResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDedicatedBlockStorageClustersResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDedicatedBlockStorageClustersResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDedicatedBlockStorageClustersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDedicatedHostAutoRenewRequest(TeaModel):
    def __init__(self, dedicated_host_ids=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.dedicated_host_ids = dedicated_host_ids  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDedicatedHostAutoRenewRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_host_ids is not None:
            result['DedicatedHostIds'] = self.dedicated_host_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DedicatedHostIds') is not None:
            self.dedicated_host_ids = m.get('DedicatedHostIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeDedicatedHostAutoRenewResponseBodyDedicatedHostRenewAttributesDedicatedHostRenewAttribute(TeaModel):
    def __init__(self, auto_renew_enabled=None, auto_renew_with_ecs=None, dedicated_host_id=None, duration=None,
                 period_unit=None, renewal_status=None):
        self.auto_renew_enabled = auto_renew_enabled  # type: bool
        self.auto_renew_with_ecs = auto_renew_with_ecs  # type: str
        self.dedicated_host_id = dedicated_host_id  # type: str
        self.duration = duration  # type: int
        self.period_unit = period_unit  # type: str
        self.renewal_status = renewal_status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDedicatedHostAutoRenewResponseBodyDedicatedHostRenewAttributesDedicatedHostRenewAttribute, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_renew_enabled is not None:
            result['AutoRenewEnabled'] = self.auto_renew_enabled
        if self.auto_renew_with_ecs is not None:
            result['AutoRenewWithEcs'] = self.auto_renew_with_ecs
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.renewal_status is not None:
            result['RenewalStatus'] = self.renewal_status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoRenewEnabled') is not None:
            self.auto_renew_enabled = m.get('AutoRenewEnabled')
        if m.get('AutoRenewWithEcs') is not None:
            self.auto_renew_with_ecs = m.get('AutoRenewWithEcs')
        if m.get('DedicatedHostId') is not None:
            self.dedicated_host_id = m.get('DedicatedHostId')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('RenewalStatus') is not None:
            self.renewal_status = m.get('RenewalStatus')
        return self


class DescribeDedicatedHostAutoRenewResponseBodyDedicatedHostRenewAttributes(TeaModel):
    def __init__(self, dedicated_host_renew_attribute=None):
        self.dedicated_host_renew_attribute = dedicated_host_renew_attribute  # type: list[DescribeDedicatedHostAutoRenewResponseBodyDedicatedHostRenewAttributesDedicatedHostRenewAttribute]

    def validate(self):
        if self.dedicated_host_renew_attribute:
            for k in self.dedicated_host_renew_attribute:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDedicatedHostAutoRenewResponseBodyDedicatedHostRenewAttributes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DedicatedHostRenewAttribute'] = []
        if self.dedicated_host_renew_attribute is not None:
            for k in self.dedicated_host_renew_attribute:
                result['DedicatedHostRenewAttribute'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.dedicated_host_renew_attribute = []
        if m.get('DedicatedHostRenewAttribute') is not None:
            for k in m.get('DedicatedHostRenewAttribute'):
                temp_model = DescribeDedicatedHostAutoRenewResponseBodyDedicatedHostRenewAttributesDedicatedHostRenewAttribute()
                self.dedicated_host_renew_attribute.append(temp_model.from_map(k))
        return self


class DescribeDedicatedHostAutoRenewResponseBody(TeaModel):
    def __init__(self, dedicated_host_renew_attributes=None, request_id=None):
        self.dedicated_host_renew_attributes = dedicated_host_renew_attributes  # type: DescribeDedicatedHostAutoRenewResponseBodyDedicatedHostRenewAttributes
        self.request_id = request_id  # type: str

    def validate(self):
        if self.dedicated_host_renew_attributes:
            self.dedicated_host_renew_attributes.validate()

    def to_map(self):
        _map = super(DescribeDedicatedHostAutoRenewResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_host_renew_attributes is not None:
            result['DedicatedHostRenewAttributes'] = self.dedicated_host_renew_attributes.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DedicatedHostRenewAttributes') is not None:
            temp_model = DescribeDedicatedHostAutoRenewResponseBodyDedicatedHostRenewAttributes()
            self.dedicated_host_renew_attributes = temp_model.from_map(m['DedicatedHostRenewAttributes'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDedicatedHostAutoRenewResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeDedicatedHostAutoRenewResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeDedicatedHostAutoRenewResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDedicatedHostAutoRenewResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDedicatedHostClustersRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDedicatedHostClustersRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDedicatedHostClustersRequest(TeaModel):
    def __init__(self, dedicated_host_cluster_ids=None, dedicated_host_cluster_name=None, lock_reason=None,
                 owner_account=None, owner_id=None, page_number=None, page_size=None, region_id=None, resource_group_id=None,
                 resource_owner_account=None, resource_owner_id=None, status=None, tag=None, zone_id=None):
        self.dedicated_host_cluster_ids = dedicated_host_cluster_ids  # type: str
        self.dedicated_host_cluster_name = dedicated_host_cluster_name  # type: str
        self.lock_reason = lock_reason  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.status = status  # type: str
        self.tag = tag  # type: list[DescribeDedicatedHostClustersRequestTag]
        self.zone_id = zone_id  # type: str

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDedicatedHostClustersRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_host_cluster_ids is not None:
            result['DedicatedHostClusterIds'] = self.dedicated_host_cluster_ids
        if self.dedicated_host_cluster_name is not None:
            result['DedicatedHostClusterName'] = self.dedicated_host_cluster_name
        if self.lock_reason is not None:
            result['LockReason'] = self.lock_reason
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.status is not None:
            result['Status'] = self.status
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DedicatedHostClusterIds') is not None:
            self.dedicated_host_cluster_ids = m.get('DedicatedHostClusterIds')
        if m.get('DedicatedHostClusterName') is not None:
            self.dedicated_host_cluster_name = m.get('DedicatedHostClusterName')
        if m.get('LockReason') is not None:
            self.lock_reason = m.get('LockReason')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeDedicatedHostClustersRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityAvailableInstanceTypesAvailableInstanceType(TeaModel):
    def __init__(self, available_instance_capacity=None, instance_type=None):
        self.available_instance_capacity = available_instance_capacity  # type: int
        self.instance_type = instance_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityAvailableInstanceTypesAvailableInstanceType, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.available_instance_capacity is not None:
            result['AvailableInstanceCapacity'] = self.available_instance_capacity
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvailableInstanceCapacity') is not None:
            self.available_instance_capacity = m.get('AvailableInstanceCapacity')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        return self


class DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityAvailableInstanceTypes(TeaModel):
    def __init__(self, available_instance_type=None):
        self.available_instance_type = available_instance_type  # type: list[DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityAvailableInstanceTypesAvailableInstanceType]

    def validate(self):
        if self.available_instance_type:
            for k in self.available_instance_type:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityAvailableInstanceTypes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AvailableInstanceType'] = []
        if self.available_instance_type is not None:
            for k in self.available_instance_type:
                result['AvailableInstanceType'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.available_instance_type = []
        if m.get('AvailableInstanceType') is not None:
            for k in m.get('AvailableInstanceType'):
                temp_model = DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityAvailableInstanceTypesAvailableInstanceType()
                self.available_instance_type.append(temp_model.from_map(k))
        return self


class DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityLocalStorageCapacitiesLocalStorageCapacity(TeaModel):
    def __init__(self, available_disk=None, data_disk_category=None, total_disk=None):
        self.available_disk = available_disk  # type: int
        self.data_disk_category = data_disk_category  # type: str
        self.total_disk = total_disk  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityLocalStorageCapacitiesLocalStorageCapacity, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.available_disk is not None:
            result['AvailableDisk'] = self.available_disk
        if self.data_disk_category is not None:
            result['DataDiskCategory'] = self.data_disk_category
        if self.total_disk is not None:
            result['TotalDisk'] = self.total_disk
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvailableDisk') is not None:
            self.available_disk = m.get('AvailableDisk')
        if m.get('DataDiskCategory') is not None:
            self.data_disk_category = m.get('DataDiskCategory')
        if m.get('TotalDisk') is not None:
            self.total_disk = m.get('TotalDisk')
        return self


class DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityLocalStorageCapacities(TeaModel):
    def __init__(self, local_storage_capacity=None):
        self.local_storage_capacity = local_storage_capacity  # type: list[DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityLocalStorageCapacitiesLocalStorageCapacity]

    def validate(self):
        if self.local_storage_capacity:
            for k in self.local_storage_capacity:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityLocalStorageCapacities, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LocalStorageCapacity'] = []
        if self.local_storage_capacity is not None:
            for k in self.local_storage_capacity:
                result['LocalStorageCapacity'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.local_storage_capacity = []
        if m.get('LocalStorageCapacity') is not None:
            for k in m.get('LocalStorageCapacity'):
                temp_model = DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityLocalStorageCapacitiesLocalStorageCapacity()
                self.local_storage_capacity.append(temp_model.from_map(k))
        return self


class DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacity(TeaModel):
    def __init__(self, available_instance_types=None, available_memory=None, available_vcpus=None,
                 local_storage_capacities=None, total_memory=None, total_vcpus=None):
        self.available_instance_types = available_instance_types  # type: DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityAvailableInstanceTypes
        self.available_memory = available_memory  # type: int
        self.available_vcpus = available_vcpus  # type: int
        self.local_storage_capacities = local_storage_capacities  # type: DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityLocalStorageCapacities
        self.total_memory = total_memory  # type: int
        self.total_vcpus = total_vcpus  # type: int

    def validate(self):
        if self.available_instance_types:
            self.available_instance_types.validate()
        if self.local_storage_capacities:
            self.local_storage_capacities.validate()

    def to_map(self):
        _map = super(DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacity, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.available_instance_types is not None:
            result['AvailableInstanceTypes'] = self.available_instance_types.to_map()
        if self.available_memory is not None:
            result['AvailableMemory'] = self.available_memory
        if self.available_vcpus is not None:
            result['AvailableVcpus'] = self.available_vcpus
        if self.local_storage_capacities is not None:
            result['LocalStorageCapacities'] = self.local_storage_capacities.to_map()
        if self.total_memory is not None:
            result['TotalMemory'] = self.total_memory
        if self.total_vcpus is not None:
            result['TotalVcpus'] = self.total_vcpus
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvailableInstanceTypes') is not None:
            temp_model = DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityAvailableInstanceTypes()
            self.available_instance_types = temp_model.from_map(m['AvailableInstanceTypes'])
        if m.get('AvailableMemory') is not None:
            self.available_memory = m.get('AvailableMemory')
        if m.get('AvailableVcpus') is not None:
            self.available_vcpus = m.get('AvailableVcpus')
        if m.get('LocalStorageCapacities') is not None:
            temp_model = DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacityLocalStorageCapacities()
            self.local_storage_capacities = temp_model.from_map(m['LocalStorageCapacities'])
        if m.get('TotalMemory') is not None:
            self.total_memory = m.get('TotalMemory')
        if m.get('TotalVcpus') is not None:
            self.total_vcpus = m.get('TotalVcpus')
        return self


class DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostIds(TeaModel):
    def __init__(self, dedicated_host_id=None):
        self.dedicated_host_id = dedicated_host_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_host_id is not None:
            result['DedicatedHostId'] = self.dedicated_host_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DedicatedHostId') is not None:
            self.dedicated_host_id = m.get('DedicatedHostId')
        return self


class DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterTagsTag(TeaModel):
    def __init__(self, tag_key=None, tag_value=None):
        self.tag_key = tag_key  # type: str
        self.tag_value = tag_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterTagsTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag  # type: list[DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterTagsTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostCluster(TeaModel):
    def __init__(self, dedicated_host_cluster_capacity=None, dedicated_host_cluster_id=None,
                 dedicated_host_cluster_name=None, dedicated_host_ids=None, description=None, region_id=None, resource_group_id=None, tags=None,
                 zone_id=None):
        self.dedicated_host_cluster_capacity = dedicated_host_cluster_capacity  # type: DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostClusterCapacity
        self.dedicated_host_cluster_id = dedicated_host_cluster_id  # type: str
        self.dedicated_host_cluster_name = dedicated_host_cluster_name  # type: str
        self.dedicated_host_ids = dedicated_host_ids  # type: DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterDedicatedHostIds
        self.description = description  # type: str
        self.region_id = region_id  # type: str
        self.resource_group_id = resource_group_id  # type: str
        self.tags = tags  # type: DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostClusterTags
        self.zone_id = zone_id  # type: str

    def validate(self):
        if self.dedicated_host_cluster_capacity:
            self.dedicated_host_cluster_capacity.validate()
        if self.dedicated_host_ids:
            self.dedicated_host_ids.validate()
        if self.tags:
            self.tags.validate()

    def to_map(self):
        _map = super(DescribeDedicatedHostClustersResponseBodyDedicatedHostClustersDedicatedHostCluster, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dedicated_host_cluster_capacity is not None:
            result['DedicatedHostClusterCapacity'] = self.dedicated_host_cluster_capacity.to_map()
        if self.dedicated_host_cluster_id is not None:
            result['DedicatedHostClusterId'] = self.dedicated_host_cluster_id
        if self.dedicated_host_cluster_name i