#*=+--+=#=+--         SwiftCore Flight Management Software        --+=#=+--+=#*#
#               Copyright (C) 2020 Black Swift Technologies LLC.               #
#                             All Rights Reserved.                             #
#                                                                              #
#    NOTICE:  All information contained herein is, and remains the property    #
#    of Black Swift Technologies.                                              #
#                                                                              #
#    The intellectual and technical concepts contained herein are              #
#    proprietary to Black Swift Technologies LLC and may be covered by U.S.    #
#    and foreign patents, patents in process, and are protected by trade       #
#    secret or copyright law.                                                  #
#                                                                              #
#    Dissemination of this information or reproduction of this material is     #
#    strictly forbidden unless prior written permission is obtained from       #
#    Black Swift Technologies LLC.                                             #
#                                                                              #
#*=+--+=#=+--                 --+=#=+--+=#=+--                    --+=#=+--+=#*#

from enum import Enum
import struct

from .comm_packets import *

#                      THIS FILE IS AUTOGENERATED BY                           #
#                                 msg-gen.py                                   #
#                                DO NOT EDIT                                   #

class CAN_GNSS_LLA:
	SIZE = 23

	def __init__ (self, startByte = 0, latitude = 0.0, longitude = 0.0,
	altitude = 0.0, chk = 0):
		self.startByte = startByte
		self.latitude = latitude
		self.longitude = longitude
		self.altitude = altitude
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_GNSS_LLA]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]

		self.latitude = struct.unpack_from('<d',buf,offset)[0]

		self.longitude = struct.unpack_from('<d',buf,offset)[0]

		self.altitude = struct.unpack_from('<f',buf,offset)[0]

		self.chk = struct.unpack_from('<H',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<d', self.latitude))
		buf.extend(struct.pack('<d', self.longitude))
		buf.extend(struct.pack('<f', self.altitude))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_GNSS_RTCM:
	SIZE = 68

	def __init__ (self, startByte = 0, size = 0, payload = [None] * 64,
	chk = 0):
		self.startByte = startByte
		self.size = size

		if (len(payload) != 64):
			raise ValueError('array payload expecting length '+str(64)+' got '+str(len(payload)))

		self.payload = list(payload)

		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_GNSS_RTCM]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]

		self.size = struct.unpack_from('<B',buf,offset)[0]

		self.payload = [];

		for i in range(0,64):
			self.payload.append(struct.unpack_from('<B',buf,offset)[0])
			offset = offset+struct.calcsize('<B')

		self.chk = struct.unpack_from('<H',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<B', self.size))

		for val in self.payload:
		    buf.extend(struct.pack('<B', val))

		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_GNSS_SVIN:
	SIZE = 20

	def __init__ (self, startByte = 0, time_elapsed = 0, time_minimum = 0,
	accuracy = 0.0, accuracy_minimum = 0.0, flags = 0, chk = 0):
		self.startByte = startByte
		self.time_elapsed = time_elapsed
		self.time_minimum = time_minimum
		self.accuracy = accuracy
		self.accuracy_minimum = accuracy_minimum
		self.flags = flags
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_GNSS_SVIN]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]

		self.time_elapsed = struct.unpack_from('<I',buf,offset)[0]

		self.time_minimum = struct.unpack_from('<I',buf,offset)[0]

		self.accuracy = struct.unpack_from('<f',buf,offset)[0]

		self.accuracy_minimum = struct.unpack_from('<f',buf,offset)[0]

		self.flags = struct.unpack_from('<B',buf,offset)[0]

		self.chk = struct.unpack_from('<H',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<I', self.time_elapsed))
		buf.extend(struct.pack('<I', self.time_minimum))
		buf.extend(struct.pack('<f', self.accuracy))
		buf.extend(struct.pack('<f', self.accuracy_minimum))
		buf.extend(struct.pack('<B', self.flags))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_GNSS_UTC:
	SIZE = 9

	def __init__ (self, startByte = 0, hours = 0, minutes = 0, seconds = 0.0,
	chk = 0):
		self.startByte = startByte
		self.hours = hours
		self.minutes = minutes
		self.seconds = seconds
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_GNSS_UTC]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]

		self.hours = struct.unpack_from('<B',buf,offset)[0]

		self.minutes = struct.unpack_from('<B',buf,offset)[0]

		self.seconds = struct.unpack_from('<f',buf,offset)[0]

		self.chk = struct.unpack_from('<H',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<B', self.hours))
		buf.extend(struct.pack('<B', self.minutes))
		buf.extend(struct.pack('<f', self.seconds))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_GNSS_UTC_W:
	SIZE = 11

	def __init__ (self, startByte = 0, week = 0, hours = 0, minutes = 0,
	seconds = 0.0, chk = 0):
		self.startByte = startByte
		self.week = week
		self.hours = hours
		self.minutes = minutes
		self.seconds = seconds
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_GNSS_UTC_W]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]

		self.week = struct.unpack_from('<H',buf,offset)[0]

		self.hours = struct.unpack_from('<B',buf,offset)[0]

		self.minutes = struct.unpack_from('<B',buf,offset)[0]

		self.seconds = struct.unpack_from('<f',buf,offset)[0]

		self.chk = struct.unpack_from('<H',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<H', self.week))
		buf.extend(struct.pack('<B', self.hours))
		buf.extend(struct.pack('<B', self.minutes))
		buf.extend(struct.pack('<f', self.seconds))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

#---------[ Actuators ]---------#

CAN_NUM_ACTUATORS = 16

#---------[ Comms ]---------#

class CAN_PacketTypes (Enum):
	# SENSORS

	CAN_PKT_PRESSURE=16
	CAN_PKT_AIR_DATA=17
	CAN_PKT_MHP=18
	CAN_PKT_IMU=32
	CAN_PKT_ACCEL=33
	CAN_PKT_GYRO=34
	CAN_PKT_MAG=35
	CAN_PKT_GNSS=48
	CAN_PKT_GNSS_UTC=49
	CAN_PKT_GNSS_LLA=50
	CAN_PKT_GNSS_VEL=51
	CAN_PKT_GNSS_HEALTH=52
	CAN_PKT_GNSS_UTC_W=53
	CAN_PKT_GNSS_RTCM=54
	CAN_PKT_GNSS_HEALTH_2=55
	CAN_PKT_GNSS_SVIN=56
	CAN_PKT_AGL=96
	CAN_PKT_PROXIMITY=112
	CAN_PKT_ADSB=144

	# STATE


	# CONTROL


	# ACTUATORS

	CAN_PKT_ACTUATOR=2047

	# INPUT

	CAN_PKT_RECEIVER=1

	# SYSTEM

	CAN_PKT_SUPPLY=64

	# TELEMETRY


	# HWIL


	# FLIGHT PLAN


	# VEHICLE CONFIGURATION


	# MISSION


	# PAYLOAD

	CAN_PKT_NDVI=80
	CAN_PKT_NDVI_DOWN=81
	CAN_PKT_NDVI_UP=82
	CAN_PKT_TRIGGER=83

	# ERRORS

#---------[ PAYLOAD ]---------#

class CAN_NDVI:
	SIZE = 20

	def __init__ (self, startByte = 0, id = 0, red = 0.0, near_ir = 0.0,
	ir_ambient = 0.0, ir_object = 0.0, chk = 0):
		self.startByte = startByte
		self.id = id
		self.red = red
		self.near_ir = near_ir
		self.ir_ambient = ir_ambient
		self.ir_object = ir_object
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_NDVI]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]

		self.id = struct.unpack_from('<B',buf,offset)[0]

		self.red = struct.unpack_from('<f',buf,offset)[0]

		self.near_ir = struct.unpack_from('<f',buf,offset)[0]

		self.ir_ambient = struct.unpack_from('<f',buf,offset)[0]

		self.ir_object = struct.unpack_from('<f',buf,offset)[0]

		self.chk = struct.unpack_from('<H',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<B', self.id))
		buf.extend(struct.pack('<f', self.red))
		buf.extend(struct.pack('<f', self.near_ir))
		buf.extend(struct.pack('<f', self.ir_ambient))
		buf.extend(struct.pack('<f', self.ir_object))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

#---------[ SENSORS ]---------#

class CAN_ADSB:
	SIZE = 59

	def __init__ (self, startByte = 0, timestamp = 0.0, icao_address = 0,
	latitude = 0.0, longitude = 0.0, altitude_type = 0, altitude = 0.0,
	heading = 0.0, horizontal_velocity = 0.0, vertical_velocity = 0.0,
	callsign = [None] * 9, emitter_type = 0, tslc = 0, flags = 0, squawk = 0,
	chk = 0):
		self.startByte = startByte
		self.timestamp = timestamp
		self.icao_address = icao_address
		self.latitude = latitude
		self.longitude = longitude
		self.altitude_type = altitude_type
		self.altitude = altitude
		self.heading = heading
		self.horizontal_velocity = horizontal_velocity
		self.vertical_velocity = vertical_velocity

		if (len(callsign) != 9):
			raise ValueError('array callsign expecting length '+str(9)+' got '+str(len(callsign)))

		self.callsign = list(callsign)

		self.emitter_type = emitter_type
		self.tslc = tslc
		self.flags = flags
		self.squawk = squawk
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_ADSB]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]

		self.timestamp = struct.unpack_from('<f',buf,offset)[0]

		self.icao_address = struct.unpack_from('<I',buf,offset)[0]

		self.latitude = struct.unpack_from('<d',buf,offset)[0]

		self.longitude = struct.unpack_from('<d',buf,offset)[0]

		self.altitude_type = struct.unpack_from('<B',buf,offset)[0]

		self.altitude = struct.unpack_from('<f',buf,offset)[0]

		self.heading = struct.unpack_from('<f',buf,offset)[0]

		self.horizontal_velocity = struct.unpack_from('<f',buf,offset)[0]

		self.vertical_velocity = struct.unpack_from('<f',buf,offset)[0]

		self.callsign = [];

		for i in range(0,9):
			self.callsign.append(struct.unpack_from('<B',buf,offset)[0])
			offset = offset+struct.calcsize('<B')

		self.emitter_type = struct.unpack_from('<B',buf,offset)[0]

		self.tslc = struct.unpack_from('<B',buf,offset)[0]

		self.flags = struct.unpack_from('<H',buf,offset)[0]

		self.squawk = struct.unpack_from('<H',buf,offset)[0]

		self.chk = struct.unpack_from('<H',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<f', self.timestamp))
		buf.extend(struct.pack('<I', self.icao_address))
		buf.extend(struct.pack('<d', self.latitude))
		buf.extend(struct.pack('<d', self.longitude))
		buf.extend(struct.pack('<B', self.altitude_type))
		buf.extend(struct.pack('<f', self.altitude))
		buf.extend(struct.pack('<f', self.heading))
		buf.extend(struct.pack('<f', self.horizontal_velocity))
		buf.extend(struct.pack('<f', self.vertical_velocity))

		for val in self.callsign:
		    buf.extend(struct.pack('<B', val))

		buf.extend(struct.pack('<B', self.emitter_type))
		buf.extend(struct.pack('<B', self.tslc))
		buf.extend(struct.pack('<H', self.flags))
		buf.extend(struct.pack('<H', self.squawk))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_AGL:
	SIZE = 15

	def __init__ (self, startByte = 0, timestamp = 0.0, distance = 0.0,
	velocity = 0.0, chk = 0):
		self.startByte = startByte
		self.timestamp = timestamp
		self.distance = distance
		self.velocity = velocity
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_AGL]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]

		self.timestamp = struct.unpack_from('<f',buf,offset)[0]

		self.distance = struct.unpack_from('<f',buf,offset)[0]

		self.velocity = struct.unpack_from('<f',buf,offset)[0]

		self.chk = struct.unpack_from('<H',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<f', self.timestamp))
		buf.extend(struct.pack('<f', self.distance))
		buf.extend(struct.pack('<f', self.velocity))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_Accelerometer:
	SIZE = 19

	def __init__ (self, startByte = 0, ax = 0.0, ay = 0.0, az = 0.0,
	temp = 0.0, chk = 0):
		self.startByte = startByte
		self.ax = ax
		self.ay = ay
		self.az = az
		self.temp = temp
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_Accelerometer]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]

		self.ax = struct.unpack_from('<f',buf,offset)[0]

		self.ay = struct.unpack_from('<f',buf,offset)[0]

		self.az = struct.unpack_from('<f',buf,offset)[0]

		self.temp = struct.unpack_from('<f',buf,offset)[0]

		self.chk = struct.unpack_from('<H',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<f', self.ax))
		buf.extend(struct.pack('<f', self.ay))
		buf.extend(struct.pack('<f', self.az))
		buf.extend(struct.pack('<f', self.temp))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_AirData:
	SIZE = 19

	def __init__ (self, startByte = 0, static_pressure = 0.0,
	dynamic_pressure = 0.0, air_temperature = 0.0, humidity = 0.0, chk = 0):
		self.startByte = startByte
		self.static_pressure = static_pressure
		self.dynamic_pressure = dynamic_pressure
		self.air_temperature = air_temperature
		self.humidity = humidity
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_AirData]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]

		self.static_pressure = struct.unpack_from('<f',buf,offset)[0]

		self.dynamic_pressure = struct.unpack_from('<f',buf,offset)[0]

		self.air_temperature = struct.unpack_from('<f',buf,offset)[0]

		self.humidity = struct.unpack_from('<f',buf,offset)[0]

		self.chk = struct.unpack_from('<H',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<f', self.static_pressure))
		buf.extend(struct.pack('<f', self.dynamic_pressure))
		buf.extend(struct.pack('<f', self.air_temperature))
		buf.extend(struct.pack('<f', self.humidity))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_GNSS:
	SIZE = 57

	def __init__ (self, startByte = 0, week = 0, hours = 0, minutes = 0,
	seconds = 0.0, latitude = 0.0, longitude = 0.0, altitude = 0.0,
	heading = 0.0, speed = 0.0, pdop = 0.0, satellites = 0, fix_type = 0,
	vx = 0.0, vy = 0.0, vz = 0.0, chk = 0):
		self.startByte = startByte
		self.week = week
		self.hours = hours
		self.minutes = minutes
		self.seconds = seconds
		self.latitude = latitude
		self.longitude = longitude
		self.altitude = altitude
		self.heading = heading
		self.speed = speed
		self.pdop = pdop
		self.satellites = satellites
		self.fix_type = fix_type
		self.vx = vx
		self.vy = vy
		self.vz = vz
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_GNSS]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]

		self.week = struct.unpack_from('<H',buf,offset)[0]

		self.hours = struct.unpack_from('<B',buf,offset)[0]

		self.minutes = struct.unpack_from('<B',buf,offset)[0]

		self.seconds = struct.unpack_from('<f',buf,offset)[0]

		self.latitude = struct.unpack_from('<d',buf,offset)[0]

		self.longitude = struct.unpack_from('<d',buf,offset)[0]

		self.altitude = struct.unpack_from('<f',buf,offset)[0]

		self.heading = struct.unpack_from('<f',buf,offset)[0]

		self.speed = struct.unpack_from('<f',buf,offset)[0]

		self.pdop = struct.unpack_from('<f',buf,offset)[0]

		self.satellites = struct.unpack_from('<B',buf,offset)[0]

		self.fix_type = struct.unpack_from('<B',buf,offset)[0]

		self.vx = struct.unpack_from('<f',buf,offset)[0]

		self.vy = struct.unpack_from('<f',buf,offset)[0]

		self.vz = struct.unpack_from('<f',buf,offset)[0]

		self.chk = struct.unpack_from('<H',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<H', self.week))
		buf.extend(struct.pack('<B', self.hours))
		buf.extend(struct.pack('<B', self.minutes))
		buf.extend(struct.pack('<f', self.seconds))
		buf.extend(struct.pack('<d', self.latitude))
		buf.extend(struct.pack('<d', self.longitude))
		buf.extend(struct.pack('<f', self.altitude))
		buf.extend(struct.pack('<f', self.heading))
		buf.extend(struct.pack('<f', self.speed))
		buf.extend(struct.pack('<f', self.pdop))
		buf.extend(struct.pack('<B', self.satellites))
		buf.extend(struct.pack('<B', self.fix_type))
		buf.extend(struct.pack('<f', self.vx))
		buf.extend(struct.pack('<f', self.vy))
		buf.extend(struct.pack('<f', self.vz))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_GNSS_HEALTH:
	SIZE = 8

	def __init__ (self, startByte = 0, pdop = 0.0, satellites = 0, chk = 0):
		self.startByte = startByte
		self.pdop = pdop
		self.satellites = satellites
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_GNSS_HEALTH]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]

		self.pdop = struct.unpack_from('<f',buf,offset)[0]

		self.satellites = struct.unpack_from('<B',buf,offset)[0]

		self.chk = struct.unpack_from('<H',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<f', self.pdop))
		buf.extend(struct.pack('<B', self.satellites))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_GNSS_HEALTH_2:
	SIZE = 11

	def __init__ (self, startByte = 0, pdop = 0.0, satellites = 0,
	fix_type = 0, buffer = [None] * 2, chk = 0):
		self.startByte = startByte
		self.pdop = pdop
		self.satellites = satellites
		self.fix_type = fix_type

		if (len(buffer) != 2):
			raise ValueError('array buffer expecting length '+str(2)+' got '+str(len(buffer)))

		self.buffer = list(buffer)

		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_GNSS_HEALTH_2]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]

		self.pdop = struct.unpack_from('<f',buf,offset)[0]

		self.satellites = struct.unpack_from('<B',buf,offset)[0]

		self.fix_type = struct.unpack_from('<B',buf,offset)[0]

		self.buffer = [];

		for i in range(0,2):
			self.buffer.append(struct.unpack_from('<B',buf,offset)[0])
			offset = offset+struct.calcsize('<B')

		self.chk = struct.unpack_from('<H',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<f', self.pdop))
		buf.extend(struct.pack('<B', self.satellites))
		buf.extend(struct.pack('<B', self.fix_type))

		for val in self.buffer:
		    buf.extend(struct.pack('<B', val))

		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_GNSS_VEL:
	SIZE = 23

	def __init__ (self, startByte = 0, heading = 0.0, speed = 0.0, vx = 0.0,
	vy = 0.0, vz = 0.0, chk = 0):
		self.startByte = startByte
		self.heading = heading
		self.speed = speed
		self.vx = vx
		self.vy = vy
		self.vz = vz
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_GNSS_VEL]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]

		self.heading = struct.unpack_from('<f',buf,offset)[0]

		self.speed = struct.unpack_from('<f',buf,offset)[0]

		self.vx = struct.unpack_from('<f',buf,offset)[0]

		self.vy = struct.unpack_from('<f',buf,offset)[0]

		self.vz = struct.unpack_from('<f',buf,offset)[0]

		self.chk = struct.unpack_from('<H',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<f', self.heading))
		buf.extend(struct.pack('<f', self.speed))
		buf.extend(struct.pack('<f', self.vx))
		buf.extend(struct.pack('<f', self.vy))
		buf.extend(struct.pack('<f', self.vz))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_Gyroscope:
	SIZE = 19

	def __init__ (self, startByte = 0, gx = 0.0, gy = 0.0, gz = 0.0,
	temp = 0.0, chk = 0):
		self.startByte = startByte
		self.gx = gx
		self.gy = gy
		self.gz = gz
		self.temp = temp
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_Gyroscope]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]

		self.gx = struct.unpack_from('<f',buf,offset)[0]

		self.gy = struct.unpack_from('<f',buf,offset)[0]

		self.gz = struct.unpack_from('<f',buf,offset)[0]

		self.temp = struct.unpack_from('<f',buf,offset)[0]

		self.chk = struct.unpack_from('<H',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<f', self.gx))
		buf.extend(struct.pack('<f', self.gy))
		buf.extend(struct.pack('<f', self.gz))
		buf.extend(struct.pack('<f', self.temp))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_IMU:
	SIZE = 43

	def __init__ (self, startByte = 0, ax = 0.0, ay = 0.0, az = 0.0, gx = 0.0,
	gy = 0.0, gz = 0.0, mx = 0.0, my = 0.0, mz = 0.0, temp = 0.0, chk = 0):
		self.startByte = startByte
		self.ax = ax
		self.ay = ay
		self.az = az
		self.gx = gx
		self.gy = gy
		self.gz = gz
		self.mx = mx
		self.my = my
		self.mz = mz
		self.temp = temp
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_IMU]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]

		self.ax = struct.unpack_from('<f',buf,offset)[0]

		self.ay = struct.unpack_from('<f',buf,offset)[0]

		self.az = struct.unpack_from('<f',buf,offset)[0]

		self.gx = struct.unpack_from('<f',buf,offset)[0]

		self.gy = struct.unpack_from('<f',buf,offset)[0]

		self.gz = struct.unpack_from('<f',buf,offset)[0]

		self.mx = struct.unpack_from('<f',buf,offset)[0]

		self.my = struct.unpack_from('<f',buf,offset)[0]

		self.mz = struct.unpack_from('<f',buf,offset)[0]

		self.temp = struct.unpack_from('<f',buf,offset)[0]

		self.chk = struct.unpack_from('<H',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<f', self.ax))
		buf.extend(struct.pack('<f', self.ay))
		buf.extend(struct.pack('<f', self.az))
		buf.extend(struct.pack('<f', self.gx))
		buf.extend(struct.pack('<f', self.gy))
		buf.extend(struct.pack('<f', self.gz))
		buf.extend(struct.pack('<f', self.mx))
		buf.extend(struct.pack('<f', self.my))
		buf.extend(struct.pack('<f', self.mz))
		buf.extend(struct.pack('<f', self.temp))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_MHP:
	SIZE = 57

	def __init__ (self, startByte = 0, system_time = 0, static_pressure = 0,
	dynamic_pressure = [None] * 5, air_temperature = 0, humidity = 0,
	gyroscope = [None] * 3, accelerometer = [None] * 3,
	magnetometer = [None] * 3, alpha = 0, beta = 0, chk = 0):
		self.startByte = startByte
		self.system_time = system_time
		self.static_pressure = static_pressure

		if (len(dynamic_pressure) != 5):
			raise ValueError('array dynamic_pressure expecting length '+str(5)+' got '+str(len(dynamic_pressure)))

		self.dynamic_pressure = list(dynamic_pressure)

		self.air_temperature = air_temperature
		self.humidity = humidity

		if (len(gyroscope) != 3):
			raise ValueError('array gyroscope expecting length '+str(3)+' got '+str(len(gyroscope)))

		self.gyroscope = list(gyroscope)

		if (len(accelerometer) != 3):
			raise ValueError('array accelerometer expecting length '+str(3)+' got '+str(len(accelerometer)))

		self.accelerometer = list(accelerometer)

		if (len(magnetometer) != 3):
			raise ValueError('array magnetometer expecting length '+str(3)+' got '+str(len(magnetometer)))

		self.magnetometer = list(magnetometer)

		self.alpha = alpha
		self.beta = beta
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_MHP]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]

		self.system_time = struct.unpack_from('<I',buf,offset)[0]

		self.static_pressure = struct.unpack_from('<I',buf,offset)[0]

		self.dynamic_pressure = [];

		for i in range(0,5):
			self.dynamic_pressure.append(struct.unpack_from('<i',buf,offset)[0])
			offset = offset+struct.calcsize('<i')

		self.air_temperature = struct.unpack_from('<h',buf,offset)[0]

		self.humidity = struct.unpack_from('<H',buf,offset)[0]

		self.gyroscope = [];

		for i in range(0,3):
			self.gyroscope.append(struct.unpack_from('<h',buf,offset)[0])
			offset = offset+struct.calcsize('<h')

		self.accelerometer = [];

		for i in range(0,3):
			self.accelerometer.append(struct.unpack_from('<h',buf,offset)[0])
			offset = offset+struct.calcsize('<h')

		self.magnetometer = [];

		for i in range(0,3):
			self.magnetometer.append(struct.unpack_from('<h',buf,offset)[0])
			offset = offset+struct.calcsize('<h')

		self.alpha = struct.unpack_from('<h',buf,offset)[0]

		self.beta = struct.unpack_from('<h',buf,offset)[0]

		self.chk = struct.unpack_from('<H',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<I', self.system_time))
		buf.extend(struct.pack('<I', self.static_pressure))

		for val in self.dynamic_pressure:
		    buf.extend(struct.pack('<i', val))

		buf.extend(struct.pack('<h', self.air_temperature))
		buf.extend(struct.pack('<H', self.humidity))

		for val in self.gyroscope:
		    buf.extend(struct.pack('<h', val))

		for val in self.accelerometer:
		    buf.extend(struct.pack('<h', val))

		for val in self.magnetometer:
		    buf.extend(struct.pack('<h', val))

		buf.extend(struct.pack('<h', self.alpha))
		buf.extend(struct.pack('<h', self.beta))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_Magnetometer:
	SIZE = 15

	def __init__ (self, startByte = 0, mx = 0.0, my = 0.0, mz = 0.0,
	chk = 0):
		self.startByte = startByte
		self.mx = mx
		self.my = my
		self.mz = mz
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_Magnetometer]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]

		self.mx = struct.unpack_from('<f',buf,offset)[0]

		self.my = struct.unpack_from('<f',buf,offset)[0]

		self.mz = struct.unpack_from('<f',buf,offset)[0]

		self.chk = struct.unpack_from('<H',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<f', self.mx))
		buf.extend(struct.pack('<f', self.my))
		buf.extend(struct.pack('<f', self.mz))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_Pressure:
	SIZE = 15

	def __init__ (self, startByte = 0, pressureSta = 0.0, pressureDyn = 0.0,
	temp = 0.0, chk = 0):
		self.startByte = startByte
		self.pressureSta = pressureSta
		self.pressureDyn = pressureDyn
		self.temp = temp
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_Pressure]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]

		self.pressureSta = struct.unpack_from('<f',buf,offset)[0]

		self.pressureDyn = struct.unpack_from('<f',buf,offset)[0]

		self.temp = struct.unpack_from('<f',buf,offset)[0]

		self.chk = struct.unpack_from('<H',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<f', self.pressureSta))
		buf.extend(struct.pack('<f', self.pressureDyn))
		buf.extend(struct.pack('<f', self.temp))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_Proximity:
	SIZE = 15

	def __init__ (self, startByte = 0, timestamp = 0.0, distance = 0.0,
	velocity = 0.0, chk = 0):
		self.startByte = startByte
		self.timestamp = timestamp
		self.distance = distance
		self.velocity = velocity
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_Proximity]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]

		self.timestamp = struct.unpack_from('<f',buf,offset)[0]

		self.distance = struct.unpack_from('<f',buf,offset)[0]

		self.velocity = struct.unpack_from('<f',buf,offset)[0]

		self.chk = struct.unpack_from('<H',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<f', self.timestamp))
		buf.extend(struct.pack('<f', self.distance))
		buf.extend(struct.pack('<f', self.velocity))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

class CAN_Trigger:
	SIZE = 10

	def __init__ (self, startByte = 0, timestamp = 0.0, id = 0, channel = 0,
	chk = 0):
		self.startByte = startByte
		self.timestamp = timestamp
		self.id = id
		self.channel = channel
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_Trigger]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]

		self.timestamp = struct.unpack_from('<f',buf,offset)[0]

		self.id = struct.unpack_from('<H',buf,offset)[0]

		self.channel = struct.unpack_from('<B',buf,offset)[0]

		self.chk = struct.unpack_from('<H',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<f', self.timestamp))
		buf.extend(struct.pack('<H', self.id))
		buf.extend(struct.pack('<B', self.channel))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

#---------[ SYSTEM ]---------#

class CAN_Supply:
	SIZE = 19

	def __init__ (self, startByte = 0, voltage = 0.0, current = 0.0,
	coulomb_count = 0.0, temperature = 0.0, chk = 0):
		self.startByte = startByte
		self.voltage = voltage
		self.current = current
		self.coulomb_count = coulomb_count
		self.temperature = temperature
		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_Supply]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]

		self.voltage = struct.unpack_from('<f',buf,offset)[0]

		self.current = struct.unpack_from('<f',buf,offset)[0]

		self.coulomb_count = struct.unpack_from('<f',buf,offset)[0]

		self.temperature = struct.unpack_from('<f',buf,offset)[0]

		self.chk = struct.unpack_from('<H',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))
		buf.extend(struct.pack('<f', self.voltage))
		buf.extend(struct.pack('<f', self.current))
		buf.extend(struct.pack('<f', self.coulomb_count))
		buf.extend(struct.pack('<f', self.temperature))
		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

#---------[ ACTUATORS ]---------#

class CAN_Actuator:
	SIZE = 35

	def __init__ (self, startByte = 0, usec = [None] * 16, chk = 0):
		self.startByte = startByte

		if (len(usec) != 16):
			raise ValueError('array usec expecting length '+str(16)+' got '+str(len(usec)))

		self.usec = list(usec)

		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_Actuator]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]

		self.usec = [];

		for i in range(0,16):
			self.usec.append(struct.unpack_from('<H',buf,offset)[0])
			offset = offset+struct.calcsize('<H')

		self.chk = struct.unpack_from('<H',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))

		for val in self.usec:
		    buf.extend(struct.pack('<H', val))

		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)

#---------[ INPUT ]---------#

class CAN_Receiver:
	SIZE = 35

	def __init__ (self, startByte = 0, usec = [None] * 16, chk = 0):
		self.startByte = startByte

		if (len(usec) != 16):
			raise ValueError('array usec expecting length '+str(16)+' got '+str(len(usec)))

		self.usec = list(usec)

		self.chk = chk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CAN_Receiver]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.startByte = struct.unpack_from('<B',buf,offset)[0]

		self.usec = [];

		for i in range(0,16):
			self.usec.append(struct.unpack_from('<H',buf,offset)[0])
			offset = offset+struct.calcsize('<H')

		self.chk = struct.unpack_from('<H',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.startByte))

		for val in self.usec:
		    buf.extend(struct.pack('<H', val))

		buf.extend(struct.pack('<H', self.chk))
		return bytearray(buf)
