#*=+--+=#=+--         SwiftCore Flight Management Software        --+=#=+--+=#*#
#               Copyright (C) 2020 Black Swift Technologies LLC.               #
#                             All Rights Reserved.                             #
#                                                                              #
#    NOTICE:  All information contained herein is, and remains the property    #
#    of Black Swift Technologies.                                              #
#                                                                              #
#    The intellectual and technical concepts contained herein are              #
#    proprietary to Black Swift Technologies LLC and may be covered by U.S.    #
#    and foreign patents, patents in process, and are protected by trade       #
#    secret or copyright law.                                                  #
#                                                                              #
#    Dissemination of this information or reproduction of this material is     #
#    strictly forbidden unless prior written permission is obtained from       #
#    Black Swift Technologies LLC.                                             #
#                                                                              #
#*=+--+=#=+--                 --+=#=+--+=#=+--                    --+=#=+--+=#*#

from enum import Enum
import struct

from .comm_packets import *

#                      THIS FILE IS AUTOGENERATED BY                           #
#                                 msg-gen.py                                   #
#                                DO NOT EDIT                                   #

#---------[ Actuators ]---------#

MAX_USEC = 2200
MIN_USEC = 800
NUM_ACTUATORS = 16
NUM_MANUAL_CHANNELS = 16

class ActuatorFunction (Enum):
	ACT_UNUSED=0
	ACT_L_AILERON=1
	ACT_L_ELEVATOR=2
	ACT_L_THROTTLE=3
	ACT_L_RUDDER=4
	ACT_L_FLAP=5
	ACT_L_RUDDERVATOR=6
	ACT_L_ELEVON=7
	ACT_L_GEAR=8
	ACT_R_AILERON=9
	ACT_R_ELEVATOR=10
	ACT_R_THROTTLE=11
	ACT_R_RUDDER=12
	ACT_R_FLAP=13
	ACT_R_RUDDERVATOR=14
	ACT_R_ELEVON=15
	ACT_R_GEAR=16
	ACT_ROTOR=17
	ACT_PAYLOAD_1=18
	ACT_PAYLOAD_2=19
	ACT_PAYLOAD_3=20
	ACT_PAYLOAD_4=21
	ACT_PAYLOAD_5=22
	ACT_PAYLOAD_6=23
	ACT_PAYLOAD_7=24
	ACT_PAYLOAD_8=25
	ACT_PAYLOAD_9=26
	ACT_PAYLOAD_10=27
	ACT_PAYLOAD_11=28
	ACT_PAYLOAD_12=29
	ACT_PAYLOAD_13=30
	ACT_PAYLOAD_14=31
	ACT_PAYLOAD_15=32
	ACT_PAYLOAD_16=33
	ACT_INVALID=34

class JoystickFunction (Enum):
	UNUSED_JS=0
	JS_ROLL_RATE=1
	JS_PITCH_RATE=2
	JS_YAW_RATE=3
	JS_X_VEL=4
	JS_Y_VEL=5
	JS_Z_VEL=6
	JS_PAYLOAD_1=7
	JS_PAYLOAD_2=8
	INVALID_JOYSTICK=9

class SurfaceCommand (Enum):
	AILERON=0
	ELEVATOR=1
	THROTTLE=2
	RUDDER=3
	FLAPS=4
	GEAR=5
	PAYLOAD_1=6
	PAYLOAD_2=7
	PAYLOAD_3=8
	PAYLOAD_4=9
	PAYLOAD_5=10
	PAYLOAD_6=11
	PAYLOAD_7=12
	PAYLOAD_8=13
	PAYLOAD_9=14
	PAYLOAD_10=15
	PAYLOAD_11=16
	PAYLOAD_12=17
	PAYLOAD_13=18
	PAYLOAD_14=19
	PAYLOAD_15=20
	PAYLOAD_16=21
	INVALID_SURFACE=22

class ActuatorCalibration:
	SIZE = 8

	def __init__ (self, channel = 255,
	type = ActuatorFunction.ACT_INVALID, max_usec = 1500, mid_usec = 1500,
	min_usec = 1500):
		self.channel = channel

		self.type = ActuatorFunction(type)

		self.max_usec = max_usec
		self.mid_usec = mid_usec
		self.min_usec = min_usec

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [ActuatorCalibration]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.channel = struct.unpack_from('<B',buf,offset)[0]

		self.type = ActuatorFunction(struct.unpack_from('<B',buf,offset)[0])
		offset = offset+struct.calcsize('<B')

		self.max_usec = struct.unpack_from('<H',buf,offset)[0]

		self.mid_usec = struct.unpack_from('<H',buf,offset)[0]

		self.min_usec = struct.unpack_from('<H',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.channel))

		buf.put(ActuatorFunction.encode(self.type));

		buf.extend(struct.pack('<H', self.max_usec))
		buf.extend(struct.pack('<H', self.mid_usec))
		buf.extend(struct.pack('<H', self.min_usec))
		return bytearray(buf)

class Actuators:
	SIZE = 32

	def __init__ (self, usec = [None] * 16):
		if (len(usec) != 16):
			raise ValueError('array usec expecting length '+str(16)+' got '+str(len(usec)))

		self.usec = list(usec)

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [Actuators]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.usec = [];

		for i in range(0,16):
			self.usec.append(struct.unpack_from('<h',buf,offset)[0])
			offset = offset+struct.calcsize('<h')

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		for val in self.usec:
		    buf.extend(struct.pack('<h', val))
		return bytearray(buf)

#---------[ Comms ]---------#

class PacketTypes (Enum):
	# SENSORS

	SENSORS_GPS=1
	SENSORS_ACCELEROMETER=2
	SENSORS_GYROSCOPE=3
	SENSORS_MAGNETOMETER=4
	SENSORS_IMU=5
	SENSORS_DYNAMIC_PRESSURE=6
	SENSORS_STATIC_PRESSURE=7
	SENSORS_AIR_TEMPERATURE=8
	SENSORS_AGL=9
	SENSORS_CALIBRATE=10
	SENSORS_BOARD_ORIENTATION=11
	SENSORS_GNSS_ORIENTATION=12
	SENSORS_MHP=13
	SENSORS_GNSS_RTCM=14
	SENSORS_MHP_SENSORS=15

	SENSORS_MHP_9H_SENSORS=23  # FIXME - TECHNICALLY IN STATE ADDR SPACE

	SENSORS_MHP_9H_TIMING=24  # FIXME - TECHNICALLY IN STATE ADDR SPACE

	SENSORS_DYNP_CALIBRATION=25  # FIXME - TECHNICALLY IN STATE ADDR SPACE

	SENSORS_GYRO_CALIBRATION=26  # FIXME - TECHNICALLY IN STATE ADDR SPACE

	SENSORS_MAG_CALIBRATION=27  # FIXME - TECHNICALLY IN STATE ADDR SPACE

	SENSORS_MAG_CURRENT_CAL=28  # FIXME - TECHNICALLY IN STATE ADDR SPACE

	SENSORS_ADSB=29  # FIXME - TECHNICALLY IN STATE ADDR SPACE

	SENSORS_MHP_GNSS=30  # FIXME - TECHNICALLY IN STATE ADDR SPACE

	SENSORS_MHP_TIMING=31  # FIXME - TECHNICALLY IN STATE ADDR SPACE


	# STATE

	STATE_STATE=16  # ONLY USED INTERNALLY

	STATE_ESTIMATOR_PARAM=17

	STATE_FLIGHT_CONTROLLER=18  # ONLY USED INTERNALLY O


	# CONTROL

	# CONTROL_VALUES                = 0x20

	CONTROL_COMMAND=33
	CONTROL_PID=34
	CONTROL_FLIGHT_PARAMS=35
	CONTROL_FILTER_PARAMS=36

	# ACTUATORS

	ACTUATORS_VALUES=48
	ACTUATORS_CALIBRATION=49
	ACTUATORS_ROTOR_PARAMS=50
	ACTUATORS_MIXING_PARAMS=51

	# HANDSET

	HANDSET_VALUES=52
	HANDSET_CALIBRATION=53

	# INPUT

	INPUT_HANDSET_VALUES=64
	INPUT_HANDSET_SETUP=65
	INPUT_JOYSTICK_VALUES=66
	INPUT_JOYSTICK_SETUP=67

	# SYSTEM

	SYSTEM_POWER_ON=80
	SYSTEM_INITIALIZE=81

	SYSTEM_HEALTH_AND_STATUS=82  # FIXME - ONLY USED INTERNALLY

	SYSTEM_HARDWARE_ERROR=83
	SYSTEM_REBOOT=95

	# TELEMETRY

	TELEMETRY_HEARTBEAT=96
	TELEMETRY_POSITION=97
	TELEMETRY_ORIENTATION=98
	TELEMETRY_PRESSURE=99
	TELEMETRY_CONTROL=100
	TELEMETRY_SYSTEM=101
	TELEMETRY_GCS=102
	TELEMETRY_GCS_LOCATION=103
	TELEMETRY_PAYLOAD=104
	TELEMETRY_GCS_SVIN=105

	# HWIL

	HWIL_SENSORS=112
	HWIL_ACTUATORS=113
	HWIL_CAN=114

	# FLIGHT PLAN

	FLIGHT_PLAN=128
	FLIGHT_PLAN_MAP=129
	FLIGHT_PLAN_WAYPOINT=130
	LAST_MAPPING_WAYPOINT=131
	DUBIN_PATH=132

	# VEHICLE CONFIGURATION

	VEHICLE_PARAMS=144
	VEHICLE_LIMITS=145
	VEHICLE_LAUNCH_PARAMS=146
	VEHICLE_LAND_PARAMS=147

	# MISSION

	MISSION_CHECKLIST=160
	MISSION_PARAMETERS=161

	# PAYLOAD

	PAYLOAD_TRIGGER=224
	PAYLOAD_PARAMS=225
	PAYLOAD_NDVI=226
	PAYLOAD_LDCR=227
	PAYLOAD_CONTROL=228
	PAYLOAD_CAMERA_TAG=229
	PAYLOAD_STATUS=230
	PAYLOAD_SERIAL=231

	PAYLOAD_DATA_CHANNEL_0=232
	PAYLOAD_DATA_CHANNEL_1=233
	PAYLOAD_DATA_CHANNEL_2=234
	PAYLOAD_DATA_CHANNEL_3=235
	PAYLOAD_DATA_CHANNEL_4=236
	PAYLOAD_DATA_CHANNEL_5=237
	PAYLOAD_DATA_CHANNEL_6=238
	PAYLOAD_DATA_CHANNEL_7=239

	# ERRORS

	INVALID_PACKET=255

#---------[ Configuration ]---------#

COMMS_VERSION = 3160
MAX_ALTITUDE = 20000
MAX_VEHICLES = 5

#---------[ Estimator ]---------#

class EstimatorParameters:
	SIZE = 48

	def __init__ (self, cf_acc_gain = 0.0, cf_mag_gain = 0.0,
	cf_press_gain = 0.0, altitude_filter_Ph = 0.0, altitude_filter_R = 0.0,
	altitude_filter_Q1 = 0.0, altitude_filter_Q2 = 0.0,
	altitude_filter_Q3 = 0.0, ax_filter_alpha = 0.0, ax_filter_beta = 0.0,
	agl_filter_rate = 0.0, agl_filter_cutoff = 0.0):
		self.cf_acc_gain = cf_acc_gain
		self.cf_mag_gain = cf_mag_gain
		self.cf_press_gain = cf_press_gain
		self.altitude_filter_Ph = altitude_filter_Ph
		self.altitude_filter_R = altitude_filter_R
		self.altitude_filter_Q1 = altitude_filter_Q1
		self.altitude_filter_Q2 = altitude_filter_Q2
		self.altitude_filter_Q3 = altitude_filter_Q3
		self.ax_filter_alpha = ax_filter_alpha
		self.ax_filter_beta = ax_filter_beta
		self.agl_filter_rate = agl_filter_rate
		self.agl_filter_cutoff = agl_filter_cutoff

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [EstimatorParameters]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.cf_acc_gain = struct.unpack_from('<f',buf,offset)[0]

		self.cf_mag_gain = struct.unpack_from('<f',buf,offset)[0]

		self.cf_press_gain = struct.unpack_from('<f',buf,offset)[0]

		self.altitude_filter_Ph = struct.unpack_from('<f',buf,offset)[0]

		self.altitude_filter_R = struct.unpack_from('<f',buf,offset)[0]

		self.altitude_filter_Q1 = struct.unpack_from('<f',buf,offset)[0]

		self.altitude_filter_Q2 = struct.unpack_from('<f',buf,offset)[0]

		self.altitude_filter_Q3 = struct.unpack_from('<f',buf,offset)[0]

		self.ax_filter_alpha = struct.unpack_from('<f',buf,offset)[0]

		self.ax_filter_beta = struct.unpack_from('<f',buf,offset)[0]

		self.agl_filter_rate = struct.unpack_from('<f',buf,offset)[0]

		self.agl_filter_cutoff = struct.unpack_from('<f',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<f', self.cf_acc_gain))
		buf.extend(struct.pack('<f', self.cf_mag_gain))
		buf.extend(struct.pack('<f', self.cf_press_gain))
		buf.extend(struct.pack('<f', self.altitude_filter_Ph))
		buf.extend(struct.pack('<f', self.altitude_filter_R))
		buf.extend(struct.pack('<f', self.altitude_filter_Q1))
		buf.extend(struct.pack('<f', self.altitude_filter_Q2))
		buf.extend(struct.pack('<f', self.altitude_filter_Q3))
		buf.extend(struct.pack('<f', self.ax_filter_alpha))
		buf.extend(struct.pack('<f', self.ax_filter_beta))
		buf.extend(struct.pack('<f', self.agl_filter_rate))
		buf.extend(struct.pack('<f', self.agl_filter_cutoff))
		return bytearray(buf)

class State:
	SIZE = 92

	def __init__ (self, system_time = 0.0, q = [None] * 4, altitude = 0.0, ias = 0.0,
	ias_dot = 0.0, h = 0.0, h_dot = 0.0, turnrate = 0.0, accel_y = 0.0,
	latitude = 0.0, longitude = 0.0, vx = 0.0, vy = 0.0, agl = 0.0, tas = 0.0,
	wind = [None] * 3):
		self.system_time = system_time

		if (len(q) != 4):
			raise ValueError('array q expecting length '+str(4)+' got '+str(len(q)))

		self.q = list(q)

		self.altitude = altitude
		self.ias = ias
		self.ias_dot = ias_dot
		self.h = h
		self.h_dot = h_dot
		self.turnrate = turnrate
		self.accel_y = accel_y
		self.latitude = latitude
		self.longitude = longitude
		self.vx = vx
		self.vy = vy
		self.agl = agl
		self.tas = tas

		if (len(wind) != 3):
			raise ValueError('array wind expecting length '+str(3)+' got '+str(len(wind)))

		self.wind = list(wind)

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [State]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.system_time = struct.unpack_from('<f',buf,offset)[0]

		self.q = [];

		for i in range(0,4):
			self.q.append(struct.unpack_from('<f',buf,offset)[0])
			offset = offset+struct.calcsize('<f')

		self.altitude = struct.unpack_from('<f',buf,offset)[0]

		self.ias = struct.unpack_from('<f',buf,offset)[0]

		self.ias_dot = struct.unpack_from('<f',buf,offset)[0]

		self.h = struct.unpack_from('<f',buf,offset)[0]

		self.h_dot = struct.unpack_from('<f',buf,offset)[0]

		self.turnrate = struct.unpack_from('<f',buf,offset)[0]

		self.accel_y = struct.unpack_from('<f',buf,offset)[0]

		self.latitude = struct.unpack_from('<d',buf,offset)[0]

		self.longitude = struct.unpack_from('<d',buf,offset)[0]

		self.vx = struct.unpack_from('<f',buf,offset)[0]

		self.vy = struct.unpack_from('<f',buf,offset)[0]

		self.agl = struct.unpack_from('<f',buf,offset)[0]

		self.tas = struct.unpack_from('<f',buf,offset)[0]

		self.wind = [];

		for i in range(0,3):
			self.wind.append(struct.unpack_from('<f',buf,offset)[0])
			offset = offset+struct.calcsize('<f')

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<f', self.system_time))

		for val in self.q:
		    buf.extend(struct.pack('<f', val))

		buf.extend(struct.pack('<f', self.altitude))
		buf.extend(struct.pack('<f', self.ias))
		buf.extend(struct.pack('<f', self.ias_dot))
		buf.extend(struct.pack('<f', self.h))
		buf.extend(struct.pack('<f', self.h_dot))
		buf.extend(struct.pack('<f', self.turnrate))
		buf.extend(struct.pack('<f', self.accel_y))
		buf.extend(struct.pack('<d', self.latitude))
		buf.extend(struct.pack('<d', self.longitude))
		buf.extend(struct.pack('<f', self.vx))
		buf.extend(struct.pack('<f', self.vy))
		buf.extend(struct.pack('<f', self.agl))
		buf.extend(struct.pack('<f', self.tas))

		for val in self.wind:
		    buf.extend(struct.pack('<f', val))
		return bytearray(buf)

#---------[ FlightPlan ]---------#

ERROR_WAYPOINT = 118
INVALID_WAYPOINT = 255
LANDING_WAYPOINT_1 = 101
LANDING_WAYPOINT_2 = 107
LAUNCH_WAYPOINT = 113
LOOK_AT_POINT = 120
LOST_COMM_WAYPOINT = 119
MAX_LOOK_AT_POINTS = 10
MAX_USER_WAYPOINTS = 100
MAX_WAYPOINTS = 130
VIRTUAL_WAYPOINT = 114
WAYPOINT_MAP_SIZE = 17

class DubinsPathType (Enum):
	RSR=0
	LSL=1
	LSR=2
	RSL=3
	LRL=4
	RLR=5
	ORBIT=6
	HELIX=7
	NEXT=8
	GOTO=9
	GOTO_MR=10

class FPMapMode (Enum):
	NONE=0
	ADD=1
	DELETE=2
	FINISH=3

class WaypointAction (Enum):
	ACTION_NONE=0
	BASE=1
	RELATIVE=2
	AGL_ALT=4
	AYL_ALT=8
	LANDING=16
	TAKEOFF=32
	FLY_OVER=64
	MAP_TO=128
	MAP_FROM=256
	END_OF_RUNWAY=512

class Waypoint:
	SIZE = 28

	def __init__ (self, num = 255, next = 255, latitude = 0.0, longitude = 0.0,
	altitude = 0.0, radius = 0.0, action = 0):
		self.num = num
		self.next = next
		self.latitude = latitude
		self.longitude = longitude
		self.altitude = altitude
		self.radius = radius
		self.action = action

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [Waypoint]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.num = struct.unpack_from('<B',buf,offset)[0]

		self.next = struct.unpack_from('<B',buf,offset)[0]

		self.latitude = struct.unpack_from('<d',buf,offset)[0]

		self.longitude = struct.unpack_from('<d',buf,offset)[0]

		self.altitude = struct.unpack_from('<f',buf,offset)[0]

		self.radius = struct.unpack_from('<f',buf,offset)[0]

		self.action = struct.unpack_from('<H',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.num))
		buf.extend(struct.pack('<B', self.next))
		buf.extend(struct.pack('<d', self.latitude))
		buf.extend(struct.pack('<d', self.longitude))
		buf.extend(struct.pack('<f', self.altitude))
		buf.extend(struct.pack('<f', self.radius))
		buf.extend(struct.pack('<H', self.action))
		return bytearray(buf)

class DubinsPath:
	SIZE = 109

	def __init__ (self, xc0_x = 0.0, xc0_y = 0.0, xc1_x = 0.0, xc1_y = 0.0,
	xc2_x = 0.0, xc2_y = 0.0, t0_i = 0.0, t0_f = 0.0, t1_i = 0.0, t1_f = 0.0,
	t2_i = 0.0, t2_f = 0.0, a = 0.0, b = 0.0, c0 = 0.0, c1 = 0.0, c2 = 0.0,
	x0 = 0.0, y0 = 0.0, z00 = 0.0, z01 = 0.0, z02 = 0.0, big_r = 0.0,
	origin_lat = 0.0, origin_lon = 0.0, path_type = DubinsPathType.GOTO):
		self.xc0_x = xc0_x
		self.xc0_y = xc0_y
		self.xc1_x = xc1_x
		self.xc1_y = xc1_y
		self.xc2_x = xc2_x
		self.xc2_y = xc2_y
		self.t0_i = t0_i
		self.t0_f = t0_f
		self.t1_i = t1_i
		self.t1_f = t1_f
		self.t2_i = t2_i
		self.t2_f = t2_f
		self.a = a
		self.b = b
		self.c0 = c0
		self.c1 = c1
		self.c2 = c2
		self.x0 = x0
		self.y0 = y0
		self.z00 = z00
		self.z01 = z01
		self.z02 = z02
		self.big_r = big_r
		self.origin_lat = origin_lat
		self.origin_lon = origin_lon

		self.path_type = DubinsPathType(path_type)

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [DubinsPath]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.xc0_x = struct.unpack_from('<f',buf,offset)[0]

		self.xc0_y = struct.unpack_from('<f',buf,offset)[0]

		self.xc1_x = struct.unpack_from('<f',buf,offset)[0]

		self.xc1_y = struct.unpack_from('<f',buf,offset)[0]

		self.xc2_x = struct.unpack_from('<f',buf,offset)[0]

		self.xc2_y = struct.unpack_from('<f',buf,offset)[0]

		self.t0_i = struct.unpack_from('<f',buf,offset)[0]

		self.t0_f = struct.unpack_from('<f',buf,offset)[0]

		self.t1_i = struct.unpack_from('<f',buf,offset)[0]

		self.t1_f = struct.unpack_from('<f',buf,offset)[0]

		self.t2_i = struct.unpack_from('<f',buf,offset)[0]

		self.t2_f = struct.unpack_from('<f',buf,offset)[0]

		self.a = struct.unpack_from('<f',buf,offset)[0]

		self.b = struct.unpack_from('<f',buf,offset)[0]

		self.c0 = struct.unpack_from('<f',buf,offset)[0]

		self.c1 = struct.unpack_from('<f',buf,offset)[0]

		self.c2 = struct.unpack_from('<f',buf,offset)[0]

		self.x0 = struct.unpack_from('<f',buf,offset)[0]

		self.y0 = struct.unpack_from('<f',buf,offset)[0]

		self.z00 = struct.unpack_from('<f',buf,offset)[0]

		self.z01 = struct.unpack_from('<f',buf,offset)[0]

		self.z02 = struct.unpack_from('<f',buf,offset)[0]

		self.big_r = struct.unpack_from('<f',buf,offset)[0]

		self.origin_lat = struct.unpack_from('<d',buf,offset)[0]

		self.origin_lon = struct.unpack_from('<d',buf,offset)[0]

		self.path_type = DubinsPathType(struct.unpack_from('<B',buf,offset)[0])
		offset = offset+struct.calcsize('<B')

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<f', self.xc0_x))
		buf.extend(struct.pack('<f', self.xc0_y))
		buf.extend(struct.pack('<f', self.xc1_x))
		buf.extend(struct.pack('<f', self.xc1_y))
		buf.extend(struct.pack('<f', self.xc2_x))
		buf.extend(struct.pack('<f', self.xc2_y))
		buf.extend(struct.pack('<f', self.t0_i))
		buf.extend(struct.pack('<f', self.t0_f))
		buf.extend(struct.pack('<f', self.t1_i))
		buf.extend(struct.pack('<f', self.t1_f))
		buf.extend(struct.pack('<f', self.t2_i))
		buf.extend(struct.pack('<f', self.t2_f))
		buf.extend(struct.pack('<f', self.a))
		buf.extend(struct.pack('<f', self.b))
		buf.extend(struct.pack('<f', self.c0))
		buf.extend(struct.pack('<f', self.c1))
		buf.extend(struct.pack('<f', self.c2))
		buf.extend(struct.pack('<f', self.x0))
		buf.extend(struct.pack('<f', self.y0))
		buf.extend(struct.pack('<f', self.z00))
		buf.extend(struct.pack('<f', self.z01))
		buf.extend(struct.pack('<f', self.z02))
		buf.extend(struct.pack('<f', self.big_r))
		buf.extend(struct.pack('<d', self.origin_lat))
		buf.extend(struct.pack('<d', self.origin_lon))

		buf.put(DubinsPathType.encode(self.path_type));
		return bytearray(buf)

class FlightPlanMap:
	SIZE = 18

	def __init__ (self, mode = FPMapMode.NONE, map = [None] * 17):
		self.mode = FPMapMode(mode)

		if (len(map) != 17):
			raise ValueError('array map expecting length '+str(17)+' got '+str(len(map)))

		self.map = list(map)

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [FlightPlanMap]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.mode = FPMapMode(struct.unpack_from('<B',buf,offset)[0])
		offset = offset+struct.calcsize('<B')

		self.map = [];

		for i in range(0,17):
			self.map.append(struct.unpack_from('<B',buf,offset)[0])
			offset = offset+struct.calcsize('<B')

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.put(FPMapMode.encode(self.mode));

		for val in self.map:
		    buf.extend(struct.pack('<B', val))
		return bytearray(buf)

#---------[ Mission ]---------#

class MissionInitialization (Enum):
	MISSION_LIMITS_INITIALIZED=1
	MISSION_LOST_COMMS_INITIALIZED=2
	MISSION_START_WP_INITIALIZED=4

#---------[ Sensors ]---------#

FLAGS_BARO_VALID = 256
FLAGS_SIMULATED = 64
FLAGS_SOURCE_UAT = 32767
FLAGS_VALID_ALTITUDE = 2
FLAGS_VALID_CALLSIGN = 16
FLAGS_VALID_COORDS = 1
FLAGS_VALID_HEADING = 4
FLAGS_VALID_SQUAWK = 32
FLAGS_VALID_VELOCITY = 8
FLAGS_VERTICAL_VELOCITY_VALID = 128

class ADSB_Altitude (Enum):
	# Altitude reported from a Baro source using QNH reference

	ALTITUDE_TYPE_PRESSURE_QNH=0

	# Altitude reported from a GNSS source

	ALTITUDE_TYPE_GEOMETRIC=1

class ADSB_Emitter (Enum):
	EMITTER_TYPE_NO_INFO=0
	EMITTER_TYPE_LIGHT=1
	EMITTER_TYPE_SMALL=2
	EMITTER_TYPE_LARGE=3
	EMITTER_TYPE_HIGH_VORTEX_LARGE=4
	EMITTER_TYPE_HEAVY=5
	EMITTER_TYPE_HIGHLY_MANUV=6
	EMITTER_TYPE_ROTOCRAFT=7
	EMITTER_TYPE_UNASSIGNED=8
	EMITTER_TYPE_GLIDER=9
	EMITTER_TYPE_LIGHTER_AIR=10
	EMITTER_TYPE_PARACHUTE=11
	EMITTER_TYPE_ULTRA_LIGHT=12
	EMITTER_TYPE_UNASSIGNED2=13
	EMITTER_TYPE_UAV=14
	EMITTER_TYPE_SPACE=15
	EMITTER_TYPE_UNASSGINED3=16
	EMITTER_TYPE_EMERGENCY_SURFACE=17
	EMITTER_TYPE_SERVICE_SURFACE=18
	EMITTER_TYPE_POINT_OBSTACLE=19

class CalibrationState (Enum):
	CAL_UNKNOWN=0
	REQUESTED=1
	SENT=2
	CALIBRATED=3

class GPSFixType (Enum):
	NO_FIX=0
	DEAD_RECKONING_ONLY=1
	FIX_2D=2
	FIX_3D=3
	GNSS_DEAD_RECKONING=4
	TIME_ONLY=5
	DGPS=6
	RTK=7

class SensorType (Enum):
	ACCELEROMETER=0
	GYROSCOPE=1
	MAGNETOMETER=2
	DYNAMIC_PRESSURE=3
	STATIC_PRESSURE=4
	TEMPERATURE=5
	HUMIDITY=6
	AGL=7
	GPS=8
	SENSOR_PAYLOAD_1=9
	SENSOR_PAYLOAD_2=10
	SENSOR_PAYLOAD_3=11
	SENSOR_PAYLOAD_4=12
	SENSOR_PAYLOAD_5=13
	UNKNOWN_SENSOR=14

class AxisMapping:
	SIZE = 3

	def __init__ (self, axis = [None] * 3):
		if (len(axis) != 3):
			raise ValueError('array axis expecting length '+str(3)+' got '+str(len(axis)))

		self.axis = list(axis)

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [AxisMapping]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.axis = [];

		for i in range(0,3):
			self.axis.append(struct.unpack_from('<b',buf,offset)[0])
			offset = offset+struct.calcsize('<b')

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		for val in self.axis:
		    buf.extend(struct.pack('<b', val))
		return bytearray(buf)

class MHP:
	SIZE = 52

	def __init__ (self, system_time = 0.0, alpha = 0.0, beta = 0.0, q = 0.0, ias = 0.0,
	tas = 0.0, wind = [None] * 3, quaternion = [None] * 4):
		self.system_time = system_time
		self.alpha = alpha
		self.beta = beta
		self.q = q
		self.ias = ias
		self.tas = tas

		if (len(wind) != 3):
			raise ValueError('array wind expecting length '+str(3)+' got '+str(len(wind)))

		self.wind = list(wind)

		if (len(quaternion) != 4):
			raise ValueError('array quaternion expecting length '+str(4)+' got '+str(len(quaternion)))

		self.quaternion = list(quaternion)

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [MHP]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.system_time = struct.unpack_from('<f',buf,offset)[0]

		self.alpha = struct.unpack_from('<f',buf,offset)[0]

		self.beta = struct.unpack_from('<f',buf,offset)[0]

		self.q = struct.unpack_from('<f',buf,offset)[0]

		self.ias = struct.unpack_from('<f',buf,offset)[0]

		self.tas = struct.unpack_from('<f',buf,offset)[0]

		self.wind = [];

		for i in range(0,3):
			self.wind.append(struct.unpack_from('<f',buf,offset)[0])
			offset = offset+struct.calcsize('<f')

		self.quaternion = [];

		for i in range(0,4):
			self.quaternion.append(struct.unpack_from('<f',buf,offset)[0])
			offset = offset+struct.calcsize('<f')

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<f', self.system_time))
		buf.extend(struct.pack('<f', self.alpha))
		buf.extend(struct.pack('<f', self.beta))
		buf.extend(struct.pack('<f', self.q))
		buf.extend(struct.pack('<f', self.ias))
		buf.extend(struct.pack('<f', self.tas))

		for val in self.wind:
		    buf.extend(struct.pack('<f', val))

		for val in self.quaternion:
		    buf.extend(struct.pack('<f', val))
		return bytearray(buf)

class MHP9HSensors:
	SIZE = 77

	def __init__ (self, system_time = 0.0, error_code = 0,
	static_pressure = 0.0, dynamic_pressure = [None] * 9, air_temperature = 0.0,
	humidity = 0.0, gyroscope = [None] * 3, accelerometer = [None] * 3):
		self.system_time = system_time
		self.error_code = error_code
		self.static_pressure = static_pressure

		if (len(dynamic_pressure) != 9):
			raise ValueError('array dynamic_pressure expecting length '+str(9)+' got '+str(len(dynamic_pressure)))

		self.dynamic_pressure = list(dynamic_pressure)

		self.air_temperature = air_temperature
		self.humidity = humidity

		if (len(gyroscope) != 3):
			raise ValueError('array gyroscope expecting length '+str(3)+' got '+str(len(gyroscope)))

		self.gyroscope = list(gyroscope)

		if (len(accelerometer) != 3):
			raise ValueError('array accelerometer expecting length '+str(3)+' got '+str(len(accelerometer)))

		self.accelerometer = list(accelerometer)

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [MHP9HSensors]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.system_time = struct.unpack_from('<f',buf,offset)[0]

		self.error_code = struct.unpack_from('<B',buf,offset)[0]

		self.static_pressure = struct.unpack_from('<f',buf,offset)[0]

		self.dynamic_pressure = [];

		for i in range(0,9):
			self.dynamic_pressure.append(struct.unpack_from('<f',buf,offset)[0])
			offset = offset+struct.calcsize('<f')

		self.air_temperature = struct.unpack_from('<f',buf,offset)[0]

		self.humidity = struct.unpack_from('<f',buf,offset)[0]

		self.gyroscope = [];

		for i in range(0,3):
			self.gyroscope.append(struct.unpack_from('<f',buf,offset)[0])
			offset = offset+struct.calcsize('<f')

		self.accelerometer = [];

		for i in range(0,3):
			self.accelerometer.append(struct.unpack_from('<f',buf,offset)[0])
			offset = offset+struct.calcsize('<f')

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<f', self.system_time))
		buf.extend(struct.pack('<B', self.error_code))
		buf.extend(struct.pack('<f', self.static_pressure))

		for val in self.dynamic_pressure:
		    buf.extend(struct.pack('<f', val))

		buf.extend(struct.pack('<f', self.air_temperature))
		buf.extend(struct.pack('<f', self.humidity))

		for val in self.gyroscope:
		    buf.extend(struct.pack('<f', val))

		for val in self.accelerometer:
		    buf.extend(struct.pack('<f', val))
		return bytearray(buf)

class MHP9HTiming:
	SIZE = 64

	def __init__ (self, system_time = 0.0, static_pressure_time = 0.0,
	dynamic_pressure_time = [None] * 9, air_temperature_time = 0.0,
	humidity_time = 0.0, imu_time = 0.0, magnetometer_time = 0.0,
	gps_time = 0.0):
		self.system_time = system_time
		self.static_pressure_time = static_pressure_time

		if (len(dynamic_pressure_time) != 9):
			raise ValueError('array dynamic_pressure_time expecting length '+str(9)+' got '+str(len(dynamic_pressure_time)))

		self.dynamic_pressure_time = list(dynamic_pressure_time)

		self.air_temperature_time = air_temperature_time
		self.humidity_time = humidity_time
		self.imu_time = imu_time
		self.magnetometer_time = magnetometer_time
		self.gps_time = gps_time

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [MHP9HTiming]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.system_time = struct.unpack_from('<f',buf,offset)[0]

		self.static_pressure_time = struct.unpack_from('<f',buf,offset)[0]

		self.dynamic_pressure_time = [];

		for i in range(0,9):
			self.dynamic_pressure_time.append(struct.unpack_from('<f',buf,offset)[0])
			offset = offset+struct.calcsize('<f')

		self.air_temperature_time = struct.unpack_from('<f',buf,offset)[0]

		self.humidity_time = struct.unpack_from('<f',buf,offset)[0]

		self.imu_time = struct.unpack_from('<f',buf,offset)[0]

		self.magnetometer_time = struct.unpack_from('<f',buf,offset)[0]

		self.gps_time = struct.unpack_from('<f',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<f', self.system_time))
		buf.extend(struct.pack('<f', self.static_pressure_time))

		for val in self.dynamic_pressure_time:
		    buf.extend(struct.pack('<f', val))

		buf.extend(struct.pack('<f', self.air_temperature_time))
		buf.extend(struct.pack('<f', self.humidity_time))
		buf.extend(struct.pack('<f', self.imu_time))
		buf.extend(struct.pack('<f', self.magnetometer_time))
		buf.extend(struct.pack('<f', self.gps_time))
		return bytearray(buf)

class MHPSensors:
	SIZE = 61

	def __init__ (self, system_time = 0.0, error_code = 0, static_pressure = 0.0,
	dynamic_pressure = [None] * 5, air_temperature = 0.0, humidity = 0.0,
	gyroscope = [None] * 3, accelerometer = [None] * 3):
		self.system_time = system_time
		self.error_code = error_code
		self.static_pressure = static_pressure

		if (len(dynamic_pressure) != 5):
			raise ValueError('array dynamic_pressure expecting length '+str(5)+' got '+str(len(dynamic_pressure)))

		self.dynamic_pressure = list(dynamic_pressure)

		self.air_temperature = air_temperature
		self.humidity = humidity

		if (len(gyroscope) != 3):
			raise ValueError('array gyroscope expecting length '+str(3)+' got '+str(len(gyroscope)))

		self.gyroscope = list(gyroscope)

		if (len(accelerometer) != 3):
			raise ValueError('array accelerometer expecting length '+str(3)+' got '+str(len(accelerometer)))

		self.accelerometer = list(accelerometer)

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [MHPSensors]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.system_time = struct.unpack_from('<f',buf,offset)[0]

		self.error_code = struct.unpack_from('<B',buf,offset)[0]

		self.static_pressure = struct.unpack_from('<f',buf,offset)[0]

		self.dynamic_pressure = [];

		for i in range(0,5):
			self.dynamic_pressure.append(struct.unpack_from('<f',buf,offset)[0])
			offset = offset+struct.calcsize('<f')

		self.air_temperature = struct.unpack_from('<f',buf,offset)[0]

		self.humidity = struct.unpack_from('<f',buf,offset)[0]

		self.gyroscope = [];

		for i in range(0,3):
			self.gyroscope.append(struct.unpack_from('<f',buf,offset)[0])
			offset = offset+struct.calcsize('<f')

		self.accelerometer = [];

		for i in range(0,3):
			self.accelerometer.append(struct.unpack_from('<f',buf,offset)[0])
			offset = offset+struct.calcsize('<f')

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<f', self.system_time))
		buf.extend(struct.pack('<B', self.error_code))
		buf.extend(struct.pack('<f', self.static_pressure))

		for val in self.dynamic_pressure:
		    buf.extend(struct.pack('<f', val))

		buf.extend(struct.pack('<f', self.air_temperature))
		buf.extend(struct.pack('<f', self.humidity))

		for val in self.gyroscope:
		    buf.extend(struct.pack('<f', val))

		for val in self.accelerometer:
		    buf.extend(struct.pack('<f', val))
		return bytearray(buf)

class MHPSensorsGNSS:
	SIZE = 60

	def __init__ (self, system_time = 0.0, magnetometer = [None] * 3,
	week = 0, hour = 0, minute = 0, seconds = 0.0, latitude = 0.0,
	longitude = 0.0, altitude = 0.0, velocity = [None] * 3, pdop = 0.0):
		self.system_time = system_time

		if (len(magnetometer) != 3):
			raise ValueError('array magnetometer expecting length '+str(3)+' got '+str(len(magnetometer)))

		self.magnetometer = list(magnetometer)

		self.week = week
		self.hour = hour
		self.minute = minute
		self.seconds = seconds
		self.latitude = latitude
		self.longitude = longitude
		self.altitude = altitude

		if (len(velocity) != 3):
			raise ValueError('array velocity expecting length '+str(3)+' got '+str(len(velocity)))

		self.velocity = list(velocity)

		self.pdop = pdop

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [MHPSensorsGNSS]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.system_time = struct.unpack_from('<f',buf,offset)[0]

		self.magnetometer = [];

		for i in range(0,3):
			self.magnetometer.append(struct.unpack_from('<f',buf,offset)[0])
			offset = offset+struct.calcsize('<f')

		self.week = struct.unpack_from('<H',buf,offset)[0]

		self.hour = struct.unpack_from('<B',buf,offset)[0]

		self.minute = struct.unpack_from('<B',buf,offset)[0]

		self.seconds = struct.unpack_from('<f',buf,offset)[0]

		self.latitude = struct.unpack_from('<d',buf,offset)[0]

		self.longitude = struct.unpack_from('<d',buf,offset)[0]

		self.altitude = struct.unpack_from('<f',buf,offset)[0]

		self.velocity = [];

		for i in range(0,3):
			self.velocity.append(struct.unpack_from('<f',buf,offset)[0])
			offset = offset+struct.calcsize('<f')

		self.pdop = struct.unpack_from('<f',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<f', self.system_time))

		for val in self.magnetometer:
		    buf.extend(struct.pack('<f', val))

		buf.extend(struct.pack('<H', self.week))
		buf.extend(struct.pack('<B', self.hour))
		buf.extend(struct.pack('<B', self.minute))
		buf.extend(struct.pack('<f', self.seconds))
		buf.extend(struct.pack('<d', self.latitude))
		buf.extend(struct.pack('<d', self.longitude))
		buf.extend(struct.pack('<f', self.altitude))

		for val in self.velocity:
		    buf.extend(struct.pack('<f', val))

		buf.extend(struct.pack('<f', self.pdop))
		return bytearray(buf)

class MHPTiming:
	SIZE = 48

	def __init__ (self, system_time = 0.0, static_pressure_time = 0.0,
	dynamic_pressure_time = [None] * 5, air_temperature_time = 0.0,
	humidity_time = 0.0, imu_time = 0.0, magnetometer_time = 0.0,
	gps_time = 0.0):
		self.system_time = system_time
		self.static_pressure_time = static_pressure_time

		if (len(dynamic_pressure_time) != 5):
			raise ValueError('array dynamic_pressure_time expecting length '+str(5)+' got '+str(len(dynamic_pressure_time)))

		self.dynamic_pressure_time = list(dynamic_pressure_time)

		self.air_temperature_time = air_temperature_time
		self.humidity_time = humidity_time
		self.imu_time = imu_time
		self.magnetometer_time = magnetometer_time
		self.gps_time = gps_time

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [MHPTiming]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.system_time = struct.unpack_from('<f',buf,offset)[0]

		self.static_pressure_time = struct.unpack_from('<f',buf,offset)[0]

		self.dynamic_pressure_time = [];

		for i in range(0,5):
			self.dynamic_pressure_time.append(struct.unpack_from('<f',buf,offset)[0])
			offset = offset+struct.calcsize('<f')

		self.air_temperature_time = struct.unpack_from('<f',buf,offset)[0]

		self.humidity_time = struct.unpack_from('<f',buf,offset)[0]

		self.imu_time = struct.unpack_from('<f',buf,offset)[0]

		self.magnetometer_time = struct.unpack_from('<f',buf,offset)[0]

		self.gps_time = struct.unpack_from('<f',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<f', self.system_time))
		buf.extend(struct.pack('<f', self.static_pressure_time))

		for val in self.dynamic_pressure_time:
		    buf.extend(struct.pack('<f', val))

		buf.extend(struct.pack('<f', self.air_temperature_time))
		buf.extend(struct.pack('<f', self.humidity_time))
		buf.extend(struct.pack('<f', self.imu_time))
		buf.extend(struct.pack('<f', self.magnetometer_time))
		buf.extend(struct.pack('<f', self.gps_time))
		return bytearray(buf)

class Pressure:
	SIZE = 12

	def __init__ (self, system_time = 0.0, pressure = 0.0, temperature = 0.0):
		self.system_time = system_time
		self.pressure = pressure
		self.temperature = temperature

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [Pressure]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.system_time = struct.unpack_from('<f',buf,offset)[0]

		self.pressure = struct.unpack_from('<f',buf,offset)[0]

		self.temperature = struct.unpack_from('<f',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<f', self.system_time))
		buf.extend(struct.pack('<f', self.pressure))
		buf.extend(struct.pack('<f', self.temperature))
		return bytearray(buf)

class RTCM:
	SIZE = 65

	def __init__ (self, size = 0, payload = [None] * 64):
		self.size = size

		if (len(payload) != 64):
			raise ValueError('array payload expecting length '+str(64)+' got '+str(len(payload)))

		self.payload = list(payload)

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [RTCM]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.size = struct.unpack_from('<B',buf,offset)[0]

		self.payload = [];

		for i in range(0,64):
			self.payload.append(struct.unpack_from('<B',buf,offset)[0])
			offset = offset+struct.calcsize('<B')

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.size))

		for val in self.payload:
		    buf.extend(struct.pack('<B', val))
		return bytearray(buf)

class SensorOffsets:
	SIZE = 33

	def __init__ (self, status = 0, gyroscope_x = 0.0, gyroscope_y = 0.0,
	gyroscope_z = 0.0, magnetometer_x = 0.0, magnetometer_y = 0.0,
	magnetometer_z = 0.0, dynamic_pressure = 0.0, temperature = 0.0):
		self.status = status
		self.gyroscope_x = gyroscope_x
		self.gyroscope_y = gyroscope_y
		self.gyroscope_z = gyroscope_z
		self.magnetometer_x = magnetometer_x
		self.magnetometer_y = magnetometer_y
		self.magnetometer_z = magnetometer_z
		self.dynamic_pressure = dynamic_pressure
		self.temperature = temperature

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [SensorOffsets]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.status = struct.unpack_from('<B',buf,offset)[0]

		self.gyroscope_x = struct.unpack_from('<f',buf,offset)[0]

		self.gyroscope_y = struct.unpack_from('<f',buf,offset)[0]

		self.gyroscope_z = struct.unpack_from('<f',buf,offset)[0]

		self.magnetometer_x = struct.unpack_from('<f',buf,offset)[0]

		self.magnetometer_y = struct.unpack_from('<f',buf,offset)[0]

		self.magnetometer_z = struct.unpack_from('<f',buf,offset)[0]

		self.dynamic_pressure = struct.unpack_from('<f',buf,offset)[0]

		self.temperature = struct.unpack_from('<f',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.status))
		buf.extend(struct.pack('<f', self.gyroscope_x))
		buf.extend(struct.pack('<f', self.gyroscope_y))
		buf.extend(struct.pack('<f', self.gyroscope_z))
		buf.extend(struct.pack('<f', self.magnetometer_x))
		buf.extend(struct.pack('<f', self.magnetometer_y))
		buf.extend(struct.pack('<f', self.magnetometer_z))
		buf.extend(struct.pack('<f', self.dynamic_pressure))
		buf.extend(struct.pack('<f', self.temperature))
		return bytearray(buf)

class SingleAxisSensorCalibration:
	SIZE = 8

	def __init__ (self, b = 0.0, m = 0.0):
		self.b = b
		self.m = m

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [SingleAxisSensorCalibration]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.b = struct.unpack_from('<f',buf,offset)[0]

		self.m = struct.unpack_from('<f',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<f', self.b))
		buf.extend(struct.pack('<f', self.m))
		return bytearray(buf)

class SingleValue:
	SIZE = 4

	def __init__ (self, value = 0.0):
		self.value = value

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [SingleValue]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.value = struct.unpack_from('<f',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<f', self.value))
		return bytearray(buf)

class SingleValueSensor:
	SIZE = 8

	def __init__ (self, system_time = 0.0, value = 0.0):
		self.system_time = system_time
		self.value = value

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [SingleValueSensor]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.system_time = struct.unpack_from('<f',buf,offset)[0]

		self.value = struct.unpack_from('<f',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<f', self.system_time))
		buf.extend(struct.pack('<f', self.value))
		return bytearray(buf)

class ThreeAxisSensor:
	SIZE = 16

	def __init__ (self, system_time = 0.0, x = 0.0, y = 0.0, z = 0.0):
		self.system_time = system_time
		self.x = x
		self.y = y
		self.z = z

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [ThreeAxisSensor]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.system_time = struct.unpack_from('<f',buf,offset)[0]

		self.x = struct.unpack_from('<f',buf,offset)[0]

		self.y = struct.unpack_from('<f',buf,offset)[0]

		self.z = struct.unpack_from('<f',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<f', self.system_time))
		buf.extend(struct.pack('<f', self.x))
		buf.extend(struct.pack('<f', self.y))
		buf.extend(struct.pack('<f', self.z))
		return bytearray(buf)

class ThreeAxisSensorCalibration:
	SIZE = 48

	def __init__ (self, b = [None] * 3, m = [None] * 9):
		if (len(b) != 3):
			raise ValueError('array b expecting length '+str(3)+' got '+str(len(b)))

		self.b = list(b)

		if (len(m) != 9):
			raise ValueError('array m expecting length '+str(9)+' got '+str(len(m)))

		self.m = list(m)

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [ThreeAxisSensorCalibration]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.b = [];

		for i in range(0,3):
			self.b.append(struct.unpack_from('<f',buf,offset)[0])
			offset = offset+struct.calcsize('<f')

		self.m = [];

		for i in range(0,9):
			self.m.append(struct.unpack_from('<f',buf,offset)[0])
			offset = offset+struct.calcsize('<f')

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		for val in self.b:
		    buf.extend(struct.pack('<f', val))

		for val in self.m:
		    buf.extend(struct.pack('<f', val))
		return bytearray(buf)

class ADSB:
	SIZE = 56

	def __init__ (self, system_time = 0.0, icao_address = 0, latitude = 0.0,
	longitude = 0.0, altitude_type = ADSB_Altitude(0), altitude = 0.0,
	heading = 0.0, horizontal_velocity = 0.0, vertical_velocity = 0.0,
	callsign = [None] * 9, emitter_type = ADSB_Emitter(0), tslc = 0, flags = 0,
	squawk = 0):
		self.system_time = system_time
		self.icao_address = icao_address
		self.latitude = latitude
		self.longitude = longitude

		self.altitude_type = ADSB_Altitude(altitude_type)

		self.altitude = altitude
		self.heading = heading
		self.horizontal_velocity = horizontal_velocity
		self.vertical_velocity = vertical_velocity

		if (len(callsign) != 9):
			raise ValueError('array callsign expecting length '+str(9)+' got '+str(len(callsign)))

		self.callsign = list(callsign)

		self.emitter_type = ADSB_Emitter(emitter_type)

		self.tslc = tslc
		self.flags = flags
		self.squawk = squawk

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [ADSB]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.system_time = struct.unpack_from('<f',buf,offset)[0]

		self.icao_address = struct.unpack_from('<I',buf,offset)[0]

		self.latitude = struct.unpack_from('<d',buf,offset)[0]

		self.longitude = struct.unpack_from('<d',buf,offset)[0]

		self.altitude_type = ADSB_Altitude(struct.unpack_from('<B',buf,offset)[0])
		offset = offset+struct.calcsize('<B')

		self.altitude = struct.unpack_from('<f',buf,offset)[0]

		self.heading = struct.unpack_from('<f',buf,offset)[0]

		self.horizontal_velocity = struct.unpack_from('<f',buf,offset)[0]

		self.vertical_velocity = struct.unpack_from('<f',buf,offset)[0]

		self.callsign = [];

		for i in range(0,9):
			self.callsign.append(struct.unpack_from('<B',buf,offset)[0])
			offset = offset+struct.calcsize('<B')

		self.emitter_type = ADSB_Emitter(struct.unpack_from('<B',buf,offset)[0])
		offset = offset+struct.calcsize('<B')

		self.tslc = struct.unpack_from('<B',buf,offset)[0]

		self.flags = struct.unpack_from('<H',buf,offset)[0]

		self.squawk = struct.unpack_from('<H',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<f', self.system_time))
		buf.extend(struct.pack('<I', self.icao_address))
		buf.extend(struct.pack('<d', self.latitude))
		buf.extend(struct.pack('<d', self.longitude))

		buf.put(ADSB_Altitude.encode(self.altitude_type));

		buf.extend(struct.pack('<f', self.altitude))
		buf.extend(struct.pack('<f', self.heading))
		buf.extend(struct.pack('<f', self.horizontal_velocity))
		buf.extend(struct.pack('<f', self.vertical_velocity))

		for val in self.callsign:
		    buf.extend(struct.pack('<B', val))

		buf.put(ADSB_Emitter.encode(self.emitter_type));

		buf.extend(struct.pack('<B', self.tslc))
		buf.extend(struct.pack('<H', self.flags))
		buf.extend(struct.pack('<H', self.squawk))
		return bytearray(buf)

class CalibrateSensor:
	SIZE = 2

	def __init__ (self, sensor = SensorType.UNKNOWN_SENSOR,
	state = CalibrationState.CAL_UNKNOWN):
		self.sensor = SensorType(sensor)

		self.state = CalibrationState(state)

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [CalibrateSensor]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.sensor = SensorType(struct.unpack_from('<B',buf,offset)[0])
		offset = offset+struct.calcsize('<B')

		self.state = CalibrationState(struct.unpack_from('<B',buf,offset)[0])
		offset = offset+struct.calcsize('<B')

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.put(SensorType.encode(self.sensor));

		buf.put(CalibrationState.encode(self.state));
		return bytearray(buf)

class GPS:
	SIZE = 66

	def __init__ (self, system_time = 0.0, week = 0, hour = 0, minute = 0,
	seconds = 0.0, latitude = 0.0, longitude = 0.0, altitude = 0.0, speed = 0.0,
	course = 0.0, satellites = 0, pdop = 0.0, last_fix = -1.0,
	fix_type = GPSFixType.NO_FIX, velocity = 0):
		self.system_time = system_time
		self.week = week
		self.hour = hour
		self.minute = minute
		self.seconds = seconds
		self.latitude = latitude
		self.longitude = longitude
		self.altitude = altitude
		self.speed = speed
		self.course = course
		self.satellites = satellites
		self.pdop = pdop
		self.last_fix = last_fix

		self.fix_type = GPSFixType(fix_type)

		self.velocity = ThreeAxisSensor(velocity)

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [GPS]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.system_time = struct.unpack_from('<f',buf,offset)[0]

		self.week = struct.unpack_from('<H',buf,offset)[0]

		self.hour = struct.unpack_from('<B',buf,offset)[0]

		self.minute = struct.unpack_from('<B',buf,offset)[0]

		self.seconds = struct.unpack_from('<f',buf,offset)[0]

		self.latitude = struct.unpack_from('<d',buf,offset)[0]

		self.longitude = struct.unpack_from('<d',buf,offset)[0]

		self.altitude = struct.unpack_from('<f',buf,offset)[0]

		self.speed = struct.unpack_from('<f',buf,offset)[0]

		self.course = struct.unpack_from('<f',buf,offset)[0]

		self.satellites = struct.unpack_from('<B',buf,offset)[0]

		self.pdop = struct.unpack_from('<f',buf,offset)[0]

		self.last_fix = struct.unpack_from('<f',buf,offset)[0]

		self.fix_type = GPSFixType(struct.unpack_from('<B',buf,offset)[0])
		offset = offset+struct.calcsize('<B')

		self.velocity = ThreeAxisSensor()
		self.velocity.parse(buf[offset:offset+ThreeAxisSensor.SIZE])
		offset = offset+ThreeAxisSensor.SIZE

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<f', self.system_time))
		buf.extend(struct.pack('<H', self.week))
		buf.extend(struct.pack('<B', self.hour))
		buf.extend(struct.pack('<B', self.minute))
		buf.extend(struct.pack('<f', self.seconds))
		buf.extend(struct.pack('<d', self.latitude))
		buf.extend(struct.pack('<d', self.longitude))
		buf.extend(struct.pack('<f', self.altitude))
		buf.extend(struct.pack('<f', self.speed))
		buf.extend(struct.pack('<f', self.course))
		buf.extend(struct.pack('<B', self.satellites))
		buf.extend(struct.pack('<f', self.pdop))
		buf.extend(struct.pack('<f', self.last_fix))

		buf.put(GPSFixType.encode(self.fix_type));

		buf.extend(self.velocity.serialize())
		return bytearray(buf)

class IMU:
	SIZE = 56

	def __init__ (self, accelerometer = 0, gyroscope = 0, magnetometer = 0,
	temperature = 0):
		self.accelerometer = ThreeAxisSensor(accelerometer)

		self.gyroscope = ThreeAxisSensor(gyroscope)

		self.magnetometer = ThreeAxisSensor(magnetometer)

		self.temperature = SingleValueSensor(temperature)

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [IMU]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.accelerometer = ThreeAxisSensor()
		self.accelerometer.parse(buf[offset:offset+ThreeAxisSensor.SIZE])
		offset = offset+ThreeAxisSensor.SIZE

		self.gyroscope = ThreeAxisSensor()
		self.gyroscope.parse(buf[offset:offset+ThreeAxisSensor.SIZE])
		offset = offset+ThreeAxisSensor.SIZE

		self.magnetometer = ThreeAxisSensor()
		self.magnetometer.parse(buf[offset:offset+ThreeAxisSensor.SIZE])
		offset = offset+ThreeAxisSensor.SIZE

		self.temperature = SingleValueSensor()
		self.temperature.parse(buf[offset:offset+SingleValueSensor.SIZE])
		offset = offset+SingleValueSensor.SIZE

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(self.accelerometer.serialize())
		buf.extend(self.gyroscope.serialize())
		buf.extend(self.magnetometer.serialize())
		buf.extend(self.temperature.serialize())
		return bytearray(buf)

class ThreeAxisFirstOrderCorrection:
	SIZE = 25

	def __init__ (self, sensor = SensorType.UNKNOWN_SENSOR,
	x = [None] * 2, y = [None] * 2, z = [None] * 2):
		self.sensor = SensorType(sensor)

		if (len(x) != 2):
			raise ValueError('array x expecting length '+str(2)+' got '+str(len(x)))

		self.x = list(x)

		if (len(y) != 2):
			raise ValueError('array y expecting length '+str(2)+' got '+str(len(y)))

		self.y = list(y)

		if (len(z) != 2):
			raise ValueError('array z expecting length '+str(2)+' got '+str(len(z)))

		self.z = list(z)

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [ThreeAxisFirstOrderCorrection]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.sensor = SensorType(struct.unpack_from('<B',buf,offset)[0])
		offset = offset+struct.calcsize('<B')

		self.x = [];

		for i in range(0,2):
			self.x.append(struct.unpack_from('<f',buf,offset)[0])
			offset = offset+struct.calcsize('<f')

		self.y = [];

		for i in range(0,2):
			self.y.append(struct.unpack_from('<f',buf,offset)[0])
			offset = offset+struct.calcsize('<f')

		self.z = [];

		for i in range(0,2):
			self.z.append(struct.unpack_from('<f',buf,offset)[0])
			offset = offset+struct.calcsize('<f')

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.put(SensorType.encode(self.sensor));

		for val in self.x:
		    buf.extend(struct.pack('<f', val))

		for val in self.y:
		    buf.extend(struct.pack('<f', val))

		for val in self.z:
		    buf.extend(struct.pack('<f', val))
		return bytearray(buf)

class Sensors:
	SIZE = 170

	def __init__ (self, imu = 0, gps = 0, dynamic_pressure = 0, static_pressure = 0,
	air_temperature = 0, humidity = 0, agl = 0):
		self.imu = IMU(imu)

		self.gps = GPS(gps)

		self.dynamic_pressure = Pressure(dynamic_pressure)

		self.static_pressure = Pressure(static_pressure)

		self.air_temperature = SingleValueSensor(air_temperature)

		self.humidity = SingleValueSensor(humidity)

		self.agl = SingleValueSensor(agl)

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [Sensors]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.imu = IMU()
		self.imu.parse(buf[offset:offset+IMU.SIZE])
		offset = offset+IMU.SIZE

		self.gps = GPS()
		self.gps.parse(buf[offset:offset+GPS.SIZE])
		offset = offset+GPS.SIZE

		self.dynamic_pressure = Pressure()
		self.dynamic_pressure.parse(buf[offset:offset+Pressure.SIZE])
		offset = offset+Pressure.SIZE

		self.static_pressure = Pressure()
		self.static_pressure.parse(buf[offset:offset+Pressure.SIZE])
		offset = offset+Pressure.SIZE

		self.air_temperature = SingleValueSensor()
		self.air_temperature.parse(buf[offset:offset+SingleValueSensor.SIZE])
		offset = offset+SingleValueSensor.SIZE

		self.humidity = SingleValueSensor()
		self.humidity.parse(buf[offset:offset+SingleValueSensor.SIZE])
		offset = offset+SingleValueSensor.SIZE

		self.agl = SingleValueSensor()
		self.agl.parse(buf[offset:offset+SingleValueSensor.SIZE])
		offset = offset+SingleValueSensor.SIZE

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(self.imu.serialize())
		buf.extend(self.gps.serialize())
		buf.extend(self.dynamic_pressure.serialize())
		buf.extend(self.static_pressure.serialize())
		buf.extend(self.air_temperature.serialize())
		buf.extend(self.humidity.serialize())
		buf.extend(self.agl.serialize())
		return bytearray(buf)

#---------[ Status ]---------#

class HardwareErrors (Enum):
	HW_ERROR_WATCHDOG_RESET=0
	HW_ERROR_I2C_BUS_LOCK=1
	HW_ERROR_CAN_BUS_LOCK=2
	HW_ERROR_HARD_FAULT=3
	HW_ERROR_MEM_MANAGE=4
	HW_ERROR_BUS_FAULT=5
	HW_ERROR_USAGE_FAULT=6

class InterruptTags (Enum):
	IRQ_INVALID=0
	IRQ_SYSTICK=1
	IRQ_TIMER=2
	IRQ_I2C1=3
	IRQ_I2C2=4
	IRQ_CAN1_RX=5
	IRQ_CAN1_TX=6
	IRQ_CAN2_RX=7
	IRQ_CAN2_TX=8
	IRQ_USART1=9
	IRQ_USART2=10
	IRQ_UART4=11
	IRQ_SDIO=12
	IRQ_COMM_RX=13
	IRQ_COMM_TX=14
	IRQ_DMA2_STREAM5=15
	IRQ_DMA2_STREAM7=16
	IRQ_DMA1_STREAM2=17
	IRQ_DMA1_STREAM5=18
	IRQ_DMA1_STREAM6=19
	IRQ_DMA1_STREAM1=20
	IRQ_DMA1_STREAM4=21
	IRQ_DMA1_STREAM3=22
	IRQ_DMA2_STREAM3=23
	IRQ_DMA2_STREAM6=24

class SystemErrors (Enum):
	ERROR_NO_ERROR=0
	ERROR_LOW_BATT=1
	ERROR_HIGH_VOLTAGE=2
	ERROR_NO_BATT=4
	ERROR_NO_GPS=8
	ERROR_NO_RADIO=16
	ERROR_HIGH_CURRENT=32
	ERROR_HIGH_TEMP=64
	ERROR_ENGINE_OUT=128
	ERROR_NAVIGATION_ERROR=256
	ERROR_CONTROLLER_ERROR=512
	ERROR_BAD_IAS=1024
	ERROR_FLYING_NO_PREFLIGHT=2048
	ERROR_NO_PAYLOAD_ACTUATOR=4096
	ERROR_BAD_FLIGHTPLAN=8192
	ERROR_NO_SD_CARD=16384
	ERROR_SD_CARD_ERROR=32768
	ERROR_GEOFENCE=65536
	ERROR_BAD_GPS=131072
	ERROR_NO_LASER=262144
	ERROR_NO_STATIC_PRESS=524288
	ERROR_NO_MAG=1048576
	ERROR_COMM_LIMIT=2097152
	ERROR_BAD_COMMS=4194304
	ERROR_BAD_HANDSET=8388608
	ERROR_BATT_LIMIT=16777216
	ERROR_CRITICAL_BATT=33554432
	ERROR_HW_FAULT=67108864
	ERROR_BAD_PROPULSION=134217728
	ERROR_ICING=268435456
	ERROR_BAD_LAUNCH=536870912
	ERROR_RESET_IN_FLIGHT=1073741824

	# ERROR_WIND_LIMIT          = 0x00000000

	# ERROR_TEMPERATURE_LIMIT   = 0x00000000

	# ERROR_DA_LIMIT            = 0x00000000

class TaskTags (Enum):
	TASK_INVALID=0
	TASK_SENSORS=1
	TASK_ESTIMATOR=2
	TASK_CONTROLLER=3
	TASK_ACTUATORS=4
	TASK_LOGGING=5
	TASK_SAVE_PARAM=6
	TASK_INPUT=7
	TASK_COMM_RX=8
	TASK_COMM_TX=9
	TASK_SYSTEM=10
	TASK_EEPROM=11
	TASK_SDCARD=12

#---------[ System ]---------#

class HardwareModel (Enum):
	HW_UNKNOWN=0
	HW_LITE=1
	HW_TEMPEST=2
	HW_PRO=3
	HW_SWIL=4
	HW_XPLANE=5

class RadioType (Enum):
	RADIO_SOCKET=0
	RADIO_SERIAL=1
	RADIO_P900=2
	RADIO_XBEE=3
	RADIO_XTEND=4
	RADIO_INVALID=5

class SystemMode (Enum):
	INITALIZE=0
	START_UP=1
	PREFLIGHT=2
	FLIGHT=3
	HWIL=4

class VehicleType (Enum):
	VEHICLE_UNKNOWN=0
	FIXED_WING=1
	MULTI_COPTER=2
	GCS=3
	PAYLOAD_NODE=4
	TAIL_SITTER=5
	VTOL=6

class HardwareError:
	SIZE = 35

	def __init__ (self, error_code = 0, r0 = 0, r1 = 0, r2 = 0, r3 = 0,
	r12 = 0, lr = 0, pc = 0, psr = 0, task = 0, irq = 0):
		self.error_code = error_code
		self.r0 = r0
		self.r1 = r1
		self.r2 = r2
		self.r3 = r3
		self.r12 = r12
		self.lr = lr
		self.pc = pc
		self.psr = psr
		self.task = task
		self.irq = irq

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [HardwareError]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.error_code = struct.unpack_from('<B',buf,offset)[0]

		self.r0 = struct.unpack_from('<I',buf,offset)[0]

		self.r1 = struct.unpack_from('<I',buf,offset)[0]

		self.r2 = struct.unpack_from('<I',buf,offset)[0]

		self.r3 = struct.unpack_from('<I',buf,offset)[0]

		self.r12 = struct.unpack_from('<I',buf,offset)[0]

		self.lr = struct.unpack_from('<I',buf,offset)[0]

		self.pc = struct.unpack_from('<I',buf,offset)[0]

		self.psr = struct.unpack_from('<I',buf,offset)[0]

		self.task = struct.unpack_from('<B',buf,offset)[0]

		self.irq = struct.unpack_from('<B',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.error_code))
		buf.extend(struct.pack('<I', self.r0))
		buf.extend(struct.pack('<I', self.r1))
		buf.extend(struct.pack('<I', self.r2))
		buf.extend(struct.pack('<I', self.r3))
		buf.extend(struct.pack('<I', self.r12))
		buf.extend(struct.pack('<I', self.lr))
		buf.extend(struct.pack('<I', self.pc))
		buf.extend(struct.pack('<I', self.psr))
		buf.extend(struct.pack('<B', self.task))
		buf.extend(struct.pack('<B', self.irq))
		return bytearray(buf)

class PowerOn:
	SIZE = 6

	def __init__ (self, comms_rev = 0, serial_num = 0):
		self.comms_rev = comms_rev
		self.serial_num = serial_num

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [PowerOn]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.comms_rev = struct.unpack_from('<H',buf,offset)[0]

		self.serial_num = struct.unpack_from('<I',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<H', self.comms_rev))
		buf.extend(struct.pack('<I', self.serial_num))
		return bytearray(buf)

class SystemStatus:
	SIZE = 27

	def __init__ (self, batt_voltage = 0.0, batt_current = 0.0,
	batt_percent = 0.0, batt_coulomb_count = 0.0, flight_time = 0.0, rssi = 0,
	lost_comm = 1, lost_gps = 1, error_code = 0):
		self.batt_voltage = batt_voltage
		self.batt_current = batt_current
		self.batt_percent = batt_percent
		self.batt_coulomb_count = batt_coulomb_count
		self.flight_time = flight_time
		self.rssi = rssi
		self.lost_comm = lost_comm
		self.lost_gps = lost_gps
		self.error_code = error_code

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [SystemStatus]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.batt_voltage = struct.unpack_from('<f',buf,offset)[0]

		self.batt_current = struct.unpack_from('<f',buf,offset)[0]

		self.batt_percent = struct.unpack_from('<f',buf,offset)[0]

		self.batt_coulomb_count = struct.unpack_from('<f',buf,offset)[0]

		self.flight_time = struct.unpack_from('<f',buf,offset)[0]

		self.rssi = struct.unpack_from('<b',buf,offset)[0]

		self.lost_comm = struct.unpack_from('<B',buf,offset)[0]

		self.lost_gps = struct.unpack_from('<B',buf,offset)[0]

		self.error_code = struct.unpack_from('<I',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<f', self.batt_voltage))
		buf.extend(struct.pack('<f', self.batt_current))
		buf.extend(struct.pack('<f', self.batt_percent))
		buf.extend(struct.pack('<f', self.batt_coulomb_count))
		buf.extend(struct.pack('<f', self.flight_time))
		buf.extend(struct.pack('<b', self.rssi))
		buf.extend(struct.pack('<B', self.lost_comm))
		buf.extend(struct.pack('<B', self.lost_gps))
		buf.extend(struct.pack('<I', self.error_code))
		return bytearray(buf)

class SystemInitialize:
	SIZE = 40

	def __init__ (self, vehicle_type = VehicleType.VEHICLE_UNKNOWN,
	model = HardwareModel.HW_UNKNOWN, sw_rev = 0, hw_rev = 0, svn_rev = 0,
	comms_rev = 0, serial_num = 0, vehicle_initialized = 0, num_inputs = 0,
	num_actuators = 0, name = [None] * 16, unused = [None] * 5):
		self.vehicle_type = VehicleType(vehicle_type)

		self.model = HardwareModel(model)

		self.sw_rev = sw_rev
		self.hw_rev = hw_rev
		self.svn_rev = svn_rev
		self.comms_rev = comms_rev
		self.serial_num = serial_num
		self.vehicle_initialized = vehicle_initialized
		self.num_inputs = num_inputs
		self.num_actuators = num_actuators

		if (len(name) != 16):
			raise ValueError('array name expecting length '+str(16)+' got '+str(len(name)))

		self.name = list(name)

		if (len(unused) != 5):
			raise ValueError('array unused expecting length '+str(5)+' got '+str(len(unused)))

		self.unused = list(unused)

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [SystemInitialize]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.vehicle_type = VehicleType(struct.unpack_from('<B',buf,offset)[0])
		offset = offset+struct.calcsize('<B')

		self.model = HardwareModel(struct.unpack_from('<B',buf,offset)[0])
		offset = offset+struct.calcsize('<B')

		self.sw_rev = struct.unpack_from('<H',buf,offset)[0]

		self.hw_rev = struct.unpack_from('<H',buf,offset)[0]

		self.svn_rev = struct.unpack_from('<I',buf,offset)[0]

		self.comms_rev = struct.unpack_from('<H',buf,offset)[0]

		self.serial_num = struct.unpack_from('<I',buf,offset)[0]

		self.vehicle_initialized = struct.unpack_from('<B',buf,offset)[0]

		self.num_inputs = struct.unpack_from('<B',buf,offset)[0]

		self.num_actuators = struct.unpack_from('<B',buf,offset)[0]

		self.name = [];

		for i in range(0,16):
			self.name.append(struct.unpack_from('<B',buf,offset)[0])
			offset = offset+struct.calcsize('<B')

		self.unused = [];

		for i in range(0,5):
			self.unused.append(struct.unpack_from('<B',buf,offset)[0])
			offset = offset+struct.calcsize('<B')

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.put(VehicleType.encode(self.vehicle_type));

		buf.put(HardwareModel.encode(self.model));

		buf.extend(struct.pack('<H', self.sw_rev))
		buf.extend(struct.pack('<H', self.hw_rev))
		buf.extend(struct.pack('<I', self.svn_rev))
		buf.extend(struct.pack('<H', self.comms_rev))
		buf.extend(struct.pack('<I', self.serial_num))
		buf.extend(struct.pack('<B', self.vehicle_initialized))
		buf.extend(struct.pack('<B', self.num_inputs))
		buf.extend(struct.pack('<B', self.num_actuators))

		for val in self.name:
		    buf.extend(struct.pack('<B', val))

		for val in self.unused:
		    buf.extend(struct.pack('<B', val))
		return bytearray(buf)

#---------[ Vehicle ]---------#

class BatteryChemistry (Enum):
	BATT_CHEM_LIPO=0
	BATT_CHEM_LIHV=1
	BATT_CHEM_LIION=2
	BATT_CHEM_INVALID=3

#---------[ Input ]---------#

class HandsetFunction (Enum):
	HS_FUNC_UNUSED=0

	HS_FUNC_SET_AUTO=1  # follow waypoints

	HS_FUNC_SET_POS=2  # follow joystick

	HS_FUNC_SET_PILOT=3  # follow pilot (manual rc) command

	HS_FUNC_L_AILERON=4
	HS_FUNC_L_ELEVATOR=5
	HS_FUNC_L_THROTTLE=6
	HS_FUNC_L_RUDDER=7
	HS_FUNC_L_FLAP=8
	HS_FUNC_L_GEAR=9
	HS_FUNC_R_AILERON=10
	HS_FUNC_R_ELEVATOR=11
	HS_FUNC_R_THROTTLE=12
	HS_FUNC_R_RUDDER=13
	HS_FUNC_R_FLAP=14
	HS_FUNC_R_GEAR=15

	HS_FUNC_PAYLOAD_1=16
	HS_FUNC_PAYLOAD_2=17
	HS_FUNC_PAYLOAD_3=18
	HS_FUNC_PAYLOAD_4=19
	HS_FUNC_PAYLOAD_5=20
	HS_FUNC_PAYLOAD_6=21
	HS_FUNC_PAYLOAD_7=22
	HS_FUNC_PAYLOAD_8=23
	HS_FUNC_PAYLOAD_9=24
	HS_FUNC_PAYLOAD_10=25
	HS_FUNC_PAYLOAD_11=26
	HS_FUNC_PAYLOAD_12=27
	HS_FUNC_PAYLOAD_13=28
	HS_FUNC_PAYLOAD_14=29
	HS_FUNC_PAYLOAD_15=30
	HS_FUNC_PAYLOAD_16=31

	HS_FUNC_ROLL=32
	HS_FUNC_PITCH=33

	HS_FUNC_ROLL_RATE=34
	HS_FUNC_PITCH_RATE=35
	HS_FUNC_YAW_RATE=36

	HS_FUNC_X_VEL=37
	HS_FUNC_Y_VEL=38
	HS_FUNC_Z_VEL=39

	HS_FUNC_THRUST=40

	HS_FUNC_SET_MOTORS=41  # arm / disarm motors


	# pilot mode

	HS_FUNC_SET_ACRO=42  # angular rates, and v-rate

	HS_FUNC_SET_ANGLE=43  # angles, and v-rate

	HS_FUNC_SET_COORD=44  # coordinated turn


	# position mode

	HS_FUNC_SET_BODY=45  # body frame velocity input

	HS_FUNC_SET_WORLD=46  # world frame velocity input

	HS_FUNC_SET_BASE=47  # polar frame velocity inputs


	HS_FUNC_INVALID=48

class HandsetType (Enum):
	HS_TYPE_LINEAR=0
	HS_TYPE_TOGGLE=1
	HS_TYPE_3WAY=2
	HS_TYPE_INVALID=3

class HandsetValues:
	SIZE = 32

	def __init__ (self, usec = [None] * 16):
		if (len(usec) != 16):
			raise ValueError('array usec expecting length '+str(16)+' got '+str(len(usec)))

		self.usec = list(usec)

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [HandsetValues]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.usec = [];

		for i in range(0,16):
			self.usec.append(struct.unpack_from('<H',buf,offset)[0])
			offset = offset+struct.calcsize('<H')

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		for val in self.usec:
		    buf.extend(struct.pack('<H', val))
		return bytearray(buf)

#---------[ Controller ]---------#

JOYSTICK_BUTTONS_BYTES = 2
MAX_JOYSTICK_BUTTONS = 16
MAX_JOYSTICK_CHANNELS = 4

class AltitudeControlMode (Enum):
	ALT_MODE_TAKE_OFF=0

	ALT_MODE_HOLD=1  # use altitude controller to track commanded alt

	ALT_MODE_RATE=2  # throttle is climb or sink rate

	ALT_MODE_AUTO=3  # use altitude controller to track waypoint alt

	ALT_MODE_LAND=4
	ALT_MODE_EXTERNAL=5

	ALT_MODE_DIRECT=6  # throttle is passed directly as thrust command

	ALT_MODE_INVALID=7

class AutopilotMode (Enum):
	AP_MODE_INIT=0
	AP_MODE_AUTOMATIC=1
	AP_MODE_MANUAL=2
	AP_MODE_JOYSTICK=3
	AP_MODE_INVALID_MODE=4

class CommandID (Enum):
	# NOTE - you must check the numbers in the CommandID values

	# contained in the children folders if you modify or change these numbers

	#

	# States

	CMD_AUTOPILOT_MODE=0
	CMD_FLIGHT_MODE=1
	CMD_LANDING_MODE=2

	# Controller Modes

	CMD_ALT_MODE=3
	CMD_LAT_MODE=4
	CMD_NAV_MODE=5

	# System Commands

	CMD_ENGINE_KILL=6
	CMD_FLIGHT_TERMINATE=7
	CMD_ABORT=8

	# Navigation

	CMD_WAYPOINT=9
	CMD_WPT_ALT=16
	CMD_TURN_RATE=10

	# Flight Actions

	CMD_LAUNCH=11
	CMD_LAND=12

	# Attitude

	CMD_ROLL=13
	CMD_PITCH=14
	CMD_YAW=15

	CMD_ROLL_RATE=17
	CMD_PITCH_RATE=18
	CMD_YAW_RATE=19

	# Altitude

	CMD_ALTITUDE=20
	CMD_VRATE=21

	# Logging Commands

	CMD_DOWNLOAD_LOG=22

	# Payload Commands

	CMD_TRIGGER_PAYLOAD=23

	CMD_INVALID=37

class FlightMode (Enum):
	FLIGHT_MODE_INIT=0
	FLIGHT_MODE_PREFLIGHT=1
	FLIGHT_MODE_CALIBRATE=2
	FLIGHT_MODE_LAUNCH=3
	FLIGHT_MODE_CLIMBOUT=4
	FLIGHT_MODE_TRANSITION_TO_FORWARD=5
	FLIGHT_MODE_FLYING=6
	FLIGHT_MODE_TRANSITION_TO_HOVER=7
	FLIGHT_MODE_LANDING=8
	FLIGHT_MODE_LANDED=9
	FLIGHT_MODE_POSTFLIGHT=10
	FLIGHT_MODE_TERMINATE=11
	FLIGHT_MODE_INVALID_MODE=12

class LateralControlMode (Enum):
	LAT_MODE_WINGS_LEVEL=0  # this also has heading (yaw) hold for ground handling

	LAT_MODE_COURSE_HOLD=1  # this is a course, not a heading, hold

	LAT_MODE_RATES=2  # roll, pitch, and yaw rate commands

	LAT_MODE_ANGLES=3  # roll and pitch angle commands, yaw rate command

	LAT_MODE_COORDINATED=4  # roll controls turn rate coordinated with vehicle roll, pitch controls pitch

	LAT_MODE_AUTO=5  # autopilot controls all inputs

	LAT_MODE_EXTERNAL=6
	LAT_MODE_INVALID=7

class LoopMode (Enum):
	AUTO=0
	ON=1
	OFF=2

class NavigationControllerMode (Enum):
	NAV_OFF=0  # Navigation controller is not running

	NAV_POS=1  # hold position and heading

	NAV_PILOT_BODY=2  # track position and yaw

	NAV_PILOT_WORLD=3  # track position and yaw

	NAV_PILOT_BASE=4  # track position and yaw

	NAV_WPT_HCMD=5  # track waypoint plan at command height

	NAV_WPT=6  # follow waypoint plan (include waypoint alt)

	NAV_INVALID=7

class Command:
	SIZE = 5

	def __init__ (self, id = 255, value = 0.0):
		self.id = id
		self.value = value

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [Command]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.id = struct.unpack_from('<B',buf,offset)[0]

		self.value = struct.unpack_from('<f',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.id))
		buf.extend(struct.pack('<f', self.value))
		return bytearray(buf)

class HandsetCalibration:
	SIZE = 7

	def __init__ (self, channel = 255,
	function_min = HandsetFunction.HS_FUNC_INVALID,
	function_mid = HandsetFunction.HS_FUNC_INVALID,
	function_max = HandsetFunction.HS_FUNC_INVALID,
	type = HandsetType.HS_TYPE_INVALID, usec = 2000):
		self.channel = channel

		self.function_min = HandsetFunction(function_min)

		self.function_mid = HandsetFunction(function_mid)

		self.function_max = HandsetFunction(function_max)

		self.type = HandsetType(type)

		self.usec = usec

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [HandsetCalibration]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.channel = struct.unpack_from('<B',buf,offset)[0]

		self.function_min = HandsetFunction(struct.unpack_from('<B',buf,offset)[0])
		offset = offset+struct.calcsize('<B')

		self.function_mid = HandsetFunction(struct.unpack_from('<B',buf,offset)[0])
		offset = offset+struct.calcsize('<B')

		self.function_max = HandsetFunction(struct.unpack_from('<B',buf,offset)[0])
		offset = offset+struct.calcsize('<B')

		self.type = HandsetType(struct.unpack_from('<B',buf,offset)[0])
		offset = offset+struct.calcsize('<B')

		self.usec = struct.unpack_from('<H',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.channel))

		buf.put(HandsetFunction.encode(self.function_min));

		buf.put(HandsetFunction.encode(self.function_mid));

		buf.put(HandsetFunction.encode(self.function_max));

		buf.put(HandsetType.encode(self.type));

		buf.extend(struct.pack('<H', self.usec))
		return bytearray(buf)

class Limit:
	SIZE = 8

	def __init__ (self, min = -float("inf"), max = float("inf")):
		self.min = min
		self.max = max

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [Limit]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.min = struct.unpack_from('<f',buf,offset)[0]

		self.max = struct.unpack_from('<f',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<f', self.min))
		buf.extend(struct.pack('<f', self.max))
		return bytearray(buf)

class Timeout:
	SIZE = 2

	def __init__ (self, seconds = 0, waypoint = 0):
		self.seconds = seconds
		self.waypoint = waypoint

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [Timeout]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.seconds = struct.unpack_from('<B',buf,offset)[0]

		self.waypoint = struct.unpack_from('<B',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.seconds))
		buf.extend(struct.pack('<B', self.waypoint))
		return bytearray(buf)

class PID:
	SIZE = 21

	def __init__ (self, id = 0, p = 0.0, i = 0.0, d = 0.0, output = 0):
		self.id = id
		self.p = p
		self.i = i
		self.d = d

		self.output = Limit(output)

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [PID]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.id = struct.unpack_from('<B',buf,offset)[0]

		self.p = struct.unpack_from('<f',buf,offset)[0]

		self.i = struct.unpack_from('<f',buf,offset)[0]

		self.d = struct.unpack_from('<f',buf,offset)[0]

		self.output = Limit()
		self.output.parse(buf[offset:offset+Limit.SIZE])
		offset = offset+Limit.SIZE

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<B', self.id))
		buf.extend(struct.pack('<f', self.p))
		buf.extend(struct.pack('<f', self.i))
		buf.extend(struct.pack('<f', self.d))
		buf.extend(self.output.serialize())
		return bytearray(buf)

class TabletJoystick:
	SIZE = 10

	def __init__ (self, axis = [None] * 4, button = [None] * 2):
		if (len(axis) != 4):
			raise ValueError('array axis expecting length '+str(4)+' got '+str(len(axis)))

		self.axis = list(axis)

		if (len(button) != 2):
			raise ValueError('array button expecting length '+str(2)+' got '+str(len(button)))

		self.button = list(button)

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [TabletJoystick]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.axis = [];

		for i in range(0,4):
			self.axis.append(struct.unpack_from('<h',buf,offset)[0])
			offset = offset+struct.calcsize('<h')

		self.button = [];

		for i in range(0,2):
			self.button.append(struct.unpack_from('<B',buf,offset)[0])
			offset = offset+struct.calcsize('<B')

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		for val in self.axis:
		    buf.extend(struct.pack('<h', val))

		for val in self.button:
		    buf.extend(struct.pack('<B', val))
		return bytearray(buf)

#---------[ Communication ]---------#

class TelemetryControl:
	SIZE = 110

	def __init__ (self, roll = 0.0, pitch = 0.0, yaw = 0.0,
	roll_rate = 0.0, pitch_rate = 0.0, yaw_rate = 0.0, vx = 0.0, vy = 0.0,
	vrate = 0.0, altitude = 0.0, waypoint = 0, look_at_point = 0,
	lat_mode = LateralControlMode.LAT_MODE_INVALID,
	alt_mode = AltitudeControlMode.ALT_MODE_INVALID,
	nav_mode = NavigationControllerMode.NAV_INVALID, landing_status = 0,
	actuators = [None] * 16):
		self.roll = roll
		self.pitch = pitch
		self.yaw = yaw
		self.roll_rate = roll_rate
		self.pitch_rate = pitch_rate
		self.yaw_rate = yaw_rate
		self.vx = vx
		self.vy = vy
		self.vrate = vrate
		self.altitude = altitude
		self.waypoint = waypoint
		self.look_at_point = look_at_point

		self.lat_mode = LateralControlMode(lat_mode)

		self.alt_mode = AltitudeControlMode(alt_mode)

		self.nav_mode = NavigationControllerMode(nav_mode)

		self.landing_status = landing_status

		if (len(actuators) != 16):
			raise ValueError('array actuators expecting length '+str(16)+' got '+str(len(actuators)))

		self.actuators = list(actuators)

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [TelemetryControl]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.roll = struct.unpack_from('<f',buf,offset)[0]

		self.pitch = struct.unpack_from('<f',buf,offset)[0]

		self.yaw = struct.unpack_from('<f',buf,offset)[0]

		self.roll_rate = struct.unpack_from('<f',buf,offset)[0]

		self.pitch_rate = struct.unpack_from('<f',buf,offset)[0]

		self.yaw_rate = struct.unpack_from('<f',buf,offset)[0]

		self.vx = struct.unpack_from('<f',buf,offset)[0]

		self.vy = struct.unpack_from('<f',buf,offset)[0]

		self.vrate = struct.unpack_from('<f',buf,offset)[0]

		self.altitude = struct.unpack_from('<f',buf,offset)[0]

		self.waypoint = struct.unpack_from('<B',buf,offset)[0]

		self.look_at_point = struct.unpack_from('<B',buf,offset)[0]

		self.lat_mode = LateralControlMode(struct.unpack_from('<B',buf,offset)[0])
		offset = offset+struct.calcsize('<B')

		self.alt_mode = AltitudeControlMode(struct.unpack_from('<B',buf,offset)[0])
		offset = offset+struct.calcsize('<B')

		self.nav_mode = NavigationControllerMode(struct.unpack_from('<B',buf,offset)[0])
		offset = offset+struct.calcsize('<B')

		self.landing_status = struct.unpack_from('<B',buf,offset)[0]

		self.actuators = [];

		for i in range(0,16):
			self.actuators.append(struct.unpack_from('<f',buf,offset)[0])
			offset = offset+struct.calcsize('<f')

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<f', self.roll))
		buf.extend(struct.pack('<f', self.pitch))
		buf.extend(struct.pack('<f', self.yaw))
		buf.extend(struct.pack('<f', self.roll_rate))
		buf.extend(struct.pack('<f', self.pitch_rate))
		buf.extend(struct.pack('<f', self.yaw_rate))
		buf.extend(struct.pack('<f', self.vx))
		buf.extend(struct.pack('<f', self.vy))
		buf.extend(struct.pack('<f', self.vrate))
		buf.extend(struct.pack('<f', self.altitude))
		buf.extend(struct.pack('<B', self.waypoint))
		buf.extend(struct.pack('<B', self.look_at_point))

		buf.put(LateralControlMode.encode(self.lat_mode));

		buf.put(AltitudeControlMode.encode(self.alt_mode));

		buf.put(NavigationControllerMode.encode(self.nav_mode));

		buf.extend(struct.pack('<B', self.landing_status))

		for val in self.actuators:
		    buf.extend(struct.pack('<f', val))
		return bytearray(buf)

#---------[ Telemetry ]---------#

class TelemetryOrientation:
	SIZE = 48

	def __init__ (self, q = [None] * 4, omega = 0, magnetometer = 0):
		if (len(q) != 4):
			raise ValueError('array q expecting length '+str(4)+' got '+str(len(q)))

		self.q = list(q)

		self.omega = ThreeAxisSensor(omega)

		self.magnetometer = ThreeAxisSensor(magnetometer)

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [TelemetryOrientation]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.q = [];

		for i in range(0,4):
			self.q.append(struct.unpack_from('<f',buf,offset)[0])
			offset = offset+struct.calcsize('<f')

		self.omega = ThreeAxisSensor()
		self.omega.parse(buf[offset:offset+ThreeAxisSensor.SIZE])
		offset = offset+ThreeAxisSensor.SIZE

		self.magnetometer = ThreeAxisSensor()
		self.magnetometer.parse(buf[offset:offset+ThreeAxisSensor.SIZE])
		offset = offset+ThreeAxisSensor.SIZE

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		for val in self.q:
		    buf.extend(struct.pack('<f', val))

		buf.extend(self.omega.serialize())
		buf.extend(self.magnetometer.serialize())
		return bytearray(buf)

class TelemetryPosition:
	SIZE = 72

	def __init__ (self, latitude = 0.0, longitude = 0.0, altitude = 0.0,
	height = 0.0, speed = 0.0, course = 0.0, position = 0, velocity = 0,
	acceleration = 0):
		self.latitude = latitude
		self.longitude = longitude
		self.altitude = altitude
		self.height = height
		self.speed = speed
		self.course = course

		self.position = ThreeAxisSensor(position)

		self.velocity = ThreeAxisSensor(velocity)

		self.acceleration = ThreeAxisSensor(acceleration)

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [TelemetryPosition]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.latitude = struct.unpack_from('<f',buf,offset)[0]

		self.longitude = struct.unpack_from('<f',buf,offset)[0]

		self.altitude = struct.unpack_from('<f',buf,offset)[0]

		self.height = struct.unpack_from('<f',buf,offset)[0]

		self.speed = struct.unpack_from('<f',buf,offset)[0]

		self.course = struct.unpack_from('<f',buf,offset)[0]

		self.position = ThreeAxisSensor()
		self.position.parse(buf[offset:offset+ThreeAxisSensor.SIZE])
		offset = offset+ThreeAxisSensor.SIZE

		self.velocity = ThreeAxisSensor()
		self.velocity.parse(buf[offset:offset+ThreeAxisSensor.SIZE])
		offset = offset+ThreeAxisSensor.SIZE

		self.acceleration = ThreeAxisSensor()
		self.acceleration.parse(buf[offset:offset+ThreeAxisSensor.SIZE])
		offset = offset+ThreeAxisSensor.SIZE

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<f', self.latitude))
		buf.extend(struct.pack('<f', self.longitude))
		buf.extend(struct.pack('<f', self.altitude))
		buf.extend(struct.pack('<f', self.height))
		buf.extend(struct.pack('<f', self.speed))
		buf.extend(struct.pack('<f', self.course))
		buf.extend(self.position.serialize())
		buf.extend(self.velocity.serialize())
		buf.extend(self.acceleration.serialize())
		return bytearray(buf)

class TelemetryPressure:
	SIZE = 44

	def __init__ (self, static_pressure = 0.0, dynamic_pressure = 0.0,
	air_temperature = 0.0, humidity = 0.0, wind = 0, ias = 0.0, alpha = 0.0,
	beta = 0.0):
		self.static_pressure = static_pressure
		self.dynamic_pressure = dynamic_pressure
		self.air_temperature = air_temperature
		self.humidity = humidity

		self.wind = ThreeAxisSensor(wind)

		self.ias = ias
		self.alpha = alpha
		self.beta = beta

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [TelemetryPressure]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.static_pressure = struct.unpack_from('<f',buf,offset)[0]

		self.dynamic_pressure = struct.unpack_from('<f',buf,offset)[0]

		self.air_temperature = struct.unpack_from('<f',buf,offset)[0]

		self.humidity = struct.unpack_from('<f',buf,offset)[0]

		self.wind = ThreeAxisSensor()
		self.wind.parse(buf[offset:offset+ThreeAxisSensor.SIZE])
		offset = offset+ThreeAxisSensor.SIZE

		self.ias = struct.unpack_from('<f',buf,offset)[0]

		self.alpha = struct.unpack_from('<f',buf,offset)[0]

		self.beta = struct.unpack_from('<f',buf,offset)[0]

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<f', self.static_pressure))
		buf.extend(struct.pack('<f', self.dynamic_pressure))
		buf.extend(struct.pack('<f', self.air_temperature))
		buf.extend(struct.pack('<f', self.humidity))
		buf.extend(self.wind.serialize())
		buf.extend(struct.pack('<f', self.ias))
		buf.extend(struct.pack('<f', self.alpha))
		buf.extend(struct.pack('<f', self.beta))
		return bytearray(buf)

class TelemetrySystem:
	SIZE = 44

	def __init__ (self, batt_voltage = 0.0, batt_current = 0.0,
	batt_coulomb_count = 0.0, batt_percent = 0.0, flight_time = 0.0, week = 0,
	hour = 0, minute = 0, seconds = 0.0, satellites = 0, pdop = 0.0,
	fix_type = GPSFixType(0), rssi = 0, lost_comm = 0, lost_gps = 0,
	engine_on = 0, error_code = 0, autopilot_mode = AutopilotMode(0),
	flight_mode = FlightMode(0)):
		self.batt_voltage = batt_voltage
		self.batt_current = batt_current
		self.batt_coulomb_count = batt_coulomb_count
		self.batt_percent = batt_percent
		self.flight_time = flight_time
		self.week = week
		self.hour = hour
		self.minute = minute
		self.seconds = seconds
		self.satellites = satellites
		self.pdop = pdop

		self.fix_type = GPSFixType(fix_type)

		self.rssi = rssi
		self.lost_comm = lost_comm
		self.lost_gps = lost_gps
		self.engine_on = engine_on
		self.error_code = error_code

		self.autopilot_mode = AutopilotMode(autopilot_mode)

		self.flight_mode = FlightMode(flight_mode)

	def parse(self,buf):
		if (len(buf) != self.SIZE):
			raise BufferError('INVALID PACKET SIZE [TelemetrySystem]: Expected=' + str(self.SIZE) + ' Received='+ str(len(buf)))

		offset = 0

		self.batt_voltage = struct.unpack_from('<f',buf,offset)[0]

		self.batt_current = struct.unpack_from('<f',buf,offset)[0]

		self.batt_coulomb_count = struct.unpack_from('<f',buf,offset)[0]

		self.batt_percent = struct.unpack_from('<f',buf,offset)[0]

		self.flight_time = struct.unpack_from('<f',buf,offset)[0]

		self.week = struct.unpack_from('<H',buf,offset)[0]

		self.hour = struct.unpack_from('<B',buf,offset)[0]

		self.minute = struct.unpack_from('<B',buf,offset)[0]

		self.seconds = struct.unpack_from('<f',buf,offset)[0]

		self.satellites = struct.unpack_from('<B',buf,offset)[0]

		self.pdop = struct.unpack_from('<f',buf,offset)[0]

		self.fix_type = GPSFixType(struct.unpack_from('<B',buf,offset)[0])
		offset = offset+struct.calcsize('<B')

		self.rssi = struct.unpack_from('<b',buf,offset)[0]

		self.lost_comm = struct.unpack_from('<B',buf,offset)[0]

		self.lost_gps = struct.unpack_from('<B',buf,offset)[0]

		self.engine_on = struct.unpack_from('<B',buf,offset)[0]

		self.error_code = struct.unpack_from('<I',buf,offset)[0]

		self.autopilot_mode = AutopilotMode(struct.unpack_from('<B',buf,offset)[0])
		offset = offset+struct.calcsize('<B')

		self.flight_mode = FlightMode(struct.unpack_from('<B',buf,offset)[0])
		offset = offset+struct.calcsize('<B')

	def getSize(self):
		return self.SIZE

	def serialize(self):
		buf = []

		buf.extend(struct.pack('<f', self.batt_voltage))
		buf.extend(struct.pack('<f', self.batt_current))
		buf.extend(struct.pack('<f', self.batt_coulomb_count))
		buf.extend(struct.pack('<f', self.batt_percent))
		buf.extend(struct.pack('<f', self.flight_time))
		buf.extend(struct.pack('<H', self.week))
		buf.extend(struct.pack('<B', self.hour))
		buf.extend(struct.pack('<B', self.minute))
		buf.extend(struct.pack('<f', self.seconds))
		buf.extend(struct.pack('<B', self.satellites))
		buf.extend(struct.pack('<f', self.pdop))

		buf.put(GPSFixType.encode(self.fix_type));

		buf.extend(struct.pack('<b', self.rssi))
		buf.extend(struct.pack('<B', self.lost_comm))
		buf.extend(struct.pack('<B', self.lost_gps))
		buf.extend(struct.pack('<B', self.engine_on))
		buf.extend(struct.pack('<I', self.error_code))

		buf.put(AutopilotMode.encode(self.autopilot_mode));

		buf.put(FlightMode.encode(self.flight_mode));
		return bytearray(buf)
