// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef TINY_SHAPE_DATA_H
#define TINY_SHAPE_DATA_H

/// position xyz, unused w, normal, uv
static const float cube_vertices[] = {
    -1.0f, -1.0f, 1.0f,  1.0f, 0,  0,  1,  0,
    0,  // 0
    1.0f,  -1.0f, 1.0f,  1.0f, 0,  0,  1,  1,
    0,  // 1
    1.0f,  1.0f,  1.0f,  1.0f, 0,  0,  1,  1,
    1,  // 2
    -1.0f, 1.0f,  1.0f,  1.0f, 0,  0,  1,  0,
    1,  // 3

    -1.0f, -1.0f, -1.0f, 1.0f, 0,  0,  -1, 0,
    0,  // 4
    1.0f,  -1.0f, -1.0f, 1.0f, 0,  0,  -1, 1,
    0,  // 5
    1.0f,  1.0f,  -1.0f, 1.0f, 0,  0,  -1, 1,
    1,  // 6
    -1.0f, 1.0f,  -1.0f, 1.0f, 0,  0,  -1, 0,
    1,  // 7

    -1.0f, -1.0f, -1.0f, 1.0f, -1, 0,  0,  0, 0,
    -1.0f, 1.0f,  -1.0f, 1.0f, -1, 0,  0,  1, 0,
    -1.0f, 1.0f,  1.0f,  1.0f, -1, 0,  0,  1, 1,
    -1.0f, -1.0f, 1.0f,  1.0f, -1, 0,  0,  0, 1,

    1.0f,  -1.0f, -1.0f, 1.0f, 1,  0,  0,  0, 0,
    1.0f,  1.0f,  -1.0f, 1.0f, 1,  0,  0,  1, 0,
    1.0f,  1.0f,  1.0f,  1.0f, 1,  0,  0,  1, 1,
    1.0f,  -1.0f, 1.0f,  1.0f, 1,  0,  0,  0, 1,

    -1.0f, -1.0f, -1.0f, 1.0f, 0,  -1, 0,  0, 0,
    -1.0f, -1.0f, 1.0f,  1.0f, 0,  -1, 0,  1, 0,
    1.0f,  -1.0f, 1.0f,  1.0f, 0,  -1, 0,  1, 1,
    1.0f,  -1.0f, -1.0f, 1.0f, 0,  -1, 0,  0, 1,

    -1.0f, 1.0f,  -1.0f, 1.0f, 0,  1,  0,  0, 0,
    -1.0f, 1.0f,  1.0f,  1.0f, 0,  1,  0,  1, 0,
    1.0f,  1.0f,  1.0f,  1.0f, 0,  1,  0,  1, 1,
    1.0f,  1.0f,  -1.0f, 1.0f, 0,  1,  0,  0, 1,
};

/// position xyz, unused w, normal, uv
static const float cube_vertices_textured[] = {
    -1.0f, -1.0f, 1.0f,  1.0f, 0,  0,  1,  0.75,
    0.25,  // 0//back
    1.0f,  -1.0f, 1.0f,  1.0f, 0,  0,  1,  1,
    0.25,  // 1
    1.0f,  1.0f,  1.0f,  1.0f, 0,  0,  1,  1,
    0,  // 2
    -1.0f, 1.0f,  1.0f,  1.0f, 0,  0,  1,  0.75,
    0,  // 3

    -1.0f, -1.0f, -1.0f, 1.0f, 0,  0,  -1, 0.5,
    0.25,  // 4//front
    1.0f,  -1.0f, -1.0f, 1.0f, 0,  0,  -1, 0.25,
    0.25,  // 5
    1.0f,  1.0f,  -1.0f, 1.0f, 0,  0,  -1, 0.25,
    0,  // 6
    -1.0f, 1.0f,  -1.0f, 1.0f, 0,  0,  -1, 0.5,
    0,  // 7

    -1.0f, -1.0f, -1.0f, 1.0f, -1, 0,  0,  0.5,
    0,  // Right
    -1.0f, 1.0f,  -1.0f, 1.0f, -1, 0,  0,  0.75, 0,
    -1.0f, 1.0f,  1.0f,  1.0f, -1, 0,  0,  0.75, 0.25,
    -1.0f, -1.0f, 1.0f,  1.0f, -1, 0,  0,  0.5,  0.25,

    1.0f,  -1.0f, -1.0f, 1.0f, 1,  0,  0,  0.25,
    0.5,  // Left
    1.0f,  1.0f,  -1.0f, 1.0f, 1,  0,  0,  0.25, 0.25,
    1.0f,  1.0f,  1.0f,  1.0f, 1,  0,  0,  0.,   .25,
    1.0f,  -1.0f, 1.0f,  1.0f, 1,  0,  0,  0,    .5,

    -1.0f, -1.0f, -1.0f, 1.0f, 0,  -1, 0,  0.25,
    0.5,  // bottom
    -1.0f, -1.0f, 1.0f,  1.0f, 0,  -1, 0,  0.25, 0.25,
    1.0f,  -1.0f, 1.0f,  1.0f, 0,  -1, 0,  0.5,  0.25,
    1.0f,  -1.0f, -1.0f, 1.0f, 0,  -1, 0,  0.5,  0.5,

    -1.0f, 1.0f,  -1.0f, 1.0f, 0,  1,  0,  0,
    0,  // top
    -1.0f, 1.0f,  1.0f,  1.0f, 0,  1,  0,  0,    0.25,
    1.0f,  1.0f,  1.0f,  1.0f, 0,  1,  0,  0.25, 0.25,
    1.0f,  1.0f,  -1.0f, 1.0f, 0,  1,  0,  0.25, 0,
};

/// position xyz, unused w, normal, uv
static const float cube_vertices2[] = {
    -1.5f, -0.5f, 0.5f,  0.0f, 0,  0,  1,  0,
    0,  // 0
    1.5f,  -0.5f, 0.5f,  0.0f, 0,  0,  1,  1,
    0,  // 1
    1.5f,  0.5f,  0.5f,  0.0f, 0,  0,  1,  1,
    1,  // 2
    -1.5f, 0.5f,  0.5f,  0.0f, 0,  0,  1,  0,
    1,  // 3

    -1.5f, -0.5f, -0.5f, 0.5f, 0,  0,  -1, 0,
    0,  // 4
    1.5f,  -0.5f, -0.5f, 0.5f, 0,  0,  -1, 1,
    0,  // 5
    1.5f,  0.5f,  -0.5f, 0.5f, 0,  0,  -1, 1,
    1,  // 6
    -1.5f, 0.5f,  -0.5f, 0.5f, 0,  0,  -1, 0,
    1,  // 7

    -1.5f, -0.5f, -0.5f, 0.5f, -1, 0,  0,  0, 0,
    -1.5f, 0.5f,  -0.5f, 0.5f, -1, 0,  0,  1, 0,
    -1.5f, 0.5f,  0.5f,  0.5f, -1, 0,  0,  1, 1,
    -1.5f, -0.5f, 0.5f,  0.5f, -1, 0,  0,  0, 1,

    1.5f,  -0.5f, -0.5f, 0.5f, 1,  0,  0,  0, 0,
    1.5f,  0.5f,  -0.5f, 0.5f, 1,  0,  0,  1, 0,
    1.5f,  0.5f,  0.5f,  0.5f, 1,  0,  0,  1, 1,
    1.5f,  -0.5f, 0.5f,  0.5f, 1,  0,  0,  0, 1,

    -1.5f, -0.5f, -0.5f, 0.5f, 0,  -1, 0,  0, 0,
    -1.5f, -0.5f, 0.5f,  0.5f, 0,  -1, 0,  1, 0,
    1.5f,  -0.5f, 0.5f,  0.5f, 0,  -1, 0,  1, 1,
    1.5f,  -0.5f, -0.5f, 0.5f, 0,  -1, 0,  0, 1,

    -1.5f, 0.5f,  -0.5f, 0.5f, 0,  1,  0,  0, 0,
    -1.5f, 0.5f,  0.5f,  0.5f, 0,  1,  0,  1, 0,
    1.5f,  0.5f,  0.5f,  0.5f, 0,  1,  0,  1, 1,
    1.5f,  0.5f,  -0.5f, 0.5f, 0,  1,  0,  0, 1,
};

static const int cube_indices[] = {0,  1,  2,  0,  2,  3,  // ground face
                                   6,  5,  4,  7,  6,  4,  // top face
                                   10, 9,  8,  11, 10, 8,  12, 13,
                                   14, 12, 14, 15, 18, 17, 16, 19,
                                   18, 16, 20, 21, 22, 20, 22, 23};

static const float textured_sphere_vertices[] = {
  0.000000, -0.142315, -0.989821, 0.000000, 0.183700, 0.000000, -0.983000, 0.504961, 0.896295,
0.000000, 0.142315, -0.989821, 0.000000, 0.183700, 0.000000, -0.983000, 0.504961, 0.896295,
0.357565, 0.142315, -0.922981, 0.000000, 0.183700, 0.000000, -0.983000, 0.653523, 0.868524,
0.000000, -0.142315, -0.989821, 0.000000, 0.183700, 0.000000, -0.983000, 0.504961, 0.896295,
0.357565, 0.142315, -0.922981, 0.000000, 0.183700, 0.000000, -0.983000, 0.653523, 0.868524,
0.357565, -0.142315, -0.922981, 0.000000, 0.183700, 0.000000, -0.983000, 0.653523, 0.868524,
0.000000, 0.654861, -0.755750, 0.000000, 0.121500, 0.750100, -0.650000, 0.504961, 0.799042,
0.000000, 0.841254, -0.540641, 0.000000, 0.121500, 0.750100, -0.650000, 0.504961, 0.709668,
0.195302, 0.841254, -0.504133, 0.000000, 0.121500, 0.750100, -0.650000, 0.586106, 0.694499,
0.000000, 0.654861, -0.755750, 0.000000, 0.121500, 0.750100, -0.650000, 0.504961, 0.799042,
0.195302, 0.841254, -0.504133, 0.000000, 0.121500, 0.750100, -0.650000, 0.586106, 0.694499,
0.273008, 0.654861, -0.704715, 0.000000, 0.121500, 0.750100, -0.650000, 0.618392, 0.777838,
0.000000, -0.959493, -0.281733, 0.000000, 0.077400, -0.906900, -0.414200, 0.504961, 0.602096,
0.000000, -0.841254, -0.540641, 0.000000, 0.077400, -0.906900, -0.414200, 0.504961, 0.709668,
0.195302, -0.841254, -0.504133, 0.000000, 0.077400, -0.906900, -0.414200, 0.586106, 0.694499,
0.000000, -0.959493, -0.281733, 0.000000, 0.077400, -0.906900, -0.414200, 0.504961, 0.602096,
0.195302, -0.841254, -0.504133, 0.000000, 0.077400, -0.906900, -0.414200, 0.586106, 0.694499,
0.101774, -0.959493, -0.262708, 0.000000, 0.077400, -0.906900, -0.414200, 0.547246, 0.594191,
0.000000, -0.415415, -0.909632, 0.000000, 0.176500, -0.277300, -0.944400, 0.504961, 0.862977,
0.000000, -0.142315, -0.989821, 0.000000, 0.176500, -0.277300, -0.944400, 0.504961, 0.896295,
0.357565, -0.142315, -0.922981, 0.000000, 0.176500, -0.277300, -0.944400, 0.653523, 0.868524,
0.000000, -0.415415, -0.909632, 0.000000, 0.176500, -0.277300, -0.944400, 0.504961, 0.862977,
0.357565, -0.142315, -0.922981, 0.000000, 0.176500, -0.277300, -0.944400, 0.653523, 0.868524,
0.328597, -0.415415, -0.848207, 0.000000, 0.176500, -0.277300, -0.944400, 0.641488, 0.837456,
0.000000, 0.415415, -0.909632, 0.000000, 0.155300, 0.534100, -0.831000, 0.504961, 0.862977,
0.000000, 0.654861, -0.755750, 0.000000, 0.155300, 0.534100, -0.831000, 0.504961, 0.799042,
0.273008, 0.654861, -0.704715, 0.000000, 0.155300, 0.534100, -0.831000, 0.618392, 0.777838,
0.000000, 0.415415, -0.909632, 0.000000, 0.155300, 0.534100, -0.831000, 0.504961, 0.862977,
0.273008, 0.654861, -0.704715, 0.000000, 0.155300, 0.534100, -0.831000, 0.618392, 0.777838,
0.328597, 0.415415, -0.848207, 0.000000, 0.155300, 0.534100, -0.831000, 0.641488, 0.837456,
0.000000, -1.000000, -0.000000, 0.000000, 0.026600, -0.989500, -0.142300, 0.504961, 0.485040,
0.000000, -0.959493, -0.281733, 0.000000, 0.026600, -0.989500, -0.142300, 0.504961, 0.602096,
0.101774, -0.959493, -0.262708, 0.000000, 0.026600, -0.989500, -0.142300, 0.547246, 0.594191,
0.000000, 0.959493, -0.281733, 0.000000, 0.026600, 0.989500, -0.142300, 0.504961, 0.602095,
-0.000000, 1.000000, -0.000000, 0.000000, 0.026600, 0.989500, -0.142300, 0.504961, 0.485040,
0.101774, 0.959493, -0.262708, 0.000000, 0.026600, 0.989500, -0.142300, 0.547246, 0.594191,
-0.000000, -0.654861, -0.755750, 0.000000, 0.155300, -0.534100, -0.831000, 0.504961, 0.799042,
0.000000, -0.415415, -0.909632, 0.000000, 0.155300, -0.534100, -0.831000, 0.504961, 0.862977,
0.328597, -0.415415, -0.848207, 0.000000, 0.155300, -0.534100, -0.831000, 0.641488, 0.837456,
-0.000000, -0.654861, -0.755750, 0.000000, 0.155300, -0.534100, -0.831000, 0.504961, 0.799042,
0.328597, -0.415415, -0.848207, 0.000000, 0.155300, -0.534100, -0.831000, 0.641488, 0.837456,
0.273008, -0.654861, -0.704715, 0.000000, 0.155300, -0.534100, -0.831000, 0.618392, 0.777838,
0.000000, 0.142315, -0.989821, 0.000000, 0.176500, 0.277300, -0.944400, 0.504961, 0.896295,
0.000000, 0.415415, -0.909632, 0.000000, 0.176500, 0.277300, -0.944400, 0.504961, 0.862977,
0.328597, 0.415415, -0.848207, 0.000000, 0.176500, 0.277300, -0.944400, 0.641488, 0.837456,
0.000000, 0.142315, -0.989821, 0.000000, 0.176500, 0.277300, -0.944400, 0.504961, 0.896295,
0.328597, 0.415415, -0.848207, 0.000000, 0.176500, 0.277300, -0.944400, 0.641488, 0.837456,
0.357565, 0.142315, -0.922981, 0.000000, 0.176500, 0.277300, -0.944400, 0.653523, 0.868524,
0.000000, 0.841254, -0.540641, 0.000000, 0.077400, 0.906900, -0.414200, 0.504961, 0.709668,
0.000000, 0.959493, -0.281733, 0.000000, 0.077400, 0.906900, -0.414200, 0.504961, 0.602095,
0.101774, 0.959493, -0.262708, 0.000000, 0.077400, 0.906900, -0.414200, 0.547246, 0.594191,
0.000000, 0.841254, -0.540641, 0.000000, 0.077400, 0.906900, -0.414200, 0.504961, 0.709668,
0.101774, 0.959493, -0.262708, 0.000000, 0.077400, 0.906900, -0.414200, 0.547246, 0.594191,
0.195302, 0.841254, -0.504133, 0.000000, 0.077400, 0.906900, -0.414200, 0.586106, 0.694499,
0.000000, -0.841254, -0.540641, 0.000000, 0.121500, -0.750100, -0.650000, 0.504961, 0.709668,
-0.000000, -0.654861, -0.755750, 0.000000, 0.121500, -0.750100, -0.650000, 0.504961, 0.799042,
0.273008, -0.654861, -0.704715, 0.000000, 0.121500, -0.750100, -0.650000, 0.618392, 0.777838,
0.000000, -0.841254, -0.540641, 0.000000, 0.121500, -0.750100, -0.650000, 0.504961, 0.709668,
0.273008, -0.654861, -0.704715, 0.000000, 0.121500, -0.750100, -0.650000, 0.618392, 0.777838,
0.195302, -0.841254, -0.504133, 0.000000, 0.121500, -0.750100, -0.650000, 0.586106, 0.694499,
0.195302, 0.841254, -0.504133, 0.000000, 0.221800, 0.906900, -0.358200, 0.586106, 0.694499,
0.101774, 0.959493, -0.262708, 0.000000, 0.221800, 0.906900, -0.358200, 0.547246, 0.594191,
0.189802, 0.959493, -0.208203, 0.000000, 0.221800, 0.906900, -0.358200, 0.583821, 0.571545,
0.195302, 0.841254, -0.504133, 0.000000, 0.221800, 0.906900, -0.358200, 0.586106, 0.694499,
0.189802, 0.959493, -0.208203, 0.000000, 0.221800, 0.906900, -0.358200, 0.583821, 0.571545,
0.364227, 0.841254, -0.399538, 0.000000, 0.221800, 0.906900, -0.358200, 0.656292, 0.651042,
0.195302, -0.841254, -0.504133, 0.000000, 0.348100, -0.750100, -0.562200, 0.586106, 0.694499,
0.273008, -0.654861, -0.704715, 0.000000, 0.348100, -0.750100, -0.562200, 0.618392, 0.777838,
0.509145, -0.654861, -0.558506, 0.000000, 0.348100, -0.750100, -0.562200, 0.716503, 0.717090,
0.195302, -0.841254, -0.504133, 0.000000, 0.348100, -0.750100, -0.562200, 0.586106, 0.694499,
0.509145, -0.654861, -0.558506, 0.000000, 0.348100, -0.750100, -0.562200, 0.716503, 0.717090,
0.364227, -0.841254, -0.399538, 0.000000, 0.348100, -0.750100, -0.562200, 0.656292, 0.651042,
0.357565, -0.142315, -0.922981, 0.000000, 0.526400, 0.000000, -0.850200, 0.653523, 0.868524,
0.357565, 0.142315, -0.922981, 0.000000, 0.526400, 0.000000, -0.850200, 0.653523, 0.868524,
0.666838, 0.142315, -0.731487, 0.000000, 0.526400, 0.000000, -0.850200, 0.782022, 0.788961,
0.357565, -0.142315, -0.922981, 0.000000, 0.526400, 0.000000, -0.850200, 0.653523, 0.868524,
0.666838, 0.142315, -0.731487, 0.000000, 0.526400, 0.000000, -0.850200, 0.782022, 0.788961,
0.666838, -0.142315, -0.731487, 0.000000, 0.526400, 0.000000, -0.850200, 0.782022, 0.788961,
0.273008, 0.654861, -0.704715, 0.000000, 0.348100, 0.750100, -0.562200, 0.618392, 0.777838,
0.195302, 0.841254, -0.504133, 0.000000, 0.348100, 0.750100, -0.562200, 0.586106, 0.694499,
0.364227, 0.841254, -0.399538, 0.000000, 0.348100, 0.750100, -0.562200, 0.656292, 0.651042,
0.273008, 0.654861, -0.704715, 0.000000, 0.348100, 0.750100, -0.562200, 0.618392, 0.777838,
0.364227, 0.841254, -0.399538, 0.000000, 0.348100, 0.750100, -0.562200, 0.656292, 0.651042,
0.509145, 0.654861, -0.558506, 0.000000, 0.348100, 0.750100, -0.562200, 0.716503, 0.717090,
0.101774, -0.959493, -0.262708, 0.000000, 0.221800, -0.906900, -0.358200, 0.547246, 0.594191,
0.195302, -0.841254, -0.504133, 0.000000, 0.221800, -0.906900, -0.358200, 0.586106, 0.694499,
0.364227, -0.841254, -0.399538, 0.000000, 0.221800, -0.906900, -0.358200, 0.656292, 0.651042,
0.101774, -0.959493, -0.262708, 0.000000, 0.221800, -0.906900, -0.358200, 0.547246, 0.594191,
0.364227, -0.841254, -0.399538, 0.000000, 0.221800, -0.906900, -0.358200, 0.656292, 0.651042,
0.189802, -0.959493, -0.208203, 0.000000, 0.221800, -0.906900, -0.358200, 0.583821, 0.571545,
0.328597, -0.415415, -0.848207, 0.000000, 0.505800, -0.277300, -0.816900, 0.641488, 0.837456,
0.357565, -0.142315, -0.922981, 0.000000, 0.505800, -0.277300, -0.816900, 0.653523, 0.868524,
0.666838, -0.142315, -0.731487, 0.000000, 0.505800, -0.277300, -0.816900, 0.782022, 0.788961,
0.328597, -0.415415, -0.848207, 0.000000, 0.505800, -0.277300, -0.816900, 0.641488, 0.837456,
0.666838, -0.142315, -0.731487, 0.000000, 0.505800, -0.277300, -0.816900, 0.782022, 0.788961,
0.612815, -0.415415, -0.672226, 0.000000, 0.505800, -0.277300, -0.816900, 0.759576, 0.764339,
0.328597, 0.415415, -0.848207, 0.000000, 0.445100, 0.534100, -0.718800, 0.641488, 0.837456,
0.273008, 0.654861, -0.704715, 0.000000, 0.445100, 0.534100, -0.718800, 0.618392, 0.777838,
0.509145, 0.654861, -0.558506, 0.000000, 0.445100, 0.534100, -0.718800, 0.716503, 0.717090,
0.328597, 0.415415, -0.848207, 0.000000, 0.445100, 0.534100, -0.718800, 0.641488, 0.837456,
0.509145, 0.654861, -0.558506, 0.000000, 0.445100, 0.534100, -0.718800, 0.716503, 0.717090,
0.612815, 0.415415, -0.672226, 0.000000, 0.445100, 0.534100, -0.718800, 0.759576, 0.764339,
0.000000, -1.000000, -0.000000, 0.000000, 0.076200, -0.989500, -0.123100, 0.504961, 0.485040,
0.101774, -0.959493, -0.262708, 0.000000, 0.076200, -0.989500, -0.123100, 0.547246, 0.594191,
0.189802, -0.959493, -0.208203, 0.000000, 0.076200, -0.989500, -0.123100, 0.583821, 0.571545,
0.101774, 0.959493, -0.262708, 0.000000, 0.076200, 0.989500, -0.123100, 0.547246, 0.594191,
-0.000000, 1.000000, -0.000000, 0.000000, 0.076200, 0.989500, -0.123100, 0.504961, 0.485040,
0.189802, 0.959493, -0.208203, 0.000000, 0.076200, 0.989500, -0.123100, 0.583821, 0.571545,
0.273008, -0.654861, -0.704715, 0.000000, 0.445100, -0.534100, -0.718800, 0.618392, 0.777838,
0.328597, -0.415415, -0.848207, 0.000000, 0.445100, -0.534100, -0.718800, 0.641488, 0.837456,
0.612815, -0.415415, -0.672226, 0.000000, 0.445100, -0.534100, -0.718800, 0.759576, 0.764339,
0.273008, -0.654861, -0.704715, 0.000000, 0.445100, -0.534100, -0.718800, 0.618392, 0.777838,
0.612815, -0.415415, -0.672226, 0.000000, 0.445100, -0.534100, -0.718800, 0.759576, 0.764339,
0.509145, -0.654861, -0.558506, 0.000000, 0.445100, -0.534100, -0.718800, 0.716503, 0.717090,
0.357565, 0.142315, -0.922981, 0.000000, 0.505800, 0.277300, -0.816900, 0.653523, 0.868524,
0.328597, 0.415415, -0.848207, 0.000000, 0.505800, 0.277300, -0.816900, 0.641488, 0.837456,
0.612815, 0.415415, -0.672226, 0.000000, 0.505800, 0.277300, -0.816900, 0.759576, 0.764339,
0.357565, 0.142315, -0.922981, 0.000000, 0.505800, 0.277300, -0.816900, 0.653523, 0.868524,
0.612815, 0.415415, -0.672226, 0.000000, 0.505800, 0.277300, -0.816900, 0.759576, 0.764339,
0.666838, 0.142315, -0.731487, 0.000000, 0.505800, 0.277300, -0.816900, 0.782022, 0.788961,
0.666838, -0.142315, -0.731487, 0.000000, 0.798000, 0.000000, -0.602600, 0.782022, 0.788961,
0.666838, 0.142315, -0.731487, 0.000000, 0.798000, 0.000000, -0.602600, 0.782022, 0.788961,
0.886052, 0.142315, -0.441201, 0.000000, 0.798000, 0.000000, -0.602600, 0.873101, 0.668352,
0.666838, -0.142315, -0.731487, 0.000000, 0.798000, 0.000000, -0.602600, 0.782022, 0.788961,
0.886052, 0.142315, -0.441201, 0.000000, 0.798000, 0.000000, -0.602600, 0.873101, 0.668352,
0.886052, -0.142315, -0.441201, 0.000000, 0.798000, 0.000000, -0.602600, 0.873101, 0.668352,
0.509145, 0.654861, -0.558506, 0.000000, 0.527700, 0.750100, -0.398500, 0.716503, 0.717090,
0.364227, 0.841254, -0.399538, 0.000000, 0.527700, 0.750100, -0.398500, 0.656292, 0.651042,
0.483962, 0.841254, -0.240984, 0.000000, 0.527700, 0.750100, -0.398500, 0.706039, 0.585165,
0.509145, 0.654861, -0.558506, 0.000000, 0.527700, 0.750100, -0.398500, 0.716503, 0.717090,
0.483962, 0.841254, -0.240984, 0.000000, 0.527700, 0.750100, -0.398500, 0.706039, 0.585165,
0.676519, 0.654861, -0.336867, 0.000000, 0.527700, 0.750100, -0.398500, 0.786044, 0.625003,
0.189802, -0.959493, -0.208203, 0.000000, 0.336200, -0.906900, -0.253900, 0.583821, 0.571545,
0.364227, -0.841254, -0.399538, 0.000000, 0.336200, -0.906900, -0.253900, 0.656292, 0.651042,
0.483962, -0.841254, -0.240984, 0.000000, 0.336200, -0.906900, -0.253900, 0.706039, 0.585165,
0.189802, -0.959493, -0.208203, 0.000000, 0.336200, -0.906900, -0.253900, 0.583821, 0.571545,
0.483962, -0.841254, -0.240984, 0.000000, 0.336200, -0.906900, -0.253900, 0.706039, 0.585165,
0.252197, -0.959493, -0.125579, 0.000000, 0.336200, -0.906900, -0.253900, 0.609745, 0.537216,
0.612815, -0.415415, -0.672226, 0.000000, 0.766700, -0.277300, -0.579000, 0.759576, 0.764339,
0.666838, -0.142315, -0.731487, 0.000000, 0.766700, -0.277300, -0.579000, 0.782022, 0.788961,
0.886052, -0.142315, -0.441201, 0.000000, 0.766700, -0.277300, -0.579000, 0.873101, 0.668352,
0.612815, -0.415415, -0.672226, 0.000000, 0.766700, -0.277300, -0.579000, 0.759576, 0.764339,
0.886052, -0.142315, -0.441201, 0.000000, 0.766700, -0.277300, -0.579000, 0.873101, 0.668352,
0.814269, -0.415415, -0.405458, 0.000000, 0.766700, -0.277300, -0.579000, 0.843277, 0.653502,
0.612815, 0.415415, -0.672226, 0.000000, 0.674700, 0.534100, -0.509500, 0.759576, 0.764339,
0.509145, 0.654861, -0.558506, 0.000000, 0.674700, 0.534100, -0.509500, 0.716503, 0.717090,
0.676519, 0.654861, -0.336867, 0.000000, 0.674700, 0.534100, -0.509500, 0.786044, 0.625003,
0.612815, 0.415415, -0.672226, 0.000000, 0.674700, 0.534100, -0.509500, 0.759576, 0.764339,
0.676519, 0.654861, -0.336867, 0.000000, 0.674700, 0.534100, -0.509500, 0.786044, 0.625003,
0.814269, 0.415415, -0.405458, 0.000000, 0.674700, 0.534100, -0.509500, 0.843277, 0.653502,
0.000000, -1.000000, -0.000000, 0.000000, 0.115500, -0.989500, -0.087200, 0.504961, 0.485040,
0.189802, -0.959493, -0.208203, 0.000000, 0.115500, -0.989500, -0.087200, 0.583821, 0.571545,
0.252197, -0.959493, -0.125579, 0.000000, 0.115500, -0.989500, -0.087200, 0.609745, 0.537216,
0.189802, 0.959493, -0.208203, 0.000000, 0.115500, 0.989500, -0.087200, 0.583821, 0.571545,
-0.000000, 1.000000, -0.000000, 0.000000, 0.115500, 0.989500, -0.087200, 0.504961, 0.485040,
0.252197, 0.959493, -0.125579, 0.000000, 0.115500, 0.989500, -0.087200, 0.609745, 0.537216,
0.509145, -0.654861, -0.558506, 0.000000, 0.674700, -0.534100, -0.509500, 0.716503, 0.717090,
0.612815, -0.415415, -0.672226, 0.000000, 0.674700, -0.534100, -0.509500, 0.759576, 0.764339,
0.814269, -0.415415, -0.405458, 0.000000, 0.674700, -0.534100, -0.509500, 0.843277, 0.653502,
0.509145, -0.654861, -0.558506, 0.000000, 0.674700, -0.534100, -0.509500, 0.716503, 0.717090,
0.814269, -0.415415, -0.405458, 0.000000, 0.674700, -0.534100, -0.509500, 0.843277, 0.653502,
0.676519, -0.654861, -0.336867, 0.000000, 0.674700, -0.534100, -0.509500, 0.786044, 0.625003,
0.666838, 0.142315, -0.731487, 0.000000, 0.766700, 0.277300, -0.579000, 0.782022, 0.788961,
0.612815, 0.415415, -0.672226, 0.000000, 0.766700, 0.277300, -0.579000, 0.759576, 0.764339,
0.814269, 0.415415, -0.405458, 0.000000, 0.766700, 0.277300, -0.579000, 0.843277, 0.653502,
0.666838, 0.142315, -0.731487, 0.000000, 0.766700, 0.277300, -0.579000, 0.782022, 0.788961,
0.814269, 0.415415, -0.405458, 0.000000, 0.766700, 0.277300, -0.579000, 0.843277, 0.653502,
0.886052, 0.142315, -0.441201, 0.000000, 0.766700, 0.277300, -0.579000, 0.873101, 0.668352,
0.364227, 0.841254, -0.399538, 0.000000, 0.336200, 0.906900, -0.253900, 0.656292, 0.651042,
0.189802, 0.959493, -0.208203, 0.000000, 0.336200, 0.906900, -0.253900, 0.583821, 0.571545,
0.252197, 0.959493, -0.125579, 0.000000, 0.336200, 0.906900, -0.253900, 0.609745, 0.537216,
0.364227, 0.841254, -0.399538, 0.000000, 0.336200, 0.906900, -0.253900, 0.656292, 0.651042,
0.252197, 0.959493, -0.125579, 0.000000, 0.336200, 0.906900, -0.253900, 0.609745, 0.537216,
0.483962, 0.841254, -0.240984, 0.000000, 0.336200, 0.906900, -0.253900, 0.706039, 0.585165,
0.364227, -0.841254, -0.399538, 0.000000, 0.527700, -0.750100, -0.398500, 0.656292, 0.651042,
0.509145, -0.654861, -0.558506, 0.000000, 0.527700, -0.750100, -0.398500, 0.716503, 0.717090,
0.676519, -0.654861, -0.336867, 0.000000, 0.527700, -0.750100, -0.398500, 0.786044, 0.625003,
0.364227, -0.841254, -0.399538, 0.000000, 0.527700, -0.750100, -0.398500, 0.656292, 0.651042,
0.676519, -0.654861, -0.336867, 0.000000, 0.527700, -0.750100, -0.398500, 0.786044, 0.625003,
0.483962, -0.841254, -0.240984, 0.000000, 0.527700, -0.750100, -0.398500, 0.706039, 0.585165,
0.814269, -0.415415, -0.405458, 0.000000, 0.924100, -0.277300, -0.262900, 0.843277, 0.653502,
0.886052, -0.142315, -0.441201, 0.000000, 0.924100, -0.277300, -0.262900, 0.873101, 0.668352,
0.985599, -0.142315, -0.091329, 0.000000, 0.924100, -0.277300, -0.262900, 0.914461, 0.522986,
0.814269, -0.415415, -0.405458, 0.000000, 0.924100, -0.277300, -0.262900, 0.843277, 0.653502,
0.985599, -0.142315, -0.091329, 0.000000, 0.924100, -0.277300, -0.262900, 0.914461, 0.522986,
0.905751, -0.415415, -0.083930, 0.000000, 0.924100, -0.277300, -0.262900, 0.881286, 0.519912,
0.814269, 0.415415, -0.405458, 0.000000, 0.813200, 0.534100, -0.231400, 0.843277, 0.653502,
0.676519, 0.654861, -0.336867, 0.000000, 0.813200, 0.534100, -0.231400, 0.786044, 0.625003,
0.752526, 0.654861, -0.069732, 0.000000, 0.813200, 0.534100, -0.231400, 0.817623, 0.514013,
0.814269, 0.415415, -0.405458, 0.000000, 0.813200, 0.534100, -0.231400, 0.843277, 0.653502,
0.752526, 0.654861, -0.069732, 0.000000, 0.813200, 0.534100, -0.231400, 0.817623, 0.514013,
0.905752, 0.415415, -0.083930, 0.000000, 0.813200, 0.534100, -0.231400, 0.881286, 0.519912,
0.000000, -1.000000, -0.000000, 0.000000, 0.139200, -0.989500, -0.039600, 0.504961, 0.485040,
0.252197, -0.959493, -0.125579, 0.000000, 0.139200, -0.989500, -0.039600, 0.609745, 0.537216,
0.280531, -0.959493, -0.025995, 0.000000, 0.139200, -0.989500, -0.039600, 0.621517, 0.495841,
0.252197, 0.959493, -0.125579, 0.000000, 0.139200, 0.989500, -0.039600, 0.609745, 0.537216,
-0.000000, 1.000000, -0.000000, 0.000000, 0.139200, 0.989500, -0.039600, 0.504961, 0.485040,
0.280531, 0.959493, -0.025995, 0.000000, 0.139200, 0.989500, -0.039600, 0.621517, 0.495841,
0.676519, -0.654861, -0.336867, 0.000000, 0.813200, -0.534100, -0.231400, 0.786044, 0.625003,
0.814269, -0.415415, -0.405458, 0.000000, 0.813200, -0.534100, -0.231400, 0.843277, 0.653502,
0.905751, -0.415415, -0.083930, 0.000000, 0.813200, -0.534100, -0.231400, 0.881286, 0.519912,
0.676519, -0.654861, -0.336867, 0.000000, 0.813200, -0.534100, -0.231400, 0.786044, 0.625003,
0.905751, -0.415415, -0.083930, 0.000000, 0.813200, -0.534100, -0.231400, 0.881286, 0.519912,
0.752525, -0.654861, -0.069732, 0.000000, 0.813200, -0.534100, -0.231400, 0.817623, 0.514013,
0.886052, 0.142315, -0.441201, 0.000000, 0.924100, 0.277300, -0.262900, 0.873101, 0.668352,
0.814269, 0.415415, -0.405458, 0.000000, 0.924100, 0.277300, -0.262900, 0.843277, 0.653502,
0.905752, 0.415415, -0.083930, 0.000000, 0.924100, 0.277300, -0.262900, 0.881286, 0.519912,
0.886052, 0.142315, -0.441201, 0.000000, 0.924100, 0.277300, -0.262900, 0.873101, 0.668352,
0.905752, 0.415415, -0.083930, 0.000000, 0.924100, 0.277300, -0.262900, 0.881286, 0.519912,
0.985599, 0.142315, -0.091329, 0.000000, 0.924100, 0.277300, -0.262900, 0.914461, 0.522986,
0.483962, 0.841254, -0.240984, 0.000000, 0.405300, 0.906900, -0.115300, 0.706039, 0.585165,
0.252197, 0.959493, -0.125579, 0.000000, 0.405300, 0.906900, -0.115300, 0.609745, 0.537216,
0.280531, 0.959493, -0.025995, 0.000000, 0.405300, 0.906900, -0.115300, 0.621517, 0.495841,
0.483962, 0.841254, -0.240984, 0.000000, 0.405300, 0.906900, -0.115300, 0.706039, 0.585165,
0.280531, 0.959493, -0.025995, 0.000000, 0.405300, 0.906900, -0.115300, 0.621517, 0.495841,
0.538334, 0.841254, -0.049884, 0.000000, 0.405300, 0.906900, -0.115300, 0.728630, 0.505766,
0.483962, -0.841254, -0.240984, 0.000000, 0.636000, -0.750100, -0.181000, 0.706039, 0.585165,
0.676519, -0.654861, -0.336867, 0.000000, 0.636000, -0.750100, -0.181000, 0.786044, 0.625003,
0.752525, -0.654861, -0.069732, 0.000000, 0.636000, -0.750100, -0.181000, 0.817623, 0.514013,
0.483962, -0.841254, -0.240984, 0.000000, 0.636000, -0.750100, -0.181000, 0.706039, 0.585165,
0.752525, -0.654861, -0.069732, 0.000000, 0.636000, -0.750100, -0.181000, 0.817623, 0.514013,
0.538334, -0.841254, -0.049884, 0.000000, 0.636000, -0.750100, -0.181000, 0.728630, 0.505766,
0.886052, -0.142315, -0.441201, 0.000000, 0.961800, 0.000000, -0.273700, 0.873101, 0.668352,
0.886052, 0.142315, -0.441201, 0.000000, 0.961800, 0.000000, -0.273700, 0.873101, 0.668352,
0.985599, 0.142315, -0.091329, 0.000000, 0.961800, 0.000000, -0.273700, 0.914461, 0.522986,
0.886052, -0.142315, -0.441201, 0.000000, 0.961800, 0.000000, -0.273700, 0.873101, 0.668352,
0.985599, 0.142315, -0.091329, 0.000000, 0.961800, 0.000000, -0.273700, 0.914461, 0.522986,
0.985599, -0.142315, -0.091329, 0.000000, 0.961800, 0.000000, -0.273700, 0.914461, 0.522986,
0.676519, 0.654861, -0.336867, 0.000000, 0.636000, 0.750100, -0.181000, 0.786044, 0.625003,
0.483962, 0.841254, -0.240984, 0.000000, 0.636000, 0.750100, -0.181000, 0.706039, 0.585165,
0.538334, 0.841254, -0.049884, 0.000000, 0.636000, 0.750100, -0.181000, 0.728630, 0.505766,
0.676519, 0.654861, -0.336867, 0.000000, 0.636000, 0.750100, -0.181000, 0.786044, 0.625003,
0.538334, 0.841254, -0.049884, 0.000000, 0.636000, 0.750100, -0.181000, 0.728630, 0.505766,
0.752526, 0.654861, -0.069732, 0.000000, 0.636000, 0.750100, -0.181000, 0.817623, 0.514013,
0.252197, -0.959493, -0.125579, 0.000000, 0.405300, -0.906900, -0.115300, 0.609745, 0.537216,
0.483962, -0.841254, -0.240984, 0.000000, 0.405300, -0.906900, -0.115300, 0.706039, 0.585165,
0.538334, -0.841254, -0.049884, 0.000000, 0.405300, -0.906900, -0.115300, 0.728630, 0.505766,
0.252197, -0.959493, -0.125579, 0.000000, 0.405300, -0.906900, -0.115300, 0.609745, 0.537216,
0.538334, -0.841254, -0.049884, 0.000000, 0.405300, -0.906900, -0.115300, 0.728630, 0.505766,
0.280531, -0.959493, -0.025995, 0.000000, 0.405300, -0.906900, -0.115300, 0.621517, 0.495841,
0.000000, -1.000000, -0.000000, 0.000000, 0.144100, -0.989500, 0.013400, 0.504961, 0.485040,
0.280531, -0.959493, -0.025995, 0.000000, 0.144100, -0.989500, 0.013400, 0.621517, 0.495841,
0.270977, -0.959493, 0.077100, 0.000000, 0.144100, -0.989500, 0.013400, 0.617548, 0.453007,
0.280531, 0.959493, -0.025995, 0.000000, 0.144100, 0.989500, 0.013400, 0.621517, 0.495841,
-0.000000, 1.000000, -0.000000, 0.000000, 0.144100, 0.989500, 0.013400, 0.504961, 0.485040,
0.270977, 0.959493, 0.077100, 0.000000, 0.144100, 0.989500, 0.013400, 0.617548, 0.453007,
0.752525, -0.654861, -0.069732, 0.000000, 0.841800, -0.534100, 0.078000, 0.817623, 0.514013,
0.905751, -0.415415, -0.083930, 0.000000, 0.841800, -0.534100, 0.078000, 0.881286, 0.519912,
0.874907, -0.415415, 0.248932, 0.000000, 0.841800, -0.534100, 0.078000, 0.868471, 0.381613,
0.752525, -0.654861, -0.069732, 0.000000, 0.841800, -0.534100, 0.078000, 0.817623, 0.514013,
0.874907, -0.415415, 0.248932, 0.000000, 0.841800, -0.534100, 0.078000, 0.868471, 0.381613,
0.726899, -0.654861, 0.206820, 0.000000, 0.841800, -0.534100, 0.078000, 0.806976, 0.399110,
0.985599, 0.142315, -0.091329, 0.000000, 0.956700, 0.277300, 0.088600, 0.914461, 0.522986,
0.905752, 0.415415, -0.083930, 0.000000, 0.956700, 0.277300, 0.088600, 0.881286, 0.519912,
0.874907, 0.415415, 0.248932, 0.000000, 0.956700, 0.277300, 0.088600, 0.868471, 0.381613,
0.985599, 0.142315, -0.091329, 0.000000, 0.956700, 0.277300, 0.088600, 0.914461, 0.522986,
0.874907, 0.415415, 0.248932, 0.000000, 0.956700, 0.277300, 0.088600, 0.868471, 0.381613,
0.952035, 0.142315, 0.270877, 0.000000, 0.956700, 0.277300, 0.088600, 0.900516, 0.372495,
0.538334, 0.841254, -0.049884, 0.000000, 0.419500, 0.906900, 0.038900, 0.728630, 0.505766,
0.280531, 0.959493, -0.025995, 0.000000, 0.419500, 0.906900, 0.038900, 0.621517, 0.495841,
0.270977, 0.959493, 0.077100, 0.000000, 0.419500, 0.906900, 0.038900, 0.617548, 0.453007,
0.538334, 0.841254, -0.049884, 0.000000, 0.419500, 0.906900, 0.038900, 0.728630, 0.505766,
0.270977, 0.959493, 0.077100, 0.000000, 0.419500, 0.906900, 0.038900, 0.617548, 0.453007,
0.520002, 0.841254, 0.147953, 0.000000, 0.419500, 0.906900, 0.038900, 0.721013, 0.423568,
0.538334, -0.841254, -0.049884, 0.000000, 0.658400, -0.750100, 0.061000, 0.728630, 0.505766,
0.752525, -0.654861, -0.069732, 0.000000, 0.658400, -0.750100, 0.061000, 0.817623, 0.514013,
0.726899, -0.654861, 0.206820, 0.000000, 0.658400, -0.750100, 0.061000, 0.806976, 0.399110,
0.538334, -0.841254, -0.049884, 0.000000, 0.658400, -0.750100, 0.061000, 0.728630, 0.505766,
0.726899, -0.654861, 0.206820, 0.000000, 0.658400, -0.750100, 0.061000, 0.806976, 0.399110,
0.520002, -0.841254, 0.147953, 0.000000, 0.658400, -0.750100, 0.061000, 0.721013, 0.423568,
0.985599, -0.142315, -0.091329, 0.000000, 0.995700, 0.000000, 0.092300, 0.914461, 0.522986,
0.985599, 0.142315, -0.091329, 0.000000, 0.995700, 0.000000, 0.092300, 0.914461, 0.522986,
0.952035, 0.142315, 0.270877, 0.000000, 0.995700, 0.000000, 0.092300, 0.900516, 0.372495,
0.985599, -0.142315, -0.091329, 0.000000, 0.995700, 0.000000, 0.092300, 0.914461, 0.522986,
0.952035, 0.142315, 0.270877, 0.000000, 0.995700, 0.000000, 0.092300, 0.900516, 0.372495,
0.952035, -0.142315, 0.270877, 0.000000, 0.995700, 0.000000, 0.092300, 0.900516, 0.372495,
0.752526, 0.654861, -0.069732, 0.000000, 0.658400, 0.750100, 0.061000, 0.817623, 0.514013,
0.538334, 0.841254, -0.049884, 0.000000, 0.658400, 0.750100, 0.061000, 0.728630, 0.505766,
0.520002, 0.841254, 0.147953, 0.000000, 0.658400, 0.750100, 0.061000, 0.721013, 0.423568,
0.752526, 0.654861, -0.069732, 0.000000, 0.658400, 0.750100, 0.061000, 0.817623, 0.514013,
0.520002, 0.841254, 0.147953, 0.000000, 0.658400, 0.750100, 0.061000, 0.721013, 0.423568,
0.726899, 0.654861, 0.206821, 0.000000, 0.658400, 0.750100, 0.061000, 0.806976, 0.399110,
0.280531, -0.959493, -0.025995, 0.000000, 0.419500, -0.906900, 0.038900, 0.621517, 0.495841,
0.538334, -0.841254, -0.049884, 0.000000, 0.419500, -0.906900, 0.038900, 0.728630, 0.505766,
0.520002, -0.841254, 0.147953, 0.000000, 0.419500, -0.906900, 0.038900, 0.721013, 0.423568,
0.280531, -0.959493, -0.025995, 0.000000, 0.419500, -0.906900, 0.038900, 0.621517, 0.495841,
0.520002, -0.841254, 0.147953, 0.000000, 0.419500, -0.906900, 0.038900, 0.721013, 0.423568,
0.270977, -0.959493, 0.077100, 0.000000, 0.419500, -0.906900, 0.038900, 0.617548, 0.453007,
0.905751, -0.415415, -0.083930, 0.000000, 0.956700, -0.277300, 0.088600, 0.881286, 0.519912,
0.985599, -0.142315, -0.091329, 0.000000, 0.956700, -0.277300, 0.088600, 0.914461, 0.522986,
0.952035, -0.142315, 0.270877, 0.000000, 0.956700, -0.277300, 0.088600, 0.900516, 0.372495,
0.905751, -0.415415, -0.083930, 0.000000, 0.956700, -0.277300, 0.088600, 0.881286, 0.519912,
0.952035, -0.142315, 0.270877, 0.000000, 0.956700, -0.277300, 0.088600, 0.900516, 0.372495,
0.874907, -0.415415, 0.248932, 0.000000, 0.956700, -0.277300, 0.088600, 0.868471, 0.381613,
0.905752, 0.415415, -0.083930, 0.000000, 0.841800, 0.534100, 0.078000, 0.881286, 0.519912,
0.752526, 0.654861, -0.069732, 0.000000, 0.841800, 0.534100, 0.078000, 0.817623, 0.514013,
0.726899, 0.654861, 0.206821, 0.000000, 0.841800, 0.534100, 0.078000, 0.806976, 0.399110,
0.905752, 0.415415, -0.083930, 0.000000, 0.841800, 0.534100, 0.078000, 0.881286, 0.519912,
0.726899, 0.654861, 0.206821, 0.000000, 0.841800, 0.534100, 0.078000, 0.806976, 0.399110,
0.874907, 0.415415, 0.248932, 0.000000, 0.841800, 0.534100, 0.078000, 0.868471, 0.381613,
0.952035, 0.142315, 0.270877, 0.000000, 0.860100, 0.277300, 0.428300, 0.900516, 0.372495,
0.874907, 0.415415, 0.248932, 0.000000, 0.860100, 0.277300, 0.428300, 0.868471, 0.381613,
0.725902, 0.415415, 0.548176, 0.000000, 0.860100, 0.277300, 0.428300, 0.806561, 0.257282,
0.952035, 0.142315, 0.270877, 0.000000, 0.860100, 0.277300, 0.428300, 0.900516, 0.372495,
0.725902, 0.415415, 0.548176, 0.000000, 0.860100, 0.277300, 0.428300, 0.806561, 0.257282,
0.789894, 0.142315, 0.596500, 0.000000, 0.860100, 0.277300, 0.428300, 0.833149, 0.237204,
0.520002, 0.841254, 0.147953, 0.000000, 0.377200, 0.906900, 0.187800, 0.721013, 0.423568,
0.270977, 0.959493, 0.077100, 0.000000, 0.377200, 0.906900, 0.187800, 0.617548, 0.453007,
0.224827, 0.959493, 0.169782, 0.000000, 0.377200, 0.906900, 0.187800, 0.598373, 0.414499,
0.520002, 0.841254, 0.147953, 0.000000, 0.377200, 0.906900, 0.187800, 0.721013, 0.423568,
0.224827, 0.959493, 0.169782, 0.000000, 0.377200, 0.906900, 0.187800, 0.598373, 0.414499,
0.431441, 0.841254, 0.325809, 0.000000, 0.377200, 0.906900, 0.187800, 0.684218, 0.349672,
0.520002, -0.841254, 0.147953, 0.000000, 0.591900, -0.750100, 0.294800, 0.721013, 0.423568,
0.726899, -0.654861, 0.206820, 0.000000, 0.591900, -0.750100, 0.294800, 0.806976, 0.399110,
0.603101, -0.654861, 0.455441, 0.000000, 0.591900, -0.750100, 0.294800, 0.755540, 0.295812,
0.520002, -0.841254, 0.147953, 0.000000, 0.591900, -0.750100, 0.294800, 0.721013, 0.423568,
0.603101, -0.654861, 0.455441, 0.000000, 0.591900, -0.750100, 0.294800, 0.755540, 0.295812,
0.431441, -0.841254, 0.325809, 0.000000, 0.591900, -0.750100, 0.294800, 0.684218, 0.349672,
0.952035, -0.142315, 0.270877, 0.000000, 0.895200, 0.000000, 0.445700, 0.900516, 0.372495,
0.952035, 0.142315, 0.270877, 0.000000, 0.895200, 0.000000, 0.445700, 0.900516, 0.372495,
0.789894, 0.142315, 0.596500, 0.000000, 0.895200, 0.000000, 0.445700, 0.833149, 0.237204,
0.952035, -0.142315, 0.270877, 0.000000, 0.895200, 0.000000, 0.445700, 0.900516, 0.372495,
0.789894, 0.142315, 0.596500, 0.000000, 0.895200, 0.000000, 0.445700, 0.833149, 0.237204,
0.789894, -0.142315, 0.596500, 0.000000, 0.895200, 0.000000, 0.445700, 0.833149, 0.237204,
0.726899, 0.654861, 0.206821, 0.000000, 0.591900, 0.750100, 0.294800, 0.806976, 0.399110,
0.520002, 0.841254, 0.147953, 0.000000, 0.591900, 0.750100, 0.294800, 0.721013, 0.423568,
0.431441, 0.841254, 0.325809, 0.000000, 0.591900, 0.750100, 0.294800, 0.684218, 0.349672,
0.726899, 0.654861, 0.206821, 0.000000, 0.591900, 0.750100, 0.294800, 0.806976, 0.399110,
0.431441, 0.841254, 0.325809, 0.000000, 0.591900, 0.750100, 0.294800, 0.684218, 0.349672,
0.603101, 0.654861, 0.455441, 0.000000, 0.591900, 0.750100, 0.294800, 0.755540, 0.295812,
0.270977, -0.959493, 0.077100, 0.000000, 0.377200, -0.906900, 0.187800, 0.617548, 0.453007,
0.520002, -0.841254, 0.147953, 0.000000, 0.377200, -0.906900, 0.187800, 0.721013, 0.423568,
0.431441, -0.841254, 0.325809, 0.000000, 0.377200, -0.906900, 0.187800, 0.684218, 0.349672,
0.270977, -0.959493, 0.077100, 0.000000, 0.377200, -0.906900, 0.187800, 0.617548, 0.453007,
0.431441, -0.841254, 0.325809, 0.000000, 0.377200, -0.906900, 0.187800, 0.684218, 0.349672,
0.224827, -0.959493, 0.169782, 0.000000, 0.377200, -0.906900, 0.187800, 0.598373, 0.414499,
0.874907, -0.415415, 0.248932, 0.000000, 0.860100, -0.277300, 0.428300, 0.868471, 0.381613,
0.952035, -0.142315, 0.270877, 0.000000, 0.860100, -0.277300, 0.428300, 0.900516, 0.372495,
0.789894, -0.142315, 0.596500, 0.000000, 0.860100, -0.277300, 0.428300, 0.833149, 0.237204,
0.874907, -0.415415, 0.248932, 0.000000, 0.860100, -0.277300, 0.428300, 0.868471, 0.381613,
0.789894, -0.142315, 0.596500, 0.000000, 0.860100, -0.277300, 0.428300, 0.833149, 0.237204,
0.725902, -0.415415, 0.548176, 0.000000, 0.860100, -0.277300, 0.428300, 0.806561, 0.257282,
0.874907, 0.415415, 0.248932, 0.000000, 0.756800, 0.534100, 0.376800, 0.868471, 0.381613,
0.726899, 0.654861, 0.206821, 0.000000, 0.756800, 0.534100, 0.376800, 0.806976, 0.399110,
0.603101, 0.654861, 0.455441, 0.000000, 0.756800, 0.534100, 0.376800, 0.755540, 0.295812,
0.874907, 0.415415, 0.248932, 0.000000, 0.756800, 0.534100, 0.376800, 0.868471, 0.381613,
0.603101, 0.654861, 0.455441, 0.000000, 0.756800, 0.534100, 0.376800, 0.755540, 0.295812,
0.725902, 0.415415, 0.548176, 0.000000, 0.756800, 0.534100, 0.376800, 0.806561, 0.257282,
0.000000, -1.000000, -0.000000, 0.000000, 0.129600, -0.989500, 0.064500, 0.504961, 0.485040,
0.270977, -0.959493, 0.077100, 0.000000, 0.129600, -0.989500, 0.064500, 0.617548, 0.453007,
0.224827, -0.959493, 0.169782, 0.000000, 0.129600, -0.989500, 0.064500, 0.598373, 0.414499,
0.270977, 0.959493, 0.077100, 0.000000, 0.129600, 0.989500, 0.064500, 0.617548, 0.453007,
-0.000000, 1.000000, -0.000000, 0.000000, 0.129600, 0.989500, 0.064500, 0.504961, 0.485040,
0.224827, 0.959493, 0.169782, 0.000000, 0.129600, 0.989500, 0.064500, 0.598373, 0.414499,
0.726899, -0.654861, 0.206820, 0.000000, 0.756800, -0.534100, 0.376800, 0.806976, 0.399110,
0.874907, -0.415415, 0.248932, 0.000000, 0.756800, -0.534100, 0.376800, 0.868471, 0.381613,
0.725902, -0.415415, 0.548176, 0.000000, 0.756800, -0.534100, 0.376800, 0.806561, 0.257282,
0.726899, -0.654861, 0.206820, 0.000000, 0.756800, -0.534100, 0.376800, 0.806976, 0.399110,
0.725902, -0.415415, 0.548176, 0.000000, 0.756800, -0.534100, 0.376800, 0.806561, 0.257282,
0.603101, -0.654861, 0.455441, 0.000000, 0.756800, -0.534100, 0.376800, 0.755540, 0.295812,
0.789894, -0.142315, 0.596500, 0.000000, 0.673700, 0.000000, 0.739000, 0.833149, 0.237204,
0.789894, 0.142315, 0.596500, 0.000000, 0.673700, 0.000000, 0.739000, 0.833149, 0.237204,
0.521074, 0.142315, 0.841563, 0.000000, 0.673700, 0.000000, 0.739000, 0.721459, 0.135385,
0.789894, -0.142315, 0.596500, 0.000000, 0.673700, 0.000000, 0.739000, 0.833149, 0.237204,
0.521074, 0.142315, 0.841563, 0.000000, 0.673700, 0.000000, 0.739000, 0.721459, 0.135385,
0.521074, -0.142315, 0.841563, 0.000000, 0.673700, 0.000000, 0.739000, 0.721459, 0.135385,
0.603101, 0.654861, 0.455441, 0.000000, 0.445500, 0.750100, 0.488700, 0.755540, 0.295812,
0.431441, 0.841254, 0.325809, 0.000000, 0.445500, 0.750100, 0.488700, 0.684218, 0.349672,
0.284611, 0.841254, 0.459662, 0.000000, 0.445500, 0.750100, 0.488700, 0.623212, 0.294058,
0.603101, 0.654861, 0.455441, 0.000000, 0.445500, 0.750100, 0.488700, 0.755540, 0.295812,
0.284611, 0.841254, 0.459662, 0.000000, 0.445500, 0.750100, 0.488700, 0.623212, 0.294058,
0.397851, 0.654861, 0.642551, 0.000000, 0.445500, 0.750100, 0.488700, 0.670262, 0.218071,
0.224827, -0.959493, 0.169782, 0.000000, 0.283900, -0.906900, 0.311400, 0.598373, 0.414499,
0.431441, -0.841254, 0.325809, 0.000000, 0.283900, -0.906900, 0.311400, 0.684218, 0.349672,
0.284611, -0.841254, 0.459662, 0.000000, 0.283900, -0.906900, 0.311400, 0.623212, 0.294058,
0.224827, -0.959493, 0.169782, 0.000000, 0.283900, -0.906900, 0.311400, 0.598373, 0.414499,
0.284611, -0.841254, 0.459662, 0.000000, 0.283900, -0.906900, 0.311400, 0.623212, 0.294058,
0.148313, -0.959493, 0.239534, 0.000000, 0.283900, -0.906900, 0.311400, 0.566583, 0.385518,
0.725902, -0.415415, 0.548176, 0.000000, 0.647300, -0.277300, 0.710000, 0.806561, 0.257282,
0.789894, -0.142315, 0.596500, 0.000000, 0.647300, -0.277300, 0.710000, 0.833149, 0.237204,
0.521074, -0.142315, 0.841563, 0.000000, 0.647300, -0.277300, 0.710000, 0.721459, 0.135385,
0.725902, -0.415415, 0.548176, 0.000000, 0.647300, -0.277300, 0.710000, 0.806561, 0.257282,
0.521074, -0.142315, 0.841563, 0.000000, 0.647300, -0.277300, 0.710000, 0.721459, 0.135385,
0.478859, -0.415415, 0.773385, 0.000000, 0.647300, -0.277300, 0.710000, 0.703919, 0.163712,
0.725902, 0.415415, 0.548176, 0.000000, 0.569600, 0.534100, 0.624800, 0.806561, 0.257282,
0.603101, 0.654861, 0.455441, 0.000000, 0.569600, 0.534100, 0.624800, 0.755540, 0.295812,
0.397851, 0.654861, 0.642551, 0.000000, 0.569600, 0.534100, 0.624800, 0.670262, 0.218071,
0.725902, 0.415415, 0.548176, 0.000000, 0.569600, 0.534100, 0.624800, 0.806561, 0.257282,
0.397851, 0.654861, 0.642551, 0.000000, 0.569600, 0.534100, 0.624800, 0.670262, 0.218071,
0.478859, 0.415415, 0.773385, 0.000000, 0.569600, 0.534100, 0.624800, 0.703919, 0.163712,
0.000000, -1.000000, -0.000000, 0.000000, 0.097500, -0.989500, 0.107000, 0.504961, 0.485040,
0.224827, -0.959493, 0.169782, 0.000000, 0.097500, -0.989500, 0.107000, 0.598373, 0.414499,
0.148313, -0.959493, 0.239534, 0.000000, 0.097500, -0.989500, 0.107000, 0.566583, 0.385518,
0.224827, 0.959493, 0.169782, 0.000000, 0.097500, 0.989500, 0.107000, 0.598373, 0.414499,
-0.000000, 1.000000, -0.000000, 0.000000, 0.097500, 0.989500, 0.107000, 0.504961, 0.485040,
0.148313, 0.959493, 0.239534, 0.000000, 0.097500, 0.989500, 0.107000, 0.566583, 0.385518,
0.603101, -0.654861, 0.455441, 0.000000, 0.569600, -0.534100, 0.624800, 0.755540, 0.295812,
0.725902, -0.415415, 0.548176, 0.000000, 0.569600, -0.534100, 0.624800, 0.806561, 0.257282,
0.478859, -0.415415, 0.773385, 0.000000, 0.569600, -0.534100, 0.624800, 0.703919, 0.163712,
0.603101, -0.654861, 0.455441, 0.000000, 0.569600, -0.534100, 0.624800, 0.755540, 0.295812,
0.478859, -0.415415, 0.773385, 0.000000, 0.569600, -0.534100, 0.624800, 0.703919, 0.163712,
0.397851, -0.654861, 0.642551, 0.000000, 0.569600, -0.534100, 0.624800, 0.670262, 0.218071,
0.789894, 0.142315, 0.596500, 0.000000, 0.647300, 0.277300, 0.710000, 0.833149, 0.237204,
0.725902, 0.415415, 0.548176, 0.000000, 0.647300, 0.277300, 0.710000, 0.806561, 0.257282,
0.478859, 0.415415, 0.773385, 0.000000, 0.647300, 0.277300, 0.710000, 0.703919, 0.163712,
0.789894, 0.142315, 0.596500, 0.000000, 0.647300, 0.277300, 0.710000, 0.833149, 0.237204,
0.478859, 0.415415, 0.773385, 0.000000, 0.647300, 0.277300, 0.710000, 0.703919, 0.163712,
0.521074, 0.142315, 0.841563, 0.000000, 0.647300, 0.277300, 0.710000, 0.721459, 0.135385,
0.431441, 0.841254, 0.325809, 0.000000, 0.283900, 0.906900, 0.311400, 0.684218, 0.349672,
0.224827, 0.959493, 0.169782, 0.000000, 0.283900, 0.906900, 0.311400, 0.598373, 0.414499,
0.148313, 0.959493, 0.239534, 0.000000, 0.283900, 0.906900, 0.311400, 0.566583, 0.385518,
0.431441, 0.841254, 0.325809, 0.000000, 0.283900, 0.906900, 0.311400, 0.684218, 0.349672,
0.148313, 0.959493, 0.239534, 0.000000, 0.283900, 0.906900, 0.311400, 0.566583, 0.385518,
0.284611, 0.841254, 0.459662, 0.000000, 0.283900, 0.906900, 0.311400, 0.623212, 0.294058,
0.431441, -0.841254, 0.325809, 0.000000, 0.445500, -0.750100, 0.488700, 0.684218, 0.349672,
0.603101, -0.654861, 0.455441, 0.000000, 0.445500, -0.750100, 0.488700, 0.755540, 0.295812,
0.397851, -0.654861, 0.642551, 0.000000, 0.445500, -0.750100, 0.488700, 0.670262, 0.218071,
0.431441, -0.841254, 0.325809, 0.000000, 0.445500, -0.750100, 0.488700, 0.684218, 0.349672,
0.397851, -0.654861, 0.642551, 0.000000, 0.445500, -0.750100, 0.488700, 0.670262, 0.218071,
0.284611, -0.841254, 0.459662, 0.000000, 0.445500, -0.750100, 0.488700, 0.623212, 0.294058,
0.148313, -0.959493, 0.239534, 0.000000, 0.152200, -0.906900, 0.392900, 0.566583, 0.385518,
0.284611, -0.841254, 0.459662, 0.000000, 0.152200, -0.906900, 0.392900, 0.623212, 0.294058,
0.099342, -0.841254, 0.531435, 0.000000, 0.152200, -0.906900, 0.392900, 0.546236, 0.264238,
0.148313, -0.959493, 0.239534, 0.000000, 0.152200, -0.906900, 0.392900, 0.566583, 0.385518,
0.099342, -0.841254, 0.531435, 0.000000, 0.152200, -0.906900, 0.392900, 0.546236, 0.264238,
0.051768, -0.959493, 0.276935, 0.000000, 0.152200, -0.906900, 0.392900, 0.526470, 0.369978,
0.478859, -0.415415, 0.773385, 0.000000, 0.347100, -0.277300, 0.895900, 0.703919, 0.163712,
0.521074, -0.142315, 0.841563, 0.000000, 0.347100, -0.277300, 0.895900, 0.721459, 0.135385,
0.181879, -0.142315, 0.972968, 0.000000, 0.347100, -0.277300, 0.895900, 0.580529, 0.080788,
0.478859, -0.415415, 0.773385, 0.000000, 0.347100, -0.277300, 0.895900, 0.703919, 0.163712,
0.181879, -0.142315, 0.972968, 0.000000, 0.347100, -0.277300, 0.895900, 0.580529, 0.080788,
0.167144, -0.415415, 0.894144, 0.000000, 0.347100, -0.277300, 0.895900, 0.574407, 0.113538,
0.478859, 0.415415, 0.773385, 0.000000, 0.305400, 0.534100, 0.788300, 0.703919, 0.163712,
0.397851, 0.654861, 0.642551, 0.000000, 0.305400, 0.534100, 0.788300, 0.670262, 0.218071,
0.138869, 0.654861, 0.742881, 0.000000, 0.305400, 0.534100, 0.788300, 0.562659, 0.176385,
0.478859, 0.415415, 0.773385, 0.000000, 0.305400, 0.534100, 0.788300, 0.703919, 0.163712,
0.138869, 0.654861, 0.742881, 0.000000, 0.305400, 0.534100, 0.788300, 0.562659, 0.176385,
0.167144, 0.415415, 0.894144, 0.000000, 0.305400, 0.534100, 0.788300, 0.574407, 0.113538,
0.000000, -1.000000, -0.000000, 0.000000, 0.052300, -0.989500, 0.135000, 0.504961, 0.485040,
0.148313, -0.959493, 0.239534, 0.000000, 0.052300, -0.989500, 0.135000, 0.566583, 0.385518,
0.051768, -0.959493, 0.276935, 0.000000, 0.052300, -0.989500, 0.135000, 0.526470, 0.369978,
0.148313, 0.959493, 0.239534, 0.000000, 0.052300, 0.989500, 0.135000, 0.566583, 0.385518,
-0.000000, 1.000000, -0.000000, 0.000000, 0.052300, 0.989500, 0.135000, 0.504961, 0.485040,
0.051768, 0.959493, 0.276935, 0.000000, 0.052300, 0.989500, 0.135000, 0.526470, 0.369978,
0.397851, -0.654861, 0.642551, 0.000000, 0.305400, -0.534100, 0.788300, 0.670262, 0.218071,
0.478859, -0.415415, 0.773385, 0.000000, 0.305400, -0.534100, 0.788300, 0.703919, 0.163712,
0.167144, -0.415415, 0.894144, 0.000000, 0.305400, -0.534100, 0.788300, 0.574407, 0.113538,
0.397851, -0.654861, 0.642551, 0.000000, 0.305400, -0.534100, 0.788300, 0.670262, 0.218071,
0.167144, -0.415415, 0.894144, 0.000000, 0.305400, -0.534100, 0.788300, 0.574407, 0.113538,
0.138869, -0.654861, 0.742881, 0.000000, 0.305400, -0.534100, 0.788300, 0.562659, 0.176385,
0.521074, 0.142315, 0.841563, 0.000000, 0.347100, 0.277300, 0.895900, 0.721459, 0.135385,
0.478859, 0.415415, 0.773385, 0.000000, 0.347100, 0.277300, 0.895900, 0.703919, 0.163712,
0.167144, 0.415415, 0.894144, 0.000000, 0.347100, 0.277300, 0.895900, 0.574407, 0.113538,
0.521074, 0.142315, 0.841563, 0.000000, 0.347100, 0.277300, 0.895900, 0.721459, 0.135385,
0.167144, 0.415415, 0.894144, 0.000000, 0.347100, 0.277300, 0.895900, 0.574407, 0.113538,
0.181879, 0.142315, 0.972968, 0.000000, 0.347100, 0.277300, 0.895900, 0.580529, 0.080788,
0.284611, 0.841254, 0.459662, 0.000000, 0.152200, 0.906900, 0.392900, 0.623212, 0.294058,
0.148313, 0.959493, 0.239534, 0.000000, 0.152200, 0.906900, 0.392900, 0.566583, 0.385518,
0.051768, 0.959493, 0.276935, 0.000000, 0.152200, 0.906900, 0.392900, 0.526470, 0.369978,
0.284611, 0.841254, 0.459662, 0.000000, 0.152200, 0.906900, 0.392900, 0.623212, 0.294058,
0.051768, 0.959493, 0.276935, 0.000000, 0.152200, 0.906900, 0.392900, 0.526470, 0.369978,
0.099342, 0.841254, 0.531435, 0.000000, 0.152200, 0.906900, 0.392900, 0.546236, 0.264238,
0.284611, -0.841254, 0.459662, 0.000000, 0.238900, -0.750100, 0.616600, 0.623212, 0.294058,
0.397851, -0.654861, 0.642551, 0.000000, 0.238900, -0.750100, 0.616600, 0.670262, 0.218071,
0.138869, -0.654861, 0.742881, 0.000000, 0.238900, -0.750100, 0.616600, 0.562659, 0.176385,
0.284611, -0.841254, 0.459662, 0.000000, 0.238900, -0.750100, 0.616600, 0.623212, 0.294058,
0.138869, -0.654861, 0.742881, 0.000000, 0.238900, -0.750100, 0.616600, 0.562659, 0.176385,
0.099342, -0.841254, 0.531435, 0.000000, 0.238900, -0.750100, 0.616600, 0.546236, 0.264238,
0.521074, -0.142315, 0.841563, 0.000000, 0.361200, 0.000000, 0.932500, 0.721459, 0.135385,
0.521074, 0.142315, 0.841563, 0.000000, 0.361200, 0.000000, 0.932500, 0.721459, 0.135385,
0.181879, 0.142315, 0.972968, 0.000000, 0.361200, 0.000000, 0.932500, 0.580529, 0.080788,
0.521074, -0.142315, 0.841563, 0.000000, 0.361200, 0.000000, 0.932500, 0.721459, 0.135385,
0.181879, 0.142315, 0.972968, 0.000000, 0.361200, 0.000000, 0.932500, 0.580529, 0.080788,
0.181879, -0.142315, 0.972968, 0.000000, 0.361200, 0.000000, 0.932500, 0.580529, 0.080788,
0.397851, 0.654861, 0.642551, 0.000000, 0.238900, 0.750100, 0.616600, 0.670262, 0.218071,
0.284611, 0.841254, 0.459662, 0.000000, 0.238900, 0.750100, 0.616600, 0.623212, 0.294058,
0.099342, 0.841254, 0.531435, 0.000000, 0.238900, 0.750100, 0.616600, 0.546236, 0.264238,
0.397851, 0.654861, 0.642551, 0.000000, 0.238900, 0.750100, 0.616600, 0.670262, 0.218071,
0.099342, 0.841254, 0.531435, 0.000000, 0.238900, 0.750100, 0.616600, 0.546236, 0.264238,
0.138869, 0.654861, 0.742881, 0.000000, 0.238900, 0.750100, 0.616600, 0.562659, 0.176385,
0.167144, 0.415415, 0.894144, 0.000000, 0.000000, 0.534100, 0.845400, 0.574407, 0.113538,
0.138869, 0.654861, 0.742881, 0.000000, 0.000000, 0.534100, 0.845400, 0.562659, 0.176385,
-0.138869, 0.654861, 0.742881, 0.000000, 0.000000, 0.534100, 0.845400, 0.447264, 0.176385,
0.167144, 0.415415, 0.894144, 0.000000, 0.000000, 0.534100, 0.845400, 0.574407, 0.113538,
-0.138869, 0.654861, 0.742881, 0.000000, 0.000000, 0.534100, 0.845400, 0.447264, 0.176385,
-0.167145, 0.415415, 0.894144, 0.000000, 0.000000, 0.534100, 0.845400, 0.435515, 0.113538,
0.000000, -1.000000, -0.000000, 0.000000, 0.000000, -0.989500, 0.144700, 0.504961, 0.485040,
0.051768, -0.959493, 0.276935, 0.000000, 0.000000, -0.989500, 0.144700, 0.526470, 0.369978,
-0.051768, -0.959493, 0.276935, 0.000000, 0.000000, -0.989500, 0.144700, 0.483452, 0.369978,
0.051768, 0.959493, 0.276935, 0.000000, 0.000000, 0.989500, 0.144700, 0.526470, 0.369978,
-0.000000, 1.000000, -0.000000, 0.000000, 0.000000, 0.989500, 0.144700, 0.504961, 0.485040,
-0.051768, 0.959493, 0.276935, 0.000000, 0.000000, 0.989500, 0.144700, 0.483452, 0.369978,
0.138869, -0.654861, 0.742881, 0.000000, 0.000000, -0.534100, 0.845400, 0.562659, 0.176385,
0.167144, -0.415415, 0.894144, 0.000000, 0.000000, -0.534100, 0.845400, 0.574407, 0.113538,
-0.167145, -0.415415, 0.894144, 0.000000, 0.000000, -0.534100, 0.845400, 0.435515, 0.113538,
0.138869, -0.654861, 0.742881, 0.000000, 0.000000, -0.534100, 0.845400, 0.562659, 0.176385,
-0.167145, -0.415415, 0.894144, 0.000000, 0.000000, -0.534100, 0.845400, 0.435515, 0.113538,
-0.138869, -0.654861, 0.742881, 0.000000, 0.000000, -0.534100, 0.845400, 0.447264, 0.176385,
0.181879, 0.142315, 0.972968, 0.000000, 0.000000, 0.277300, 0.960800, 0.580529, 0.080788,
0.167144, 0.415415, 0.894144, 0.000000, 0.000000, 0.277300, 0.960800, 0.574407, 0.113538,
-0.167145, 0.415415, 0.894144, 0.000000, 0.000000, 0.277300, 0.960800, 0.435515, 0.113538,
0.181879, 0.142315, 0.972968, 0.000000, 0.000000, 0.277300, 0.960800, 0.580529, 0.080788,
-0.167145, 0.415415, 0.894144, 0.000000, 0.000000, 0.277300, 0.960800, 0.435515, 0.113538,
-0.181879, 0.142315, 0.972968, 0.000000, 0.000000, 0.277300, 0.960800, 0.429393, 0.080788,
0.099342, 0.841254, 0.531435, 0.000000, 0.000000, 0.906900, 0.421300, 0.546236, 0.264238,
0.051768, 0.959493, 0.276935, 0.000000, 0.000000, 0.906900, 0.421300, 0.526470, 0.369978,
-0.051768, 0.959493, 0.276935, 0.000000, 0.000000, 0.906900, 0.421300, 0.483452, 0.369978,
0.099342, 0.841254, 0.531435, 0.000000, 0.000000, 0.906900, 0.421300, 0.546236, 0.264238,
-0.051768, 0.959493, 0.276935, 0.000000, 0.000000, 0.906900, 0.421300, 0.483452, 0.369978,
-0.099343, 0.841254, 0.531435, 0.000000, 0.000000, 0.906900, 0.421300, 0.463686, 0.264238,
0.099342, -0.841254, 0.531435, 0.000000, 0.000000, -0.750100, 0.661300, 0.546236, 0.264238,
0.138869, -0.654861, 0.742881, 0.000000, 0.000000, -0.750100, 0.661300, 0.562659, 0.176385,
-0.138869, -0.654861, 0.742881, 0.000000, 0.000000, -0.750100, 0.661300, 0.447264, 0.176385,
0.099342, -0.841254, 0.531435, 0.000000, 0.000000, -0.750100, 0.661300, 0.546236, 0.264238,
-0.138869, -0.654861, 0.742881, 0.000000, 0.000000, -0.750100, 0.661300, 0.447264, 0.176385,
-0.099343, -0.841254, 0.531435, 0.000000, 0.000000, -0.750100, 0.661300, 0.463686, 0.264238,
0.181879, -0.142315, 0.972968, 0.000000, 0.000000, 0.000000, 1.000000, 0.580529, 0.080788,
0.181879, 0.142315, 0.972968, 0.000000, 0.000000, 0.000000, 1.000000, 0.580529, 0.080788,
-0.181879, 0.142315, 0.972968, 0.000000, 0.000000, 0.000000, 1.000000, 0.429393, 0.080788,
0.181879, -0.142315, 0.972968, 0.000000, 0.000000, 0.000000, 1.000000, 0.580529, 0.080788,
-0.181879, 0.142315, 0.972968, 0.000000, 0.000000, 0.000000, 1.000000, 0.429393, 0.080788,
-0.181879, -0.142315, 0.972968, 0.000000, 0.000000, 0.000000, 1.000000, 0.429393, 0.080788,
0.138869, 0.654861, 0.742881, 0.000000, 0.000000, 0.750100, 0.661300, 0.562659, 0.176385,
0.099342, 0.841254, 0.531435, 0.000000, 0.000000, 0.750100, 0.661300, 0.546236, 0.264238,
-0.099343, 0.841254, 0.531435, 0.000000, 0.000000, 0.750100, 0.661300, 0.463686, 0.264238,
0.138869, 0.654861, 0.742881, 0.000000, 0.000000, 0.750100, 0.661300, 0.562659, 0.176385,
-0.099343, 0.841254, 0.531435, 0.000000, 0.000000, 0.750100, 0.661300, 0.463686, 0.264238,
-0.138869, 0.654861, 0.742881, 0.000000, 0.000000, 0.750100, 0.661300, 0.447264, 0.176385,
0.051768, -0.959493, 0.276935, 0.000000, 0.000000, -0.906900, 0.421300, 0.526470, 0.369978,
0.099342, -0.841254, 0.531435, 0.000000, 0.000000, -0.906900, 0.421300, 0.546236, 0.264238,
-0.099343, -0.841254, 0.531435, 0.000000, 0.000000, -0.906900, 0.421300, 0.463686, 0.264238,
0.051768, -0.959493, 0.276935, 0.000000, 0.000000, -0.906900, 0.421300, 0.526470, 0.369978,
-0.099343, -0.841254, 0.531435, 0.000000, 0.000000, -0.906900, 0.421300, 0.463686, 0.264238,
-0.051768, -0.959493, 0.276935, 0.000000, 0.000000, -0.906900, 0.421300, 0.483452, 0.369978,
0.167144, -0.415415, 0.894144, 0.000000, 0.000000, -0.277300, 0.960800, 0.574407, 0.113538,
0.181879, -0.142315, 0.972968, 0.000000, 0.000000, -0.277300, 0.960800, 0.580529, 0.080788,
-0.181879, -0.142315, 0.972968, 0.000000, 0.000000, -0.277300, 0.960800, 0.429393, 0.080788,
0.167144, -0.415415, 0.894144, 0.000000, 0.000000, -0.277300, 0.960800, 0.574407, 0.113538,
-0.181879, -0.142315, 0.972968, 0.000000, 0.000000, -0.277300, 0.960800, 0.429393, 0.080788,
-0.167145, -0.415415, 0.894144, 0.000000, 0.000000, -0.277300, 0.960800, 0.435515, 0.113538,
-0.181879, 0.142315, 0.972968, 0.000000, -0.347100, 0.277300, 0.895900, 0.429393, 0.080788,
-0.167145, 0.415415, 0.894144, 0.000000, -0.347100, 0.277300, 0.895900, 0.435515, 0.113538,
-0.478860, 0.415415, 0.773385, 0.000000, -0.347100, 0.277300, 0.895900, 0.306003, 0.163712,
-0.181879, 0.142315, 0.972968, 0.000000, -0.347100, 0.277300, 0.895900, 0.429393, 0.080788,
-0.478860, 0.415415, 0.773385, 0.000000, -0.347100, 0.277300, 0.895900, 0.306003, 0.163712,
-0.521074, 0.142315, 0.841563, 0.000000, -0.347100, 0.277300, 0.895900, 0.288464, 0.135385,
-0.099343, 0.841254, 0.531435, 0.000000, -0.152200, 0.906900, 0.392900, 0.463686, 0.264238,
-0.051768, 0.959493, 0.276935, 0.000000, -0.152200, 0.906900, 0.392900, 0.483452, 0.369978,
-0.148313, 0.959493, 0.239534, 0.000000, -0.152200, 0.906900, 0.392900, 0.443340, 0.385518,
-0.099343, 0.841254, 0.531435, 0.000000, -0.152200, 0.906900, 0.392900, 0.463686, 0.264238,
-0.148313, 0.959493, 0.239534, 0.000000, -0.152200, 0.906900, 0.392900, 0.443340, 0.385518,
-0.284611, 0.841254, 0.459662, 0.000000, -0.152200, 0.906900, 0.392900, 0.386710, 0.294058,
-0.099343, -0.841254, 0.531435, 0.000000, -0.238900, -0.750100, 0.616600, 0.463686, 0.264238,
-0.138869, -0.654861, 0.742881, 0.000000, -0.238900, -0.750100, 0.616600, 0.447264, 0.176385,
-0.397851, -0.654861, 0.642551, 0.000000, -0.238900, -0.750100, 0.616600, 0.339661, 0.218071,
-0.099343, -0.841254, 0.531435, 0.000000, -0.238900, -0.750100, 0.616600, 0.463686, 0.264238,
-0.397851, -0.654861, 0.642551, 0.000000, -0.238900, -0.750100, 0.616600, 0.339661, 0.218071,
-0.284611, -0.841254, 0.459662, 0.000000, -0.238900, -0.750100, 0.616600, 0.386710, 0.294058,
-0.181879, -0.142315, 0.972968, 0.000000, -0.361200, 0.000000, 0.932500, 0.429393, 0.080788,
-0.181879, 0.142315, 0.972968, 0.000000, -0.361200, 0.000000, 0.932500, 0.429393, 0.080788,
-0.521074, 0.142315, 0.841563, 0.000000, -0.361200, 0.000000, 0.932500, 0.288464, 0.135385,
-0.181879, -0.142315, 0.972968, 0.000000, -0.361200, 0.000000, 0.932500, 0.429393, 0.080788,
-0.521074, 0.142315, 0.841563, 0.000000, -0.361200, 0.000000, 0.932500, 0.288464, 0.135385,
-0.521074, -0.142315, 0.841563, 0.000000, -0.361200, 0.000000, 0.932500, 0.288464, 0.135385,
-0.138869, 0.654861, 0.742881, 0.000000, -0.238900, 0.750100, 0.616600, 0.447264, 0.176385,
-0.099343, 0.841254, 0.531435, 0.000000, -0.238900, 0.750100, 0.616600, 0.463686, 0.264238,
-0.284611, 0.841254, 0.459662, 0.000000, -0.238900, 0.750100, 0.616600, 0.386710, 0.294058,
-0.138869, 0.654861, 0.742881, 0.000000, -0.238900, 0.750100, 0.616600, 0.447264, 0.176385,
-0.284611, 0.841254, 0.459662, 0.000000, -0.238900, 0.750100, 0.616600, 0.386710, 0.294058,
-0.397851, 0.654861, 0.642551, 0.000000, -0.238900, 0.750100, 0.616600, 0.339661, 0.218071,
-0.051768, -0.959493, 0.276935, 0.000000, -0.152200, -0.906900, 0.392900, 0.483452, 0.369978,
-0.099343, -0.841254, 0.531435, 0.000000, -0.152200, -0.906900, 0.392900, 0.463686, 0.264238,
-0.284611, -0.841254, 0.459662, 0.000000, -0.152200, -0.906900, 0.392900, 0.386710, 0.294058,
-0.051768, -0.959493, 0.276935, 0.000000, -0.152200, -0.906900, 0.392900, 0.483452, 0.369978,
-0.284611, -0.841254, 0.459662, 0.000000, -0.152200, -0.906900, 0.392900, 0.386710, 0.294058,
-0.148313, -0.959493, 0.239534, 0.000000, -0.152200, -0.906900, 0.392900, 0.443340, 0.385518,
-0.167145, -0.415415, 0.894144, 0.000000, -0.347100, -0.277300, 0.895900, 0.435515, 0.113538,
-0.181879, -0.142315, 0.972968, 0.000000, -0.347100, -0.277300, 0.895900, 0.429393, 0.080788,
-0.521074, -0.142315, 0.841563, 0.000000, -0.347100, -0.277300, 0.895900, 0.288464, 0.135385,
-0.167145, -0.415415, 0.894144, 0.000000, -0.347100, -0.277300, 0.895900, 0.435515, 0.113538,
-0.521074, -0.142315, 0.841563, 0.000000, -0.347100, -0.277300, 0.895900, 0.288464, 0.135385,
-0.478860, -0.415415, 0.773384, 0.000000, -0.347100, -0.277300, 0.895900, 0.306003, 0.163712,
-0.167145, 0.415415, 0.894144, 0.000000, -0.305400, 0.534100, 0.788300, 0.435515, 0.113538,
-0.138869, 0.654861, 0.742881, 0.000000, -0.305400, 0.534100, 0.788300, 0.447264, 0.176385,
-0.397851, 0.654861, 0.642551, 0.000000, -0.305400, 0.534100, 0.788300, 0.339661, 0.218071,
-0.167145, 0.415415, 0.894144, 0.000000, -0.305400, 0.534100, 0.788300, 0.435515, 0.113538,
-0.397851, 0.654861, 0.642551, 0.000000, -0.305400, 0.534100, 0.788300, 0.339661, 0.218071,
-0.478860, 0.415415, 0.773385, 0.000000, -0.305400, 0.534100, 0.788300, 0.306003, 0.163712,
0.000000, -1.000000, -0.000000, 0.000000, -0.052300, -0.989500, 0.135000, 0.504961, 0.485040,
-0.051768, -0.959493, 0.276935, 0.000000, -0.052300, -0.989500, 0.135000, 0.483452, 0.369978,
-0.148313, -0.959493, 0.239534, 0.000000, -0.052300, -0.989500, 0.135000, 0.443340, 0.385518,
-0.051768, 0.959493, 0.276935, 0.000000, -0.052300, 0.989500, 0.135000, 0.483452, 0.369978,
-0.000000, 1.000000, -0.000000, 0.000000, -0.052300, 0.989500, 0.135000, 0.504961, 0.485040,
-0.148313, 0.959493, 0.239534, 0.000000, -0.052300, 0.989500, 0.135000, 0.443340, 0.385518,
-0.138869, -0.654861, 0.742881, 0.000000, -0.305400, -0.534100, 0.788300, 0.447264, 0.176385,
-0.167145, -0.415415, 0.894144, 0.000000, -0.305400, -0.534100, 0.788300, 0.435515, 0.113538,
-0.478860, -0.415415, 0.773384, 0.000000, -0.305400, -0.534100, 0.788300, 0.306003, 0.163712,
-0.138869, -0.654861, 0.742881, 0.000000, -0.305400, -0.534100, 0.788300, 0.447264, 0.176385,
-0.478860, -0.415415, 0.773384, 0.000000, -0.305400, -0.534100, 0.788300, 0.306003, 0.163712,
-0.397851, -0.654861, 0.642551, 0.000000, -0.305400, -0.534100, 0.788300, 0.339661, 0.218071,
-0.284611, -0.841254, 0.459662, 0.000000, -0.445500, -0.750100, 0.488700, 0.386710, 0.294058,
-0.397851, -0.654861, 0.642551, 0.000000, -0.445500, -0.750100, 0.488700, 0.339661, 0.218071,
-0.603101, -0.654861, 0.455441, 0.000000, -0.445500, -0.750100, 0.488700, 0.254383, 0.295812,
-0.284611, -0.841254, 0.459662, 0.000000, -0.445500, -0.750100, 0.488700, 0.386710, 0.294058,
-0.603101, -0.654861, 0.455441, 0.000000, -0.445500, -0.750100, 0.488700, 0.254383, 0.295812,
-0.431441, -0.841254, 0.325809, 0.000000, -0.445500, -0.750100, 0.488700, 0.325705, 0.349672,
-0.521074, -0.142315, 0.841563, 0.000000, -0.673700, 0.000000, 0.739000, 0.288464, 0.135385,
-0.521074, 0.142315, 0.841563, 0.000000, -0.673700, 0.000000, 0.739000, 0.288464, 0.135385,
-0.789895, 0.142315, 0.596500, 0.000000, -0.673700, 0.000000, 0.739000, 0.176773, 0.237204,
-0.521074, -0.142315, 0.841563, 0.000000, -0.673700, 0.000000, 0.739000, 0.288464, 0.135385,
-0.789895, 0.142315, 0.596500, 0.000000, -0.673700, 0.000000, 0.739000, 0.176773, 0.237204,
-0.789895, -0.142315, 0.596500, 0.000000, -0.673700, 0.000000, 0.739000, 0.176773, 0.237204,
-0.397851, 0.654861, 0.642551, 0.000000, -0.445500, 0.750100, 0.488700, 0.339661, 0.218071,
-0.284611, 0.841254, 0.459662, 0.000000, -0.445500, 0.750100, 0.488700, 0.386710, 0.294058,
-0.431441, 0.841254, 0.325809, 0.000000, -0.445500, 0.750100, 0.488700, 0.325705, 0.349672,
-0.397851, 0.654861, 0.642551, 0.000000, -0.445500, 0.750100, 0.488700, 0.339661, 0.218071,
-0.431441, 0.841254, 0.325809, 0.000000, -0.445500, 0.750100, 0.488700, 0.325705, 0.349672,
-0.603101, 0.654861, 0.455441, 0.000000, -0.445500, 0.750100, 0.488700, 0.254383, 0.295812,
-0.148313, -0.959493, 0.239534, 0.000000, -0.283900, -0.906900, 0.311400, 0.443340, 0.385518,
-0.284611, -0.841254, 0.459662, 0.000000, -0.283900, -0.906900, 0.311400, 0.386710, 0.294058,
-0.431441, -0.841254, 0.325809, 0.000000, -0.283900, -0.906900, 0.311400, 0.325705, 0.349672,
-0.148313, -0.959493, 0.239534, 0.000000, -0.283900, -0.906900, 0.311400, 0.443340, 0.385518,
-0.431441, -0.841254, 0.325809, 0.000000, -0.283900, -0.906900, 0.311400, 0.325705, 0.349672,
-0.224827, -0.959493, 0.169782, 0.000000, -0.283900, -0.906900, 0.311400, 0.411549, 0.414499,
-0.478860, -0.415415, 0.773384, 0.000000, -0.647300, -0.277300, 0.710000, 0.306003, 0.163712,
-0.521074, -0.142315, 0.841563, 0.000000, -0.647300, -0.277300, 0.710000, 0.288464, 0.135385,
-0.789895, -0.142315, 0.596500, 0.000000, -0.647300, -0.277300, 0.710000, 0.176773, 0.237204,
-0.478860, -0.415415, 0.773384, 0.000000, -0.647300, -0.277300, 0.710000, 0.306003, 0.163712,
-0.789895, -0.142315, 0.596500, 0.000000, -0.647300, -0.277300, 0.710000, 0.176773, 0.237204,
-0.725902, -0.415415, 0.548175, 0.000000, -0.647300, -0.277300, 0.710000, 0.203361, 0.257282,
-0.478860, 0.415415, 0.773385, 0.000000, -0.569600, 0.534100, 0.624800, 0.306003, 0.163712,
-0.397851, 0.654861, 0.642551, 0.000000, -0.569600, 0.534100, 0.624800, 0.339661, 0.218071,
-0.603101, 0.654861, 0.455441, 0.000000, -0.569600, 0.534100, 0.624800, 0.254383, 0.295812,
-0.478860, 0.415415, 0.773385, 0.000000, -0.569600, 0.534100, 0.624800, 0.306003, 0.163712,
-0.603101, 0.654861, 0.455441, 0.000000, -0.569600, 0.534100, 0.624800, 0.254383, 0.295812,
-0.725902, 0.415415, 0.548176, 0.000000, -0.569600, 0.534100, 0.624800, 0.203361, 0.257282,
0.000000, -1.000000, -0.000000, 0.000000, -0.097500, -0.989500, 0.107000, 0.504961, 0.485040,
-0.148313, -0.959493, 0.239534, 0.000000, -0.097500, -0.989500, 0.107000, 0.443340, 0.385518,
-0.224827, -0.959493, 0.169782, 0.000000, -0.097500, -0.989500, 0.107000, 0.411549, 0.414499,
-0.148313, 0.959493, 0.239534, 0.000000, -0.097500, 0.989500, 0.107000, 0.443340, 0.385518,
-0.000000, 1.000000, -0.000000, 0.000000, -0.097500, 0.989500, 0.107000, 0.504961, 0.485040,
-0.224827, 0.959493, 0.169782, 0.000000, -0.097500, 0.989500, 0.107000, 0.411549, 0.414499,
-0.397851, -0.654861, 0.642551, 0.000000, -0.569600, -0.534100, 0.624800, 0.339661, 0.218071,
-0.478860, -0.415415, 0.773384, 0.000000, -0.569600, -0.534100, 0.624800, 0.306003, 0.163712,
-0.725902, -0.415415, 0.548175, 0.000000, -0.569600, -0.534100, 0.624800, 0.203361, 0.257282,
-0.397851, -0.654861, 0.642551, 0.000000, -0.569600, -0.534100, 0.624800, 0.339661, 0.218071,
-0.725902, -0.415415, 0.548175, 0.000000, -0.569600, -0.534100, 0.624800, 0.203361, 0.257282,
-0.603101, -0.654861, 0.455441, 0.000000, -0.569600, -0.534100, 0.624800, 0.254383, 0.295812,
-0.521074, 0.142315, 0.841563, 0.000000, -0.647300, 0.277300, 0.710000, 0.288464, 0.135385,
-0.478860, 0.415415, 0.773385, 0.000000, -0.647300, 0.277300, 0.710000, 0.306003, 0.163712,
-0.725902, 0.415415, 0.548176, 0.000000, -0.647300, 0.277300, 0.710000, 0.203361, 0.257282,
-0.521074, 0.142315, 0.841563, 0.000000, -0.647300, 0.277300, 0.710000, 0.288464, 0.135385,
-0.725902, 0.415415, 0.548176, 0.000000, -0.647300, 0.277300, 0.710000, 0.203361, 0.257282,
-0.789895, 0.142315, 0.596500, 0.000000, -0.647300, 0.277300, 0.710000, 0.176773, 0.237204,
-0.284611, 0.841254, 0.459662, 0.000000, -0.283900, 0.906900, 0.311400, 0.386710, 0.294058,
-0.148313, 0.959493, 0.239534, 0.000000, -0.283900, 0.906900, 0.311400, 0.443340, 0.385518,
-0.224827, 0.959493, 0.169782, 0.000000, -0.283900, 0.906900, 0.311400, 0.411549, 0.414499,
-0.284611, 0.841254, 0.459662, 0.000000, -0.283900, 0.906900, 0.311400, 0.386710, 0.294058,
-0.224827, 0.959493, 0.169782, 0.000000, -0.283900, 0.906900, 0.311400, 0.411549, 0.414499,
-0.431441, 0.841254, 0.325809, 0.000000, -0.283900, 0.906900, 0.311400, 0.325705, 0.349672,
-0.603101, 0.654861, 0.455441, 0.000000, -0.591900, 0.750100, 0.294800, 0.254383, 0.295812,
-0.431441, 0.841254, 0.325809, 0.000000, -0.591900, 0.750100, 0.294800, 0.325705, 0.349672,
-0.520002, 0.841254, 0.147953, 0.000000, -0.591900, 0.750100, 0.294800, 0.288909, 0.423568,
-0.603101, 0.654861, 0.455441, 0.000000, -0.591900, 0.750100, 0.294800, 0.254383, 0.295812,
-0.520002, 0.841254, 0.147953, 0.000000, -0.591900, 0.750100, 0.294800, 0.288909, 0.423568,
-0.726899, 0.654861, 0.206820, 0.000000, -0.591900, 0.750100, 0.294800, 0.202946, 0.399110,
-0.224827, -0.959493, 0.169782, 0.000000, -0.377200, -0.906900, 0.187800, 0.411549, 0.414499,
-0.431441, -0.841254, 0.325809, 0.000000, -0.377200, -0.906900, 0.187800, 0.325705, 0.349672,
-0.520002, -0.841254, 0.147953, 0.000000, -0.377200, -0.906900, 0.187800, 0.288909, 0.423568,
-0.224827, -0.959493, 0.169782, 0.000000, -0.377200, -0.906900, 0.187800, 0.411549, 0.414499,
-0.520002, -0.841254, 0.147953, 0.000000, -0.377200, -0.906900, 0.187800, 0.288909, 0.423568,
-0.270978, -0.959493, 0.077100, 0.000000, -0.377200, -0.906900, 0.187800, 0.392374, 0.453007,
-0.725902, -0.415415, 0.548175, 0.000000, -0.860100, -0.277300, 0.428300, 0.203361, 0.257282,
-0.789895, -0.142315, 0.596500, 0.000000, -0.860100, -0.277300, 0.428300, 0.176773, 0.237204,
-0.952036, -0.142315, 0.270877, 0.000000, -0.860100, -0.277300, 0.428300, 0.109406, 0.372495,
-0.725902, -0.415415, 0.548175, 0.000000, -0.860100, -0.277300, 0.428300, 0.203361, 0.257282,
-0.952036, -0.142315, 0.270877, 0.000000, -0.860100, -0.277300, 0.428300, 0.109406, 0.372495,
-0.874907, -0.415415, 0.248932, 0.000000, -0.860100, -0.277300, 0.428300, 0.141452, 0.381613,
-0.725902, 0.415415, 0.548176, 0.000000, -0.756800, 0.534100, 0.376800, 0.203361, 0.257282,
-0.603101, 0.654861, 0.455441, 0.000000, -0.756800, 0.534100, 0.376800, 0.254383, 0.295812,
-0.726899, 0.654861, 0.206820, 0.000000, -0.756800, 0.534100, 0.376800, 0.202946, 0.399110,
-0.725902, 0.415415, 0.548176, 0.000000, -0.756800, 0.534100, 0.376800, 0.203361, 0.257282,
-0.726899, 0.654861, 0.206820, 0.000000, -0.756800, 0.534100, 0.376800, 0.202946, 0.399110,
-0.874907, 0.415415, 0.248932, 0.000000, -0.756800, 0.534100, 0.376800, 0.141452, 0.381613,
0.000000, -1.000000, -0.000000, 0.000000, -0.129600, -0.989500, 0.064500, 0.504961, 0.485040,
-0.224827, -0.959493, 0.169782, 0.000000, -0.129600, -0.989500, 0.064500, 0.411549, 0.414499,
-0.270978, -0.959493, 0.077100, 0.000000, -0.129600, -0.989500, 0.064500, 0.392374, 0.453007,
-0.224827, 0.959493, 0.169782, 0.000000, -0.129600, 0.989500, 0.064500, 0.411549, 0.414499,
-0.000000, 1.000000, -0.000000, 0.000000, -0.129600, 0.989500, 0.064500, 0.504961, 0.485040,
-0.270978, 0.959493, 0.077100, 0.000000, -0.129600, 0.989500, 0.064500, 0.392374, 0.453007,
-0.603101, -0.654861, 0.455441, 0.000000, -0.756800, -0.534100, 0.376800, 0.254383, 0.295812,
-0.725902, -0.415415, 0.548175, 0.000000, -0.756800, -0.534100, 0.376800, 0.203361, 0.257282,
-0.874907, -0.415415, 0.248932, 0.000000, -0.756800, -0.534100, 0.376800, 0.141452, 0.381613,
-0.603101, -0.654861, 0.455441, 0.000000, -0.756800, -0.534100, 0.376800, 0.254383, 0.295812,
-0.874907, -0.415415, 0.248932, 0.000000, -0.756800, -0.534100, 0.376800, 0.141452, 0.381613,
-0.726899, -0.654861, 0.206820, 0.000000, -0.756800, -0.534100, 0.376800, 0.202947, 0.399110,
-0.789895, 0.142315, 0.596500, 0.000000, -0.860100, 0.277300, 0.428300, 0.176773, 0.237204,
-0.725902, 0.415415, 0.548176, 0.000000, -0.860100, 0.277300, 0.428300, 0.203361, 0.257282,
-0.874907, 0.415415, 0.248932, 0.000000, -0.860100, 0.277300, 0.428300, 0.141452, 0.381613,
-0.789895, 0.142315, 0.596500, 0.000000, -0.860100, 0.277300, 0.428300, 0.176773, 0.237204,
-0.874907, 0.415415, 0.248932, 0.000000, -0.860100, 0.277300, 0.428300, 0.141452, 0.381613,
-0.952036, 0.142315, 0.270877, 0.000000, -0.860100, 0.277300, 0.428300, 0.109406, 0.372495,
-0.431441, 0.841254, 0.325809, 0.000000, -0.377200, 0.906900, 0.187800, 0.325705, 0.349672,
-0.224827, 0.959493, 0.169782, 0.000000, -0.377200, 0.906900, 0.187800, 0.411549, 0.414499,
-0.270978, 0.959493, 0.077100, 0.000000, -0.377200, 0.906900, 0.187800, 0.392374, 0.453007,
-0.431441, 0.841254, 0.325809, 0.000000, -0.377200, 0.906900, 0.187800, 0.325705, 0.349672,
-0.270978, 0.959493, 0.077100, 0.000000, -0.377200, 0.906900, 0.187800, 0.392374, 0.453007,
-0.520002, 0.841254, 0.147953, 0.000000, -0.377200, 0.906900, 0.187800, 0.288909, 0.423568,
-0.431441, -0.841254, 0.325809, 0.000000, -0.591900, -0.750100, 0.294800, 0.325705, 0.349672,
-0.603101, -0.654861, 0.455441, 0.000000, -0.591900, -0.750100, 0.294800, 0.254383, 0.295812,
-0.726899, -0.654861, 0.206820, 0.000000, -0.591900, -0.750100, 0.294800, 0.202947, 0.399110,
-0.431441, -0.841254, 0.325809, 0.000000, -0.591900, -0.750100, 0.294800, 0.325705, 0.349672,
-0.726899, -0.654861, 0.206820, 0.000000, -0.591900, -0.750100, 0.294800, 0.202947, 0.399110,
-0.520002, -0.841254, 0.147953, 0.000000, -0.591900, -0.750100, 0.294800, 0.288909, 0.423568,
-0.789895, -0.142315, 0.596500, 0.000000, -0.895200, 0.000000, 0.445700, 0.176773, 0.237204,
-0.789895, 0.142315, 0.596500, 0.000000, -0.895200, 0.000000, 0.445700, 0.176773, 0.237204,
-0.952036, 0.142315, 0.270877, 0.000000, -0.895200, 0.000000, 0.445700, 0.109406, 0.372495,
-0.789895, -0.142315, 0.596500, 0.000000, -0.895200, 0.000000, 0.445700, 0.176773, 0.237204,
-0.952036, 0.142315, 0.270877, 0.000000, -0.895200, 0.000000, 0.445700, 0.109406, 0.372495,
-0.952036, -0.142315, 0.270877, 0.000000, -0.895200, 0.000000, 0.445700, 0.109406, 0.372495,
-0.874907, 0.415415, 0.248932, 0.000000, -0.841800, 0.534100, 0.078000, 0.141452, 0.381613,
-0.726899, 0.654861, 0.206820, 0.000000, -0.841800, 0.534100, 0.078000, 0.202946, 0.399110,
-0.752526, 0.654861, -0.069732, 0.000000, -0.841800, 0.534100, 0.078000, 0.192299, 0.514013,
-0.874907, 0.415415, 0.248932, 0.000000, -0.841800, 0.534100, 0.078000, 0.141452, 0.381613,
-0.752526, 0.654861, -0.069732, 0.000000, -0.841800, 0.534100, 0.078000, 0.192299, 0.514013,
-0.905752, 0.415415, -0.083931, 0.000000, -0.841800, 0.534100, 0.078000, 0.128636, 0.519912,
0.000000, -1.000000, -0.000000, 0.000000, -0.144100, -0.989500, 0.013400, 0.504961, 0.485040,
-0.270978, -0.959493, 0.077100, 0.000000, -0.144100, -0.989500, 0.013400, 0.392374, 0.453007,
-0.280531, -0.959493, -0.025995, 0.000000, -0.144100, -0.989500, 0.013400, 0.388405, 0.495841,
-0.270978, 0.959493, 0.077100, 0.000000, -0.144100, 0.989500, 0.013400, 0.392374, 0.453007,
-0.000000, 1.000000, -0.000000, 0.000000, -0.144100, 0.989500, 0.013400, 0.504961, 0.485040,
-0.280531, 0.959493, -0.025995, 0.000000, -0.144100, 0.989500, 0.013400, 0.388405, 0.495841,
-0.726899, -0.654861, 0.206820, 0.000000, -0.841800, -0.534100, 0.078000, 0.202947, 0.399110,
-0.874907, -0.415415, 0.248932, 0.000000, -0.841800, -0.534100, 0.078000, 0.141452, 0.381613,
-0.905752, -0.415415, -0.083930, 0.000000, -0.841800, -0.534100, 0.078000, 0.128636, 0.519912,
-0.726899, -0.654861, 0.206820, 0.000000, -0.841800, -0.534100, 0.078000, 0.202947, 0.399110,
-0.905752, -0.415415, -0.083930, 0.000000, -0.841800, -0.534100, 0.078000, 0.128636, 0.519912,
-0.752525, -0.654861, -0.069732, 0.000000, -0.841800, -0.534100, 0.078000, 0.192299, 0.514013,
-0.952036, 0.142315, 0.270877, 0.000000, -0.956700, 0.277300, 0.088600, 0.109406, 0.372495,
-0.874907, 0.415415, 0.248932, 0.000000, -0.956700, 0.277300, 0.088600, 0.141452, 0.381613,
-0.905752, 0.415415, -0.083931, 0.000000, -0.956700, 0.277300, 0.088600, 0.128636, 0.519912,
-0.952036, 0.142315, 0.270877, 0.000000, -0.956700, 0.277300, 0.088600, 0.109406, 0.372495,
-0.905752, 0.415415, -0.083931, 0.000000, -0.956700, 0.277300, 0.088600, 0.128636, 0.519912,
-0.985599, 0.142315, -0.091329, 0.000000, -0.956700, 0.277300, 0.088600, 0.095461, 0.522986,
-0.520002, 0.841254, 0.147953, 0.000000, -0.419500, 0.906900, 0.038900, 0.288909, 0.423568,
-0.270978, 0.959493, 0.077100, 0.000000, -0.419500, 0.906900, 0.038900, 0.392374, 0.453007,
-0.280531, 0.959493, -0.025995, 0.000000, -0.419500, 0.906900, 0.038900, 0.388405, 0.495841,
-0.520002, 0.841254, 0.147953, 0.000000, -0.419500, 0.906900, 0.038900, 0.288909, 0.423568,
-0.280531, 0.959493, -0.025995, 0.000000, -0.419500, 0.906900, 0.038900, 0.388405, 0.495841,
-0.538334, 0.841254, -0.049884, 0.000000, -0.419500, 0.906900, 0.038900, 0.281292, 0.505766,
-0.520002, -0.841254, 0.147953, 0.000000, -0.658400, -0.750100, 0.061000, 0.288909, 0.423568,
-0.726899, -0.654861, 0.206820, 0.000000, -0.658400, -0.750100, 0.061000, 0.202947, 0.399110,
-0.752525, -0.654861, -0.069732, 0.000000, -0.658400, -0.750100, 0.061000, 0.192299, 0.514013,
-0.520002, -0.841254, 0.147953, 0.000000, -0.658400, -0.750100, 0.061000, 0.288909, 0.423568,
-0.752525, -0.654861, -0.069732, 0.000000, -0.658400, -0.750100, 0.061000, 0.192299, 0.514013,
-0.538334, -0.841254, -0.049884, 0.000000, -0.658400, -0.750100, 0.061000, 0.281292, 0.505766,
-0.952036, -0.142315, 0.270877, 0.000000, -0.995700, 0.000000, 0.092300, 0.109406, 0.372495,
-0.952036, 0.142315, 0.270877, 0.000000, -0.995700, 0.000000, 0.092300, 0.109406, 0.372495,
-0.985599, 0.142315, -0.091329, 0.000000, -0.995700, 0.000000, 0.092300, 0.095461, 0.522986,
-0.952036, -0.142315, 0.270877, 0.000000, -0.995700, 0.000000, 0.092300, 0.109406, 0.372495,
-0.985599, 0.142315, -0.091329, 0.000000, -0.995700, 0.000000, 0.092300, 0.095461, 0.522986,
-0.985599, -0.142315, -0.091329, 0.000000, -0.995700, 0.000000, 0.092300, 0.095461, 0.522986,
-0.726899, 0.654861, 0.206820, 0.000000, -0.658400, 0.750100, 0.061000, 0.202946, 0.399110,
-0.520002, 0.841254, 0.147953, 0.000000, -0.658400, 0.750100, 0.061000, 0.288909, 0.423568,
-0.538334, 0.841254, -0.049884, 0.000000, -0.658400, 0.750100, 0.061000, 0.281292, 0.505766,
-0.726899, 0.654861, 0.206820, 0.000000, -0.658400, 0.750100, 0.061000, 0.202946, 0.399110,
-0.538334, 0.841254, -0.049884, 0.000000, -0.658400, 0.750100, 0.061000, 0.281292, 0.505766,
-0.752526, 0.654861, -0.069732, 0.000000, -0.658400, 0.750100, 0.061000, 0.192299, 0.514013,
-0.270978, -0.959493, 0.077100, 0.000000, -0.419500, -0.906900, 0.038900, 0.392374, 0.453007,
-0.520002, -0.841254, 0.147953, 0.000000, -0.419500, -0.906900, 0.038900, 0.288909, 0.423568,
-0.538334, -0.841254, -0.049884, 0.000000, -0.419500, -0.906900, 0.038900, 0.281292, 0.505766,
-0.270978, -0.959493, 0.077100, 0.000000, -0.419500, -0.906900, 0.038900, 0.392374, 0.453007,
-0.538334, -0.841254, -0.049884, 0.000000, -0.419500, -0.906900, 0.038900, 0.281292, 0.505766,
-0.280531, -0.959493, -0.025995, 0.000000, -0.419500, -0.906900, 0.038900, 0.388405, 0.495841,
-0.874907, -0.415415, 0.248932, 0.000000, -0.956700, -0.277300, 0.088600, 0.141452, 0.381613,
-0.952036, -0.142315, 0.270877, 0.000000, -0.956700, -0.277300, 0.088600, 0.109406, 0.372495,
-0.985599, -0.142315, -0.091329, 0.000000, -0.956700, -0.277300, 0.088600, 0.095461, 0.522986,
-0.874907, -0.415415, 0.248932, 0.000000, -0.956700, -0.277300, 0.088600, 0.141452, 0.381613,
-0.985599, -0.142315, -0.091329, 0.000000, -0.956700, -0.277300, 0.088600, 0.095461, 0.522986,
-0.905752, -0.415415, -0.083930, 0.000000, -0.956700, -0.277300, 0.088600, 0.128636, 0.519912,
-0.752525, -0.654861, -0.069732, 0.000000, -0.813200, -0.534100, -0.231400, 0.192299, 0.514013,
-0.905752, -0.415415, -0.083930, 0.000000, -0.813200, -0.534100, -0.231400, 0.128636, 0.519912,
-0.814269, -0.415415, -0.405458, 0.000000, -0.813200, -0.534100, -0.231400, 0.166646, 0.653502,
-0.752525, -0.654861, -0.069732, 0.000000, -0.813200, -0.534100, -0.231400, 0.192299, 0.514013,
-0.814269, -0.415415, -0.405458, 0.000000, -0.813200, -0.534100, -0.231400, 0.166646, 0.653502,
-0.676519, -0.654861, -0.336867, 0.000000, -0.813200, -0.534100, -0.231400, 0.223879, 0.625003,
-0.985599, 0.142315, -0.091329, 0.000000, -0.924100, 0.277300, -0.262900, 0.095461, 0.522986,
-0.905752, 0.415415, -0.083931, 0.000000, -0.924100, 0.277300, -0.262900, 0.128636, 0.519912,
-0.814269, 0.415415, -0.405458, 0.000000, -0.924100, 0.277300, -0.262900, 0.166646, 0.653502,
-0.985599, 0.142315, -0.091329, 0.000000, -0.924100, 0.277300, -0.262900, 0.095461, 0.522986,
-0.814269, 0.415415, -0.405458, 0.000000, -0.924100, 0.277300, -0.262900, 0.166646, 0.653502,
-0.886052, 0.142315, -0.441202, 0.000000, -0.924100, 0.277300, -0.262900, 0.136821, 0.668352,
-0.538334, 0.841254, -0.049884, 0.000000, -0.405300, 0.906900, -0.115300, 0.281292, 0.505766,
-0.280531, 0.959493, -0.025995, 0.000000, -0.405300, 0.906900, -0.115300, 0.388405, 0.495841,
-0.252197, 0.959493, -0.125579, 0.000000, -0.405300, 0.906900, -0.115300, 0.400178, 0.537216,
-0.538334, 0.841254, -0.049884, 0.000000, -0.405300, 0.906900, -0.115300, 0.281292, 0.505766,
-0.252197, 0.959493, -0.125579, 0.000000, -0.405300, 0.906900, -0.115300, 0.400178, 0.537216,
-0.483962, 0.841254, -0.240984, 0.000000, -0.405300, 0.906900, -0.115300, 0.303883, 0.585165,
-0.538334, -0.841254, -0.049884, 0.000000, -0.636000, -0.750100, -0.181000, 0.281292, 0.505766,
-0.752525, -0.654861, -0.069732, 0.000000, -0.636000, -0.750100, -0.181000, 0.192299, 0.514013,
-0.676519, -0.654861, -0.336867, 0.000000, -0.636000, -0.750100, -0.181000, 0.223879, 0.625003,
-0.538334, -0.841254, -0.049884, 0.000000, -0.636000, -0.750100, -0.181000, 0.281292, 0.505766,
-0.676519, -0.654861, -0.336867, 0.000000, -0.636000, -0.750100, -0.181000, 0.223879, 0.625003,
-0.483962, -0.841254, -0.240984, 0.000000, -0.636000, -0.750100, -0.181000, 0.303883, 0.585165,
-0.985599, -0.142315, -0.091329, 0.000000, -0.961800, 0.000000, -0.273700, 0.095461, 0.522986,
-0.985599, 0.142315, -0.091329, 0.000000, -0.961800, 0.000000, -0.273700, 0.095461, 0.522986,
-0.886052, 0.142315, -0.441202, 0.000000, -0.961800, 0.000000, -0.273700, 0.136821, 0.668352,
-0.985599, -0.142315, -0.091329, 0.000000, -0.961800, 0.000000, -0.273700, 0.095461, 0.522986,
-0.886052, 0.142315, -0.441202, 0.000000, -0.961800, 0.000000, -0.273700, 0.136821, 0.668352,
-0.886052, -0.142315, -0.441202, 0.000000, -0.961800, 0.000000, -0.273700, 0.136821, 0.668352,
-0.752526, 0.654861, -0.069732, 0.000000, -0.636000, 0.750100, -0.181000, 0.192299, 0.514013,
-0.538334, 0.841254, -0.049884, 0.000000, -0.636000, 0.750100, -0.181000, 0.281292, 0.505766,
-0.483962, 0.841254, -0.240984, 0.000000, -0.636000, 0.750100, -0.181000, 0.303883, 0.585165,
-0.752526, 0.654861, -0.069732, 0.000000, -0.636000, 0.750100, -0.181000, 0.192299, 0.514013,
-0.483962, 0.841254, -0.240984, 0.000000, -0.636000, 0.750100, -0.181000, 0.303883, 0.585165,
-0.676519, 0.654861, -0.336867, 0.000000, -0.636000, 0.750100, -0.181000, 0.223879, 0.625003,
-0.280531, -0.959493, -0.025995, 0.000000, -0.405300, -0.906900, -0.115300, 0.388405, 0.495841,
-0.538334, -0.841254, -0.049884, 0.000000, -0.405300, -0.906900, -0.115300, 0.281292, 0.505766,
-0.483962, -0.841254, -0.240984, 0.000000, -0.405300, -0.906900, -0.115300, 0.303883, 0.585165,
-0.280531, -0.959493, -0.025995, 0.000000, -0.405300, -0.906900, -0.115300, 0.388405, 0.495841,
-0.483962, -0.841254, -0.240984, 0.000000, -0.405300, -0.906900, -0.115300, 0.303883, 0.585165,
-0.252197, -0.959493, -0.125579, 0.000000, -0.405300, -0.906900, -0.115300, 0.400178, 0.537216,
-0.905752, -0.415415, -0.083930, 0.000000, -0.924100, -0.277300, -0.262900, 0.128636, 0.519912,
-0.985599, -0.142315, -0.091329, 0.000000, -0.924100, -0.277300, -0.262900, 0.095461, 0.522986,
-0.886052, -0.142315, -0.441202, 0.000000, -0.924100, -0.277300, -0.262900, 0.136821, 0.668352,
-0.905752, -0.415415, -0.083930, 0.000000, -0.924100, -0.277300, -0.262900, 0.128636, 0.519912,
-0.886052, -0.142315, -0.441202, 0.000000, -0.924100, -0.277300, -0.262900, 0.136821, 0.668352,
-0.814269, -0.415415, -0.405458, 0.000000, -0.924100, -0.277300, -0.262900, 0.166646, 0.653502,
-0.905752, 0.415415, -0.083931, 0.000000, -0.813200, 0.534100, -0.231400, 0.128636, 0.519912,
-0.752526, 0.654861, -0.069732, 0.000000, -0.813200, 0.534100, -0.231400, 0.192299, 0.514013,
-0.676519, 0.654861, -0.336867, 0.000000, -0.813200, 0.534100, -0.231400, 0.223879, 0.625003,
-0.905752, 0.415415, -0.083931, 0.000000, -0.813200, 0.534100, -0.231400, 0.128636, 0.519912,
-0.676519, 0.654861, -0.336867, 0.000000, -0.813200, 0.534100, -0.231400, 0.223879, 0.625003,
-0.814269, 0.415415, -0.405458, 0.000000, -0.813200, 0.534100, -0.231400, 0.166646, 0.653502,
0.000000, -1.000000, -0.000000, 0.000000, -0.139200, -0.989500, -0.039600, 0.504961, 0.485040,
-0.280531, -0.959493, -0.025995, 0.000000, -0.139200, -0.989500, -0.039600, 0.388405, 0.495841,
-0.252197, -0.959493, -0.125579, 0.000000, -0.139200, -0.989500, -0.039600, 0.400178, 0.537216,
-0.280531, 0.959493, -0.025995, 0.000000, -0.139200, 0.989500, -0.039600, 0.388405, 0.495841,
-0.000000, 1.000000, -0.000000, 0.000000, -0.139200, 0.989500, -0.039600, 0.504961, 0.485040,
-0.252197, 0.959493, -0.125579, 0.000000, -0.139200, 0.989500, -0.039600, 0.400178, 0.537216,
-0.483962, 0.841254, -0.240984, 0.000000, -0.336200, 0.906900, -0.253900, 0.303883, 0.585165,
-0.252197, 0.959493, -0.125579, 0.000000, -0.336200, 0.906900, -0.253900, 0.400178, 0.537216,
-0.189802, 0.959493, -0.208203, 0.000000, -0.336200, 0.906900, -0.253900, 0.426102, 0.571545,
-0.483962, 0.841254, -0.240984, 0.000000, -0.336200, 0.906900, -0.253900, 0.303883, 0.585165,
-0.189802, 0.959493, -0.208203, 0.000000, -0.336200, 0.906900, -0.253900, 0.426102, 0.571545,
-0.364227, 0.841254, -0.399538, 0.000000, -0.336200, 0.906900, -0.253900, 0.353631, 0.651042,
-0.483962, -0.841254, -0.240984, 0.000000, -0.527700, -0.750100, -0.398500, 0.303883, 0.585165,
-0.676519, -0.654861, -0.336867, 0.000000, -0.527700, -0.750100, -0.398500, 0.223879, 0.625003,
-0.509145, -0.654861, -0.558506, 0.000000, -0.527700, -0.750100, -0.398500, 0.293420, 0.717090,
-0.483962, -0.841254, -0.240984, 0.000000, -0.527700, -0.750100, -0.398500, 0.303883, 0.585165,
-0.509145, -0.654861, -0.558506, 0.000000, -0.527700, -0.750100, -0.398500, 0.293420, 0.717090,
-0.364227, -0.841254, -0.399538, 0.000000, -0.527700, -0.750100, -0.398500, 0.353631, 0.651042,
-0.886052, -0.142315, -0.441202, 0.000000, -0.798000, 0.000000, -0.602600, 0.136821, 0.668352,
-0.886052, 0.142315, -0.441202, 0.000000, -0.798000, 0.000000, -0.602600, 0.136821, 0.668352,
-0.666838, 0.142315, -0.731487, 0.000000, -0.798000, 0.000000, -0.602600, 0.227901, 0.788961,
-0.886052, -0.142315, -0.441202, 0.000000, -0.798000, 0.000000, -0.602600, 0.136821, 0.668352,
-0.666838, 0.142315, -0.731487, 0.000000, -0.798000, 0.000000, -0.602600, 0.227901, 0.788961,
-0.666838, -0.142315, -0.731487, 0.000000, -0.798000, 0.000000, -0.602600, 0.227901, 0.788961,
-0.676519, 0.654861, -0.336867, 0.000000, -0.527700, 0.750100, -0.398500, 0.223879, 0.625003,
-0.483962, 0.841254, -0.240984, 0.000000, -0.527700, 0.750100, -0.398500, 0.303883, 0.585165,
-0.364227, 0.841254, -0.399538, 0.000000, -0.527700, 0.750100, -0.398500, 0.353631, 0.651042,
-0.676519, 0.654861, -0.336867, 0.000000, -0.527700, 0.750100, -0.398500, 0.223879, 0.625003,
-0.364227, 0.841254, -0.399538, 0.000000, -0.527700, 0.750100, -0.398500, 0.353631, 0.651042,
-0.509145, 0.654861, -0.558506, 0.000000, -0.527700, 0.750100, -0.398500, 0.293420, 0.717090,
-0.252197, -0.959493, -0.125579, 0.000000, -0.336200, -0.906900, -0.253900, 0.400178, 0.537216,
-0.483962, -0.841254, -0.240984, 0.000000, -0.336200, -0.906900, -0.253900, 0.303883, 0.585165,
-0.364227, -0.841254, -0.399538, 0.000000, -0.336200, -0.906900, -0.253900, 0.353631, 0.651042,
-0.252197, -0.959493, -0.125579, 0.000000, -0.336200, -0.906900, -0.253900, 0.400178, 0.537216,
-0.364227, -0.841254, -0.399538, 0.000000, -0.336200, -0.906900, -0.253900, 0.353631, 0.651042,
-0.189802, -0.959493, -0.208203, 0.000000, -0.336200, -0.906900, -0.253900, 0.426102, 0.571545,
-0.814269, -0.415415, -0.405458, 0.000000, -0.766700, -0.277300, -0.579000, 0.166646, 0.653502,
-0.886052, -0.142315, -0.441202, 0.000000, -0.766700, -0.277300, -0.579000, 0.136821, 0.668352,
-0.666838, -0.142315, -0.731487, 0.000000, -0.766700, -0.277300, -0.579000, 0.227901, 0.788961,
-0.814269, -0.415415, -0.405458, 0.000000, -0.766700, -0.277300, -0.579000, 0.166646, 0.653502,
-0.666838, -0.142315, -0.731487, 0.000000, -0.766700, -0.277300, -0.579000, 0.227901, 0.788961,
-0.612815, -0.415415, -0.672226, 0.000000, -0.766700, -0.277300, -0.579000, 0.250347, 0.764339,
-0.814269, 0.415415, -0.405458, 0.000000, -0.674700, 0.534100, -0.509500, 0.166646, 0.653502,
-0.676519, 0.654861, -0.336867, 0.000000, -0.674700, 0.534100, -0.509500, 0.223879, 0.625003,
-0.509145, 0.654861, -0.558506, 0.000000, -0.674700, 0.534100, -0.509500, 0.293420, 0.717090,
-0.814269, 0.415415, -0.405458, 0.000000, -0.674700, 0.534100, -0.509500, 0.166646, 0.653502,
-0.509145, 0.654861, -0.558506, 0.000000, -0.674700, 0.534100, -0.509500, 0.293420, 0.717090,
-0.612815, 0.415415, -0.672226, 0.000000, -0.674700, 0.534100, -0.509500, 0.250347, 0.764339,
0.000000, -1.000000, -0.000000, 0.000000, -0.115500, -0.989500, -0.087200, 0.504961, 0.485040,
-0.252197, -0.959493, -0.125579, 0.000000, -0.115500, -0.989500, -0.087200, 0.400178, 0.537216,
-0.189802, -0.959493, -0.208203, 0.000000, -0.115500, -0.989500, -0.087200, 0.426102, 0.571545,
-0.252197, 0.959493, -0.125579, 0.000000, -0.115500, 0.989500, -0.087200, 0.400178, 0.537216,
-0.000000, 1.000000, -0.000000, 0.000000, -0.115500, 0.989500, -0.087200, 0.504961, 0.485040,
-0.189802, 0.959493, -0.208203, 0.000000, -0.115500, 0.989500, -0.087200, 0.426102, 0.571545,
-0.676519, -0.654861, -0.336867, 0.000000, -0.674700, -0.534100, -0.509500, 0.223879, 0.625003,
-0.814269, -0.415415, -0.405458, 0.000000, -0.674700, -0.534100, -0.509500, 0.166646, 0.653502,
-0.612815, -0.415415, -0.672226, 0.000000, -0.674700, -0.534100, -0.509500, 0.250347, 0.764339,
-0.676519, -0.654861, -0.336867, 0.000000, -0.674700, -0.534100, -0.509500, 0.223879, 0.625003,
-0.612815, -0.415415, -0.672226, 0.000000, -0.674700, -0.534100, -0.509500, 0.250347, 0.764339,
-0.509145, -0.654861, -0.558506, 0.000000, -0.674700, -0.534100, -0.509500, 0.293420, 0.717090,
-0.886052, 0.142315, -0.441202, 0.000000, -0.766700, 0.277300, -0.579000, 0.136821, 0.668352,
-0.814269, 0.415415, -0.405458, 0.000000, -0.766700, 0.277300, -0.579000, 0.166646, 0.653502,
-0.612815, 0.415415, -0.672226, 0.000000, -0.766700, 0.277300, -0.579000, 0.250347, 0.764339,
-0.886052, 0.142315, -0.441202, 0.000000, -0.766700, 0.277300, -0.579000, 0.136821, 0.668352,
-0.612815, 0.415415, -0.672226, 0.000000, -0.766700, 0.277300, -0.579000, 0.250347, 0.764339,
-0.666838, 0.142315, -0.731487, 0.000000, -0.766700, 0.277300, -0.579000, 0.227901, 0.788961,
-0.509145, 0.654861, -0.558506, 0.000000, -0.348100, 0.750100, -0.562200, 0.293420, 0.717090,
-0.364227, 0.841254, -0.399538, 0.000000, -0.348100, 0.750100, -0.562200, 0.353631, 0.651042,
-0.195302, 0.841254, -0.504133, 0.000000, -0.348100, 0.750100, -0.562200, 0.423816, 0.694499,
-0.509145, 0.654861, -0.558506, 0.000000, -0.348100, 0.750100, -0.562200, 0.293420, 0.717090,
-0.195302, 0.841254, -0.504133, 0.000000, -0.348100, 0.750100, -0.562200, 0.423816, 0.694499,
-0.273008, 0.654861, -0.704716, 0.000000, -0.348100, 0.750100, -0.562200, 0.391531, 0.777838,
-0.189802, -0.959493, -0.208203, 0.000000, -0.221800, -0.906900, -0.358200, 0.426102, 0.571545,
-0.364227, -0.841254, -0.399538, 0.000000, -0.221800, -0.906900, -0.358200, 0.353631, 0.651042,
-0.195302, -0.841254, -0.504133, 0.000000, -0.221800, -0.906900, -0.358200, 0.423816, 0.694499,
-0.189802, -0.959493, -0.208203, 0.000000, -0.221800, -0.906900, -0.358200, 0.426102, 0.571545,
-0.195302, -0.841254, -0.504133, 0.000000, -0.221800, -0.906900, -0.358200, 0.423816, 0.694499,
-0.101773, -0.959493, -0.262708, 0.000000, -0.221800, -0.906900, -0.358200, 0.462676, 0.594191,
-0.612815, -0.415415, -0.672226, 0.000000, -0.505800, -0.277300, -0.816900, 0.250347, 0.764339,
-0.666838, -0.142315, -0.731487, 0.000000, -0.505800, -0.277300, -0.816900, 0.227901, 0.788961,
-0.357565, -0.142315, -0.922981, 0.000000, -0.505800, -0.277300, -0.816900, 0.356399, 0.868524,
-0.612815, -0.415415, -0.672226, 0.000000, -0.505800, -0.277300, -0.816900, 0.250347, 0.764339,
-0.357565, -0.142315, -0.922981, 0.000000, -0.505800, -0.277300, -0.816900, 0.356399, 0.868524,
-0.328597, -0.415415, -0.848207, 0.000000, -0.505800, -0.277300, -0.816900, 0.368435, 0.837456,
-0.612815, 0.415415, -0.672226, 0.000000, -0.445100, 0.534100, -0.718800, 0.250347, 0.764339,
-0.509145, 0.654861, -0.558506, 0.000000, -0.445100, 0.534100, -0.718800, 0.293420, 0.717090,
-0.273008, 0.654861, -0.704716, 0.000000, -0.445100, 0.534100, -0.718800, 0.391531, 0.777838,
-0.612815, 0.415415, -0.672226, 0.000000, -0.445100, 0.534100, -0.718800, 0.250347, 0.764339,
-0.273008, 0.654861, -0.704716, 0.000000, -0.445100, 0.534100, -0.718800, 0.391531, 0.777838,
-0.328597, 0.415415, -0.848207, 0.000000, -0.445100, 0.534100, -0.718800, 0.368435, 0.837456,
0.000000, -1.000000, -0.000000, 0.000000, -0.076200, -0.989500, -0.123100, 0.504961, 0.485040,
-0.189802, -0.959493, -0.208203, 0.000000, -0.076200, -0.989500, -0.123100, 0.426102, 0.571545,
-0.101773, -0.959493, -0.262708, 0.000000, -0.076200, -0.989500, -0.123100, 0.462676, 0.594191,
-0.189802, 0.959493, -0.208203, 0.000000, -0.076200, 0.989500, -0.123100, 0.426102, 0.571545,
-0.000000, 1.000000, -0.000000, 0.000000, -0.076200, 0.989500, -0.123100, 0.504961, 0.485040,
-0.101773, 0.959493, -0.262708, 0.000000, -0.076200, 0.989500, -0.123100, 0.462676, 0.594191,
-0.509145, -0.654861, -0.558506, 0.000000, -0.445100, -0.534100, -0.718800, 0.293420, 0.717090,
-0.612815, -0.415415, -0.672226, 0.000000, -0.445100, -0.534100, -0.718800, 0.250347, 0.764339,
-0.328597, -0.415415, -0.848207, 0.000000, -0.445100, -0.534100, -0.718800, 0.368435, 0.837456,
-0.509145, -0.654861, -0.558506, 0.000000, -0.445100, -0.534100, -0.718800, 0.293420, 0.717090,
-0.328597, -0.415415, -0.848207, 0.000000, -0.445100, -0.534100, -0.718800, 0.368435, 0.837456,
-0.273008, -0.654861, -0.704715, 0.000000, -0.445100, -0.534100, -0.718800, 0.391531, 0.777838,
-0.666838, 0.142315, -0.731487, 0.000000, -0.505800, 0.277300, -0.816900, 0.227901, 0.788961,
-0.612815, 0.415415, -0.672226, 0.000000, -0.505800, 0.277300, -0.816900, 0.250347, 0.764339,
-0.328597, 0.415415, -0.848207, 0.000000, -0.505800, 0.277300, -0.816900, 0.368435, 0.837456,
-0.666838, 0.142315, -0.731487, 0.000000, -0.505800, 0.277300, -0.816900, 0.227901, 0.788961,
-0.328597, 0.415415, -0.848207, 0.000000, -0.505800, 0.277300, -0.816900, 0.368435, 0.837456,
-0.357565, 0.142315, -0.922981, 0.000000, -0.505800, 0.277300, -0.816900, 0.356399, 0.868524,
-0.364227, 0.841254, -0.399538, 0.000000, -0.221800, 0.906900, -0.358200, 0.353631, 0.651042,
-0.189802, 0.959493, -0.208203, 0.000000, -0.221800, 0.906900, -0.358200, 0.426102, 0.571545,
-0.101773, 0.959493, -0.262708, 0.000000, -0.221800, 0.906900, -0.358200, 0.462676, 0.594191,
-0.364227, 0.841254, -0.399538, 0.000000, -0.221800, 0.906900, -0.358200, 0.353631, 0.651042,
-0.101773, 0.959493, -0.262708, 0.000000, -0.221800, 0.906900, -0.358200, 0.462676, 0.594191,
-0.195302, 0.841254, -0.504133, 0.000000, -0.221800, 0.906900, -0.358200, 0.423816, 0.694499,
-0.364227, -0.841254, -0.399538, 0.000000, -0.348100, -0.750100, -0.562200, 0.353631, 0.651042,
-0.509145, -0.654861, -0.558506, 0.000000, -0.348100, -0.750100, -0.562200, 0.293420, 0.717090,
-0.273008, -0.654861, -0.704715, 0.000000, -0.348100, -0.750100, -0.562200, 0.391531, 0.777838,
-0.364227, -0.841254, -0.399538, 0.000000, -0.348100, -0.750100, -0.562200, 0.353631, 0.651042,
-0.273008, -0.654861, -0.704715, 0.000000, -0.348100, -0.750100, -0.562200, 0.391531, 0.777838,
-0.195302, -0.841254, -0.504133, 0.000000, -0.348100, -0.750100, -0.562200, 0.423816, 0.694499,
-0.666838, -0.142315, -0.731487, 0.000000, -0.526400, 0.000000, -0.850200, 0.227901, 0.788961,
-0.666838, 0.142315, -0.731487, 0.000000, -0.526400, 0.000000, -0.850200, 0.227901, 0.788961,
-0.357565, 0.142315, -0.922981, 0.000000, -0.526400, 0.000000, -0.850200, 0.356399, 0.868524,
-0.666838, -0.142315, -0.731487, 0.000000, -0.526400, 0.000000, -0.850200, 0.227901, 0.788961,
-0.357565, 0.142315, -0.922981, 0.000000, -0.526400, 0.000000, -0.850200, 0.356399, 0.868524,
-0.357565, -0.142315, -0.922981, 0.000000, -0.526400, 0.000000, -0.850200, 0.356399, 0.868524,
-0.328597, -0.415415, -0.848207, 0.000000, -0.176500, -0.277300, -0.944400, 0.368435, 0.837456,
-0.357565, -0.142315, -0.922981, 0.000000, -0.176500, -0.277300, -0.944400, 0.356399, 0.868524,
0.000000, -0.142315, -0.989821, 0.000000, -0.176500, -0.277300, -0.944400, 0.504961, 0.896295,
-0.328597, -0.415415, -0.848207, 0.000000, -0.176500, -0.277300, -0.944400, 0.368435, 0.837456,
0.000000, -0.142315, -0.989821, 0.000000, -0.176500, -0.277300, -0.944400, 0.504961, 0.896295,
0.000000, -0.415415, -0.909632, 0.000000, -0.176500, -0.277300, -0.944400, 0.504961, 0.862977,
-0.328597, 0.415415, -0.848207, 0.000000, -0.155300, 0.534100, -0.831000, 0.368435, 0.837456,
-0.273008, 0.654861, -0.704716, 0.000000, -0.155300, 0.534100, -0.831000, 0.391531, 0.777838,
0.000000, 0.654861, -0.755750, 0.000000, -0.155300, 0.534100, -0.831000, 0.504961, 0.799042,
-0.328597, 0.415415, -0.848207, 0.000000, -0.155300, 0.534100, -0.831000, 0.368435, 0.837456,
0.000000, 0.654861, -0.755750, 0.000000, -0.155300, 0.534100, -0.831000, 0.504961, 0.799042,
0.000000, 0.415415, -0.909632, 0.000000, -0.155300, 0.534100, -0.831000, 0.504961, 0.862977,
0.000000, -1.000000, -0.000000, 0.000000, -0.026600, -0.989500, -0.142300, 0.504961, 0.485040,
-0.101773, -0.959493, -0.262708, 0.000000, -0.026600, -0.989500, -0.142300, 0.462676, 0.594191,
0.000000, -0.959493, -0.281733, 0.000000, -0.026600, -0.989500, -0.142300, 0.504961, 0.602096,
-0.101773, 0.959493, -0.262708, 0.000000, -0.026600, 0.989500, -0.142300, 0.462676, 0.594191,
-0.000000, 1.000000, -0.000000, 0.000000, -0.026600, 0.989500, -0.142300, 0.504961, 0.485040,
0.000000, 0.959493, -0.281733, 0.000000, -0.026600, 0.989500, -0.142300, 0.504961, 0.602095,
-0.273008, -0.654861, -0.704715, 0.000000, -0.155300, -0.534100, -0.831000, 0.391531, 0.777838,
-0.328597, -0.415415, -0.848207, 0.000000, -0.155300, -0.534100, -0.831000, 0.368435, 0.837456,
0.000000, -0.415415, -0.909632, 0.000000, -0.155300, -0.534100, -0.831000, 0.504961, 0.862977,
-0.273008, -0.654861, -0.704715, 0.000000, -0.155300, -0.534100, -0.831000, 0.391531, 0.777838,
0.000000, -0.415415, -0.909632, 0.000000, -0.155300, -0.534100, -0.831000, 0.504961, 0.862977,
-0.000000, -0.654861, -0.755750, 0.000000, -0.155300, -0.534100, -0.831000, 0.504961, 0.799042,
-0.357565, 0.142315, -0.922981, 0.000000, -0.176500, 0.277300, -0.944400, 0.356399, 0.868524,
-0.328597, 0.415415, -0.848207, 0.000000, -0.176500, 0.277300, -0.944400, 0.368435, 0.837456,
0.000000, 0.415415, -0.909632, 0.000000, -0.176500, 0.277300, -0.944400, 0.504961, 0.862977,
-0.357565, 0.142315, -0.922981, 0.000000, -0.176500, 0.277300, -0.944400, 0.356399, 0.868524,
0.000000, 0.415415, -0.909632, 0.000000, -0.176500, 0.277300, -0.944400, 0.504961, 0.862977,
0.000000, 0.142315, -0.989821, 0.000000, -0.176500, 0.277300, -0.944400, 0.504961, 0.896295,
-0.195302, 0.841254, -0.504133, 0.000000, -0.077400, 0.906900, -0.414200, 0.423816, 0.694499,
-0.101773, 0.959493, -0.262708, 0.000000, -0.077400, 0.906900, -0.414200, 0.462676, 0.594191,
0.000000, 0.959493, -0.281733, 0.000000, -0.077400, 0.906900, -0.414200, 0.504961, 0.602095,
-0.195302, 0.841254, -0.504133, 0.000000, -0.077400, 0.906900, -0.414200, 0.423816, 0.694499,
0.000000, 0.959493, -0.281733, 0.000000, -0.077400, 0.906900, -0.414200, 0.504961, 0.602095,
0.000000, 0.841254, -0.540641, 0.000000, -0.077400, 0.906900, -0.414200, 0.504961, 0.709668,
-0.195302, -0.841254, -0.504133, 0.000000, -0.121500, -0.750100, -0.650000, 0.423816, 0.694499,
-0.273008, -0.654861, -0.704715, 0.000000, -0.121500, -0.750100, -0.650000, 0.391531, 0.777838,
-0.000000, -0.654861, -0.755750, 0.000000, -0.121500, -0.750100, -0.650000, 0.504961, 0.799042,
-0.195302, -0.841254, -0.504133, 0.000000, -0.121500, -0.750100, -0.650000, 0.423816, 0.694499,
-0.000000, -0.654861, -0.755750, 0.000000, -0.121500, -0.750100, -0.650000, 0.504961, 0.799042,
0.000000, -0.841254, -0.540641, 0.000000, -0.121500, -0.750100, -0.650000, 0.504961, 0.709668,
-0.357565, -0.142315, -0.922981, 0.000000, -0.183700, 0.000000, -0.983000, 0.356399, 0.868524,
-0.357565, 0.142315, -0.922981, 0.000000, -0.183700, 0.000000, -0.983000, 0.356399, 0.868524,
0.000000, 0.142315, -0.989821, 0.000000, -0.183700, 0.000000, -0.983000, 0.504961, 0.896295,
-0.357565, -0.142315, -0.922981, 0.000000, -0.183700, 0.000000, -0.983000, 0.356399, 0.868524,
0.000000, 0.142315, -0.989821, 0.000000, -0.183700, 0.000000, -0.983000, 0.504961, 0.896295,
0.000000, -0.142315, -0.989821, 0.000000, -0.183700, 0.000000, -0.983000, 0.504961, 0.896295,
-0.273008, 0.654861, -0.704716, 0.000000, -0.121500, 0.750100, -0.650000, 0.391531, 0.777838,
-0.195302, 0.841254, -0.504133, 0.000000, -0.121500, 0.750100, -0.650000, 0.423816, 0.694499,
0.000000, 0.841254, -0.540641, 0.000000, -0.121500, 0.750100, -0.650000, 0.504961, 0.709668,
-0.273008, 0.654861, -0.704716, 0.000000, -0.121500, 0.750100, -0.650000, 0.391531, 0.777838,
0.000000, 0.841254, -0.540641, 0.000000, -0.121500, 0.750100, -0.650000, 0.504961, 0.709668,
0.000000, 0.654861, -0.755750, 0.000000, -0.121500, 0.750100, -0.650000, 0.504961, 0.799042,
-0.101773, -0.959493, -0.262708, 0.000000, -0.077400, -0.906900, -0.414200, 0.462676, 0.594191,
-0.195302, -0.841254, -0.504133, 0.000000, -0.077400, -0.906900, -0.414200, 0.423816, 0.694499,
0.000000, -0.841254, -0.540641, 0.000000, -0.077400, -0.906900, -0.414200, 0.504961, 0.709668,
-0.101773, -0.959493, -0.262708, 0.000000, -0.077400, -0.906900, -0.414200, 0.462676, 0.594191,
0.000000, -0.841254, -0.540641, 0.000000, -0.077400, -0.906900, -0.414200, 0.504961, 0.709668,
0.000000, -0.959493, -0.281733, 0.000000, -0.077400, -0.906900, -0.414200, 0.504961, 0.602096,
};

static const int textured_sphere_indices[] = {
0,1,2,
3,4,5,
6,7,8,
9,10,11,
12,13,14,
15,16,17,
18,19,20,
21,22,23,
24,25,26,
27,28,29,
30,31,32,
33,34,35,
36,37,38,
39,40,41,
42,43,44,
45,46,47,
48,49,50,
51,52,53,
54,55,56,
57,58,59,
60,61,62,
63,64,65,
66,67,68,
69,70,71,
72,73,74,
75,76,77,
78,79,80,
81,82,83,
84,85,86,
87,88,89,
90,91,92,
93,94,95,
96,97,98,
99,100,101,
102,103,104,
105,106,107,
108,109,110,
111,112,113,
114,115,116,
117,118,119,
120,121,122,
123,124,125,
126,127,128,
129,130,131,
132,133,134,
135,136,137,
138,139,140,
141,142,143,
144,145,146,
147,148,149,
150,151,152,
153,154,155,
156,157,158,
159,160,161,
162,163,164,
165,166,167,
168,169,170,
171,172,173,
174,175,176,
177,178,179,
180,181,182,
183,184,185,
186,187,188,
189,190,191,
192,193,194,
195,196,197,
198,199,200,
201,202,203,
204,205,206,
207,208,209,
210,211,212,
213,214,215,
216,217,218,
219,220,221,
222,223,224,
225,226,227,
228,229,230,
231,232,233,
234,235,236,
237,238,239,
240,241,242,
243,244,245,
246,247,248,
249,250,251,
252,253,254,
255,256,257,
258,259,260,
261,262,263,
264,265,266,
267,268,269,
270,271,272,
273,274,275,
276,277,278,
279,280,281,
282,283,284,
285,286,287,
288,289,290,
291,292,293,
294,295,296,
297,298,299,
300,301,302,
303,304,305,
306,307,308,
309,310,311,
312,313,314,
315,316,317,
318,319,320,
321,322,323,
324,325,326,
327,328,329,
330,331,332,
333,334,335,
336,337,338,
339,340,341,
342,343,344,
345,346,347,
348,349,350,
351,352,353,
354,355,356,
357,358,359,
360,361,362,
363,364,365,
366,367,368,
369,370,371,
372,373,374,
375,376,377,
378,379,380,
381,382,383,
384,385,386,
387,388,389,
390,391,392,
393,394,395,
396,397,398,
399,400,401,
402,403,404,
405,406,407,
408,409,410,
411,412,413,
414,415,416,
417,418,419,
420,421,422,
423,424,425,
426,427,428,
429,430,431,
432,433,434,
435,436,437,
438,439,440,
441,442,443,
444,445,446,
447,448,449,
450,451,452,
453,454,455,
456,457,458,
459,460,461,
462,463,464,
465,466,467,
468,469,470,
471,472,473,
474,475,476,
477,478,479,
480,481,482,
483,484,485,
486,487,488,
489,490,491,
492,493,494,
495,496,497,
498,499,500,
501,502,503,
504,505,506,
507,508,509,
510,511,512,
513,514,515,
516,517,518,
519,520,521,
522,523,524,
525,526,527,
528,529,530,
531,532,533,
534,535,536,
537,538,539,
540,541,542,
543,544,545,
546,547,548,
549,550,551,
552,553,554,
555,556,557,
558,559,560,
561,562,563,
564,565,566,
567,568,569,
570,571,572,
573,574,575,
576,577,578,
579,580,581,
582,583,584,
585,586,587,
588,589,590,
591,592,593,
594,595,596,
597,598,599,
600,601,602,
603,604,605,
606,607,608,
609,610,611,
612,613,614,
615,616,617,
618,619,620,
621,622,623,
624,625,626,
627,628,629,
630,631,632,
633,634,635,
636,637,638,
639,640,641,
642,643,644,
645,646,647,
648,649,650,
651,652,653,
654,655,656,
657,658,659,
660,661,662,
663,664,665,
666,667,668,
669,670,671,
672,673,674,
675,676,677,
678,679,680,
681,682,683,
684,685,686,
687,688,689,
690,691,692,
693,694,695,
696,697,698,
699,700,701,
702,703,704,
705,706,707,
708,709,710,
711,712,713,
714,715,716,
717,718,719,
720,721,722,
723,724,725,
726,727,728,
729,730,731,
732,733,734,
735,736,737,
738,739,740,
741,742,743,
744,745,746,
747,748,749,
750,751,752,
753,754,755,
756,757,758,
759,760,761,
762,763,764,
765,766,767,
768,769,770,
771,772,773,
774,775,776,
777,778,779,
780,781,782,
783,784,785,
786,787,788,
789,790,791,
792,793,794,
795,796,797,
798,799,800,
801,802,803,
804,805,806,
807,808,809,
810,811,812,
813,814,815,
816,817,818,
819,820,821,
822,823,824,
825,826,827,
828,829,830,
831,832,833,
834,835,836,
837,838,839,
840,841,842,
843,844,845,
846,847,848,
849,850,851,
852,853,854,
855,856,857,
858,859,860,
861,862,863,
864,865,866,
867,868,869,
870,871,872,
873,874,875,
876,877,878,
879,880,881,
882,883,884,
885,886,887,
888,889,890,
891,892,893,
894,895,896,
897,898,899,
900,901,902,
903,904,905,
906,907,908,
909,910,911,
912,913,914,
915,916,917,
918,919,920,
921,922,923,
924,925,926,
927,928,929,
930,931,932,
933,934,935,
936,937,938,
939,940,941,
942,943,944,
945,946,947,
948,949,950,
951,952,953,
954,955,956,
957,958,959,
960,961,962,
963,964,965,
966,967,968,
969,970,971,
972,973,974,
975,976,977,
978,979,980,
981,982,983,
984,985,986,
987,988,989,
990,991,992,
993,994,995,
996,997,998,
999,1000,1001,
1002,1003,1004,
1005,1006,1007,
1008,1009,1010,
1011,1012,1013,
1014,1015,1016,
1017,1018,1019,
};

#endif  // TINY_SHAPE_DATA_H
