"""init

Revision ID: 6b0dd11d4b71
Revises: 
Create Date: 2023-02-14 13:03:25.553543

"""  # noqa: W291
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "6b0dd11d4b71"
down_revision = None
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    from hitfactorpy_sqlalchemy.orm.models import (
        SAEnumMatchLevel,
        SAEnumClassification,
        SAEnumDivision,
        SAEnumPowerFactor,
        SAEnumScoring,
    )

    op.create_table(
        "match_report",
        sa.Column(
            "internal_id",
            sa.Integer(),
            autoincrement=True,
            nullable=False,
            comment="Internal ID to be used as PK and FKs. Do not expose in public APIs",
        ),
        sa.Column(
            "id",
            postgresql.UUID(as_uuid=True),
            server_default=sa.text("gen_random_uuid()"),
            nullable=False,
            comment="ID exposed in public APIs",
        ),
        sa.Column("name", sa.Unicode(length=255), nullable=False),
        sa.Column("date", sa.Date(), nullable=True),
        sa.Column("match_level", SAEnumMatchLevel, nullable=True),
        sa.Column(
            "report_hash",
            postgresql.UUID(as_uuid=True),
            nullable=True,
            comment="This represents an md5 hexdigest, stored as a UUID. Used to identify potential duplicate report imports.",
        ),
        sa.PrimaryKeyConstraint("internal_id"),
        sa.UniqueConstraint("report_hash"),
    )
    op.create_index(op.f("ix_match_report_id"), "match_report", ["id"], unique=True)
    op.create_table(
        "match_report_competitor",
        sa.Column(
            "internal_id",
            sa.Integer(),
            autoincrement=True,
            nullable=False,
            comment="Internal ID to be used as PK and FKs. Do not expose in public APIs",
        ),
        sa.Column(
            "id",
            postgresql.UUID(as_uuid=True),
            server_default=sa.text("gen_random_uuid()"),
            nullable=False,
            comment="ID exposed in public APIs",
        ),
        sa.Column("match_internal_id", sa.Integer(), nullable=False),
        sa.Column("member_number", sa.Unicode(length=64), nullable=True),
        sa.Column("first_name", sa.Unicode(length=64), nullable=True),
        sa.Column("last_name", sa.Unicode(length=64), nullable=True),
        sa.Column("division", SAEnumDivision, nullable=True),
        sa.Column("classification", SAEnumClassification, nullable=True),
        sa.Column("power_factor", SAEnumPowerFactor, nullable=True),
        sa.Column("dq", sa.Boolean(), nullable=False),
        sa.Column("reentry", sa.Boolean(), nullable=False),
        sa.ForeignKeyConstraint(["match_internal_id"], ["match_report.internal_id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("internal_id"),
    )
    op.create_index(op.f("ix_match_report_competitor_id"), "match_report_competitor", ["id"], unique=True)
    op.create_table(
        "match_report_stage",
        sa.Column(
            "internal_id",
            sa.Integer(),
            autoincrement=True,
            nullable=False,
            comment="Internal ID to be used as PK and FKs. Do not expose in public APIs",
        ),
        sa.Column(
            "id",
            postgresql.UUID(as_uuid=True),
            server_default=sa.text("gen_random_uuid()"),
            nullable=False,
            comment="ID exposed in public APIs",
        ),
        sa.Column("match_internal_id", sa.Integer(), nullable=False),
        sa.Column("name", sa.Unicode(length=255), nullable=True),
        sa.Column("min_rounds", sa.Integer(), nullable=False),
        sa.Column("max_points", sa.Integer(), nullable=False),
        sa.Column("classifier", sa.Boolean(), nullable=False),
        sa.Column("classifier_number", sa.Unicode(length=64), nullable=True),
        sa.Column("stage_number", sa.Integer(), nullable=True),
        sa.Column("scoring_type", SAEnumScoring, nullable=False),
        sa.ForeignKeyConstraint(["match_internal_id"], ["match_report.internal_id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("internal_id"),
        sa.UniqueConstraint("match_internal_id", "stage_number", name="stage_score_stage_number_unique_per_match"),
    )
    op.create_index(op.f("ix_match_report_stage_id"), "match_report_stage", ["id"], unique=True)
    op.create_table(
        "match_report_stage_score",
        sa.Column(
            "internal_id",
            sa.Integer(),
            autoincrement=True,
            nullable=False,
            comment="Internal ID to be used as PK and FKs. Do not expose in public APIs",
        ),
        sa.Column(
            "id",
            postgresql.UUID(as_uuid=True),
            server_default=sa.text("gen_random_uuid()"),
            nullable=False,
            comment="ID exposed in public APIs",
        ),
        sa.Column("match_internal_id", sa.Integer(), nullable=False),
        sa.Column("competitor_internal_id", sa.Integer(), nullable=False),
        sa.Column("stage_internal_id", sa.Integer(), nullable=False),
        sa.Column("dq", sa.Boolean(), nullable=False),
        sa.Column("dnf", sa.Boolean(), nullable=False),
        sa.Column("a", sa.Integer(), nullable=False),
        sa.Column("b", sa.Integer(), nullable=False),
        sa.Column("c", sa.Integer(), nullable=False),
        sa.Column("d", sa.Integer(), nullable=False),
        sa.Column("m", sa.Integer(), nullable=False),
        sa.Column("npm", sa.Integer(), nullable=False),
        sa.Column("ns", sa.Integer(), nullable=False),
        sa.Column("procedural", sa.Integer(), nullable=False),
        sa.Column("late_shot", sa.Integer(), nullable=False),
        sa.Column("extra_shot", sa.Integer(), nullable=False),
        sa.Column("extra_hit", sa.Integer(), nullable=False),
        sa.Column("other_penalty", sa.Integer(), nullable=False),
        sa.Column("t1", sa.Numeric(precision=8, scale=2, decimal_return_scale=2), nullable=False),
        sa.Column("t2", sa.Numeric(precision=8, scale=2, decimal_return_scale=2), nullable=False),
        sa.Column("t3", sa.Numeric(precision=8, scale=2, decimal_return_scale=2), nullable=False),
        sa.Column("t4", sa.Numeric(precision=8, scale=2, decimal_return_scale=2), nullable=False),
        sa.Column("t5", sa.Numeric(precision=8, scale=2, decimal_return_scale=2), nullable=False),
        sa.Column("time", sa.Numeric(precision=8, scale=2, decimal_return_scale=2), nullable=False),
        sa.Column("raw_points", sa.Numeric(precision=8, scale=2, decimal_return_scale=2), nullable=True),
        sa.Column("penalty_points", sa.Numeric(precision=8, scale=2, decimal_return_scale=2), nullable=True),
        sa.Column("total_points", sa.Numeric(precision=8, scale=2, decimal_return_scale=2), nullable=True),
        sa.Column("hit_factor", sa.Numeric(precision=8, scale=4, decimal_return_scale=4), nullable=True),
        sa.Column("stage_points", sa.Numeric(precision=8, scale=4, decimal_return_scale=4), nullable=True),
        sa.Column("stage_place", sa.Integer(), nullable=True),
        sa.Column("stage_power_factor", SAEnumPowerFactor, nullable=True),
        sa.ForeignKeyConstraint(
            ["competitor_internal_id"], ["match_report_competitor.internal_id"], ondelete="CASCADE"
        ),
        sa.ForeignKeyConstraint(["match_internal_id"], ["match_report.internal_id"], ondelete="CASCADE"),
        sa.ForeignKeyConstraint(["stage_internal_id"], ["match_report_stage.internal_id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("internal_id"),
    )
    op.create_index(op.f("ix_match_report_stage_score_id"), "match_report_stage_score", ["id"], unique=True)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    from hitfactorpy_sqlalchemy.orm.models import (
        SAEnumMatchLevel,
        SAEnumClassification,
        SAEnumDivision,
        SAEnumPowerFactor,
        SAEnumScoring,
    )

    op.drop_index(op.f("ix_match_report_stage_score_id"), table_name="match_report_stage_score")
    op.drop_table("match_report_stage_score")
    op.drop_index(op.f("ix_match_report_stage_id"), table_name="match_report_stage")
    op.drop_table("match_report_stage")
    op.drop_index(op.f("ix_match_report_competitor_id"), table_name="match_report_competitor")
    op.drop_table("match_report_competitor")
    op.drop_index(op.f("ix_match_report_id"), table_name="match_report")
    op.drop_table("match_report")

    SAEnumMatchLevel.drop(op.get_bind())
    SAEnumClassification.drop(op.get_bind())
    SAEnumDivision.drop(op.get_bind())
    SAEnumPowerFactor.drop(op.get_bind())
    SAEnumScoring.drop(op.get_bind())
    # ### end Alembic commands ###
