# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pypath',
 'pypath.biocypher',
 'pypath.core',
 'pypath.data',
 'pypath.formats',
 'pypath.inputs',
 'pypath.internals',
 'pypath.legacy',
 'pypath.obsolete',
 'pypath.obsolete.old_manuscript',
 'pypath.omnipath',
 'pypath.omnipath.databases',
 'pypath.omnipath.server',
 'pypath.reader',
 'pypath.resources',
 'pypath.resources.data',
 'pypath.share',
 'pypath.share.lookup',
 'pypath.utils',
 'pypath.visual',
 'pypath.visual.igraph_drawing']

package_data = \
{'': ['*'], 'pypath.data': ['licenses/*', 'www/*']}

install_requires = \
['PyYAML',
 'beautifulsoup4',
 'dill',
 'future',
 'glom',
 'lxml',
 'matplotlib',
 'numpy',
 'openpyxl',
 'pandas',
 'pycurl',
 'pyreadr',
 'rdata',
 'requests',
 'scipy',
 'tabulate',
 'timeloop',
 'toml',
 'tqdm',
 'xlrd']

extras_require = \
{'bel': ['pybel', 'bio2bel', 'click'], 'graph': ['python-igraph']}

entry_points = \
{'bio2bel': ['omnipath = pypath.omnipath.bel'],
 'console_scripts': ['bio2bel_omnipath = pypath.omnipath.bel:main']}

setup_kwargs = {
    'name': 'pypath-omnipath',
    'version': '0.14.16',
    'description': 'Molecular signaling prior knowledge processing',
    'long_description': '============================================================================\n*pypath:* A Python module for molecular signaling prior knowledge processing\n============================================================================\n\nOmniPath\n========\n\nAre you interested in OmniPath data? Check out our R package OmnipathR_,\nthe most popular and most versatile access point to OmniPath, a database\nbuilt from more than 110 original resources. If you use Python and don\'t\nneed to build the database yourself, try our `Python client`_.\n\n.. _OmnipathR: https://github.com/saezlab/OmnipathR\n.. _`Python client`: https://github.com/saezlab/omnipath\n\n    **Important:** New module structure and new network API (January 2020)\n\n    Around the end of December we added a new network API to ``pypath`` which\n    is not based on ``igraph`` any more and provides a modular and versatile\n    access interface to the network data (since version ``0.9``). In January\n    we reorganized the submodules in ``pypath`` in order to create a clear\n    structure (since version ``0.10``). These are important milestones\n    towards version ``1.0`` and we hope they will make ``pypath`` more\n    convenient to use for everyone. By 18 February we merged these changes\n    to the master branch however the *pypath guide* is still to be updated.\n    Apologies for this inconvenience and please don\'t hesitate to ask\n    questions by opening an issue on github. The old ``igraph`` based network\n    class is still available in the ``pypath.legacy`` module.\n\n:Py2/3: Although we still keep the compatibility with Python 2, we don\'t\n        test ``pypath`` in this environment and already very few people use\n        Python 2. We highly recommend to use ``pypath`` in Python 3.6+.\n\n:documentation: https://saezlab.github.io/pypath\n:issues: https://github.com/saezlab/pypath/issues\n:contact: omnipathdb@gmail.com\n:developers: ``pypath`` is developed in the Saez Lab (https://saezlab.org) by\n  Ahmet Rifaioglu, Sebastian Lobentanzer and Dénes Türei. Olga Ivanova and\n  Nicolàs Palacio also contributed in the past. The R package and the\n  Cytoscape app are developed and maintained by Francesco Ceccarelli, Attila\n  Gábor, Alberto Valdeolivas, Dénes Türei and Nicolàs Palacio. The `Python\n  client`_ for the OmniPath web service has been developed and is maintained\n  by Michael Klein in the group of Fabian Theis.\n\n.. _`Python client`: https://github.com/saezlab/omnipath\n\n**pypath** is a Python module for processing molecular biology data resources,\ncombining them into databases and providing a versatile interface in Python\nas well as exporting the data for access through other platforms such as\nthe R (the OmnipathR R/Bioconductor package;\nhttps://github.com/saezlab/OmnipathR), web service (at\nhttps://omnipathdb.org), Cytoscape (the OmniPath Cytoscape app;\nhttps://apps.cytoscape.org/apps/omnipath) and BEL\n(Biological Expression Language).\n\n**pypath** provides access to more than 100 resources! It builds 5 major\ncombined databases and within these we can distinguish different datasets.\nThe 5 major databases are interactions (molecular interaction network or\npathways), enzyme-substrate relationships, protein complexes, molecular\nannotations (functional roles, localizations, and more) and inter-cellular\ncommunication roles.\n\n**pypath** consists of a number of submodules and each of them again contains\na number of submodules. Overall **pypath** consists of around 100 modules.\nThe most important higher level submodules:\n\n* *pypath.core:* contains the database classes e.g. network, complex,\n  annotations, etc\n* *pypath.inputs:* contains the resource specific methods which directly\n  downlad and preprocess data from the original sources\n* *pypath.omnipath:* higher level applications, e.g. a database manager, a\n  web server\n* *pypath.utils:* stand alone useful utilities, e.g. identifier translator,\n  Gene Ontology processor, BioPax processor, etc\n\n\nWebservice\n==========\n\n**New webservice** from 14 June 2018: the queries slightly changed, have been\nlargely extended. See the examples below.\n\nThe webservice implements a very simple REST style API, you can make requests\nby the HTTP protocol (browser, wget, curl or whatever). After defining the\nquery type and optionally a set of molecular entities (proteins) you can\nadd further GET parameters encoded in the URL.\n\nQuery types\n-----------\n\nThe webservice currently recognizes 7 types of queries: ``interactions``,\n``enz_sub``, ``annotations``, ``complexes``, ``intercell``, ``queries`` and\n``info``.\nThe query types ``resources``, ``network`` and ``about`` have not been\nimplemented yet in the new webservice.\n\nInteraction datasets\n--------------------\n\nThe instance of the ``pypath`` webserver running at the domain\nhttps://omnipathdb.org/, serves not only the OmniPath data but also other\ndatasets. Each of them has a short name what you can use in the queries\n(e.g. ``&datasets=omnipath,pathwayextra``).\n\n* ``omnipath``: the OmniPath data as defined in the paper, an arbitrary\n  optimum between coverage and quality\n* ``pathwayextra``: activity flow interactions without literature reference\n* ``kinaseextra``: enzyme-substrate interactions without literature reference\n* ``ligrecextra``: ligand-receptor interactions without literature reference\n* ``dorothea``: transcription factor (TF)-target interactions from DoRothEA\n* ``tf_target``: transcription factor (TF)-target interactions from other\n  sources\n* ``mirnatarget``: miRNA-mRNA and TF-miRNA interactions\n\nTF-target interactions from DoRothEA, a large collection additional\nenzyme-substrate interactions, and literature curated miRNA-mRNA interacions\ncombined from 4 databases.\n\nMouse and rat\n-------------\n\nExcept the miRNA interactions all interactions are available for human, mouse\nand rat. The rodent data has been translated from human using the NCBI\nHomologene database. Many human proteins do not have known homolog in rodents\nhence rodent datasets are smaller than their human counterparts. Note, if you\nwork with mouse omics data you might do better to translate your dataset to\nhuman (for example using the ``pypath.homology`` module) and use human\ninteraction data.\n\n\nExamples\n--------\n\nA request without any parameter provides the main webpage:\n\n    https://omnipathdb.org\n\nThe ``info`` returns a HTML page with comprehensive information about the\nresources. The list here should be and will be updated as currently OmniPath\nincludes much more databases:\n\n    https://omnipathdb.org/info\n\nMolecular interaction network\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n\nThe ``interactions`` query accepts some parameters and returns interactions in\ntabular format. This example returns all interactions of EGFR (P00533), with\nsources and references listed.\n\n    https://omnipathdb.org/interactions/?partners=P00533&fields=sources,references\n\nBy default only the OmniPath dataset used, to include any other dataset you\nhave to set additional parameters. For example to query the transcriptional regulators of EGFR:\n\n    https://omnipathdb.org/interactions/?targets=EGFR&types=transcriptional\n\nThe DoRothEA database assigns confidence levels to the interactions. You\nmight want to select only the highest confidence, *A* category:\n\n    https://omnipathdb.org/interactions/?targets=EGFR&types=transcriptional&dorothea_levels=A\n\nShow the transcriptional targets of Smad2 homology translated to rat including\nthe confidence levels from TF Regulons:\n\n    https://omnipathdb.org/interactions/?genesymbols=1&fields=type,ncbi_tax_id,dorothea_level&organisms=10116&sources=Smad2&types=transcriptional\n\nQuery interactions from PhosphoNetworks which is part of the *kinaseextra*\ndataset:\n\n    https://omnipathdb.org/interactions/?genesymbols=1&fields=sources&databases=PhosphoNetworks&datasets=kinaseextra\n\nGet the interactions from Signor, SPIKE and SignaLink3:\n\n    https://omnipathdb.org/interactions/?genesymbols=1&fields=sources,references&databases=Signor,SPIKE,SignaLink3\n\nAll interactions of MAP1LC3B:\n\n    https://omnipathdb.org/interactions/?genesymbols=1&partners=MAP1LC3B\n\nBy default ``partners`` queries the interaction where either the source or the\narget is among the partners. If you set the ``source_target`` parameter to\n``AND`` both the source and the target must be in the queried set:\n\n    https://omnipathdb.org/interactions/?genesymbols=1&fields=sources,references&sources=ATG3,ATG7,ATG4B,SQSTM1&targets=MAP1LC3B,MAP1LC3A,MAP1LC3C,Q9H0R8,GABARAP,GABARAPL2&source_target=AND\n\nAs you see above you can use UniProt IDs and Gene Symbols in the queries and\nalso mix them. Get the miRNA regulating NOTCH1:\n\n    https://omnipathdb.org/interactions/?genesymbols=1&fields=sources,references&datasets=mirnatarget&targets=NOTCH1\n\nNote: with the exception of mandatory fields and genesymbols, the columns\nappear exactly in the order you provided in your query.\n\nEnzyme-substrate interactions\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n\nAnother query type available is ``ptms`` which provides enzyme-substrate\ninteractions. It is very similar to the ``interactions``:\n\n    https://omnipathdb.org/enz_sub?genesymbols=1&fields=sources,references,isoforms&enzymes=FYN\n\nIs there any ubiquitination reaction?\n\n    https://omnipathdb.org/ens_sub?genesymbols=1&fields=sources,references&types=ubiquitination\n\nAnd acetylation in mouse?\n\n    https://omnipathdb.org/ptms?genesymbols=1&fields=sources,references&types=acetylation&organisms=10090\n\nRat interactions, both directly from rat and homology translated from human,\nfrom the PhosphoSite database:\n\n    https://omnipathdb.org/enz_sub?genesymbols=1&fields=sources,references&organisms=10116&databases=PhosphoSite,PhosphoSite_noref\n\n\nMolecular complexes\n^^^^^^^^^^^^^^^^^^^\n\nThe ``complexes`` query provides a comprehensive database of more than 22,000\nprotein complexes. For example, to query all complexes from CORUM and PDB\ncontaining MTOR (P42345):\n\n    https://omnipathdb.org/complexes?proteins=P42345&databases=CORUM,PDB\n\n\nAnnotations\n^^^^^^^^^^^\n\nThe ``annotations`` query provides a large variety of data about proteins,\ncomplexes and in the future other kinds of molecules. For example an\nannotation can tell if a protein is a kinase, or if it is expressed in the\nhearth muscle. These data come from dozens of databases and each kind of\nannotation record contains different fields. Because of this here we have\na ``record_id`` field which is unique within the records of each database.\nEach row contains one key value pair and you need to use the ``record_id``\nto connect the related key-value pairs. You can easily do this with ``tidyr``\nand ``dplyr`` in R or ``pandas`` in Python. An example to query the pathway\nannotations from SignaLink:\n\n    https://omnipathdb.org/annotations?databases=SignaLink_pathway\n\nOr the tissue expression of BMP7 from Human Protein Atlas:\n\n    https://omnipathdb.org/annotations?databases=HPA_tissue&proteins=BMP7\n\n\nRoles in inter-cellular communication\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n\nAnother query type is the ``intercell``, providing information about the\nroles in inter-cellular signaling. E.g. if a protein is a ligand, a receptor,\nan extracellular matrix (ECM) component, etc. The proteins and protein\ncomplexes are classified into categories. The categories are defined by a\nnumber of attributes:\n\n* `aspect`: funtional (e.g. ion channel) or locational (e.g. plasma\n  membrane transmembrane).\n* `scope`: generic (e.g. ligand) or specific (e.g. interleukin)\n* `source`: resource specific (from one resource) or composite (combined\n  from more resources)\n* `causality`: transmitter (delivering signal from the expressing cell)\n  or receiver (receiving signal into the expressing cell) or both\n* `topology`: major localization categories derived from the locational\n  categories: plasma membrane transmembrane or peripheral or secreted\n\nThe `intercell` database defines 25 functional and 10 locational generic,\ncomposite categories. The number of specific categories is above 1,000.\n\nYou can use all these attributes in your queries, see the exact keys and\nvalues at https://omnipathdb.org/queries/intercell\n\nSome example queries:\n\n    https://omnipathdb.org/intercell?proteins=EGFR,ULK1,ATG4A,BMP8B\n\nAll the resource specific functional classes for one protein:\n\n    https://omnipathdb.org/intercell?source=resource_specific&aspect=functional&proteins=P00533\n\nA list of all ECM proteins:\n\n    https://omnipathdb.org/intercell?categories=ecm\n\n\nExploring possible parameters\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n\nSometimes the names and values of the query parameters are not intuitive,\neven though in many cases the server accepts multiple alternatives. To see\nthe possible parameters with all possible values you can use the ``queries``\nquery type. The server checks the parameter names and values exactly against\nthese rules and if any of them don\'t match you will get an error message\ninstead of reply. To see the parameters for the ``interactions`` query:\n\n    https://omnipathdb.org/queries/interactions\n\n\nCan I use OmniPath in R?\n========================\n\nYou can download the data from the webservice and load into R. Thanks to\nour colleague Attila Gabor we have a dedicated package for this:\n\n    https://github.com/saezlab/OmnipathR\n\n\nInstallation\n============\n\n**Warning:** ``pip install pypath`` installs another package, you find\n``pypath`` in PyPI under the name ``pypath-omnipath``:\n\n.. code:: bash\n\n    pip install pypath-omnipath\n\nLinux\n-----\n\nIn almost any up-to-date Linux distribution the dependencies of **pypath** are\nbuilt-in, or provided by the distributors. You can simply install **pypath**\nby **pip** (see below).\nIf any non mandatory dependency is still missing, you can install them the\nusual way by *pip* or your package manager.\n\nigraph C library, cairo and pycairo\n-----------------------------------\n\nFor the legacy network class or the ``igraph`` conversion from the current\nnetwork class *python-igraph* must be installed.\n*python(2)-igraph* is a Python interface to use the igraph C library. The\nC library must be installed. The same goes for *cairo*, *py(2)cairo* and\n*graphviz*.\n\n\nDirectly from git\n-----------------\n\n.. code:: bash\n\n    pip install git+https://github.com/saezlab/pypath.git\n\nWith pip\n--------\n\nDownload the package from /dist, and install with pip:\n\n.. code:: bash\n\n    pip install pypath-x.y.z.tar.gz\n\nBuild source distribution\n-------------------------\n\nClone the git repo, and run setup.py:\n\n.. code:: bash\n\n    python setup.py sdist\n\nMac OS X\n--------\n\nRecently the installation on Mac should not be more complicated than on Linux:\nyou can simply install by **pip** (see above).\n\nWhen ``igraph`` was a mandatory dependency and it didn\'t provide wheels\nthe OS X installation was not straightforward primarily because cairo needs to\nbe compiled from source. If you want igraph and cairo we provide two scripts\nin ``scripts``: the **mac-install-brew.sh** installs everything with HomeBrew and\n**mac-install-conda.sh** installs from Anaconda distribution. With these\nscripts, installation of igraph, cairo and graphviz goes smoothly most of the\ntime and options are available to omit the last two. To know more, see\nthe description in the script header. There is a third script\n**mac-install-source.sh** which compiles everything from source and presumes\nonly Python 2.7 and Xcode installed. We do not recommend this as it is time\nconsuming and troubleshooting requires expertise.\n\nTroubleshooting\n^^^^^^^^^^^^^^^\n\n* ``no module named ...`` when you try to load a module in Python. Did\n  the installation of the module run without error? Try to run again the specific\n  part from the mac install shell script to see if any error comes up. Is the\n  path where the module has been installed in your ``$PYTHONPATH``? Try ``echo\n  $PYTHONPATH`` to see the current paths. Add your local install directories if\n  those are not there, e.g.\n  ``export PYTHONPATH="/Users/me/local/python2.7/site-packages:$PYTHONPATH"``.\n  If it works afterwards, don\'t forget to append these export path statements to\n  your ``~/.bash_profile``, so these will be set every time you launch a new\n  shell.\n\n* ``pkgconfig`` not found. Check if the ``$PKG_CONFIG_PATH`` variable is\n  set correctly, and pointing on a directory where pkgconfig really can be\n  found.\n\n* Error while trying to install py(2)cairo by pip. py(2)cairo could not be\n  installed by pip, but only by waf. Please set the ``$PKG_CONFIG_PATH`` before.\n  See **mac-install-source.sh** on how to install with waf.\n\n* Error at pygraphviz build: ``graphviz/cgraph.h file not found``. This is\n  because the directory of graphviz detected wrong by pkgconfig. See\n  **mac-install-source.sh** how to set include dirs and library dirs by\n  ``--global-option`` parameters.\n\n* Can not install bioservices, because installation of jurko-suds fails. Ok,\n  this fails because pip is not able to install the recent version of\n  setuptools, because a very old version present in the system path. The\n  development version of jurko-suds does not require setuptools, so you can\n  install it directly from git as it is done in **mac-install-source.sh**.\n\n* In **Anaconda**, *pypath* can be imported, but the modules and classes are\n  missing. Apparently Anaconda has some built-in stuff called *pypath*. This\n  has nothing to do with this module. Please be aware that Anaconda installs a\n  completely separated Python distribution, and does not detect modules in the\n  main Python installation. You need to install all modules within Anaconda\'s\n  directory. **mac-install-conda.sh** does exactly this. If you still\n  experience issues, please contact us.\n\n* ``error: openssl/ssl.h: No such file or directory``: In order to install\n  the Python modules ``pyopenssl`` and its dependency ``cryptography`` on\n  some systems the development headers of OpenSSL need to be available. This\n  is not the case if you can install ``pyopenssl`` from a wheel. If you get\n  an error about a missing libssl header, just install the appropriate\n  packages, in Debian based distros these are ``libssl-dev`` and\n  ``libffi-dev``, in Red Hat based distros ``openssl-devel`` and\n  ``libffi-devel``. In Mac OS X install ``openssl`` by ``homebrew``.\n\nMicrosoft Windows\n-----------------\n\nNot many people have used *pypath* on Microsoft computers so far. Please share\nyour experiences and contact us if you encounter any issue. We appreciate\nyour feedback, and it would be nice to have better support for other computer\nsystems.\n\nWith Anaconda\n^^^^^^^^^^^^^\n\nThe same workflow like you see in ``mac-install-conda.sh`` should work for\nAnaconda on Windows. The only problem you certainly will encounter is that not\nall the channels have packages for all platforms. If certain channel provides\nno package for Windows, or for your Python version, you just need to find an\nother one. For this, do a search:\n\n.. code:: bash\n\n    anaconda search -t conda <package name>\n\nFor example, if you search for *pycairo*, you will find out that *vgauther*\nprovides it for osx-64, but only for Python 3.4, while *richlewis* provides\nalso for Python 3.5. And for win-64 platform, there is the channel of\n*KristanAmstrong*. Go along all the commands in ``mac-install-conda.sh``, and\nmodify the channel if necessary, until all packages install successfully.\n\nWith other Python distributions\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n\nHere the basic principles are the same as everywhere: first try to install all\nexternal dependencies, after *pip* install should work. On Windows certain\npackages can not be installed by compiled from source by *pip*, instead the\neasiest to install them precompiled. These are in our case *fisher, lxml,\nnumpy (mkl version), pycairo, igraph, pygraphviz, scipy and statsmodels*. The\nprecompiled packages are available `here <http://www.lfd.uci.edu/~gohlke/pythonlibs/>`__.\nWe tested the setup with Python 3.4.3 and Python 2.7.11. The former should just\nwork fine, while with the latter we have issues to be resolved.\n\nKnown issues\n^^^^^^^^^^^^\n\n* *"No module fabric available."* -- or *pysftp* missing: this is not\n  important, only certain data download methods rely on these modules, but\n  likely you won\'t call those at all.\n* Progress indicator floods terminal: sorry about that, will be fixed soon.\n* Encoding related exceptions in Python2: these might occur at some points in\n  the module, please send the traceback if you encounter one, and we will fix\n  as soon as possible.\n* For Mac OS X (v >= 10.11 El Capitan) import of pypath fails with error:\n  "libcurl link-time ssl backend (openssl) is different from compile-time ssl\n  backend (none/other)". To fix it, you may need to reinstall pycurl library\n  using special flags. More information and steps can be found\n  `here <https://cscheng.info/2018/01/26/installing-pycurl-on-macos-high-sierra.html>`_.\n\n*Special thanks to Jorge Ferreira for testing pypath on Windows!*\n\nRelease History\n===============\n\nMain improvements in the past releases:\n\n0.1.0\n-----\n\n* First release of PyPath, for initial testing.\n\n0.2.0\n-----\n\n* Lots of small improvements in almost every module\n* Networks can be read from local files, remote files, lists or provided by any function\n* Almost all redistributed data have been removed, every source downloaded from the original provider.\n\n0.3.0\n-----\n\n* First version with partial Python 3 support.\n\n0.4.0\n-----\n\n* **pyreact** module with **BioPaxReader** and **PyReact** classes added\n* Process description databases, BioPax and PathwayCommons SIF conversion rules are supported\n* Format definitions for 6 process description databases included.\n\n0.5.0\n-----\n\n* Many classes have been added to the **plot** module\n* All figures and tables in the manuscript can be generated automatically\n* This is supported by a new module, **analysis**, which implements a generic workflow in its **Workflow** class.\n\n0.5.32\n------\n\n* `chembl`, `unichem`, `mysql` and `mysql_connect` modules made Python3 compatible\n\n0.6.31\n------\n\n* Orthology translation of network\n* Homologene UniProt dict to translate between different organisms UniProt-to-UniProt\n* Orthology translation of PTMs\n* Better processing of PhosphoSite regulatory sites\n\n0.7.0\n-----\n\n* TF-target, miRNA-mRNA and TF-miRNA interactions from many databases\n\n0.7.74\n------\n\n* New web server based on `pandas` data frames\n* New module `export` for generating data frames of interactions or enzyme-substrate interactions\n* New module `websrvtab` for exporting data frames for the web server\n* TF-target interactions from DoRothEA\n\n0.7.93\n------\n\n* New `dataio` methods for Gene Ontology\n\n0.7.110\n-------\n\n* Many new docstrings\n\n\n0.8\n---\n\n* New module `complex`: a comprehensive database of complexes\n* New module `annot`: database of protein annotations (function, location)\n* New module `intercell`: special methods for data integration focusing on intercellular communication\n* New module `bel`: BEL integration\n* Module `go` and all the connected `dataio` methods have been rewritten offering a workaround for\n  data access despite GO\'s terrible web services and providing much more versatile query methods\n* Removed MySQL support (e.g. loading mapping tables from MySQL)\n* Modules `mapping`, `reflists`, `complex`, `ptm`, `annot`, `go` became services:\n  these modules build databases and provide query methods, sometimes they even automatically\n  delete data to free memory\n* New interaction category in `data_formats`: `ligand_receptor`\n* Improved logging and control over verbosity\n* Better control over parameters by the `settings` module\n* Many methods in `dataio` have been improved or fixed, docs and code style largely improved\n* Started to add tests especially for methods in `dataio`\n\n0.9\n---\n* The network database is not dependent any more on `python-igraph` hence it\n  has been removed from the mandatory dependencies\n* New API for the network, interactions, evidences, molecular entities\n\n0.10.0\n------\n* New module structure: modules grouped into `core`, `inputs`, `internals`,\n  `legacy`, `omnipath`, `resources`, `share` and `utils` submodules.\n\n0.11.0\n------\n* Redesign of the intercell (intercellular communication roles) database\n\nUpcoming\n--------\n\n* New, more flexible network reader class\n* Full support for multi-species molecular interaction networks\n  (e.g. pathogene-host)\n* Better support for not protein only molecular interaction networks\n  (metabolites, drug compounds, RNA)\n\nFeatures\n========\n\nIntegrated databases\n--------------------\n\nIn the beginning the primary aim of ``pypath`` was to build networks from\nmultiple sources using an igraph object as the fundament of the integrated\ndata structure. From version 0.7 and 0.8 this design principle started to\nchange. Today ``pypath`` builds a number of different databases, exposes them\nby a rich API and each of them can be converted to ``pandas.DataFrame``.\nThe modules and classes responsible for the integrated databases are located\nin ``pypath.core``. The five main databases are the followings:\n\n* *network* - ``core.network``\n* *enzyme-substrate* - ``core.enz_sub``\n* *complexes* - ``core.complex``\n* *annotations* - ``core.annot``\n* *intercell* - ``core.intercell``\n\nSome of the databases have different variants (e.g. PPI and transcriptional\nnetwork) and all can be customized by many parameters.\n\nDatabase management\n-------------------\n\nThe databases above can be loaded by calling the appropriate classes.\nHowever building the databases require time and memory so we want to avoid\nbuilding them more often than necessary or keeping more than one copies\nin the memory. Some of the modules listed above have a method ``get_db``\nwhich ensures only one instance of the database is loaded. But there is a\nmore full featured database management system available in **pypath**,\nthis is the **pypath.omnipath** module. This module is able to build the\ndatabases, automatically saves them to ``pickle`` files and loads them from\nthere in subsequent sessions. **pypath** comes with a number of database\ndefinitions and users can add more. The ``pickle`` files are located by\ndefault in the ``~/.pypath/pickles/`` directory. With the ``omnipath``\nmodule it\'s easy to get an instance of a database. For example to get the\n`omnipath` PPI network dataset:\n\n.. code:: python\n\n    from pypath import omnipath\n    op = omnipath.db.get_db(\'omnipath\')\n\n**Important:** Building the databases for the first time requires the\ndownload of several MB or GB of data from the original resources. This\nnormally takes long time and is prone of errors (e.g. truncated or empty\ndownloads due to interrupted HTTP connection). In this case you should check\nthe log to find the path of the problematic cache file, check the contents\nof this file to find out the reason and possibly delete the file to ensure\nanother download attempt when you call the database build again. Sometimes\nthe original resources change their content or go offline. If you encounter\nsuch case please open an issue at https://github.com/saezlab/pypath/issues\nso we can fix it in ``pypath``. Once all the necessary contents are\ndownloaded and stored in the cache, the database builds are much faster,\nbut still can take minutes.\n\nFurther modules in pypath\n-------------------------\n\nApart from the databases, **pypath** has many submodules with standalone\nfunctionality which can be used in other modules and scripts. Below we\npresent a few of these.\n\nID conversion\n-------------\n\nThe ID conversion module ``utils.mapping`` translates between a large variety\nof gene, protein and miRNA ID types. It has the feature to translate\nsecondary UniProt ACs to primaries, and Trembl ACs to SwissProt, using\nprimary Gene Symbols to find the connections. This module automatically\nloads and stores the necessary conversion tables. Many tables\nare predefined, such as all the IDs in **UniProt mapping service,** while\nusers are able to load any table from **file** using the classes provided\nin the module ``input_formats``. An example how to translate identifiers:\n\n.. code:: python\n\n    from pypath.utils import mapping\n    mapping.map_name(\'P00533\', \'uniprot\', \'genesymbol\')\n    # {\'EGFR\'}\n\n\nHomology translation\n--------------------\n\nThe ``pypath.utils.homology`` module is able to find the homologues of genes\nbetween two organisms. It uses data from NCBI HomoloGene, and soon we will\nextend it to use Ensembl or UniProt as alternatives. This module is really\nsimple to use:\n\n.. code:: python\n\n    from pypath.utils import homology\n    homology.translate(\'P00533\', 10090) # translating the human EGFR to mouse\n    # [\'Q01279\'] # it returns the mouse Egfr UniProt AC\n',
    'author': 'Denes Turei',
    'author_email': 'turei.denes@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://omnipathdb.org/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
